//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \short A Range which is bound to a specific Document, and maintains its position.
    ///  \ingroup kte_group_smart_classes
    ///  A SmartRange is an extension of the basic Range class. It maintains its
    ///  position in the document and provides extra functionality,
    ///  including:
    ///  <li>convenience</li> functions for accessing and manipulating the content
    ///  of the associated document,
    ///  <li>adjusting</li> behavior in response to text edits,
    ///  <li>forming</li> a tree structure out of multiple SmartRange%s,
    ///  <li>providing</li> attribute information for the arbitrary highlighting extension,
    ///  <li>allowing</li> KAction%s to be bound to the range (note: not currently implemented), and
    ///  <li>providing</li> notification of changes to 3rd party software.
    ///  As a result of a smart range's close association with a document, and the processing
    ///  that occurrs as a result, smart ranges may not be copied.
    ///  For simplicity of code, ranges always maintain their start position to
    ///  be before or equal to their end position.  Attempting to set either the
    ///  start or end of the range beyond the respective end or start will result in
    ///  both values being set to the specified position.
    ///  Create a new SmartRange like this:
    ///  <pre>
    ///  // Retrieve the SmartInterface
    ///  KTextEditor.SmartInterface smart =
    ///      qobject_cast<KTextEditor.SmartInterface>( yourDocument );
    ///  if ( smart ) {
    ///      KTextEditor.SmartRange range = smart.NewSmartRange();
    ///  }
    ///  </pre>
    ///  When finished with a SmartRange, simply delete it.
    ///  \sa Range, SmartRangeNotifier, SmartRangeWatcher, and SmartInterface
    ///  \author Hamish Rodda \<rodda@kde.org\>
    ///  </remarks>        <short>    \short A Range which is bound to a specific Document, and maintains its position.</short>
    [SmokeClass("KTextEditor::SmartRange")]
    public class SmartRange : KTextEditor.Range, IDisposable {
        protected SmartRange(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(SmartRange), this);
        }
        public enum InsertBehavior {
            DoNotExpand = 0,
            ExpandLeft = 0x1,
            ExpandRight = 0x2,
        }
        // KTextEditor::SmartRange* deepestRangeContaining(const KTextEditor::Cursor& arg1,QStack<KTextEditor::SmartRange*>* arg2,QStack<KTextEditor::SmartRange*>* arg3); >>>> NOT CONVERTED
        // KTextEditor::SmartRange* deepestRangeContaining(const KTextEditor::Cursor& arg1,QStack<KTextEditor::SmartRange*>* arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  Returns that this range is a SmartRange.
        ///      </remarks>        <short>    Returns that this range is a SmartRange.</short>
        [SmokeMethod("isSmartRange() const")]
        public override bool IsSmartRange() {
            return (bool) interceptor.Invoke("isSmartRange", "isSmartRange() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns this range as a SmartRange, if it is one.
        ///      </remarks>        <short>    Returns this range as a SmartRange, if it is one.</short>
        [SmokeMethod("toSmartRange() const")]
        public override KTextEditor.SmartRange ToSmartRange() {
            return (KTextEditor.SmartRange) interceptor.Invoke("toSmartRange", "toSmartRange() const", typeof(KTextEditor.SmartRange));
        }
        /// <remarks>
        ///  \copydoc Range.SetRange(Range)
        ///  This function also provides any required adjustment of parent and child ranges,
        ///  and notification of the change if required.
        ///      </remarks>        <short>    \copydoc Range.SetRange(Range) </short>
        [SmokeMethod("setRange(const KTextEditor::Range&)")]
        public override void SetRange(KTextEditor.Range range) {
            interceptor.Invoke("setRange#", "setRange(const KTextEditor::Range&)", typeof(void), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Get the start point of this range. This version returns a casted
        ///  version of start(), as SmartRange%s always use SmartCursor%s as
        ///  the start() and end().
        ///  \returns a reference to the start of this range.
        ///      </remarks>        <short>    Get the start point of this range.</short>
        public KTextEditor.SmartCursor SmartStart() {
            return (KTextEditor.SmartCursor) interceptor.Invoke("smartStart", "smartStart()", typeof(KTextEditor.SmartCursor));
        }
        /// <remarks>
        ///  Get the end point of this range. This version returns a casted
        ///  version of end(), as SmartRange%s always use SmartCursor%s as
        ///  the start() and end().
        ///  \returns a reference to the end of this range.
        ///      </remarks>        <short>    Get the end point of this range.</short>
        public KTextEditor.SmartCursor SmartEnd() {
            return (KTextEditor.SmartCursor) interceptor.Invoke("smartEnd", "smartEnd()", typeof(KTextEditor.SmartCursor));
        }
        /// <remarks>
        ///  \overload confineToRange(Range)
        ///  Overloaded version which confines child ranges as well.
        ///      </remarks>        <short>    \overload confineToRange(Range)  Overloaded version which confines child ranges as well.</short>
        [SmokeMethod("confineToRange(const KTextEditor::Range&)")]
        public override bool ConfineToRange(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("confineToRange#", "confineToRange(const KTextEditor::Range&)", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  \overload expandToRange(Range)
        ///  Overloaded version which expands child ranges as well.
        ///      </remarks>        <short>    \overload expandToRange(Range)  Overloaded version which expands child ranges as well.</short>
        [SmokeMethod("expandToRange(const KTextEditor::Range&)")]
        public override bool ExpandToRange(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("expandToRange#", "expandToRange(const KTextEditor::Range&)", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Retrieve the document associated with this SmartRange.
        ///  \return a pointer to the associated document
        ///      </remarks>        <short>    Retrieve the document associated with this SmartRange.</short>
        public KTextEditor.Document Document() {
            return (KTextEditor.Document) interceptor.Invoke("document", "document() const", typeof(KTextEditor.Document));
        }
        /// <remarks>
        ///  Retrieve the text which is contained within this range.
        ///  \param block specify whether the text should be returned from the range's visual block, rather
        ///               than all the text within the range.
        ///      </remarks>        <short>    Retrieve the text which is contained within this range.</short>
        [SmokeMethod("text(bool) const")]
        public virtual List<string> Text(bool block) {
            return (List<string>) interceptor.Invoke("text$", "text(bool) const", typeof(List<string>), typeof(bool), block);
        }
        [SmokeMethod("text() const")]
        public virtual List<string> Text() {
            return (List<string>) interceptor.Invoke("text", "text() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Replace text in this range with <pre>text</pre>
        ///  \param text text to use as a replacement
        ///  \param block insert this text as a visual block of text rather than a linear sequence
        ///  \return \e true on success, otherwise \e false
        ///      </remarks>        <short>    Replace text in this range with \p text </short>
        [SmokeMethod("replaceText(const QStringList&, bool)")]
        public virtual bool ReplaceText(List<string> text, bool block) {
            return (bool) interceptor.Invoke("replaceText?$", "replaceText(const QStringList&, bool)", typeof(bool), typeof(List<string>), text, typeof(bool), block);
        }
        [SmokeMethod("replaceText(const QStringList&)")]
        public virtual bool ReplaceText(List<string> text) {
            return (bool) interceptor.Invoke("replaceText?", "replaceText(const QStringList&)", typeof(bool), typeof(List<string>), text);
        }
        /// <remarks>
        ///  Remove text contained within this range.
        ///  The range itself will not be deleted.
        ///  \param block specify whether the text should be deleted from the range's visual block, rather
        ///               than all the text within the range.
        ///      </remarks>        <short>    Remove text contained within this range.</short>
        [SmokeMethod("removeText(bool)")]
        public virtual bool RemoveText(bool block) {
            return (bool) interceptor.Invoke("removeText$", "removeText(bool)", typeof(bool), typeof(bool), block);
        }
        [SmokeMethod("removeText()")]
        public virtual bool RemoveText() {
            return (bool) interceptor.Invoke("removeText", "removeText()", typeof(bool));
        }
        /// <remarks>
        ///  Returns how this range reacts to characters inserted immediately outside the range.
        ///  \return the current insert behavior.
        ///      </remarks>        <short>    Returns how this range reacts to characters inserted immediately outside the range.</short>
        public uint insertBehavior() {
            return (uint) interceptor.Invoke("insertBehavior", "insertBehavior() const", typeof(uint));
        }
        /// <remarks>
        ///  Determine how the range should react to characters inserted immediately outside the range.
        ///  \todo does this need a custom function to enable determining of the behavior based on the
        ///  text that is inserted / deleted?
        ///  \param behavior the insertion behavior to use for future edits
        ///  \sa InsertBehavior
        ///      </remarks>        <short>    Determine how the range should react to characters inserted immediately outside the range.</short>
        public void SetInsertBehavior(uint behavior) {
            interceptor.Invoke("setInsertBehavior$", "setInsertBehavior(KTextEditor::SmartRange::InsertBehaviors)", typeof(void), typeof(uint), behavior);
        }
        /// <remarks>
        ///  Returns this range's parent range, if one exists.
        ///  At all times, this range will be contained within parentRange().
        ///  \return a pointer to the current parent range
        ///      </remarks>        <short>    Returns this range's parent range, if one exists.</short>
        public KTextEditor.SmartRange ParentRange() {
            return (KTextEditor.SmartRange) interceptor.Invoke("parentRange", "parentRange() const", typeof(KTextEditor.SmartRange));
        }
        /// <remarks>
        ///  Set this range's parent range.
        ///  At all times, this range will be contained within parentRange().  So, if it is outside of the
        ///  new parent to begin with, it will be expanded automatically.
        ///  When being inserted into the parent range, the parent range will be fit in between any other
        ///  pre-existing child ranges, and may resize them so as not to overlap.  However, once insertion
        ///  has occurred, changing this range directly will only resize the others, it will \e not change
        ///  the order of the ranges.  To change the order, unset the parent range, change the range, and
        ///  re-set the parent range.
        ///  \param r range to become the new parent of this range
        ///      </remarks>        <short>    Set this range's parent range.</short>
        [SmokeMethod("setParentRange(KTextEditor::SmartRange*)")]
        public virtual void SetParentRange(KTextEditor.SmartRange r) {
            interceptor.Invoke("setParentRange#", "setParentRange(KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartRange), r);
        }
        /// <remarks>
        ///  Determine whether \a parent is a parent of this range.
        ///  \param parent range to check to see if it is a parent of this range.
        ///  \return \e true if \a parent is in the parent heirachy, otherwise \e false.
        ///      </remarks>        <short>    Determine whether \a parent is a parent of this range.</short>
        public bool HasParent(KTextEditor.SmartRange parent) {
            return (bool) interceptor.Invoke("hasParent#", "hasParent(KTextEditor::SmartRange*) const", typeof(bool), typeof(KTextEditor.SmartRange), parent);
        }
        /// <remarks>
        ///  Calculate the current depth of this range.
        ///  \return the depth of this range, where 0 is no parent, 1 is one parent, etc.
        ///      </remarks>        <short>    Calculate the current depth of this range.</short>
        public int Depth() {
            return (int) interceptor.Invoke("depth", "depth() const", typeof(int));
        }
        /// <remarks>
        ///  Returns the range's top parent range, or this range if there are no parents.
        ///  \return a pointer to the top parent range
        ///      </remarks>        <short>    Returns the range's top parent range, or this range if there are no parents.</short>
        public KTextEditor.SmartRange TopParentRange() {
            return (KTextEditor.SmartRange) interceptor.Invoke("topParentRange", "topParentRange() const", typeof(KTextEditor.SmartRange));
        }
        /// <remarks>
        ///  Get the ordered list of child ranges.
        ///  To insert a child range, simply set its parent to this range using setParentRange().
        ///  \returns a list of child ranges.
        ///      </remarks>        <short>    Get the ordered list of child ranges.</short>
        public List<KTextEditor.SmartRange> ChildRanges() {
            return (List<KTextEditor.SmartRange>) interceptor.Invoke("childRanges", "childRanges() const", typeof(List<KTextEditor.SmartRange>));
        }
        /// <remarks>
        ///  Clears child ranges - i.e., removes the text that is covered by the ranges.
        ///  The ranges themselves are not deleted.
        ///  \sa removeText()
        ///      </remarks>        <short>    Clears child ranges - i.</short>
        public void ClearChildRanges() {
            interceptor.Invoke("clearChildRanges", "clearChildRanges()", typeof(void));
        }
        /// <remarks>
        ///  Deletes child ranges - i.e., deletes the SmartRange objects only.
        ///  The underlying text is not affected.
        ///      </remarks>        <short>    Deletes child ranges - i.</short>
        public void DeleteChildRanges() {
            interceptor.Invoke("deleteChildRanges", "deleteChildRanges()", typeof(void));
        }
        /// <remarks>
        ///  Clears child ranges - i.e., clears the text that is covered by the ranges,
        ///  and deletes the SmartRange objects.
        ///      </remarks>        <short>    Clears child ranges - i.</short>
        public void ClearAndDeleteChildRanges() {
            interceptor.Invoke("clearAndDeleteChildRanges", "clearAndDeleteChildRanges()", typeof(void));
        }
        /// <remarks>
        ///  Find the child before <pre>range</pre>, if any.
        ///  \param range to seach backwards from
        ///  \return the range before <pre>range</pre> if one exists, otherwise null.
        ///      </remarks>        <short>    Find the child before \p range, if any.</short>
        public KTextEditor.SmartRange ChildBefore(KTextEditor.SmartRange range) {
            return (KTextEditor.SmartRange) interceptor.Invoke("childBefore#", "childBefore(const KTextEditor::SmartRange*) const", typeof(KTextEditor.SmartRange), typeof(KTextEditor.SmartRange), range);
        }
        /// <remarks>
        ///  Find the child after <pre>range</pre>, if any.
        ///  \param range to seach backwards from
        ///  \return the range before <pre>range</pre> if one exists, otherwise null.
        ///      </remarks>        <short>    Find the child after \p range, if any.</short>
        public KTextEditor.SmartRange ChildAfter(KTextEditor.SmartRange range) {
            return (KTextEditor.SmartRange) interceptor.Invoke("childAfter#", "childAfter(const KTextEditor::SmartRange*) const", typeof(KTextEditor.SmartRange), typeof(KTextEditor.SmartRange), range);
        }
        /// <remarks>
        ///  Finds the most specific range in a heirachy for the given input range
        ///  (ie. the smallest range which wholly contains the input range)
        ///  \param input the range to use in searching
        ///  \return the deepest range which contains <pre>input</pre>
        ///      </remarks>        <short>    Finds the most specific range in a heirachy for the given input range  (ie.</short>
        public KTextEditor.SmartRange MostSpecificRange(KTextEditor.Range input) {
            return (KTextEditor.SmartRange) interceptor.Invoke("mostSpecificRange#", "mostSpecificRange(const KTextEditor::Range&) const", typeof(KTextEditor.SmartRange), typeof(KTextEditor.Range), input);
        }
        /// <remarks>
        ///  Finds the first child range which contains position <pre>pos</pre>.
        ///  \param pos the cursor position to use in searching
        ///  \return the most shallow range (from and including this range) which
        ///          contains <pre>pos</pre>
        ///      </remarks>        <short>    Finds the first child range which contains position \p pos.</short>
        public KTextEditor.SmartRange FirstRangeContaining(KTextEditor.Cursor pos) {
            return (KTextEditor.SmartRange) interceptor.Invoke("firstRangeContaining#", "firstRangeContaining(const KTextEditor::Cursor&) const", typeof(KTextEditor.SmartRange), typeof(KTextEditor.Cursor), pos);
        }
        /// <remarks>
        ///  Finds the deepest range in the heirachy which contains position <pre>pos</pre>.
        ///  Allows the caller to determine which ranges were entered and exited
        ///  by providing pointers to QStack<SmartRange>.
        ///  \param pos the cursor position to use in searching
        ///  \param rangesEntered provide a QStack<SmartRange> here to find out
        ///                       which ranges were entered during the traversal.
        ///                       The top item was the first descended.
        ///  \param rangesExited provide a QStack<SmartRange> here to find out
        ///                      which ranges were exited during the traversal.
        ///                      The top item was the first exited.
        ///  \return the deepest range (from and including this range) which
        ///          contains <pre>pos</pre>, or null if no ranges contain this position.
        ///      </remarks>        <short>    Finds the deepest range in the heirachy which contains position \p pos.</short>
        public KTextEditor.SmartRange DeepestRangeContaining(KTextEditor.Cursor pos) {
            return (KTextEditor.SmartRange) interceptor.Invoke("deepestRangeContaining#", "deepestRangeContaining(const KTextEditor::Cursor&) const", typeof(KTextEditor.SmartRange), typeof(KTextEditor.Cursor), pos);
        }
        /// <remarks>
        ///  Gets the active Attribute for this range.
        ///  \return a pointer to the active attribute
        ///      </remarks>        <short>    Gets the active Attribute for this range.</short>
        public KTextEditor.Attribute Attribute() {
            return (KTextEditor.Attribute) interceptor.Invoke("attribute", "attribute() const", typeof(KTextEditor.Attribute));
        }
        /// <remarks>
        ///  Sets the currently active attribute for this range.
        ///  \param attribute Attribute to assign to this range. If null, simply
        ///                   removes the previous Attribute.
        ///      </remarks>        <short>    Sets the currently active attribute for this range.</short>
        public void SetAttribute(KTextEditor.Attribute attribute) {
            interceptor.Invoke("setAttribute?", "setAttribute(KSharedPtr<KTextEditor::Attribute>)", typeof(void), typeof(KTextEditor.Attribute), attribute);
        }
        /// <remarks>
        ///  Associate an action with this range.  The associated action(s) will be
        ///  enabled when the caret enters the range, and disabled them on exit.
        ///  The action is also added to the context menu when the mouse/caret is within
        ///  an associated range.
        ///  \param action KAction to associate with this range
        ///      </remarks>        <short>    Associate an action with this range.</short>
        public void AssociateAction(KAction action) {
            interceptor.Invoke("associateAction#", "associateAction(KAction*)", typeof(void), typeof(KAction), action);
        }
        /// <remarks>
        ///  Remove the association with an action from this range; it will no
        ///  longer be managed.
        ///  \param action KAction to dissociate from this range
        ///      </remarks>        <short>    Remove the association with an action from this range; it will no  longer be managed.</short>
        public void DissociateAction(KAction action) {
            interceptor.Invoke("dissociateAction#", "dissociateAction(KAction*)", typeof(void), typeof(KAction), action);
        }
        /// <remarks>
        ///  Access the list of currently associated KAction%s.
        ///  \return the list of associated actions
        ///      </remarks>        <short>    Access the list of currently associated KAction%s.</short>
        public List<KAction> AssociatedActions() {
            return (List<KAction>) interceptor.Invoke("associatedActions", "associatedActions() const", typeof(List<KAction>));
        }
        /// <remarks>
        ///  Clears all associations between KAction%s and this range.
        ///      </remarks>        <short>    Clears all associations between KAction%s and this range.</short>
        public void ClearAssociatedActions() {
            interceptor.Invoke("clearAssociatedActions", "clearAssociatedActions()", typeof(void));
        }
        /// <remarks>
        ///  Connect to a notifier to receive signals indicating change of state of this range.
        ///  This function creates a notifier if none is already bound to this range; if one has
        ///  already been assigned this will return the first notifier.
        ///  If you have finished with notifications for a reasonable period of time you can
        ///  save memory by calling deleteNotifier().
        ///      </remarks>        <short>    Connect to a notifier to receive signals indicating change of state of this range.</short>
        public KTextEditor.SmartRangeNotifier PrimaryNotifier() {
            return (KTextEditor.SmartRangeNotifier) interceptor.Invoke("primaryNotifier", "primaryNotifier()", typeof(KTextEditor.SmartRangeNotifier));
        }
        /// <remarks>
        ///  Returns a list of notifiers which are receiving signals indicating change of state
        ///  of this range.  These notifiers may be receiving signals from other ranges as well.
        ///      </remarks>        <short>    Returns a list of notifiers which are receiving signals indicating change of state  of this range.</short>
        public List<KTextEditor.SmartRangeNotifier> Notifiers() {
            return (List<KTextEditor.SmartRangeNotifier>) interceptor.Invoke("notifiers", "notifiers() const", typeof(List<KTextEditor.SmartRangeNotifier>));
        }
        /// <remarks>
        ///  Register a notifier to receive signals indicating change of state of this range.
        ///  \param notifier notifier to register. Ownership is not transferred.
        ///      </remarks>        <short>    Register a notifier to receive signals indicating change of state of this range.</short>
        public void AddNotifier(KTextEditor.SmartRangeNotifier notifier) {
            interceptor.Invoke("addNotifier#", "addNotifier(KTextEditor::SmartRangeNotifier*)", typeof(void), typeof(KTextEditor.SmartRangeNotifier), notifier);
        }
        /// <remarks>
        ///  Deregister a notifier and no longer deliver signals indicating change of state of this range.
        ///  \param notifier notifier to deregister.
        ///      </remarks>        <short>    Deregister a notifier and no longer deliver signals indicating change of state of this range.</short>
        public void RemoveNotifier(KTextEditor.SmartRangeNotifier notifier) {
            interceptor.Invoke("removeNotifier#", "removeNotifier(KTextEditor::SmartRangeNotifier*)", typeof(void), typeof(KTextEditor.SmartRangeNotifier), notifier);
        }
        /// <remarks>
        ///  When finished with the primaryNotifier(), call this method to save memory by
        ///  having the SmartRangeNotifier deleted.
        ///  <b>Note:<> If a notifier was first registered via addNotifier() rather than created inside
        ///        primaryNotifier(), this method will delete that notifier.  Text editor implementations
        ///        should not use notifiers for internal purposes, instead use watchers (faster and
        ///        has documentation to this effect)
        ///      </remarks>        <short>    When finished with the primaryNotifier(), call this method to save memory by  having the SmartRangeNotifier deleted.</short>
        public void DeletePrimaryNotifier() {
            interceptor.Invoke("deletePrimaryNotifier", "deletePrimaryNotifier()", typeof(void));
        }
        /// <remarks>
        ///  Returns a list of registered SmartRangeWatchers.
        ///  <b>Note:<> this function may return watchers internal to the text editor's implementation,
        ///        eg. in the case of arbitrary highlighting and kate part.  Removing these watchers
        ///        with removeWatcher() will result in malfunction.
        ///      </remarks>        <short>    Returns a list of registered SmartRangeWatchers.</short>
        public List<KTextEditor.SmartRangeWatcher> Watchers() {
            return (List<KTextEditor.SmartRangeWatcher>) interceptor.Invoke("watchers", "watchers() const", typeof(List<KTextEditor.SmartRangeWatcher>));
        }
        /// <remarks>
        ///  Register a SmartRangeWatcher to receive calls indicating change of state
        ///  of this range. To finish receiving notifications, call removeWatcher().
        ///  \param watcher the instance of a class which is to receive
        ///                 notifications about changes to this range.
        ///      </remarks>        <short>    Register a SmartRangeWatcher to receive calls indicating change of state  of this range.</short>
        public void AddWatcher(KTextEditor.SmartRangeWatcher watcher) {
            interceptor.Invoke("addWatcher#", "addWatcher(KTextEditor::SmartRangeWatcher*)", typeof(void), typeof(KTextEditor.SmartRangeWatcher), watcher);
        }
        /// <remarks>
        ///  Stop delivery of notifications to a SmartRangeWatcher.
        ///  \param watcher the watcher that no longer wants notifications.
        ///      </remarks>        <short>    Stop delivery of notifications to a SmartRangeWatcher.</short>
        public void RemoveWatcher(KTextEditor.SmartRangeWatcher watcher) {
            interceptor.Invoke("removeWatcher#", "removeWatcher(KTextEditor::SmartRangeWatcher*)", typeof(void), typeof(KTextEditor.SmartRangeWatcher), watcher);
        }
        /// <remarks>
        ///  \internal
        ///  Constructor for subclasses to utilise.  Protected to prevent direct
        ///  instantiation.
        ///  <b>Note:<> 3rd party developers: you do not (and should not) need to subclass
        ///        the Smart classes; instead, use the SmartInterface to create instances.
        ///  \param start the start cursor to use - ownership is taken
        ///  \param end the end cursor to use - ownership is taken
        ///  \param insertBehavior the behavior of this range when an insert happens
        ///                         immediately outside the range.
        ///      </remarks>        <short>    \internal </short>
        public SmartRange(KTextEditor.SmartCursor start, KTextEditor.SmartCursor end, KTextEditor.SmartRange parent, uint insertBehavior) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SmartRange###$", "SmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*, KTextEditor::SmartRange::InsertBehaviors)", typeof(void), typeof(KTextEditor.SmartCursor), start, typeof(KTextEditor.SmartCursor), end, typeof(KTextEditor.SmartRange), parent, typeof(uint), insertBehavior);
        }
        public SmartRange(KTextEditor.SmartCursor start, KTextEditor.SmartCursor end, KTextEditor.SmartRange parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SmartRange###", "SmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*)", typeof(void), typeof(KTextEditor.SmartCursor), start, typeof(KTextEditor.SmartCursor), end, typeof(KTextEditor.SmartRange), parent);
        }
        public SmartRange(KTextEditor.SmartCursor start, KTextEditor.SmartCursor end) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SmartRange##", "SmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*)", typeof(void), typeof(KTextEditor.SmartCursor), start, typeof(KTextEditor.SmartCursor), end);
        }
        /// <remarks>
        ///  \internal
        ///  Notify this range that one or both of the cursors' position has changed directly.
        ///  \param cursor the cursor that changed. If null, both cursors have changed.
        ///  \param from the previous position of this range
        ///      </remarks>        <short>    \internal </short>
        [SmokeMethod("rangeChanged(KTextEditor::Cursor*, const KTextEditor::Range&)")]
        protected override void RangeChanged(KTextEditor.Cursor cursor, KTextEditor.Range from) {
            interceptor.Invoke("rangeChanged##", "rangeChanged(KTextEditor::Cursor*, const KTextEditor::Range&)", typeof(void), typeof(KTextEditor.Cursor), cursor, typeof(KTextEditor.Range), from);
        }
        /// <remarks>
        ///  \internal
        ///  This routine is called when the range changes how much feedback it may need, eg. if it adds an action.
        ///      </remarks>        <short>    \internal </short>
        [SmokeMethod("checkFeedback()")]
        protected virtual void CheckFeedback() {
            interceptor.Invoke("checkFeedback", "checkFeedback()", typeof(void));
        }
        /// <remarks>
        ///  \internal
        ///  Called to request creation of a new SmartRangeNotifier for this object.
        ///      </remarks>        <short>    \internal </short>
        [SmokeMethod("createNotifier()")]
        protected virtual KTextEditor.SmartRangeNotifier CreateNotifier() {
            return (KTextEditor.SmartRangeNotifier) interceptor.Invoke("createNotifier", "createNotifier()", typeof(KTextEditor.SmartRangeNotifier));
        }
        ~SmartRange() {
            interceptor.Invoke("~SmartRange", "~SmartRange()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~SmartRange", "~SmartRange()", typeof(void));
        }
    }
}
