//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  The Constraint enumeration lists the various constraints that Plasma
    ///  objects have managed for them and which they may wish to react to,
    ///  for instance in Applet.ConstraintsUpdated
    ///  </remarks>        <short>    The Constraint enumeration lists the various constraints that Plasma  objects have managed for them and which they may wish to react to,  for instance in Applet.ConstraintsUpdated  </short>
    public enum Constraint {
        NoConstraint = 0,
        FormFactorConstraint = 1,
        LocationConstraint = 2,
        ScreenConstraint = 4,
        SizeConstraint = 8,
        ImmutableConstraint = 16,
        StartupCompletedConstraint = 32,
        ContextConstraint = 64,
        PopupConstraint = 128,
        AllConstraints = FormFactorConstraint|LocationConstraint|ScreenConstraint|SizeConstraint|ImmutableConstraint|ContextConstraint|PopupConstraint,
    }
    /// <remarks>
    ///  The FormFactor enumeration describes how a Plasma.Applet should arrange
    ///  itself. The value is derived from the container managing the Applet
    ///  (e.g. in Plasma, a Corona on the desktop or on a panel).
    /// </remarks>        <short>    The FormFactor enumeration describes how a Plasma.Applet should arrange  itself.</short>
    public enum FormFactor {
        Planar = 0,
        MediaCenter = 1,
        Horizontal = 2,
        Vertical = 3,
    }
    /// <remarks>
    ///  The Direction enumeration describes in which direction, relative to the
    ///  Applet (and its managing container), popup menus, expanders, balloons,
    ///  message boxes, arrows and other such visually associated widgets should
    ///  appear in. This is usually the oposite of the Location.
    /// </remarks>        <short>    The Direction enumeration describes in which direction, relative to the  Applet (and its managing container), popup menus, expanders, balloons,  message boxes, arrows and other such visually associated widgets should  appear in.</short>
    public enum Direction {
        Down = 0,
        Up = 1,
        Left = 2,
        Right = 3,
    }
    /// <remarks>
    ///  The direction of a zoom action.
    ///  </remarks>        <short>    The direction of a zoom action.</short>
    public enum ZoomDirection {
        ZoomIn = 0,
        ZoomOut = 1,
    }
    /// <remarks>
    ///  The Location enumeration describes where on screen an element, such as an
    ///  Applet or its managing container, is positioned on the screen.
    /// </remarks>        <short>    The Location enumeration describes where on screen an element, such as an  Applet or its managing container, is positioned on the screen.</short>
    public enum Location {
        Floating = 0,
        Desktop = 1,
        FullScreen = 2,
        TopEdge = 3,
        BottomEdge = 4,
        LeftEdge = 5,
        RightEdge = 6,
    }
    /// <remarks>
    ///  The position enumeration
    /// </remarks>        <short>    The position enumeration </short>
    public enum Position {
        LeftPositioned = 0,
        RightPositioned = 1,
        TopPositioned = 2,
        BottomPositioned = 3,
        CenterPositioned = 4,
    }
    /// <remarks>
    ///  The popup position enumeration relatively to his attached widget
    /// </remarks>        <short>    The popup position enumeration relatively to his attached widget </short>
    public enum PopupPlacement {
        FloatingPopup = 0,
        TopPosedLeftAlignedPopup = 1,
        TopPosedRightAlignedPopup = 2,
        LeftPosedTopAlignedPopup = 3,
        LeftPosedBottomAlignedPopup = 4,
        BottomPosedLeftAlignedPopup = 5,
        BottomPosedRightAlignedPopup = 6,
        RightPosedTopAlignedPopup = 7,
        RightPosedBottomAlignedPopup = 8,
    }
    /// <remarks>
    ///  Flip enumeration
    ///  </remarks>        <short>    Flip enumeration  </short>
    public enum FlipDirection {
        NoFlip = 0,
        HorizontalFlip = 1,
        VerticalFlip = 2,
    }
    /// <remarks>
    ///  Zoom levels that Plasma is aware of...
    /// </remarks>        <short>    Zoom levels that Plasma is aware of.</short>
    public enum ZoomLevel {
        DesktopZoom = 0,
        GroupZoom = 1,
        OverviewZoom = 2,
    }
    /// <remarks>
    ///  Possible timing alignments
    /// </remarks>        <short>    Possible timing alignments </short>
    public enum IntervalAlignment {
        NoAlignment = 0,
        AlignToMinute = 1,
        AlignToHour = 2,
    }
    public enum ItemTypes {
        AppletType = QGraphicsItem.UserType+1,
        LineEditType = QGraphicsItem.UserType+2,
    }
    /// <remarks>
    ///  Defines the immutability of items like applets, corona and containments
    ///  they can be free to modify, locked down by the user or locked down by the
    ///  system (e.g. kiosk setups).
    ///  </remarks>        <short>    Defines the immutability of items like applets, corona and containments  they can be free to modify, locked down by the user or locked down by the  system (e.</short>
    public enum ImmutabilityType {
        Mutable = 1,
        UserImmutable = 2,
        SystemImmutable = 4,
    }
    /// <remarks>
    ///  Defines the aspect ratio used when scaling an applet
    ///  </remarks>        <short>    Defines the aspect ratio used when scaling an applet  </short>
    public enum AspectRatioMode {
        InvalidAspectRatioMode = -1,
        IgnoreAspectRatio = 0,
        KeepAspectRatio = 1,
        Square = 2,
        ConstrainedSquare = 3,
        FixedSize = 4,
    }
    /// <remarks>
    ///  The ComonentType enumeration refers to the various types of components,
    ///  or plugins, supported by plasma.
    ///  </remarks>        <short>    The ComonentType enumeration refers to the various types of components,  or plugins, supported by plasma.</short>
    public enum ComponentType {
        AppletComponent = 1,
        DataEngineComponent = 2,
        RunnerComponent = 4,
        AnimatorComponent = 8,
        ContainmentComponent = 16,
        WallpaperComponent = 32,
    }
    public enum MarginEdge {
        TopMargin = 0,
        BottomMargin = 1,
        LeftMargin = 2,
        RightMargin = 3,
    }
    public enum MessageButton {
        ButtonNone = 0,
        ButtonOk = 1,
        ButtonYes = 2,
        ButtonNo = 4,
        ButtonCancel = 8,
    }
    /// <remarks>
    ///  Status of an applet
    /// </remarks>        <short>    Status of an applet </short>
    public enum ItemStatus {
        UnknownStatus = 0,
        PassiveStatus = 1,
        ActiveStatus = 2,
        NeedsAttentionStatus = 3,
        AcceptingInputStatus = 4,
    }
    public enum AnnouncementMethod {
        NoAnnouncement = 0,
        ZeroconfAnnouncement = 1,
    }
    public enum TrustLevel {
        InvalidCredentials = 0,
        UnknownCredentials = 1,
        ValidCredentials = 2,
        TrustedCredentials = 3,
        UltimateCredentials = 4,
    }
    /// <remarks>
    ///  @file This file contains the abstract base class for all singular
    ///  animations.
    ///  </remarks>        <short>    @file This file contains the abstract base class for all singular  animations.</short>
    [SmokeClass("Plasma")]
    public class Global {
        private static SmokeInvocation staticInterceptor = null;
        static Global() {
            staticInterceptor = new SmokeInvocation(typeof(Global), null);
        }
        /// <remarks>
        ///  The runtime version of libplasma
        ///  </remarks>        <short>    The runtime version of libplasma  </short>
        public static uint Version() {
            return (uint) staticInterceptor.Invoke("version", "version()", typeof(uint));
        }
        /// <remarks>
        ///  The runtime major version of libplasma
        ///  </remarks>        <short>    The runtime major version of libplasma  </short>
        public static uint VersionMajor() {
            return (uint) staticInterceptor.Invoke("versionMajor", "versionMajor()", typeof(uint));
        }
        /// <remarks>
        ///  The runtime major version of libplasma
        ///  </remarks>        <short>    The runtime major version of libplasma  </short>
        public static uint VersionMinor() {
            return (uint) staticInterceptor.Invoke("versionMinor", "versionMinor()", typeof(uint));
        }
        /// <remarks>
        ///  The runtime major version of libplasma
        ///  </remarks>        <short>    The runtime major version of libplasma  </short>
        public static uint VersionRelease() {
            return (uint) staticInterceptor.Invoke("versionRelease", "versionRelease()", typeof(uint));
        }
        /// <remarks>
        ///  The runtime version string of libplasma
        ///  </remarks>        <short>    The runtime version string of libplasma  </short>
        public static string VersionString() {
            return (string) staticInterceptor.Invoke("versionString", "versionString()", typeof(string));
        }
        /// <remarks>
        ///  Verifies that a plugin is compatible with plasma
        ///  </remarks>        <short>    Verifies that a plugin is compatible with plasma  </short>
        public static bool IsPluginVersionCompatible(uint version) {
            return (bool) staticInterceptor.Invoke("isPluginVersionCompatible$", "isPluginVersionCompatible(unsigned int)", typeof(bool), typeof(uint), version);
        }
        /// <remarks>
        ///  Streaming operators for sending/storing identities.
        ///  </remarks>        <short>    Streaming operators for sending/storing identities.</short>
        // public static QDataStream Write(QDataStream arg1, Plasma.Credentials arg2) {
        //     return (QDataStream) staticInterceptor.Invoke("operator<<##", "operator<<(QDataStream&, const Plasma::Credentials&)", typeof(QDataStream), typeof(QDataStream), arg1, typeof(Plasma.Credentials), arg2);
        // }
        // public static QDataStream Read(QDataStream arg1, Plasma.Credentials arg2) {
        //    return (QDataStream) staticInterceptor.Invoke("operator>>##", "operator>>(QDataStream&, Plasma::Credentials&)", typeof(QDataStream), typeof(QDataStream), arg1, typeof(Plasma.Credentials), arg2);
        // }
        /// <remarks>
        /// </remarks>        <return> the scaling factor (0..1) for a ZoomLevel
        /// </return>
        ///         <short>   </short>
        public static double ScalingFactor(Plasma.ZoomLevel level) {
            return (double) staticInterceptor.Invoke("scalingFactor$", "scalingFactor(Plasma::ZoomLevel)", typeof(double), typeof(Plasma.ZoomLevel), level);
        }
        /// <remarks>
        ///  Converts a location to a direction. Handy for figuring out which way to send a popup based on
        ///  location or to point arrows and other directional items.
        /// <param> name="location" the location of the container the element will appear in
        /// </param></remarks>        <return> the visual direction the element should be oriented in
        /// </return>
        ///         <short>    Converts a location to a direction.</short>
        public static Plasma.Direction LocationToDirection(Plasma.Location location) {
            return (Plasma.Direction) staticInterceptor.Invoke("locationToDirection$", "locationToDirection(Plasma::Location)", typeof(Plasma.Direction), typeof(Plasma.Location), location);
        }
        /// <remarks>
        ///  Converts a location to the direction facing it. Handy for figuring out which way to collapse
        ///  a popup or to point arrows at the item itself.
        /// <param> name="location" the location of the container the element will appear in
        /// </param></remarks>        <return> the visual direction the element should be oriented in
        /// </return>
        ///         <short>    Converts a location to the direction facing it.</short>
        public static Plasma.Direction LocationToInverseDirection(Plasma.Location location) {
            return (Plasma.Direction) staticInterceptor.Invoke("locationToInverseDirection$", "locationToInverseDirection(Plasma::Location)", typeof(Plasma.Direction), typeof(Plasma.Location), location);
        }
        /// <remarks>
        ///  Returns the most appropriate QGraphicsView for the item.
        ///  @arg item the QGraphicsItem to locate a view for
        /// </remarks>        <return> pointer to a view, or 0 if none was found
        ///  </return>
        ///         <short>    Returns the most appropriate QGraphicsView for the item.</short>
        public static QGraphicsView ViewFor(IQGraphicsItem item) {
            return (QGraphicsView) staticInterceptor.Invoke("viewFor#", "viewFor(const QGraphicsItem*)", typeof(QGraphicsView), typeof(IQGraphicsItem), item);
        }
        /// <remarks>
        ///  Returns a list of all actions in the given QMenu
        ///  This method flattens the hierarchy of the menu by prefixing the
        ///  text of all actions in a submenu with the submenu title.
        /// <param> name="menu" the QMenu storing the actions
        /// </param><param> name="prefix" text to display before the text of all actions in the menu
        /// </param><param> name="parent" QObject to be passed as parent of all the actions in the list
        /// </param></remarks>        <short>    Returns a list of all actions in the given QMenu  This method flattens the hierarchy of the menu by prefixing the  text of all actions in a submenu with the submenu title.</short>
        public static List<QAction> ActionsFromMenu(QMenu menu, string prefix, QObject parent) {
            return (List<QAction>) staticInterceptor.Invoke("actionsFromMenu#$#", "actionsFromMenu(QMenu*, const QString&, QObject*)", typeof(List<QAction>), typeof(QMenu), menu, typeof(string), prefix, typeof(QObject), parent);
        }
        public static List<QAction> ActionsFromMenu(QMenu menu, string prefix) {
            return (List<QAction>) staticInterceptor.Invoke("actionsFromMenu#$", "actionsFromMenu(QMenu*, const QString&)", typeof(List<QAction>), typeof(QMenu), menu, typeof(string), prefix);
        }
        public static List<QAction> ActionsFromMenu(QMenu menu) {
            return (List<QAction>) staticInterceptor.Invoke("actionsFromMenu#", "actionsFromMenu(QMenu*)", typeof(List<QAction>), typeof(QMenu), menu);
        }
        /// <remarks>
        ///  @arg types a set of ComponentTypes flags for which to look up the
        ///             language support for
        /// </remarks>        <return> a list of all supported languages for the given type(s).
        /// </return>
        ///         <short>    @arg types a set of ComponentTypes flags for which to look up the             language support for </short>
        public static List<string> KnownLanguages(uint types) {
            return (List<string>) staticInterceptor.Invoke("knownLanguages$", "knownLanguages(Plasma::ComponentTypes)", typeof(List<string>), typeof(uint), types);
        }
        /// <remarks>
        ///  Loads an Applet script engine for the given language.
        /// <param> name="language" the language to load for
        /// </param><param> name="applet" the Plasma.Applet for this script
        /// </param></remarks>        <return> pointer to the AppletScript or 0 on failure; the caller is responsible
        ///          for the return object which will be parented to the Applet
        /// </return>
        ///         <short>    Loads an Applet script engine for the given language.</short>
        public static Plasma.AppletScript LoadScriptEngine(string language, Plasma.Applet applet) {
            return (Plasma.AppletScript) staticInterceptor.Invoke("loadScriptEngine$#", "loadScriptEngine(const QString&, Plasma::Applet*)", typeof(Plasma.AppletScript), typeof(string), language, typeof(Plasma.Applet), applet);
        }
        /// <remarks>
        ///  Loads an DataEngine script engine for the given language.
        /// <param> name="language" the language to load for
        /// </param><param> name="dataEngine" the Plasma.DataEngine for this script;
        /// </param></remarks>        <return> pointer to the DataEngineScript or 0 on failure; the caller is responsible
        ///          for the return object which will be parented to the DataEngine
        /// </return>
        ///         <short>    Loads an DataEngine script engine for the given language.</short>
        public static Plasma.DataEngineScript LoadScriptEngine(string language, Plasma.DataEngine dataEngine) {
            return (Plasma.DataEngineScript) staticInterceptor.Invoke("loadScriptEngine$#", "loadScriptEngine(const QString&, Plasma::DataEngine*)", typeof(Plasma.DataEngineScript), typeof(string), language, typeof(Plasma.DataEngine), dataEngine);
        }
        /// <remarks>
        ///  Loads an Applet script engine for the given language.
        /// <param> name="language" the language to load for
        /// </param><param> name="runner" the Plasma.AbstractRunner for this script
        /// </param></remarks>        <return> pointer to the RunnerScript or 0 on failure; the caller is responsible
        ///          for the return object which will be parented to the AbstractRunner
        /// </return>
        ///         <short>    Loads an Applet script engine for the given language.</short>
        public static Plasma.RunnerScript LoadScriptEngine(string language, Plasma.AbstractRunner runner) {
            return (Plasma.RunnerScript) staticInterceptor.Invoke("loadScriptEngine$#", "loadScriptEngine(const QString&, Plasma::AbstractRunner*)", typeof(Plasma.RunnerScript), typeof(string), language, typeof(Plasma.AbstractRunner), runner);
        }
        /// <remarks>
        ///  Loads an Wallpaper script engine for the given language.
        /// <param> name="language" the language to load for
        /// </param><param> name="runner" the Plasma.Wallpaper for this script
        /// </param></remarks>        <return> pointer to the RunnerScript or 0 on failure; the caller is responsible
        ///          for the return object which will be parented to the Wallpaper
        /// </return>
        ///         <short>    Loads an Wallpaper script engine for the given language.</short>
        public static Plasma.WallpaperScript LoadScriptEngine(string language, Plasma.Wallpaper wallpaper) {
            return (Plasma.WallpaperScript) staticInterceptor.Invoke("loadScriptEngine$#", "loadScriptEngine(const QString&, Plasma::Wallpaper*)", typeof(Plasma.WallpaperScript), typeof(string), language, typeof(Plasma.Wallpaper), wallpaper);
        }
        /// <remarks>
        ///  Loads an appropriate PackageStructure for the given language and type
        /// <param> name="language" the language to load the PackageStructure for
        /// </param><param> name="type" the component type
        /// </param></remarks>        <return> a guarded PackageStructure pointer
        ///  </return>
        ///         <short>    Loads an appropriate PackageStructure for the given language and type </short>
        public static Plasma.PackageStructure PackageStructure(string language, Plasma.ComponentType type) {
            return (Plasma.PackageStructure) staticInterceptor.Invoke("packageStructure$$", "packageStructure(const QString&, Plasma::ComponentType)", typeof(Plasma.PackageStructure), typeof(string), language, typeof(Plasma.ComponentType), type);
        }
    }
}
