/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef KMTMODULE_H
#define KMTMODULE_H

#include <qobject.h>
#include <qptrlist.h>
#include <qwidgetstack.h>

#include "kmtmoduleview.h"
#include <kdemacros.h>

class ModuleViewStack : public QWidgetStack
{
  Q_OBJECT

  public:
    ModuleViewStack(QWidget* parent = 0, const char* name = 0)
      : QWidgetStack(parent, name) {}

  public slots:
    void raiseWidget(QWidget* w);

  signals:
    void signalMessage(const QString&);
    void signalError(const QString&);
    void signalNewCalculation( );
};


class KDE_EXPORT KMathToolModule : public QObject
{
  Q_OBJECT

  public:
    KMathToolModule(QObject* parent = 0, const char* name = 0);
    virtual ~KMathToolModule( );

    QWidget* widget( ) const { return mvstack; }

    void showView(ModuleView* view);
    ModuleViewList views( ) const { return _views; }

  protected:
    void addView(ModuleView* view);

  private:
    ModuleViewStack* mvstack;
    ModuleViewList _views;
};

typedef QPtrList<KMathToolModule> KMathToolModuleList;

#endif // KMTMODULE_H
