/***************************************************************************
 *   Copyright (C) 2006      by Pino Toscano, toscano.pino@tiscali.it      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef KALZIUMSEARCHWIDGET_H
#define KALZIUMSEARCHWIDGET_H

#include <QWidget>

class KLineEdit;
class QTimer;

/**
 * A small widget to control the Search kept in KalziumDataObject.
 *
 * @author Pino Toscano
 */
class SearchWidget : public QWidget
{
    Q_OBJECT

public:
    /**
     * Construct a new empty search.
     */
    SearchWidget( QWidget *parent = 0 );

    ~SearchWidget();

    void giveFocus();

    void appendSearchText( const QString& text );

private slots:
    void searchTextChanged( const QString& text );
    void slotReturnPressed();
    void doSearch();

private:
    KLineEdit *m_searchLine;
    QTimer *m_timer;
};

#endif // KALZIUMSEARCHWIDGET_H
