#! /bin/bash

SOFTWARENAME=kdesudo
podir=${podir:-$PWD/po}
EXTRACTRC=${EXTRACTRC:-extractrc}
EXTRACTATTR=${EXTRACTATTR:-extractattr}
PREPARETIPS=${PREPARETIPS:-preparetips}
CPPFILES=`find -name "*.cpp"`
HFILES=`find -name "*.h"`
export EXTRACTRC EXTRACTATTR PREPARETIPS SOFTWARENAME

XGETTEXT_FLAGS="--copyright-holder=This_file_is_part_of_KDE --from-code=UTF-8 -C --kde -ci18n -ki18n:1 -ki18nc:1c,2 -ki18np:1,2 -ki18ncp:1c,2,3 -ktr2i18n:1 -kI18N_NOOP:1 -kI18N_NOOP2:1c,2 -kaliasLocale -kki18n:1 -kki18nc:1c,2 -kki18np:1,2 -kki18ncp:1c,2,3 --msgid-bugs-address=http://bugs.kde.org"
export XGETTEXT_FLAGS

podir=$podir srcdir=. XGETTEXT_PROGRAM="${XGETTEXT:-xgettext}" XGETTEXT="${XGETTEXT:-xgettext} $XGETTEXT_FLAGS -o $podir/$SOFTWARENAME.pot"
for file in $CPPFILES ; do
	XGETTEXT="$XGETTEXT $file"
done

for file in $HFILES ; do
	XGETTEXT="$XGETTEXT $file"
done

exec $XGETTEXT
