#!/bin/bash
# Run this to generate all the initial makefiles, etc.

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

PKG_NAME="Kino"

(test -f $srcdir/configure.in) || {
    echo -n "**Error**: Directory "\`$srcdir\'" does not look like the"
    echo " top-level directory"
    exit 1
}

DIE=0
export AUTOCONF=autoconf
export AUTOMAKE=automake

function autoconf_version_msg() {
    echo
    echo "You must have autoconf 2.50 or greater."
    echo "Get the latest version from ftp://ftp.gnu.org/gnu/autoconf/"
    DIE=1
}

($AUTOCONF --version) < /dev/null > /dev/null 2>&1 || {
    autoconf_version_msg
}

autoconf_major=`$AUTOCONF --version | head -n 1 | sed 's/^[^0-9]*//' | sed 's/\([0-9]*\).\([0-9]*\)/\1/'`
autoconf_minor=`$AUTOCONF --version | head -n 1 | sed 's/^[^0-9]*//' | sed 's/\([0-9]*\).\([0-9]*\)/\2/'`

if [ $autoconf_major -le 2 ]; then
	if [ $autoconf_major -lt 2 ]; then
		autoconf_version_msg
	fi
fi

function automake_version_msg () { 
    echo
    echo "You must have automake 1.5 or greater."
    echo "Get the latest version from ftp://ftp.gnu.org/gnu/automake/"
    DIE=1
}
($AUTOMAKE --version) < /dev/null > /dev/null 2>&1 || {
    automake_version_msg
}


automake_major=`$AUTOMAKE --version | head -n 1 | sed 's/^.*\([0-9][0-9]*\)\.\([0-9][0-9]*\)\(-[^-]*\)*/\1/'`
automake_minor=`$AUTOMAKE --version | head -n 1 | sed 's/^.*\([0-9][0-9]*\)\.\([0-9][0-9]*\)\(-[^-]*\)*/\2/'`

if [ $automake_major -le 1 ]; then
	if [ $automake_major -lt 1 ]; then
		automake_version_msg
	fi
fi


if test "$DIE" -eq 1; then
	exit 1
fi

if test -z "$GNOME2_DIR" ; then
    GNOME_COMMON_DATADIR="/usr/share"
else
    GNOME_COMMON_DATADIR="$GNOME2_DIR/share"
fi
GNOME_COMMON_MACROS_DIR="`pwd`/macros"
export GNOME_COMMON_DATADIR
export GNOME_COMMON_MACROS_DIR

ACLOCAL_FLAGS="-I $GNOME_COMMON_MACROS_DIR $ACLOCAL_FLAGS"
export ACLOCAL_FLAGS

. $GNOME_COMMON_MACROS_DIR/autogen.sh

