/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PARSERS_H
#define PARSERS_H

#include <qstring.h>

namespace KIO
{
	class SlaveBase;
};
class QHtmlStream;
class AptProtocol;

/** Here are defined the functional objects that takes the tokens
 * sent by AptCache and PackageManager objects, and produces HTML */
namespace Parsers
{
	class Parser
  {
  protected:
  	int m_result_count;

    static void attribute_begin(QHtmlStream& stream, const QString& text);
    static void attribute_end(QHtmlStream& stream);

  public:
  	Parser();
  	virtual ~Parser();
  	int result_count() const { return m_result_count; }
  	virtual void operator () (AptProtocol* slave, const QString& tag, const QString& value) = 0;
  };

  class Search : public Parser
  {
  public:
  	void operator () (AptProtocol* slave, const QString& tag, const QString& value);
  };

  class List : public Parser
  {
    bool m_links;
  public:
    List(bool show_links);
  	void operator () (AptProtocol* slave, const QString& tag, const QString& value);
  };

  class FileSearch : public Parser
  {
  public:
  	void operator () (AptProtocol* slave, const QString& tag, const QString& value);
  };

  class Show : public Parser
  {
  	QString m_package, m_installed;
    bool m_act;

  public:
  	Show(const QString& package, const QString& installed, bool act);
  	void operator () (AptProtocol* slave, const QString& tag, const QString& value);
  };

  class Policy : public Parser
  {
  	QString m_package, m_installed;
    bool m_has_pkgmanager;
    bool m_act;

  public:
    Policy(const QString& package, bool act);
  	QString getInstalled() const { return m_installed; }
  	void operator () (AptProtocol* slave, const QString& tag, const QString& value);
  };

  void operator << (KIO::SlaveBase& slave, const QCString& string);
  void operator << (KIO::SlaveBase& slave, const QString& string);
  void operator << (KIO::SlaveBase& slave, const char* string);

  QString mangle_version(QString version);
  bool hasPkgManager();
};

#endif
