/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: ssi_close.c,v 1.2.2.2 2004/02/18 23:09:46 vsahay Exp $
 *
 */

#include <lam_config.h>

#include <typical.h>
#include <etc_misc.h>
#include <lamdebug.h>
#include <lam-ssi.h>


/*
 * local variables
 */

static int finalized = 0;


/*
 * Main SSI shutdown.
 */
int
lam_ssi_base_close(void)
{
  /* Were we already here?  We really only need to do this once. */

  if (finalized == 1)
    return 0;

  /* If we had a stream open, close it */

  if (lam_ssi_verbose >= 0)
    lam_debug(lam_ssi_did, " Closing");
  if (lam_ssi_did >= 0) {
    lam_debug_close(lam_ssi_did);
    lam_ssi_verbose = -1;
    lam_ssi_did = -1;
  }

  /* All done */

  finalized = 1;
  return 0;
}
