/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: ssi_open.c,v 1.4 2003/02/12 19:36:24 jsquyres Exp $
 *
 */

#include <lam_config.h>

#include <stdio.h>

#include <typical.h>
#include <etc_misc.h>
#include <lamdebug.h>
#include <lam-ssi.h>


/*
 * Global variables
 */

int lam_ssi_verbose = -1;
int lam_ssi_did = -1;


/*
 * local variables
 */

static int initialized = 0;
static lam_debug_stream_info_t lds = {
  -1, -1, -1, NULL, NULL, -1, -1, -1, -1, "ssi.txt"
};


/*
 * Main SSI initialization.  
 */
int
lam_ssi_base_open(OPT *aod)
{
  /* Were we already here?  We really only need to do this once. */

  if (initialized == 1)
    return 0;

  /* What verbosity level do we want? */

  lam_ssi_base_set_verbose("LAM_MPI_SSI_ssi_verbose", &lds,
			   aod, &lam_ssi_verbose, &lam_ssi_did);
  if (lam_ssi_verbose >= 0)
    lam_debug(lam_ssi_did, " Opening");

  /* All done */

  initialized = 1;
  return 0;
}
