/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 *
 * $HEADER$
 *
 * $Id: ssi_boot_close.c,v 1.10 2003/03/20 12:09:10 jsquyres Exp $
 *
 */

#include <lam_config.h>

#include <lam-ssi-boot.h>
#include <lamdebug.h>

#include <stdio.h>


int
lam_ssi_boot_close(void)
{
  int ret = 0;

  /* Call finalize on the active boot module */

  if (lam_ssi_boot_base_module.lsb_finalize != NULL)
    lam_ssi_boot_base_module.lsb_finalize();

  /* Call close on the active boot module */

  if (lam_ssi_boot_base_module.lsb_meta_info.ssi_close_module != NULL)
    ret = lam_ssi_boot_base_module.lsb_meta_info.ssi_close_module();

  /* Close the debug stream */

  if (lam_ssi_boot_verbose >= 1)
    lam_debug(lam_ssi_boot_did, " Closing");
  if (lam_ssi_boot_did >= 0) {
    lam_debug_close(lam_ssi_boot_did);
    lam_ssi_boot_did = -1;
  }

  /* Shut down the SSI glue */

  lam_ssi_base_close();

  return ret;
}
