/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: ssi_coll_close.c,v 1.5 2003/04/03 18:33:09 jsquyres Exp $
 *
 */

#include <lam_config.h>

#include <stdio.h>

#include <all_list.h>
#include <lam-ssi-coll.h>
#include <lamdebug.h>


int
lam_ssi_coll_base_close(void)
{
  int i, ret = 0;

  /* Close all the SSI collective modules */

  for (i = 0; lam_ssi_coll_modules[i] != NULL; ++i)
    if (lam_ssi_coll_modules[i]->lsc_meta_info.ssi_close_module != NULL)
      ret += lam_ssi_coll_modules[i]->lsc_meta_info.ssi_close_module();

  /* Free the available list */

  al_free(lam_ssi_coll_base_available);

  /* Close the debug stream */

  if (lam_ssi_coll_verbose >= 0)
    lam_debug(lam_ssi_coll_did, "close: Closing");
  if (lam_ssi_coll_did >= 0) {
    lam_debug_close(lam_ssi_coll_did);
    lam_ssi_coll_did = -1;
  }

  /* Shut down the SSI glue */

  lam_ssi_base_close();

  return ret;
}
