/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: rpi_gm_util.h,v 1.7.2.2 2004/03/12 01:19:11 vsahay Exp $
 */

#ifndef LAM_SSI_RPI_GM_UTIL_H
#define LAM_SSI_RPI_GM_UTIL_H

#include <rpi_gm.h>


/*
 * Common start for all send callbacks
 */
#define LAM_SSI_RPI_GM_SEND_CALLBACK_START \
  MPI_Request req = (MPI_Request) context; \
  if (status != GM_SUCCESS) { \
    lam_ssi_rpi_gm_send_callback_fail(port, status); \
    return; \
  }

/*
 * Common finish for all send callbacks
 *
 * Note that we just got a send token back, but we can't try to
 * advance the pending send queue because we're still in a callback.
 * Hence, the main advance will notice that progress was made on sends
 * and will try to advance the pending send queue.
 */
#define LAM_SSI_RPI_GM_SEND_CALLBACK_FINISH \
  ++lam_ssi_rpi_gm_stokens; \
  lam_debug_cond((PUB(did), "++++incremented stokens to: %d", lam_ssi_rpi_gm_stokens)); \
  lam_ssi_rpi_gm_haveadv = 1;


/*
 * public functions
 */

void lam_ssi_rpi_gm_send_callback_fail(struct gm_port *port, 
				       gm_status_t status);
void lam_ssi_rpi_gm_fill_wildcards(MPI_Request req, 
				   struct lam_ssi_rpi_envl *env);
int lam_ssi_rpi_gm_setup_request_dma(MPI_Request req);


#endif /* LAM_SSI_RPI_GM_UTIL_H */
