dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2004 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_sysv_ipc_config.m4,v 1.3.2.1 2004/01/20 12:36:21 jsquyres Exp $
dnl

AC_DEFUN([LAM_CHECK_HAVE_SYSV_SEMAPHORES],[
#
# Arguments: none
#
# Dependencies: None
#
# Sets:
# LAM_HAVE_SYSV_SEMAPHORES (variable)
# LAM_HAVE_SYSV_SEMAPHORES (ac_define)
#
# Test for existance of SYSV Semaphores (not all Unixes do *cough* MacOS X
# *cough*).  This must be before the RPI selection logic, as we need to
# abort if the user chooses rpi=SYSV and we don't have SysV semaphores.
#

LAM_HAVE_SYSV_SEMAPHORES=0
AC_CHECK_HEADERS(sys/sem.h, 
	[LAM_HAVE_SYSV_SEMAPHORES=1 MSG="yes"], 
	[LAM_HAVE_SYSV_SEMAPHORES=0 MSG="no"],
	[#include <sys/types.h>])
AC_MSG_CHECKING([for SYSV semaphore support])
AC_MSG_RESULT([$MSG])
AC_DEFINE_UNQUOTED(LAM_HAVE_SYSV_SEMAPHORES, $LAM_HAVE_SYSV_SEMAPHORES,
    [Whether we have SYSV semaphores or not])
unset MSG])dnl


AC_DEFUN([LAM_CHECK_HAVE_SYSV_SHMEM],[
#
# Arguments: none
#
# Dependencies: None
#
# Sets:
# LAM_HAVE_SYSV_SHMEM (variable)
# LAM_HAVE_SYSV_SHMEM (ac_define)
#
# Test for existance of SYSV shared memory (not all platforms do
# *cough* Cygwin # *cough*).  This must be before the RPI selection
# logic, as we need to # abort if the user chooses rpi=<something 
# requiring sysv shmem> and we don't have any.
#

LAM_HAVE_SYSV_SHMEM=0
MSG="no"
AC_CHECK_HEADERS(sys/ipc.h, 
    [lam_have_ipc_h=1], [lam_have_ipc_h=0],
    [#include <sys/types.h>])
AC_CHECK_HEADERS(sys/shm.h,
    [lam_have_shm_h=1], [lam_have_shm_h=0],
    [#include <sys/types.h>])
if test "$lam_have_ipc_h" = "1" -a "$lam_have_shm_h" = "1"; then
    LAM_HAVE_SYSV_SHMEM=1
    MSG="yes"
fi
AC_MSG_CHECKING([for SYSV shared memory support])
AC_MSG_RESULT([$MSG])
AC_DEFINE_UNQUOTED(LAM_HAVE_SYSV_SHMEM, $LAM_HAVE_SYSV_SHMEM, 
    [Whether we have SYSV shared memory or not])
unset MSG lam_have_shm_h lam_have_ipc_h ])dnl
