#include "ldm-getenv-bool.h"
#include "ldminfo.h"

struct ldm_info {
    gchar    *server;
    gchar    *display;
    gchar    *fontpath;
    gchar    *override_port;
    gchar    *authfile;
    gchar    *username;
    gchar    *password;
    gchar    *lang;
    gchar    *session;
    gchar    *xsession;
    gchar    *sshoptions;
    gchar    *sound_daemon;
    gchar    *greeter_prog;
    gchar    *control_socket;
    gchar    *ipaddr;
    gboolean allowguest;
    gboolean autologin;
    gboolean sound;
    gboolean localdev;
    gboolean directx;
    gint     sshfd;
    gint     sshslavefd;
    GIOChannel *greeterr;
    GIOChannel *greeterw;
    GPid     pid;
    GPid     sshpid;
    GPid     xsessionpid;
    GPid     greeterpid;
};

/* forward decls */

void die(char *msg);
pid_t ldm_spawn (gchar *command, gint *rfd, gint *wfd, void (*setup)());
void ldm_wait(pid_t pid);
int get_userid();
int get_passwd();
int get_language();
int get_host();
int get_session();
void ssh_session(void);
void ssh_endsession(void);
void close_greeter(void);
void get_ipaddr(void);
void loginfo(const char *format, ...);
void logerr(const char *format, ...);
int set_message(gchar *message);

extern volatile sig_atomic_t unexpected_child;
extern volatile sig_atomic_t child_exited;
extern struct ldm_info ldm;

#define SENTINEL "LTSPROCKS"
#define MAXEXP 4096
