import re, gzip
from linda import libchecks, checks
from linda.dpkgver import DpkgVersion
from sets import Set

class ChangelogCheck(libchecks.LindaChecker):
    'Checks to do with the Debian and upstream changelog.'
    def init(self):
        self.changelogs = {}
        self.info = {'usr_share_doc_sym': 0, 'found_upstream': 0}
        self.changelog = {'file': None, 'name': ''}
        self.usd_path = re.compile(r'/usr/(share/)?doc/%s' % \
            self.pkg_name.replace('+', r'\+'))
        
    def check_binary_2(self):
        self.usr_share_doc_sym()
        self.search_changelogs()
        for chg in self.changelogs.keys():
            dprint(_("Calling checks for %s.") % chg, 3)
            self.changelog_checks(chg)
        self.specific_changelog_checks()

    def usr_share_doc_sym(self):
        if os.path.islink(os.path.join(self.information['dir'], \
            'unpacked/usr/share/doc', self.pkg_name)):
            self.info['usr_share_doc_sym'] = 1
            other_pkg = os.path.split(os.readlink(os.path.join(self.information['dir'], \
                'unpacked/usr/share/doc', self.pkg_name)))[-1]
            if self.information['control']['self'][0].has_key('depends'):
                if not self.information['control']['self'][0]['depends'].has_key(other_pkg) \
                    and not DataValidator('essential', other_pkg):
                    self.signal_error('usd-symlink-no-depends')
    def search_changelogs(self):
        for chg in self.information['collector']('files', 'files').keys():
            if re.search(r'\/doc.*changelog', chg, re.IGNORECASE):
                full_file_name = os.path.join(self.information['dir'], \
                    'unpacked', chg[1:])
                size = 0
                if os.path.exists(full_file_name):
                    size = int(os.path.getsize(full_file_name))
                file_path, file_name = os.path.split(chg)
                self.changelogs[chg] = {'size': size, 'link': \
                    os.path.islink(full_file_name), 'path': file_path, \
                    'file': file_name}
        dprint(_("Changelogs found: %s.") % self.changelogs, 2)
    def changelog_checks(self, chg):
        if not self.changelogs[chg]['link']:
            if self.changelogs[chg]['size'] > 4096 and not \
                chg.endswith('.html'):
                if self.information['collector']('output', 'file')[chg].find('gzip compressed') == -1:
                    self.signal_error('non-compressed-changelog', [chg])
                elif self.information['collector']('output', 'file')[chg].find('max compression') == -1:
                    self.signal_error('not-max-compression-changelog', [chg])
        if self.changelogs[chg]['path'].startswith('/usr/doc'):
            self.signal_error('changelog-usr-doc')
        if re.search(r'\.html?$', self.changelogs[chg]['file']):
            changelogs = Set(("/usr/share/doc/%s/changelog" % self.pkg_name, \
                "/usr/share/doc/%s/changelog.gz" % self.pkg_name))
            if not changelogs.intersection(self.changelogs.keys()):
                self.signal_error('html-only-changelog')
        if re.match(self.usd_path, self.changelogs[chg]['path']):
            if self.is_native():
                if self.changelogs[chg]['file'].startswith('changelog.Debian') and not self.changelog['name']:
                    self.signal_error('wrong-changelog-name')
                if self.changelogs[chg]['file'].startswith('changelog') and \
                    not self.changelog['name']:
                    self.set_changelog(chg)
            else:
                if self.changelogs[chg]['file'].startswith('changelog.Debian'):
                    self.set_changelog(chg)
                elif self.changelogs[chg]['file'].startswith('changelog'):
                    self.info['found_upstream'] = 1                    
    def specific_changelog_checks(self):
        if not self.is_native():
            if not self.info['found_upstream'] and not \
                self.info['usr_share_doc_sym']:
                self.signal_error('no-upstream-changelog')
        if self.changelog['file']:
            for line in self.changelog['file']:
                if line.startswith('add-log-mailing-address: '):
                    self.signal_error('emacs-settings-in-changelog', \
                        [self.changelog['name']])
            self.changelog['file'].close()
        else:
            tmp_name = 'changelog'
            if not self.is_native():
                tmp_name = 'changelog.Debian'
            if not self.info['usr_share_doc_sym']:
                self.signal_error('no-changelog', [tmp_name])
    
    def check_source_2(self):
        self.check_version()

    def check_version(self):
        try:
            f = open('%s/debian/changelog' % self.information['dir'])
        except IOError, e:
            dprint(_("Can't open changelog: %s.") % e)
            f = 0
        all_ver = []
        if f:
            urgency = re.compile(r'^\w.*urgency=')
            for k in f:
                if urgency.match(k):
                    start, end = map(k.find, '()')
                    pos_ver = k[start+1:end]
                    all_ver.append(DpkgVersion(pos_ver))
                    if len(all_ver) == 2:
                        break
            f.close()
        if len(all_ver) == 2:
            if all_ver[0] < all_ver[1]:
                self.signal_error('next-ver-less-than-prev', all_ver)
            if all_ver[0].is_native() != all_ver[1].is_native():
                switching = ['native', 'non-native']
                if all_ver[0].is_native():
                    switching = ['non-native', 'native']
                self.signal_error('switching-native-nonnative', switching)
            
    def set_changelog(self, changelog):
        self.changelog['name'] = changelog
        dprint(_("Setting changelog to: %s") % changelog, 2)
        if not self.changelogs[changelog]['link']:
            file_name = os.path.join(self.information['dir'], 'unpacked', \
                changelog[1:])
            if self.information['collector']('output', 'file')[changelog].find('gzip compresed') != -1:
                self.changelog['file'] = gzip.open(file_name)
            else:
                self.changelog['file'] = open(file_name)

checks.register(ChangelogCheck)

