import md5, string
from linda import libchecks, checks
from linda.parser.changes import ChangesParser

class ChangesCheck(libchecks.LindaChecker):
    def init(self):
        self.changes_file = None
        self.path = os.path.split(self.file)[0]
        self.md5sums = {}
        
    def check_changes_1(self):
        self.changes_file = ChangesParser(self.file)
        self.check_distribution()
        self.calculate_md5sums()
        self.check_files()

    def check_distribution(self):
        if self.changes_file[0].has_key('distribution'):
            for distribution in self.changes_file[0]['distribution']:
                if distribution in ('woody-proposed-updates', \
                    'testing-proposed-updates'):
                    self.signal_error('obsolete-dist', [distribution])
                    continue
                if distribution not in ('oldstable-security', 'stable', \
                    'stable-security', 'testing', 'testing-security', \
                    'unstable', 'experimental'):
                    self.signal_error('incorrect-distribution', \
                        [distribution])

    def calculate_md5sums(self):
        hexStr = string.hexdigits
        if self.changes_file[0].has_key('files'):
            for file in self.changes_file[0]['files']:
                self.md5sums[file[-1]] = 0
                try:
                    f = open(os.path.join(self.path, file[-1]))
                except EnvironmentError, e:
                    dprint(_("Can't calculate md5 for %s: %s.") % (file[-1], \
                        e))
                    f = 0
                if f:
                    check_obj = md5.new()
                    for x in f:
                        check_obj.update(x)
                    f.close()
                    checksum = ''
                    for c in check_obj.digest():
                        checksum = checksum + hexStr[(ord(c) >> 4) & 0xF] + \
                            hexStr[ord(c) & 0xF]
                    self.md5sums[file[-1]] = checksum

    def check_files(self):
        if self.changes_file[0].has_key('files'):
            for file in self.changes_file[0]['files']:
                if os.path.exists(os.path.join(self.path, file[-1])):
                    cur_file_size = os.path.getsize(os.path.join(self.path, \
                        file[-1]))
                else:
                    cur_file_size = 0
                if not self.md5sums[file[-1]] or not cur_file_size:
                    dprint(_("Md5sum or file size for %s is zero.") % file[-1])
                    continue
                else:
                    if file[0] != self.md5sums[file[-1]]:
                        self.signal_error('md5sum-mismatch', [file[-1]])
                    if int(file[1]) != cur_file_size:
                        self.signal_error('file-size-mismatch', [file[-1]])
                section = ''
                if file[2].find('/') != -1:
                    # Should be either contrib or non-free
                    split_line = file[2].split('/')
                    section = split_line[1]
                    if split_line[0] not in ('contrib', 'non-free', 'non-US'):
                        self.signal_error('unknown-component-changes', \
                            [split_line[0]])
                else:
                    section = file[2]
                if not DataValidator('section', section) and section != \
                    'byhand':
                    self.signal_error('unknown-section-changes', [file[-1], \
                        section])

checks.register(ChangesCheck)

