from linda import libchecks, checks

class UDebBinaryCheck(libchecks.LindaChecker):
    'Perform common in-deb checks for .udebs'
    def init(self):
        self.arch = 'none'
        
    def check_udeb_2(self):
        self.check_control()
        self.check_dirs()
        self.check_files()
        
    def check_control(self):
        if self.information['control']['self'][0].has_key('architecture'):
            self.arch = self.information['control']['self'][0]['architecture']
        if self.information['control']['self'][0].has_key('description'):
            if self.information['control']['self'][0]['description'][0].find(',') != -1:
                self.signal_error('comma-in-short-desc')
    def check_dirs(self):
        for dir in ('usr/share/doc', 'usr/share/man', 'usr/local'):
            if os.path.exists(os.path.join(self.information['dir'], \
                'unpacked', dir)):
                self.signal_error('%s-in-udeb' % '-'.join(dir.split('/')))
        if self.information['collector']('files', 'elf') and self.arch == \
            'all':
            self.signal_error('udeb-pkg-should-be-arch-any')
    def check_files(self):
        for file in self.information['collector']('files', 'files').keys():
            if file.startswith('/usr/share'):
                self.signal_error('file-in-u-s')
            if file.startswith('/usr/doc'):
                self.signal_error('usr-doc-in-udeb')
            if file.find('/CVS/') != -1:
                self.signal_error('cvs-dir-in-udeb')

checks.register(UDebBinaryCheck)

