import os, sys, re, linda, gettext
from linda import clparser
from linda.debug import dprint
from linda.eggs import LindaEasterEggs
from linda.libchecks import Checks
from linda.output import OutputFormats
from linda.parser.changes import ChangesParser
from linda.parser.clparser import CLParser, CLParsingException
from linda.parser.config import ConfigFileParser, ConfigFileParserException

gettext.install('linda', unicode=True)
try:
    clparser.parse_args()
except CLParsingException, e:
    print "Linda: %s" % str(e)
    sys.exit(7)
try:
    ConfigFileParser()
except ConfigFileParserException, e:
    print _("Error parsing config file: %s") % e
if not clparser['quiet']:
    LindaEasterEggs()
linda.checks = Checks()
linda.checks.startup_register()
linda.outputformats = OutputFormats()
linda.outputformats.register_all('%s/output' % linda.root)
for x in clparser['files']:
    if x.endswith('.changes'):
        ch = ChangesParser(x)
        for y in ch[0]['files']:
            if os.path.exists(y[-1]) and not re.search('(diff|tar)\.gz', \
                y[-1]):
                clparser['files'].append(y[-1])
dprint(_("Command line arguments: %s.") % clparser.arguments)
if clparser['checks']:
    linda.checks.purge()
if clparser['list-checks']:
    linda.checks.print_checks()
    sys.exit(0)
if clparser['format']:
    if clparser['format'].lower() == 'help':
        print _("Output formats:")
        for x in filter(lambda x: x != '', linda.outputformats.keys()):
            if linda.outputformats[x].__doc__ is not None:
                docstr = linda.outputformats[x].__doc__
            else:
                docstr = 'No doc string.'
            print "  - %s: %s" % (x, docstr)
        sys.exit(0)
    else:
        if clparser['format'].lower() in linda.outputformats.keys():
            if clparser['format'].lower() == 'figlet':
                if os.path.exists('/usr/bin/figlet'):
                    linda.outputobj = linda.outputformats['figlet']()
                else:
                    linda.outputobj = linda.outputformats['']()
            else:
                linda.outputobj = \
                    linda.outputformats[clparser['format'].lower()]()
        else:
            linda.outputobj = linda.outputformats['']()
else:
    linda.outputobj = linda.outputformats['']()
        
