#!/usr/bin/python

from test import test_support
# Checks
from binary_binary import BinaryCheckBinaryTest
from binary_changelog import ChangelogCheckBinaryTest
from binary_configfile import ConfigFileCheckBinaryTest
from binary_control import ControlCheckBinaryTest
from binary_controlfiles import ControlFilesCheckBinaryTest
from binary_copyright import CopyrightCheckBinaryTest
from binary_debconf import DebconfCheckBinaryTest
from binary_documentation import DocumentationCheckBinaryTest
from binary_dpkg import DpkgCheckBinaryTest
from binary_examplefiles import ExampleFilesCheckBinaryTest
from binary_files import FilesCheckBinaryTest
from binary_library import LibraryCheckBinaryTest
from binary_menu import MenuCheckBinaryTest
from binary_perl import PerlCheckBinaryTest
from binary_shebang import ShebangCheckBinaryTest
from changes_changes import ChangesCheckChangesTest
from source_cdbs import CDBSCheckSourceTest
from source_changelog import ChangelogCheckSourceTest
from source_control import ControlCheckSourceTest
from source_debhelper import DebhelperCheckSourceTest
from source_examplefiles import ExampleFilesCheckSourceTest
from source_files import FilesCheckSourceTest
from source_standards_version import StandardsVersionCheckSourceTest
from udeb_udebbinary import UDebBinaryCheckUDebTest
from udeb_udebcontrol import UDebControlCheckUDebTest
# Parsers
from parser_changes import ChangesParserTest
from parser_clparser import CLParserTest
from parser_config import ConfigFileParserTest
from parser_control import DebianControlParserTest
from parser_data import DataFileParserTest
from parser_datavalidator import DataValidatorTest
from parser_debfilename import DebFilenameParserTest
from parser_dsc import DSCParserTest
from parser_makefile import MakefileParserTest
from parser_menu import MenuParserTest
from parser_override import OverrideParserTest
from parser_template import TemplateParserTest
from parser_unixperm import UnixPermParserTest
# Output Formats
from output_branden import BrandenOutputTest
from output_lintian import LintianOutputTest
from output_long import LongOutputTest
from output_normal import NormalOutputTest
# Base
from base_checks import ChecksBaseTest
from base_collector import CollectorBaseTest
from base_dpkgver import DpkgVersionBaseTest
from base_errdict import ErrDictBaseTest
from base_errprint import PrintErrorsBaseTest
from base_funcs import FuncsBaseTest
from base_lindachecker import LindaCheckerBaseTest
from base_output import OutputBaseTest
from base_outputformats import OutputFormatsBaseTest
from base_overrides import OverridesBaseTest
from base_unpacker import UnpackerBaseTest
# End-to-end
from endtoend import EndToEndTest
from keys import KeysTest

test_support.run_unittest(BinaryCheckBinaryTest, ChangelogCheckBinaryTest, \
    ConfigFileCheckBinaryTest, ControlCheckBinaryTest, \
    ControlFilesCheckBinaryTest, CopyrightCheckBinaryTest, \
    DebconfCheckBinaryTest, DocumentationCheckBinaryTest, \
    DpkgCheckBinaryTest, ExampleFilesCheckBinaryTest, FilesCheckBinaryTest, \
    LibraryCheckBinaryTest, MenuCheckBinaryTest, PerlCheckBinaryTest, \
    ShebangCheckBinaryTest, ChangesCheckChangesTest, CDBSCheckSourceTest, \
    ChangelogCheckSourceTest, ControlCheckSourceTest, \
    DebhelperCheckSourceTest, ExampleFilesCheckSourceTest, \
    FilesCheckSourceTest, StandardsVersionCheckSourceTest, \
    UDebBinaryCheckUDebTest, UDebControlCheckUDebTest, ChangesParserTest, \
    CLParserTest, ConfigFileParserTest, DebianControlParserTest, \
    DataFileParserTest, DataValidatorTest, DebFilenameParserTest, \
    DSCParserTest, MakefileParserTest, MenuParserTest, OverrideParserTest, \
    TemplateParserTest, UnixPermParserTest, BrandenOutputTest, \
    LintianOutputTest, LongOutputTest, NormalOutputTest, ChecksBaseTest, \
    CollectorBaseTest, DpkgVersionBaseTest, ErrDictBaseTest, \
    PrintErrorsBaseTest, FuncsBaseTest, LindaCheckerBaseTest, \
    OutputBaseTest, OutputFormatsBaseTest, OverridesBaseTest, \
    UnpackerBaseTest, EndToEndTest, KeysTest)

