import re
from linda import libchecks, checks

class LibraryCheck(libchecks.LindaChecker):
    'Checks things regarding shared libraries.'
    def init(self):
        self.numbers = {'libraries': 0, 'binaries': 0}
        self.libraries = {}
        self.la_files = []
        self.info = {'soname_in_pkg': 0, 'pkgname_vs_soname': 0}
        self.lib_paths = ('/lib', '/usr/lib', '/usr/lib/libg++-dbg', \
            '/usr/X11R6/lib/Xaw3d', '/usr/local/lib', '/usr/X11R6/lib', \
            '/usr/lib/libc5-compat', '/lib/libc5-compat')
        
    def check_binary_2(self):
        self.discover_libraries()
        for library in self.libraries.keys():
            self.discover_sonames(library)
        self.check_against_libs()
        self.check_la_files()
        self.check_shlibs()
        
    def discover_libraries(self):
        for file in self.information['collector']('files', 'elf'):
            if self.information['collector']('output', 'file')[file].find('LSB shared object') != -1 and file.find('/perl5/') == -1:
                self.numbers['libraries'] += 1
                self.libraries[file] = ''
            elif self.information['collector']('output', 'file')[file].find('LSB executable') != -1:
                self.numbers['binaries'] += 1
            if file.endswith('.so') and \
                os.path.islink(os.path.join(self.information['dir'], \
                'unpacked', file[1:])) and not self.pkg_name.endswith('-dev'):
                self.signal_error('so-symlink-non-dev')
        dprint(_("Libraries discovered without the need of Australian Idol: %s") % self.numbers['libraries'], 3)
        for file in self.information['collector']('files', 'files'):
            if file.endswith('.la'):
                self.la_files.append(file)
        dprint(_("Libraries themselves: %s") % self.libraries, 3)
    def discover_sonames(self, file):
        if not os.path.islink(os.path.join(self.information['dir'], \
            'unpacked', file[1:])):
            path = os.path.split(file)[0]
            if path in self.lib_paths:
                obj = self.information['collector']('output', 'objdump')[file]
                if obj.find('SONAME') != -1:
                    cur_soname = obj[obj.find('SONAME'):obj.find('\n', \
                        obj.find('SONAME'))].split()[-1].split('.')[0]
                    if "-" in cur_soname:
                        cur_soname = cur_soname.rsplit('-', 1)[0]
                    if cur_soname:
                        self.libraries[file] = cur_soname
                del obj
        if re.search(r'[0-9]\.so\.[0-9]', self.libraries[file]):
            self.libraries[file] = self.libraries[file].replace('.so.', '-')
        else:
            self.libraries[file] = self.libraries[file].replace('.so.', '')
        dprint(_("SONAMEs discovered: %s") % self.libraries, 3)
    def check_against_libs(self):
        if ''.join(self.libraries.values()) and not self.numbers['binaries']:
            if self.information['control']['self'][0]['section'][-1] not in \
                ('libs', 'base', 'oldlibs'):
                self.signal_error('section-not-libs')
            if not self.pkg_name.startswith('lib'):
                self.signal_error('package-not-start-lib')
        for library in self.libraries.keys():
            if self.pkg_name.find(self.libraries[library].lower()) != -1 or \
                self.libraries[library].lower().find(self.pkg_name) != -1:
                self.info['soname_in_pkg'] = 1
        if self.numbers['libraries'] and not self.info['soname_in_pkg']:
            self.signal_error('package-notlike-soname')
    def check_la_files(self):
        for file in self.la_files:
            path, throw = os.path.split(file)
            la_path = ''
            f = open(os.path.join(self.information['dir'], 'unpacked', \
                file[1:]))
            for line in f:
                if line.startswith('libdir='):
                    la_path = line[line.find("'")+1:line.rfind("'")]
            f.close()
            if la_path.endswith('/'):
                la_path = la_path[:-1]
            if la_path != path:
                self.signal_error('libdir-not-equal-dir', [file])
    def check_shlibs(self):
        shlibs_file = {}
        real_shlibs = {}
        for library in self.libraries:
            dir, throw = os.path.split(library)
            if dir in self.lib_paths:
                real_shlibs[library] = self.libraries[library]
        if os.path.exists(os.path.join(self.information['dir'], 'control', \
            'shlibs')):
            shlibsf = open(os.path.join(self.information['dir'], 'control', \
                'shlibs'))
            for line in shlibsf:
                cur_line = line[:-1].split(' ', 2)
                shlibs_file[cur_line[0]] =  [cur_line[1], cur_line[2]]
            shlibsf.close()
        elif real_shlibs.keys():
            self.signal_error('no-shlib-file')
        for library in real_shlibs:
            dir, filename = os.path.split(library)
            if self.libraries[library] not in shlibs_file.keys():
                self.signal_error('lib-not-in-shlibs', \
                    [self.libraries[library]])
            else:
                sym = ''
                for file in self.information['collector']('files', 'files').keys():
                    if os.path.split(file)[0] == dir:
                        throw, name = os.path.split(file)
                        if name.startswith("%s." % self.libraries[library]) \
                            and self.information['collector']('files', \
                            'files')[file].is_link() and re.search(r'\d', \
                            name):
                            sym = file
                sover = ''
                if not sym: # Library doesn't have a symlink for some reason
                    continue
                if sym.endswith('.so'):
                    sover = sym.split(self.libraries[library])[1].split('.so')[0]
                else:
                    sover = sym.split('.so.')[1]
                if sover != shlibs_file[self.libraries[library]][0]:
                    self.signal_error('shlibs-sover-mismatch', \
                        [self.libraries[library]])
    
checks.register(LibraryCheck)

