from linda.debug import dprint
import os

def run_external_cmd(command='false', ignoreexit=0):
    pipe = os.popen('%s 2>/dev/null' % command)
    output = pipe.read()
    exitstat = pipe.close()
    if exitstat is None:
        exitstat = 0
    if output[-1:] == '\n':
        output = output[:-1]
    if exitstat != 0 and not ignoreexit:
        dprint(_("%s failed (%d): %s") % (command, exitstat, output))
        raise ExtCmdException("%s exited with a status of %d" % (command, \
            exitstat))
    return output

class ExtCmdException(Exception):
    pass

def iterate_dir(directory):
    tmp_file = []
    os.path.walk(directory, add_file, tmp_file)
    return tmp_file

def add_file(arg, dirname, names):
    for x in names:
        if os.path.isfile(os.path.join(dirname, x)) or \
            os.path.islink(os.path.join(dirname, x)):
            arg.append(os.path.join(dirname, x))

def explode_path(path):
    if not path:
        return []
    if path[0] == '.':
        path = path[1:]
    split = list(os.path.split(path))
    while True:
        other_split = list(os.path.split(split[0]))
        if other_split[0] == '/':
            split = other_split[1:] + split[1:]
            break
        else:
            split = other_split + split[1:]
    return split

