import os, re
from linda import root, clparser
from linda.debug import dprint
from linda.funcs import run_external_cmd, ExtCmdException
from linda.parser.debfilename import DebFilenameParser
from linda.parser.override import OverrideParser, OverrideParserException

class Overrides:
    def __init__(self, file, lab):
        self.file = file
        debfn = DebFilenameParser(file)
        self.pkg_name = debfn.package
        self.data = {}
        self.lab = lab
    
    def parse(self):
        for directory in ('%s/overrides' % root, '/etc/linda/overrides', \
            os.path.expanduser('~/.linda/overrides')):
            for file in ('all', self.pkg_name):
                dprint(_('Trying to parse %s/%s for overrides.') % \
                    (directory, file), 2)
                try:
                    override = OverrideParser('%s/%s' % (directory, file))
                except EnvironmentError:
                    continue
                except OverrideParserException, e:
                    dprint(_('Failed to parse %s/s for overrides: %s.') % \
                        (directory, file, e), 2)
                self.merge(override)
        if clparser['more-overrides']:
            dprint(_('Trying to parse %s for overrides.') % \
                clparser['more-overrides'], 2)
            override = OverrideParser(clparser['more-overrides'])
            self.merge(override)
        if os.path.exists(os.path.join(self.lab, 'data.tar.gz')):
            file_name = './usr/share/linda/overrides/%s' % self.pkg_name
            dprint(_('Trying to parse in-deb overrides.'), 2)
            indeb = open(os.path.join(self.lab, 'indeb'), 'w')
            try:
                output = run_external_cmd('tar zxfO %s %s' % \
                    (os.path.join(self.lab, 'data.tar.gz'), file_name))
                indeb.write(output)
                indeb.close()
                override = OverrideParser(os.path.join(self.lab, 'indeb'))
                self.merge(override)
            except ExtCmdException:
                pass
            except OverrideParserException, e:
                dprint(_('Failed to parse in-deb overrides: %s.') % e, 2)
            os.unlink(os.path.join(self.lab, 'indeb'))
        if clparser['print-overrides']:
            print _("Overrides: %s") % self.data

    def merge(self, data):
        for key in data.keys():
            self.data[key] = data[key]

    def check(self, err_dicts, data_files):
        for err_dict in err_dicts.keys():
            for tag in err_dicts[err_dict].keys():
                dprint("Checking overrides for %s." % tag)
                if self.data.has_key(tag):
                    if not self.data[tag]:
                        del err_dicts[err_dict][tag]
                        dprint(_("Overridding tag %s.") % tag)
                    elif self.data[tag].has_key('Type'):
                        dprint("Overridding tag %s's type of %s to %s." % \
                            (tag, data_files[err_dict][tag]['Type'], \
                             self.data[tag]['Type']))
                        data_files[err_dict][tag]['Type'] = \
                            self.data[tag]['Type']
                    elif self.data[tag].has_key('Data'):
                        to_del = []
                        if not err_dicts[err_dict][tag][0]:
                            if not self.data[tag].has_key('Type'):
                                del err_dicts[err_dict][tag]
                                continue
                        for error in range(len(err_dicts[err_dict][tag])):
                            for data in err_dicts[err_dict][tag][error]:
                                if re.search(self.data[tag]['Data'],
                                    str(data)) and error not in to_del:
                                    to_del.insert(0, error)
                        for deleting in to_del:
                            del err_dicts[err_dict][tag][deleting]
                        dprint("Overridding tag %s which has data %s." % \
                            (tag, self.data[tag]['Data']))
        return err_dicts, data_files

