import unittest, types, os
from linda.output import Output, OutputException

class OutputBaseTest(unittest.TestCase):
    def test_check_formatargs(self):
        "Check the check_formatargs() method of Output"
        output = Output()
        output.description = ["%s %d %l"]
        output.data = ['', '']
        output.tag = ''
        self.assertRaises(OutputException, output.check_formatargs)
        output.description = ["%s %d"]
        output.check_formatargs()

    def test_return_trans(self):
        "Check the return_trans() method of Output returns a string"
        output = Output()
        translations = output.return_trans('package-not-start-lib')
        for str in translations:
            self.assertEquals(type(str), types.StringType)

