import unittest, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class ExampleFilesCheckBinaryTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/example_files.py', {'_': __builtins__['_'], \
            'dprint': dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['binary'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        self.po_keys = POFileParser('po/en.po')
        
    def test_example_dirs(self):
        "Check the sanity of ExampleFilesCheck"
        method = getattr(self.instance, 'example_dirs')
        os.makedirs(os.path.join(self.instance.information['dir'], \
            'unpacked', 'usr', 'share', 'doc', 'test', 'examples', 'examples'))
        method()
        self.assert_('usr-share-doc-double-examples' in \
            self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'usr-share-doc-double-examples'), True)
        shutil.rmtree(self.instance.information['dir'])

