import re, glob
from linda import libchecks, checks
from linda.funcs import run_external_cmd, ExtCmdException
from linda.parser.template import TemplateParser

class DocumentationCheck(libchecks.LindaChecker):
    'Checks relating to manual and info pages.'
    def init(self):
        self.files = {'man': {}, 'bin': [], 'doc': []}
        
    def check_binary_2(self):
        self.populate_files()
        for file in self.files['man'].keys():
            self.manual_page_checks(file)
            self.manual_page_file_checks(file)
            self.call_man_parser(file)
        self.split_man()
        self.check_man_bin()
        self.check_doc_base()
        
    def populate_files(self):
        for file in self.information['collector']('files', 'files').keys():
            path_split = os.path.split(file)
            ext_split = os.path.splitext(file)
            if path_split[0] in ('/bin', '/sbin', '/usr/bin', '/usr/sbin', \
                '/usr/X11R6/bin', '/usr/games'):
                self.files['bin'].append(self.kill_extensions(path_split[1], 'binary'))
            elif re.search(r'/usr/(share/|X11R6/)?man/', path_split[0]):
                if ext_split[1] not in ('.html', '.txt'):
                    self.files['man'][file] = [path_split, ext_split]
            elif path_split[1].endswith('doc-base'):
                self.files['doc'].append(file)
        dprint(_("Populated: Bin: %s; Man: %s") % (self.files['bin'], \
            self.files['man']), 2)
    def manual_page_checks(self, file):
        if file.startswith('/usr/man/'):
            self.signal_error('manual-in-usr-man', \
                [self.files['man'][file][0][1]])
        if self.files['man'][file][1][1] != '.gz':
            self.signal_error('manual-not-compressed', \
                [self.files['man'][file][0][1]])
        if os.path.islink(os.path.join(self.information['dir'], 'unpacked', \
            file[1:])):
            if os.readlink(os.path.join(self.information['dir'], 'unpacked', \
                file[1:])).find('undocumented.7') != -1:
                self.signal_error('link-to-undocumented', \
                    [self.files['man'][file][0][1]])
    def manual_page_file_checks(self, file):
        full_file = os.path.join(self.information['dir'], 'unpacked', file[1:])
        if os.path.isfile(full_file) and not os.path.islink(full_file):
            if self.information['collector']('files', 'files')[file].is_executable():
                self.signal_error('executable-manual-page', [file])
            if self.information['collector']('output', 'file')[file].find('max compression') == -1:
                self.signal_error('manual-not-max-compression', [file])
            if self.information['collector']('output', 'file')[file].find('gzip compressed') == -1:
                self.signal_error('manual-not-using-gzip', [file])
    def call_man_parser(self, file):
        if os.path.islink(os.path.join(self.information['dir'], 'unpacked', \
            file[1:])):
            return None
        man_page = open(os.path.join(self.information['dir'], 'unpacked', \
            file[1:]))
        for line in man_page:
            if line.startswith('..so '):
                return
        man_page.close()
        try:
            run_external_cmd('lexgrog %s' % \
                os.path.join(self.information['dir'], 'unpacked', file[1:]))
        except ExtCmdException:
            self.signal_error('whatis-parse-failed-on-manpage', [file])
    def split_man(self):
        for file in self.files['man'].keys():
            if self.files['man'][file][1][1] == '.gz':
                self.files['man'][file].append(os.path.split(self.files['man'][file][1][0])[1])
            else:
                self.files['man'][file].append(os.path.split(file)[1])
            self.files['man'][file][2] = \
                self.kill_extensions(self.files['man'][file][2])
        dprint(_("After man: %s") % self.files['man'], 2)
    def check_man_bin(self):
        for file in self.files['bin']:
            found = 0
            for manpage in self.files['man'].keys():
                if file == self.files['man'][manpage][2]:
                    found = 1
            if not found:
                self.signal_error('no-manual-for-binary', [file])
    def check_doc_base(self):
        for file in self.files['doc']:
            tmpl = TemplateParser(os.path.join(self.information['dir'], \
                'unpacked', file[1:]))
            for stanza in tmpl[1:]:
                if stanza.has_key('format'):
                    if stanza['format'] == 'HTML' and not \
                        stanza.has_key('files'):
                        self.signal_error('doc-base-format-html-no-files', \
                            [file[1:]])
                if stanza.has_key('index'):
                    if not os.path.exists(os.path.join(self.information['dir'], 'unpacked', stanza['index'][1:])):
                        self.signal_error('doc-base-file-not-found', \
                            ['index', file[1:]])
                if stanza.has_key('files'):
                    if not glob.glob(os.path.join(self.information['dir'], \
                        'unpacked', stanza['files'][1:])):
                        self.signal_error('doc-base-file-not-found', \
                            ['files', file[1:]])
                            
    def kill_extensions(self, filename, type='none'):
        file, ext = os.path.splitext(filename)
        extensions = r'\.(p(l|y)|sh)'
        if type != 'binary':
            extensions = extensions[:-1] + '|[0-9][a-z]*)'
        if re.search(extensions, ext):
            return file
        else:
            return filename

checks.register(DocumentationCheck)

