import re, gettext
from linda.debug import dprint
from linda.parser.rfc822parser import RFC822Parser
_ = gettext.gettext

class DebianControlParser(RFC822Parser):
    def parse(self):
        self.split()
        for stanza in range(len(self.data)):
            for key in self.data[stanza].keys():
                if key in ('depends', 'pre-depends', 'provides', 'replaces', \
                    'conflicts', 'build-depends', 'recommends', \
                    'build-depends-indep', 'suggests'):
                    self.data[stanza]['%s-x' % key] = {}
                    self.data[stanza]['%s-orig' % key] = self.data[stanza][key]
                    for data in self.data[stanza][key].split(','):
                        dprint(_("Stanza %s; Key %s; Data: %s") % (stanza, \
                            key, data), 5)
                        for alt in data.split('|'):
                            dprint(_("Calling add_data: key %s, alt %s") % \
                            (key, alt), 5)
                            self.add_data(stanza, key, alt)
                    self.data[stanza][key] = self.data[stanza]['%s-x' % key]
                    del self.data[stanza]['%s-x' % key]
                elif key == 'description':
                    tmp_desc = self.data[stanza][key].split('\n')
                    self.data[stanza][key] = [tmp_desc[0], \
                        '\n'.join(tmp_desc[1:])]
        dprint(_("Control file: %s") % self.data, 3)
    
    def add_data(self, stanza, key, data):
        line = re.match(r'^(?P<pkg>[^ \(]+)([ ]?\(\s?(?P<rel_type>[<>=]+)\s?(?P<relation>.+)\))?([ ]\[(?P<arch>.+)\])?$', data.strip()).groupdict()
        if self.data[stanza]['%s-x' % key].has_key(line['pkg']):
            self.data[stanza]['%s-x' % key][line['pkg']]['relation'].append([line['rel_type'], line['relation']])
            self.data[stanza]['%s-x' % key][line['pkg']]['arch'].append(line['arch'])
        else:
            self.data[stanza]['%s-x' % key][line['pkg']] = {'relation': \
                [[line['rel_type'], line['relation']]], 'arch': [line['arch']]}

    def stanzas(self):
        return len(self.data)

