import sys, os, linda, unittest, tempfile
from linda.err_print import PrintErrors, ErrorPrintingException
from linda.libchecks import ErrDict
from linda.output import OutputFormats
from linda.parser.data import DataFileParser

class PrintErrorsBaseTest(unittest.TestCase):
    def setUp(self):
        self.filename = tempfile.mkstemp()[1]
        linda.root = os.path.abspath('.')
        linda.outputformats = OutputFormats()
        linda.outputformats.register_all('output')
        linda.outputobj = linda.outputformats['']()
        
    def tearDown(self):
        os.unlink(self.filename)
        
    def test_printing(self):
        "Check printing of errdicts in PrintErrors"
        f = open(self.filename, 'w')
        sys.stdout = f
        pe = PrintErrors('/tmp/test_0.0.1-1_all.deb')
        ed = {'data/binary.data': ErrDict()}
        ed['data/binary.data'].add_error('binary-note-or-comment', \
            ['/bin/ls', '.note'])
        data_file = {'data/binary.data': DataFileParser('data/binary.data')}
        pe.print_error(ed, data_file)
        f.close()
        f = open(self.filename)
        k = f.readline()
        self.assertEqual(k, \
            'E: test; Binary /bin/ls contains unneeded section .note.\n')
        sys.stdout = sys.__stdout__
        
    def test_exception(self):
        "Check wrong format arguments raise ErrorPrintingException"
        pe = PrintErrors('/tmp/test_0.0.1-1_all.deb')
        ed = {'data/binary.data': ErrDict()}
        ed['data/binary.data'].add_error('binary-note-or-comment', \
            ['/bin/ls'])
        data_file = {'data/binary.data': DataFileParser('data/binary.data')}
        try:
            pe.print_error(ed, data_file)
        except ErrorPrintingException:
            pass
        else:
            self.fail()

    def test_missing_tag_datafile(self):
        "Check that a missing tag in a datafile doesn't kill print_error"
        pe = PrintErrors('/tmp/lala_0.0.1-1_all.deb')
        ed = {'data/missing.data': ErrDict()}
        ed['data/missing.data'].add_error('this-tag-does-not-exist')
        data_file = {'data/missing.data': {}}
        try:
            pe.print_error(ed, data_file)
        except ErrorPrintingException:
            pass
        else:
            self.fail()

