import unittest
from linda.libchecks import LindaChecker

class LindaCheckerBaseTest(unittest.TestCase):
    def test_lindachecker(self):
        "Check the sanity of LindaChecker"
        lnd = LindaChecker('/tmp', '/tmp/lala_0.0.1_all.deb', {})
        self.assertEqual(lnd.pkg_name, 'lala')
        self.assertEqual(lnd.version, '0.0.1')
        self.assertEqual(lnd.is_native(), 1)
        lnd = LindaChecker('/tmp', '/tmp/lala_0.0.1-1_all.deb', {})
        self.assertEqual(lnd.version, '0.0.1-1')
        self.assertEqual(lnd.is_native(), 0)

