import unittest, gettext, os, linda, tempfile, shutil
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class CDBSCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/cdbs.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/source_cdbs.tar.gz' % \
            self.instance.information['dir'])
        os.mkdir(os.path.join(self.instance.information['dir'], 'debian'))
        
    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])

    def test_check_cdbs(self):
        "Check the sanity of CDBSCheck"
        method = getattr(self.instance, 'check_cdbs')
        os.rename(os.path.join(self.instance.information['dir'], \
            'rules.nondebhelper'), \
            os.path.join(self.instance.information['dir'], 'debian', 'rules'))
        self.instance.information['control'] = {'self': [{}]}
        method()
        self.assert_('missing-build-dep-on-cdbs' in \
            self.instance.err_dict.keys())
        os.rename(os.path.join(self.instance.information['dir'], \
            'rules.noncdbs'), os.path.join(self.instance.information['dir'], \
            'debian', 'rules'))
        self.instance.information['control']['self'][0] = {'build-depends': \
            {'cdbs': {'arch': [None], 'relation': [[None, None]]}}}
        method()
        self.assert_('no-cdbs-but-build-dep' in self.instance.err_dict.keys())
        for i in self.instance.err_dict.keys():
            del self.instance.err_dict[i]
        os.unlink(os.path.join(self.instance.information['dir'], \
            'debian/rules'))
        os.rename(os.path.join(self.instance.information['dir'], \
            'rules.includes'), os.path.join(self.instance.information['dir'], \
            'debian', 'rules'))
        method()
        self.assertEqual(['missing-build-dep-on-debhelper'], 
            self.instance.err_dict.keys())
        self.instance.information['control']['self'][0]['build-depends']['debhelper'] = {'arch': [None], 'relation': [[None, None]]}
        method()
        self.assert_('cdbs-debhelper-build-dep-too-old' in \
            self.instance.err_dict.keys())
        for key in self.instance.err_dict.keys():
            del self.instance.err_dict[key]
        self.instance.information['control']['self'][0]['build-depends']['debhelper']['relation'][0] = ['>>', '3.0']
        method()
        self.assert_('cdbs-debhelper-build-dep-too-old' in \
            self.instance.err_dict.keys())

