build-indep:

docpkg = linux-lpia-doc-$(release)
docdir = $(CURDIR)/debian/linux-doc-$(release)/usr/share/doc/$linux-doc-$(release)
install-doc:
	dh_testdir
	dh_testroot
	dh_clean -k -p$(docpkg)

	install -d $(docdir)

	# First the html docs. We skip these for autobuilds
	if [ -z "$(AUTOBUILD) nobuild" ]; then \
		install -d $(docdir)/linux-doc-tmp; \
		$(kmake) O=$(docdir)/linux-doc-tmp htmldocs; \
		mv $(docdir)/linux-doc-tmp/Documentation/DocBook \
			$(docdir)/html; \
		rm -rf $(docdir)/linux-doc-tmp; \
	fi

	# Copy the rest
	cp -a Documentation/* $(docdir)
	rm -rf $(docdir)/DocBook

indep_hdrpkg = linux-lpia-headers-$(abi_release)
indep_hdrdir = $(CURDIR)/debian/$(indep_hdrpkg)/usr/src/linux-headers-$(abi_release)
install-headers:
	dh_testdir
	dh_testroot
	dh_clean -k -p$(indep_hdrpkg)

	install -d $(indep_hdrdir)
	find . -path './debian/*' -prune -o -path './include/*' -prune \
	  -o -path './scripts/*' -prune -o -type f \
	  \( -name 'Makefile*' -o -name 'Kconfig*' -o -name 'Kbuild*' -o \
	     -name '*.sh' -o -name '*.pl' -o -name '*.lds' \) \
	  -print | cpio -pd --preserve-modification-time $(indep_hdrdir)
	cp -a scripts include $(indep_hdrdir)
	(find arch -name include -type d -print | \
		xargs -n1 -i: find : -type f) | \
		cpio -pd --preserve-modification-time $(indep_hdrdir)

srcpkg = linux-lpia-source-$(release)
srcdir = $(CURDIR)/debian/$(srcpkg)/usr/src/$(srcpkg)
install-source:
	dh_testdir
	dh_testroot
	dh_clean -k -p$(srcpkg)

	install -d $(srcdir)
	find . -path './debian/*' -prune -o \
		-path './.*' -prune -o -print | \
		cpio -pd --preserve-modification-time $(srcdir)
	(cd $(srcdir)/..; tar cf - $(srcpkg)) | bzip2 -9c > \
		$(srcdir).tar.bz2
	rm -rf $(srcdir)

# This is just to make it easy to call manually. Normally done in
# binary-indep target during builds.
binary-headers: install-headers
	dh_testdir
	dh_testroot
	dh_installchangelogs -p$(indep_hdrpkg)
	dh_installdocs -p$(indep_hdrpkg)
	dh_compress -p$(indep_hdrpkg)
	dh_fixperms -p$(indep_hdrpkg)
	dh_installdeb -p$(indep_hdrpkg)
	dh_gencontrol -p$(indep_hdrpkg)
	dh_md5sums -p$(indep_hdrpkg)
	dh_builddeb -p$(indep_hdrpkg)

binary-doc: install-doc
	dh_testdir
	dh_testroot
	dh_installchangelogs -p$(docpkg)
	dh_installdocs -p$(docpkg)
	dh_compress -p$(docpkg)
	dh_fixperms -p$(docpkg)
	dh_installdeb -p$(docpkg)
	dh_gencontrol -p$(docpkg)
	dh_md5sums -p$(docpkg)
	dh_builddeb -p$(docpkg)

binary-source: install-source
	dh_testdir
	dh_testroot
	dh_installchangelogs -p$(srcpkg)
	dh_installdocs -p$(srcpkg)
	dh_compress -p$(srcpkg)
	dh_fixperms -p$(srcpkg)
	dh_installdeb -p$(srcpkg)
	dh_gencontrol -p$(srcpkg)
	dh_md5sums -p$(srcpkg)
	dh_builddeb -p$(srcpkg)

binary-indep: binary-headers binary-doc binary-source
	# Don't remove, without this, build explodes
	echo "Leaving binary-indep"
