/* $Id: zddebug.h,v 1.3 2005/03/17 09:15:14 akw Exp $
 *
 * Copyright (C) 2004 Zydas Inc.
 * Copyright (C) 2005 Arno WILLIG <akw@users.sourceforge.net>
 * Copyright (C) 2005 Dimitriy KOROVKIN <korovkin@users.sourceforge.net>
 * Copyright (C) 2005 Todor T. ZVISKOV <warderx@users.sourceforge.net>
 * Copyright (C) 2005 Markus KARG <markus-karg@users.sourceforge.net>
 *
 * This file is part of the ZD1211 Wireless USB Driver for Linux.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _ZD_DEBUG_
#define _ZD_DEBUG_

#include <linux/string.h>
#include <stdarg.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include "zd1205.h"

#define ZD_DEBUG

#ifdef ZD_DEBUG
#define ZD1211DEBUG(n, args...) do { if (macp->dbg_flag>(n)) printk(KERN_DEBUG args); } while(0)
#define ZENTER(n) do { if (macp->dbg_flag>(n))	printk(KERN_DEBUG "%s: (enter) %s, %s line %i\n", "zd1205", __FUNCTION__,__FILE__,__LINE__); } while(0)
#define ZEXIT(n) do { if (macp->dbg_flag>(n))printk(KERN_DEBUG "%s: (exit) %s, %s line %i\n", "zd1205", __FUNCTION__,__FILE__,__LINE__); } while(0)
#else
#define ZD1211DEBUG(n, args...) do { } while (0)
#define ZENTER(n) //do {} while (0)
#define ZEXIT(n) //do {} while (0)
#endif

int zd1205_zd_dbg_ioctl(struct zd1205_private *macp, struct zdap_ioctl *zdreq);
void zd1205_set_sniffer_mode(struct zd1205_private *macp);
void zd1205_dump_regs(struct zd1205_private *macp);
void zd1205_dump_cnters(struct zd1205_private *macp);
void zd1205_dump_rfds(struct zd1205_private *macp);
#endif
