/* $Id: zdglobal.c,v 1.6 2005/03/27 20:47:36 sagamore Exp $
 *
 * Copyright (C) 2004 Zydas Inc.
 * Copyright (C) 2005 Arno WILLIG <akw@users.sourceforge.net>
 * Copyright (C) 2005 Dimitriy KOROVKIN <korovkin@users.sourceforge.net>
 * Copyright (C) 2005 Todor T. ZVISKOV <warderx@users.sourceforge.net>
 * Copyright (C) 2005 Markus KARG <markus-karg@users.sourceforge.net>
 *
 * This file is part of the ZD1211 Wireless USB Driver for Linux.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "zd80211.h"

U8		mPreambleType = LONG_PREAMBLE;
MacAddr_t	dot11MacAddress = {{0x00, 0x00, 0x00, 0x00, 0x00, 0x00}};
Element		dot11DesiredSsid;
U8		mAuthAlogrithms[2] = {OPEN_SYSTEM, SHARE_KEY};
U16		mRfChannel = 0;
U16		mBeaconPeriod = 100;
U16		mDtimPeriod = 1;
U16		mFragThreshold = 2432;
U16 		mRtsThreshold = 2432;

//WPA
Element		mWPAIe;

//WEP
U8		mKeyId = 0;
U8		mKeyFormat = WEP64_USED;
BOOLEAN 	mPrivacyInvoked = FALSE;

Element		mSsid;
Element		mBrates;
Element 	mPhpm;
MacAddr_t	mBssId;
U16 		mCap = CAP_ESS;
U16 		mDtimCount;

U8	 	mPsStaCnt = 0;	//Station count for associated and in power save mode
U8		mHiddenSSID = 0;
U8		mLimitedUser = 0;
U8		mCurrConnUser = 0;
U8		mBlockBSS = 0;
U8		mRadioOn = 1;
U8		mSwCipher = 0;
U8		mKeyVector[4][16];
U8		mBcKeyVector[16];
U8 		mWepIv[4];
U8 		mBcIv[4];
U8		mWepKeyLen;
U8		mBcKeyLen;
U8		mBcKeyId;
U8		mDynKeyMode = 0;
BOOLEAN		mZyDasModeClient = FALSE;
Seedvar		mBcSeed;
MICvar		mBcMicKey;
U8		mWpaBcKeyLen = 32;
U8		mWpaBcKeyId = 1;
U8		mGkInstalled = 0;
U16		mIv16 = 0;
U32		mIv32 = 0;

MacAddr_t	dot11BCAddress = {{0xff, 0xff, 0xff, 0xff, 0xff, 0xff}};
BssInfo_t	mBssInfo[64];
U8		mBssNum = 0;
U8		mBssCnt = 0;
U16		mAuthAlg = OPEN_SYSTEM;
U16		mListenInterval = 1;
U16		mAid;
BOOLEAN		mAssoc = FALSE;
MacAddr_t	mOldAP;
U8		mBssType = INFRASTRUCTURE_BSS;
U16		mAPCap;
Element		mAPBrates;
U8		mBssIndex = 0;
U16		mRequestFlag = 0;
U8		mPwrState = 0;
BOOLEAN		mAPAlive = FALSE;
BOOLEAN		mProbeWithSsid = FALSE;
Element		mIbssParms;
U16		mATIMWindow;
U8		mConnRetryCnt = 0;
U8		mMaxTxRate = 3;

// for G mode
Element		mErp = {{EID_ERP, 1, 0x00}};
Element		mExtRates;
U8		mMacMode = MIXED_MODE;
U8		mOperationMode;
U8		mBurstMode;
Element		mAPErates;
BOOLEAN		mIfaceOpened = FALSE;

U8		mAuthMode;
