/*
 * Copyright (c) 2005 by Benjamin Herrenschmidt <benh@kernel.crashing.org>
 * Copyright (c) 2006 by Ben Collins <bcollins@ubuntu.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef SND_PMAC_GPIO_H
#define SND_PMAC_GPIO_H 1

#include <asm/pmac_pfunc.h>

typedef struct snd_pmac_gpio {
	struct pmf_function *pfunc;
        unsigned int addr;
        u8 active_val;
        u8 inactive_val;
        u8 active_state;
	u32 state;

	/* Used by irq functions */
	int irq;
	struct pmf_irq_client irq_client;
	const char *name;
	const char *altname;
} snd_pmac_gpio_t;

/* Return a handle for access to the named gpio */
int snd_pmac_get_gpio(const char *name, const char *altname,
		      snd_pmac_gpio_t *gp);

/* Frees resources related to the gpio handle */
void snd_pmac_free_gpio(snd_pmac_gpio_t *gp);

/* GPIO Operations */
int snd_pmac_write_gpio(snd_pmac_gpio_t *gp, u32 val);
int snd_pmac_read_gpio(snd_pmac_gpio_t *gp, u32 *val);

/* Used to get the internal state of a write only gpio */
u32 snd_pmac_gpio_internal_state(snd_pmac_gpio_t *gp);

/* Register an irq for a previously allocated gpio. This is automaticlly
 * freed in snd_pmac_free_cpio. */
int snd_pmac_request_irq(snd_pmac_gpio_t *gp, void (*handler)(void *),
			 void *data);

static inline int snd_pmac_gpio_valid(snd_pmac_gpio_t *gp)
{
	return (gp->pfunc || gp->addr) ? 1 : 0;
}
#endif /* SND_PMAC_GPIO_H */
