/**************************************************************************
 * Copyright (c) Intel Corp. 2007.
 * All Rights Reserved.
 *
 * Intel funded Tungsten Graphics (http://www.tungstengraphics.com) to
 * develop this driver.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDERS, AUTHORS AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/
/*
 */

#ifndef _PSB_DRM_H_
#define _PSB_DRM_H_

#if defined(__linux__) && !defined(__KERNEL__)
#include<stdint.h>
#endif

#define DRM_PSB_SAREA_MAJOR 0
#define DRM_PSB_SAREA_MINOR 1
#define PSB_FIXED_SHIFT 16
#define PSB_PLUG_IOCTL_START 16
/*
 * Public memory types.
 */

#define DRM_PSB_MEM_MMU DRM_BO_MEM_PRIV1
#define DRM_PSB_FLAG_MEM_MMU DRM_BO_FLAG_MEM_PRIV1

#define DRM_PSB_MEM_APER DRM_BO_MEM_PRIV2
#define DRM_PSB_FLAG_MEM_APER DRM_BO_FLAG_MEM_PRIV2


typedef int32_t psb_fixed;
typedef uint32_t psb_ufixed;

static inline psb_fixed psb_int_to_fixed(int a)
{
	return a * (1 << PSB_FIXED_SHIFT);
}

static inline psb_ufixed psb_unsigned_to_ufixed(unsigned int a)
{
	return a << PSB_FIXED_SHIFT;
}

typedef struct drm_psb_scanout {
	uint32_t buffer_id;	/* DRM buffer object ID */
	uint32_t rotation;	/* Rotation as in RR_rotation definitions */
	uint32_t stride;	/* Buffer stride in bytes */
	uint32_t depth;		/* Buffer depth in bits (NOT) bpp */
	uint32_t width;		/* Buffer width in pixels */
	uint32_t height;	/* Buffer height in lines */
	psb_fixed transform[3][3];	/* Buffer composite transform */
	/* (scaling, rot, reflect) */
} drm_psb_scanout_t;

#define DRM_PSB_SAREA_OWNERS 16
#define DRM_PSB_SAREA_OWNER_2D 0
#define DRM_PSB_SAREA_OWNER_3D 1

#define DRM_PSB_SAREA_SCANOUTS 3

typedef struct drm_psb_sarea {
	/* Track changes of this data structure */

	uint32_t major;
	uint32_t minor;

	/* Last context to touch part of hw */
	uint32_t ctx_owners[DRM_PSB_SAREA_OWNERS];

	/* Definition of front- and rotated buffers */
	uint32_t num_scanouts;
	drm_psb_scanout_t scanouts[DRM_PSB_SAREA_SCANOUTS];

        int pipeA_x;
        int pipeA_y;
        int pipeA_w;
        int pipeA_h;
        int pipeB_x;
        int pipeB_y;
        int pipeB_w;
        int pipeB_h;
} drm_psb_sarea_t;

/*
 * Padding needed so that we can
 * so that PAGESIZE % sizeof(drm_psb_reloc) == 0.
 */

typedef struct drm_psb_reloc {
	enum {
		psb_reloc_offset,
		psb_reloc_stride
	} reloc_op;
	uint32_t delta;
	uint32_t where;
	uint32_t buffer;
	uint32_t mask;
	uint32_t shift;
	uint32_t align_shift;
	uint32_t dest_buffer;
} drm_psb_reloc_t;

#define PSB_ENGINE_2D 0
#define PSB_ENGINE_3D 1
#define PSB_ENGINE_VIDEO 2

typedef struct drm_psb_cmdbuf_arg {
	drm_u64_t buffer_list;	/* List of buffers to validate */
	drm_u64_t clip_rects;	/* See i915 counterpart */

	uint32_t cmdbuf_handle;	/* Command buffer object */
	uint32_t cmdbuf_offset;
	uint32_t cmdbuf_size;
	
	uint32_t reloc_handle;	/* Reloc buffer object */
	uint32_t reloc_offset;
	uint32_t num_relocs;

	int32_t damage;		/* Damage front buffer with cliprects */
	/* Not implemented yet */
	uint32_t fence_flags;
	uint32_t engine;
	uint32_t fence_handle;	/* Return: 
				   User space fence handle if requested */
} drm_psb_cmdbuf_arg_t;

#define DRM_PSB_CMDBUF          0x00
#define DRM_PSB_TEST            0x01

struct drm_psb_dev_info_arg {
	uint32_t num_use_attribute_registers;
};
#define DRM_PSB_DEVINFO         0x01

#endif
