/**************************************************************************
 *
 * Copyright (c) 2007 Intel Corporation, Hillsboro, OR, USA
 * Copyright (c) Imagination Technologies Limited, UK
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDERS, AUTHORS AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/

#ifndef _PSB_MSVDX_H_
#define _PSB_MSVDX_H_




#define assert(expr) \
        if(unlikely(!(expr))) {                                   \
        printk(KERN_ERR "Assertion failed! %s,%s,%s,line=%d\n", \
        #expr,__FILE__,__FUNCTION__,__LINE__);          \
        }

#define PSB_ASSERT(x) assert (x)
#define IMG_ASSERT(x) assert (x)

#include "psb_drv.h"

void psb_msvdx_mtx_interrupt(struct drm_device *dev);
int psb_msvdx_init(struct drm_device *dev);
int psb_msvdx_uninit(struct drm_device *dev);
int psb_msvdx_reset(struct drm_psb_private *dev_priv);
uint32_t psb_get_default_pd_addr(struct psb_mmu_driver *driver);
void psb_mtx_send(struct drm_psb_private *dev_priv, const void *pvMsg);


#define MTX_CODE_BASE		(0x80900000)
#define MTX_DATA_BASE		(0x82880000)
#define PC_START_ADDRESS	(0x80900000)

#define MTX_CORE_CODE_MEM			(0x10 )
#define MTX_CORE_DATA_MEM			(0x18 )

#define MTX_INTERNAL_REG( R_SPECIFIER , U_SPECIFIER )		( ((R_SPECIFIER)<<4) | (U_SPECIFIER) )
#define MTX_PC			MTX_INTERNAL_REG( 0 , 5 )


#define RENDEC_A_SIZE	( 1024 * 1024 )
#define RENDEC_B_SIZE	( 1024 * 1024 )


#define MEMIO_READ_FIELD(vpMem, field)																				    \
	((uint32_t)(((*((field##_TYPE *)(((uint32_t)vpMem) + field##_OFFSET))) & field##_MASK) >> field##_SHIFT))   	

#define MEMIO_WRITE_FIELD(vpMem, field, ui32Value)														\
	(*((field##_TYPE *)(((uint32_t)vpMem) + field##_OFFSET))) =										\
	((*((field##_TYPE *)(((uint32_t)vpMem) + field##_OFFSET))) & (field##_TYPE)~field##_MASK) |		\
		(field##_TYPE)(( (uint32_t) (ui32Value) << field##_SHIFT) & field##_MASK);

#define MEMIO_WRITE_FIELD_LITE(vpMem, field, ui32Value)													\
	 (*((field##_TYPE *)(((uint32_t)vpMem) + field##_OFFSET))) =										\
	((*((field##_TYPE *)(((uint32_t)vpMem) + field##_OFFSET))) |		                                \
		(field##_TYPE) (( (uint32_t) (ui32Value) << field##_SHIFT)) );

#define REGIO_READ_FIELD(ui32RegValue, reg, field)							\
	((ui32RegValue & reg##_##field##_MASK) >> reg##_##field##_SHIFT)

#define REGIO_WRITE_FIELD(ui32RegValue, reg, field, ui32Value)					\
	(ui32RegValue) =									\
	((ui32RegValue) & ~(reg##_##field##_MASK)) |						\
		(((ui32Value) << (reg##_##field##_SHIFT)) & (reg##_##field##_MASK));

#define REGIO_WRITE_FIELD_LITE(ui32RegValue, reg, field, ui32Value)				\
	(ui32RegValue) =									\
	( (ui32RegValue) | ( (ui32Value) << (reg##_##field##_SHIFT) ) );

#define MSVDX_CORE_CR_MSVDX_MAN_CLK_ENABLE_CR_CORE_MAN_CLK_ENABLE_MASK		(0x00000001)
#define MSVDX_CORE_CR_MSVDX_MAN_CLK_ENABLE_CR_VDEB_PROCESS_MAN_CLK_ENABLE_MASK		(0x00000002)
#define MSVDX_CORE_CR_MSVDX_MAN_CLK_ENABLE_CR_VDEB_ACCESS_MAN_CLK_ENABLE_MASK		(0x00000004)
#define MSVDX_CORE_CR_MSVDX_MAN_CLK_ENABLE_CR_VDMC_MAN_CLK_ENABLE_MASK		(0x00000008)
#define MSVDX_CORE_CR_MSVDX_MAN_CLK_ENABLE_CR_VEC_ENTDEC_MAN_CLK_ENABLE_MASK		(0x00000010)
#define MSVDX_CORE_CR_MSVDX_MAN_CLK_ENABLE_CR_VEC_ITRANS_MAN_CLK_ENABLE_MASK		(0x00000020)
#define MSVDX_CORE_CR_MSVDX_MAN_CLK_ENABLE_CR_MTX_MAN_CLK_ENABLE_MASK		(0x00000040)

/* MTX registers */
#define MSVDX_MTX_ENABLE		(0x0000)
#define MSVDX_MTX_KICKI			(0x0088)
#define MSVDX_MTX_REGISTER_READ_WRITE_REQUEST	(0x00FC)
#define MSVDX_MTX_REGISTER_READ_WRITE_DATA	(0x00F8)
#define MSVDX_MTX_RAM_ACCESS_DATA_TRANSFER	(0x0104)
#define MSVDX_MTX_RAM_ACCESS_CONTROL	(0x0108)
#define MSVDX_MTX_RAM_ACCESS_STATUS	(0x010C)
#define MSVDX_MTX_SOFT_RESET		(0x0200)

/* MSVDX registers */
#define MSVDX_CONTROL			(0x0600)
#define MSVDX_INTERRUPT_CLEAR		(0x060C)
#define MSVDX_INTERRUPT_STATUS		(0x0608)	
#define MSVDX_HOST_INTERRUPT_ENABLE	(0x0610)
#define MSVDX_MMU_CONTROL0		(0x0680)
#define MSVDX_MTX_RAM_BANK		(0x06F0)
#define MSVDX_MAN_CLK_ENABLE		(0x0620)

/* RENDEC registers */
#define MSVDX_RENDEC_CONTROL0		(0x0868)
#define MSVDX_RENDEC_CONTROL1		(0x086C)
#define MSVDX_RENDEC_BUFFER_SIZE	(0x0870)
#define MSVDX_RENDEC_BASE_ADDR0		(0x0874)
#define MSVDX_RENDEC_BASE_ADDR1		(0x0878)
#define MSVDX_RENDEC_READ_DATA		(0x0898)
#define MSVDX_RENDEC_CONTEXT0		(0x0950)
#define MSVDX_RENDEC_CONTEXT1		(0x0954)
#define MSVDX_RENDEC_CONTEXT2		(0x0958)
#define MSVDX_RENDEC_CONTEXT3		(0x095C)
#define MSVDX_RENDEC_CONTEXT4		(0x0960)
#define MSVDX_RENDEC_CONTEXT5		(0x0964)

/* 
 * This defines the MSVDX communication buffer
 */
#define MSVDX_COMMS_SIGNATURE_VALUE	(0xA5A5A5A5)	/*!< Signature value */
#define NUM_WORDS_HOST_BUF		(100)		/*!< Host buffer size (in 32-bit words) */
#define NUM_WORDS_MTX_BUF		(100)		/*!< MTX buffer size (in 32-bit words) */

#define MSVDX_COMMS_AREA_ADDR (0x02cc0)

#define	MSVDX_COMMS_SIGNATURE			(MSVDX_COMMS_AREA_ADDR + 0x00)
#define	MSVDX_COMMS_TO_HOST_BUF_SIZE		(MSVDX_COMMS_AREA_ADDR + 0x04)
#define MSVDX_COMMS_TO_HOST_RD_INDEX		(MSVDX_COMMS_AREA_ADDR + 0x08)
#define MSVDX_COMMS_TO_HOST_WRT_INDEX		(MSVDX_COMMS_AREA_ADDR + 0x0C)
#define MSVDX_COMMS_TO_MTX_BUF_SIZE		(MSVDX_COMMS_AREA_ADDR + 0x10)
#define MSVDX_COMMS_TO_MTX_RD_INDEX		(MSVDX_COMMS_AREA_ADDR + 0x14)
#define MSVDX_COMMS_TO_MTX_CB_RD_INDEX		(MSVDX_COMMS_AREA_ADDR + 0x18)
#define MSVDX_COMMS_TO_MTX_WRT_INDEX		(MSVDX_COMMS_AREA_ADDR + 0x1C)
#define MSVDX_COMMS_TO_HOST_BUF			(MSVDX_COMMS_AREA_ADDR + 0x20)
#define MSVDX_COMMS_TO_MTX_BUF			(MSVDX_COMMS_TO_HOST_BUF + (NUM_WORDS_HOST_BUF << 2))

#define MSVDX_COMMS_AREA_END 			(MSVDX_COMMS_TO_MTX_BUF + (NUM_WORDS_HOST_BUF << 2))

#if (MSVDX_COMMS_AREA_END != 0x03000)
#error
#endif


#define MSVDX_MTX_REGISTER_READ_WRITE_REQUEST_MTX_DREADY_MASK		(0x80000000)
#define MSVDX_MTX_REGISTER_READ_WRITE_REQUEST_MTX_DREADY_SHIFT		(31)

#define MSVDX_MTX_REGISTER_READ_WRITE_REQUEST_MTX_RNW_MASK		(0x00010000)
#define MSVDX_MTX_REGISTER_READ_WRITE_REQUEST_MTX_RNW_SHIFT		(16)

#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCMID_MASK		(0x0FF00000)
#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCMID_SHIFT		(20)

#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCM_ADDR_MASK		(0x000FFFFC)
#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCM_ADDR_SHIFT		(2)

#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCMAI_MASK		(0x00000002)
#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCMAI_SHIFT		(1)

#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCMR_MASK		(0x00000001)
#define MSVDX_MTX_RAM_ACCESS_CONTROL_MTX_MCMR_SHIFT		(0)

#define MSVDX_MTX_SOFT_RESET_MTX_RESET_MASK		(0x00000001)
#define MSVDX_MTX_SOFT_RESET_MTX_RESET_SHIFT		(0)

#define MSVDX_MTX_ENABLE_MTX_ENABLE_MASK		(0x00000001)
#define MSVDX_MTX_ENABLE_MTX_ENABLE_SHIFT		(0)

#define MSVDX_CONTROL_CR_MSVDX_SOFT_RESET_MASK		(0x00000100)
#define MSVDX_CONTROL_CR_MSVDX_SOFT_RESET_SHIFT		(8)

#define MSVDX_INTERRUPT_STATUS_CR_MMU_FAULT_IRQ_MASK		(0x00000F00)
#define MSVDX_INTERRUPT_STATUS_CR_MMU_FAULT_IRQ_SHIFT		(8)

#define MSVDX_INTERRUPT_STATUS_CR_MTX_IRQ_MASK		(0x00004000)
#define MSVDX_INTERRUPT_STATUS_CR_MTX_IRQ_SHIFT		(14)

#define MSVDX_MMU_CONTROL0_CR_MMU_PAUSE_MASK			(0x00000002)
#define MSVDX_MMU_CONTROL0_CR_MMU_PAUSE_SHIFT			(1)

#define MSVDX_MTX_RAM_BANK_CR_MTX_RAM_BANK_SIZE_MASK		(0x000F0000)
#define MSVDX_MTX_RAM_BANK_CR_MTX_RAM_BANK_SIZE_SHIFT		(16)

#define MSVDX_RENDEC_BUFFER_SIZE_RENDEC_BUFFER_SIZE0_MASK		(0x0000FFFF)
#define MSVDX_RENDEC_BUFFER_SIZE_RENDEC_BUFFER_SIZE0_SHIFT		(0)

#define MSVDX_RENDEC_BUFFER_SIZE_RENDEC_BUFFER_SIZE1_MASK		(0xFFFF0000)
#define MSVDX_RENDEC_BUFFER_SIZE_RENDEC_BUFFER_SIZE1_SHIFT		(16)

#define MSVDX_RENDEC_CONTROL1_RENDEC_DECODE_START_SIZE_MASK		(0x000000FF)
#define MSVDX_RENDEC_CONTROL1_RENDEC_DECODE_START_SIZE_SHIFT		(0)

#define MSVDX_RENDEC_CONTROL1_RENDEC_BURST_SIZE_W_MASK		(0x000C0000)
#define MSVDX_RENDEC_CONTROL1_RENDEC_BURST_SIZE_W_SHIFT		(18)

#define MSVDX_RENDEC_CONTROL1_RENDEC_BURST_SIZE_R_MASK		(0x00030000)
#define MSVDX_RENDEC_CONTROL1_RENDEC_BURST_SIZE_R_SHIFT		(16)

#define MSVDX_RENDEC_CONTROL1_RENDEC_EXTERNAL_MEMORY_MASK		(0x01000000)
#define MSVDX_RENDEC_CONTROL1_RENDEC_EXTERNAL_MEMORY_SHIFT		(24)

#define MSVDX_RENDEC_CONTROL0_RENDEC_INITIALISE_MASK		(0x00000001)
#define MSVDX_RENDEC_CONTROL0_RENDEC_INITIALISE_SHIFT		(0)

#define	FWRK_MSGID_START_PSR_HOSTMTX_MSG	(0x80)	/*!< Start of parser specific Host->MTX messages.*/
#define	FWRK_MSGID_START_PSR_MTXHOST_MSG	(0xC0)	/*!< Start of parser specific MTX->Host messages.*/
#define FWRK_MSGID_PADDING					( 0 )

#define FWRK_GENMSG_SIZE_TYPE		uint8_t
#define FWRK_GENMSG_SIZE_MASK		(0xFF)
#define FWRK_GENMSG_SIZE_SHIFT		(0)
#define FWRK_GENMSG_SIZE_OFFSET		(0x0000)
#define FWRK_GENMSG_ID_TYPE		uint8_t
#define FWRK_GENMSG_ID_MASK		(0xFF)
#define FWRK_GENMSG_ID_SHIFT		(0)
#define FWRK_GENMSG_ID_OFFSET		(0x0001)
#define FWRK_PADMSG_SIZE		(2)

/*!
******************************************************************************
 This type defines the framework specified message ids
******************************************************************************/
enum
{
	/*! Sent by the DXVA driver on the host to the mtx firmware.
	 */
	VA_MSGID_INIT				= FWRK_MSGID_START_PSR_HOSTMTX_MSG, 
	VA_MSGID_RENDER, 
	VA_MSGID_DEBLOCK, 
	VA_MSGID_BUBBLE, 

	/* Test Messages */
	VA_MSGID_TEST1,
	VA_MSGID_TEST2,

	/*! Sent by the mtx firmware to itself.
	 */
	VA_MSGID_RENDER_MC_INTERRUPT, 

	/*! Sent by the DXVA firmware on the MTX to the host.
	 */
	VA_MSGID_CMD_COMPLETED	= FWRK_MSGID_START_PSR_MTXHOST_MSG, 
	VA_MSGID_CMD_COMPLETED_BATCH,
	VA_MSGID_DEBLOCK_REQUIRED,
	VA_MSGID_TEST_RESPONCE,
	VA_MSGID_ACK,

	VA_MSGID_CMD_FAILED,
};



/* MSVDX Firmware interface */
#define FW_VA_INIT_SIZE		(8)
#define FW_VA_DEBUG_TEST2_SIZE		(4)

/* FW_VA_DEBUG_TEST2     MSG_SIZE */
#define FW_VA_DEBUG_TEST2_MSG_SIZE_TYPE		uint8_t
#define FW_VA_DEBUG_TEST2_MSG_SIZE_MASK		(0xFF)
#define FW_VA_DEBUG_TEST2_MSG_SIZE_OFFSET		(0x0000)
#define FW_VA_DEBUG_TEST2_MSG_SIZE_SHIFT		(0)


/* FW_VA_DEBUG_TEST2     ID */
#define FW_VA_DEBUG_TEST2_ID_TYPE		uint8_t
#define FW_VA_DEBUG_TEST2_ID_MASK		(0xFF)
#define FW_VA_DEBUG_TEST2_ID_OFFSET		(0x0001)
#define FW_VA_DEBUG_TEST2_ID_SHIFT		(0)

/* FW_VA_CMD_FAILED     FENCE_VALUE */
#define FW_VA_CMD_FAILED_FENCE_VALUE_TYPE		uint32_t
#define FW_VA_CMD_FAILED_FENCE_VALUE_MASK		(0xFFFFFFFF)
#define FW_VA_CMD_FAILED_FENCE_VALUE_OFFSET		(0x0004)
#define FW_VA_CMD_FAILED_FENCE_VALUE_SHIFT		(0)

/* FW_VA_CMD_FAILED     IRQSTATUS */
#define FW_VA_CMD_FAILED_IRQSTATUS_TYPE		uint32_t
#define FW_VA_CMD_FAILED_IRQSTATUS_MASK		(0xFFFFFFFF)
#define FW_VA_CMD_FAILED_IRQSTATUS_OFFSET		(0x0008)
#define FW_VA_CMD_FAILED_IRQSTATUS_SHIFT		(0)

/* FW_VA_CMD_COMPLETED     FENCE_VALUE */
#define FW_VA_CMD_COMPLETED_FENCE_VALUE_TYPE		uint32_t
#define FW_VA_CMD_COMPLETED_FENCE_VALUE_MASK		(0xFFFFFFFF)
#define FW_VA_CMD_COMPLETED_FENCE_VALUE_OFFSET		(0x0004)
#define FW_VA_CMD_COMPLETED_FENCE_VALUE_SHIFT		(0)


/* FW_VA_CMD_COMPLETED     NO_TICKS */
#define FW_VA_CMD_COMPLETED_NO_TICKS_TYPE		uint16_t
#define FW_VA_CMD_COMPLETED_NO_TICKS_MASK		(0xFFFF)
#define FW_VA_CMD_COMPLETED_NO_TICKS_OFFSET		(0x0002)
#define FW_VA_CMD_COMPLETED_NO_TICKS_SHIFT		(0)


/* FW_VA_DEBLOCK_REQUIRED     CONTEXT */
#define FW_VA_DEBLOCK_REQUIRED_CONTEXT_TYPE		uint32_t
#define FW_VA_DEBLOCK_REQUIRED_CONTEXT_MASK		(0xFFFFFFFF)
#define FW_VA_DEBLOCK_REQUIRED_CONTEXT_OFFSET		(0x0004)
#define FW_VA_DEBLOCK_REQUIRED_CONTEXT_SHIFT		(0)

/* FW_VA_INIT     GLOBAL_PTD */
#define FW_VA_INIT_GLOBAL_PTD_TYPE		uint32_t
#define FW_VA_INIT_GLOBAL_PTD_MASK		(0xFFFFFFFF)
#define FW_VA_INIT_GLOBAL_PTD_OFFSET		(0x0004)
#define FW_VA_INIT_GLOBAL_PTD_SHIFT		(0)

/* FW_VA_RENDER     FENCE_VALUE */
#define FW_VA_RENDER_FENCE_VALUE_TYPE		uint32_t
#define FW_VA_RENDER_FENCE_VALUE_MASK		(0xFFFFFFFF)
#define FW_VA_RENDER_FENCE_VALUE_OFFSET		(0x0010)
#define FW_VA_RENDER_FENCE_VALUE_SHIFT		(0)

/* FW_VA_RENDER     MMUPTD */
#define FW_VA_RENDER_MMUPTD_TYPE		uint32_t
#define FW_VA_RENDER_MMUPTD_MASK		(0xFFFFFFFF)
#define FW_VA_RENDER_MMUPTD_OFFSET		(0x0004)
#define FW_VA_RENDER_MMUPTD_SHIFT		(0)

/* FW_VA_RENDER     BUFFER_ADDRESS */
#define FW_VA_RENDER_BUFFER_ADDRESS_TYPE		uint32_t
#define FW_VA_RENDER_BUFFER_ADDRESS_MASK		(0xFFFFFFFF)
#define FW_VA_RENDER_BUFFER_ADDRESS_OFFSET		(0x0008)
#define FW_VA_RENDER_BUFFER_ADDRESS_SHIFT		(0)

/* FW_VA_RENDER     BUFFER_SIZE */
#define FW_VA_RENDER_BUFFER_SIZE_TYPE           uint16_t
#define FW_VA_RENDER_BUFFER_SIZE_MASK           (0x0FFF)
#define FW_VA_RENDER_BUFFER_SIZE_OFFSET         (0x0002)
#define FW_VA_RENDER_BUFFER_SIZE_SHIFT          (0)

#endif
