/* **********************************************************
 * Copyright 2004 VMware, Inc.  All rights reserved. 
 * **********************************************************
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * @VMKAPIMOD_LICENSE@
 */

/*
 * vmkapi_status.h --
 *
 *	Defines the VMKernel return statuses
 */

#ifndef _VMKAPI_STATUS_H_
#define _VMKAPI_STATUS_H_

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_VMKDRIVERS
#define INCLUDE_ALLOW_VMK_MODULE
#define INCLUDE_ALLOW_DISTRIBUTE
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

/*
 * The return statuses are part of the VMkernel public API. To avoid breaking
 * 3rd party software built on top of this API, any change to the table must
 * maintain backward source level as well as binary compatibility i.e. a status
 * cannot be moved in the table or removed from the table, and new statuses must
 * be added at the end (before VMK_GENERIC_LINUX_ERROR).
 *
 *                VMK error code name           Description                                   Unix name
 *                ===================           ===========                                   =========
 */
#define VMK_ERROR_CODES \
   DEFINE_VMK_ERR_AT(VMK_OK,                    "Success", 0,                                 OK          )\
   DEFINE_VMK_ERR_AT(VMK_FAILURE,               "Failure", 0x0bad0001,                        EINVAL      )\
   DEFINE_VMK_ERR(VMK_WOULD_BLOCK,              "Would block",                                EAGAIN      )\
   DEFINE_VMK_ERR(VMK_NOT_FOUND,                "Not found",                                  ENOENT      )\
   DEFINE_VMK_ERR(VMK_BUSY,                     "Busy",                                       EBUSY       )\
   DEFINE_VMK_ERR(VMK_EXISTS,                   "Already exists",                             EEXIST      )\
   DEFINE_VMK_ERR(VMK_LIMIT_EXCEEDED,           "Limit exceeded",                             EFBIG       )\
   DEFINE_VMK_ERR(VMK_BAD_PARAM,                "Bad parameter",                              EINVAL      )\
   DEFINE_VMK_ERR(VMK_METADATA_READ_ERROR,      "Metadata read error",                        EIO         )\
   DEFINE_VMK_ERR(VMK_METADATA_WRITE_ERROR,     "Metadata write error",                       EIO         )\
   DEFINE_VMK_ERR(VMK_IO_ERROR,                 "I/O error",                                  EIO         )\
   DEFINE_VMK_ERR(VMK_READ_ERROR,               "Read error",                                 EIO         )\
   DEFINE_VMK_ERR(VMK_WRITE_ERROR,              "Write error",                                EIO         )\
   DEFINE_VMK_ERR(VMK_INVALID_NAME,             "Invalid name",                               ENAMETOOLONG)\
   DEFINE_VMK_ERR(VMK_INVALID_HANDLE,           "Invalid handle",                             EBADF       )\
   DEFINE_VMK_ERR(VMK_INVALID_ADAPTER,          "No such SCSI adapter",                       ENODEV      )\
   DEFINE_VMK_ERR(VMK_INVALID_TARGET,           "No such target on adapter",                  ENODEV      )\
   DEFINE_VMK_ERR(VMK_INVALID_PARTITION,        "No such partition on target",                ENXIO       )\
   DEFINE_VMK_ERR(VMK_INVALID_FS,               "No filesystem on the device",                ENXIO       )\
   DEFINE_VMK_ERR(VMK_INVALID_MEMMAP,           "Memory map mismatch",                        EFAULT      )\
   DEFINE_VMK_ERR(VMK_NO_MEMORY,                "Out of memory",                              ENOMEM      )\
   DEFINE_VMK_ERR(VMK_NO_MEMORY_RETRY,          "Out of memory (ok to retry)",                ENOMEM      )\
   DEFINE_VMK_ERR(VMK_NO_RESOURCES,             "Out of resources",                           ENOMEM      )\
   DEFINE_VMK_ERR(VMK_NO_FREE_HANDLES,          "No free handles",                            EMFILE      )\
   DEFINE_VMK_ERR(VMK_NUM_HANDLES_EXCEEDED,     "Exceeded maximum number of allowed handles", ENFILE      )\
   DEFINE_VMK_ERR(VMK_DEPRECATED_NO_FREE_PTR_BLOCKS,       "No free pointer blocks (deprecated)",                     ENOSPC      )\
   DEFINE_VMK_ERR(VMK_DEPRECATED_NO_FREE_DATA_BLOCKS,      "No free data blocks (deprecated)",                        ENOSPC      )\
   DEFINE_VMK_ERR(VMK_CORRUPT_REDOLOG,          "Corrupt RedoLog",                            EBADF       )\
   DEFINE_VMK_ERR(VMK_STATUS_PENDING,           "Status pending",                             EAGAIN      )\
   DEFINE_VMK_ERR(VMK_STATUS_FREE,              "Status free",                                EAGAIN      )\
   DEFINE_VMK_ERR(VMK_UNSUPPORTED_CPU,          "Unsupported CPU",                            ENODEV      )\
   DEFINE_VMK_ERR(VMK_NOT_SUPPORTED,            "Not supported",                              ENOSYS      )\
   DEFINE_VMK_ERR(VMK_TIMEOUT,                  "Timeout",                                    ETIMEDOUT   )\
   DEFINE_VMK_ERR(VMK_READ_ONLY,                "Read only",                                  EROFS       )\
   DEFINE_VMK_ERR(VMK_RESERVATION_CONFLICT,     "SCSI reservation conflict",                  EAGAIN      )\
   DEFINE_VMK_ERR(VMK_FS_LOCKED,                "File system locked",                         EADDRINUSE  )\
   DEFINE_VMK_ERR(VMK_NOT_ENOUGH_SLOTS,         "Out of slots",                               ENFILE      )\
   DEFINE_VMK_ERR(VMK_INVALID_ADDRESS,          "Invalid address",                            EFAULT      )\
   DEFINE_VMK_ERR(VMK_NOT_SHARED,               "Not shared",                                 ENOMEM      )\
   DEFINE_VMK_ERR(VMK_SHARED,                   "Page is shared",                             ENOMEM      )\
   DEFINE_VMK_ERR(VMK_KSEG_PAIR_FLUSHED,        "Kseg pair flushed",                          ENOMEM      )\
   DEFINE_VMK_ERR(VMK_MAX_ASYNCIO_PENDING,      "Max async I/O requests pending",             ENOMEM      )\
   DEFINE_VMK_ERR(VMK_VERSION_MISMATCH_MINOR,   "Minor version mismatch",                     ENOSYS      )\
   DEFINE_VMK_ERR(VMK_VERSION_MISMATCH_MAJOR,   "Major version mismatch",                     ENOSYS      )\
   DEFINE_VMK_ERR(VMK_IS_CONNECTED,             "Already connected",                          EINVAL      )\
   DEFINE_VMK_ERR(VMK_IS_DISCONNECTED,          "Already disconnected",                       ENOTCONN    )\
   DEFINE_VMK_ERR(VMK_IS_ENABLED,               "Already enabled",                            EINVAL      )\
   DEFINE_VMK_ERR(VMK_IS_DISABLED,              "Already disabled",                           EINVAL      )\
   DEFINE_VMK_ERR(VMK_NOT_INITIALIZED,          "Not initialized",                            EINVAL      )\
   DEFINE_VMK_ERR(VMK_WAIT_INTERRUPTED,         "Wait interrupted",                           EINTR       )\
   DEFINE_VMK_ERR(VMK_NAME_TOO_LONG,            "Name too long",                              ENAMETOOLONG)\
   DEFINE_VMK_ERR(VMK_MISSING_FS_PES,           "VMFS volume missing physical extents",       ENOTDIR     )\
   DEFINE_VMK_ERR(VMK_NICTEAMING_VALID_MASTER,  "NIC teaming master valid",                   EINVAL      )\
   DEFINE_VMK_ERR(VMK_NICTEAMING_SLAVE,         "NIC teaming slave",                          EEXIST      )\
   DEFINE_VMK_ERR(VMK_NICTEAMING_REGULAR_VMNIC, "NIC teaming regular VMNIC",                  EINVAL      )\
   DEFINE_VMK_ERR(VMK_ABORT_NOT_RUNNING,        "Abort not running",                          ECANCELED   )\
   DEFINE_VMK_ERR(VMK_NOT_READY,                "Not ready",                                  EIO         )\
   DEFINE_VMK_ERR(VMK_CHECKSUM_MISMATCH,        "Checksum mismatch",                          EIO         )\
   DEFINE_VMK_ERR(VMK_VLAN_NO_HW_ACCEL,         "VLan HW Acceleration not supported",         EINVAL      )\
   DEFINE_VMK_ERR(VMK_NO_VLAN_SUPPORT,          "VLan is not supported in vmkernel",          EOPNOTSUPP  )\
   DEFINE_VMK_ERR(VMK_NOT_VLAN_HANDLE,          "Not a VLan handle",                          EINVAL      )\
   DEFINE_VMK_ERR(VMK_BAD_VLANID,               "Couldn't retrieve VLan id",                  EBADF       )\
   DEFINE_VMK_ERR(VMK_MIG_PROTO_ERROR,          "Migration protocol error",                   EINVAL      )\
   DEFINE_VMK_ERR(VMK_NO_CONNECT,               "No connection",                              EIO         )\
   DEFINE_VMK_ERR(VMK_SEGMENT_OVERLAP,          "Segment overlap",                            EINVAL      )\
   DEFINE_VMK_ERR(VMK_BAD_MPS,                  "Error parsing MPS Table",                    EIO         )\
   DEFINE_VMK_ERR(VMK_BAD_ACPI,                 "Error parsing ACPI Table",                   EIO         )\
   DEFINE_VMK_ERR(VMK_RESUME_ERROR,             "Failed to resume VM",                        EIO         )\
   DEFINE_VMK_ERR(VMK_NO_ADDRESS_SPACE,         "Insufficient address space for operation",   ENOMEM      )\
   DEFINE_VMK_ERR(VMK_BAD_ADDR_RANGE,           "Bad address range",                          EINVAL      )\
   DEFINE_VMK_ERR(VMK_ENETDOWN,                 "Network is down",                            ENETDOWN    )\
   DEFINE_VMK_ERR(VMK_ENETUNREACH,              "Network unreachable",                        ENETUNREACH )\
   DEFINE_VMK_ERR(VMK_ENETRESET,                "Network dropped connection on reset",        ENETRESET   )\
   DEFINE_VMK_ERR(VMK_ECONNABORTED,             "Software caused connection abort",           ECONNABORTED)\
   DEFINE_VMK_ERR(VMK_ECONNRESET,               "Connection reset by peer",                   ECONNRESET  )\
   DEFINE_VMK_ERR(VMK_ENOTCONN,                 "Socket is not connected",                    ENOTCONN    )\
   DEFINE_VMK_ERR(VMK_ESHUTDOWN,                "Can't send after socket shutdown",           ESHUTDOWN   )\
   DEFINE_VMK_ERR(VMK_ETOOMANYREFS,             "Too many references: can't splice",          ETOOMANYREFS)\
   DEFINE_VMK_ERR(VMK_ECONNREFUSED,             "Connection refused",                         ECONNREFUSED)\
   DEFINE_VMK_ERR(VMK_EHOSTDOWN,                "Host is down",                               EHOSTDOWN   )\
   DEFINE_VMK_ERR(VMK_EHOSTUNREACH,             "No route to host",                           EHOSTUNREACH)\
   DEFINE_VMK_ERR(VMK_EADDRINUSE,               "Address already in use",                     EADDRINUSE  )\
   DEFINE_VMK_ERR(VMK_BROKEN_PIPE,              "Broken pipe",                                EPIPE       )\
   DEFINE_VMK_ERR(VMK_NOT_A_DIRECTORY,          "Not a directory",                            ENOTDIR     )\
   DEFINE_VMK_ERR(VMK_IS_A_DIRECTORY,           "Is a directory",                             EISDIR      )\
   DEFINE_VMK_ERR(VMK_NOT_EMPTY,                "Directory not empty",                        ENOTEMPTY   )\
   DEFINE_VMK_ERR(VMK_NOT_IMPLEMENTED,          "Not implemented",                            ENOSYS      )\
   DEFINE_VMK_ERR(VMK_NO_SIGNAL_HANDLER,        "No signal handler",                          EINVAL      )\
   DEFINE_VMK_ERR(VMK_FATAL_SIGNAL_BLOCKED,     "Fatal signal blocked",                       EINVAL      )\
   DEFINE_VMK_ERR(VMK_NO_ACCESS,                "Permission denied",                          EACCES      )\
   DEFINE_VMK_ERR(VMK_NO_PERMISSION,            "Operation not permitted",                    EPERM       )\
   DEFINE_VMK_ERR(VMK_UNDEFINED_SYSCALL,        "Undefined syscall",                          ENOSYS      )\
   DEFINE_VMK_ERR(VMK_RESULT_TOO_LARGE,         "Result too large",                           ERANGE      )\
   DEFINE_VMK_ERR(VMK_VLAN_FILTERED,            "Pkts dropped because of VLAN (support) mismatch", ERANGE )\
   DEFINE_VMK_ERR(VMK_BAD_EXCFRAME,             "Unsafe exception frame",                     EFAULT      )\
   DEFINE_VMK_ERR(VMK_MODULE_NOT_LOADED,        "Necessary module isn't loaded",              ENODEV      )\
   DEFINE_VMK_ERR(VMK_NO_SUCH_ZOMBIE,           "No dead world by that name",                 ECHILD      )\
   DEFINE_VMK_ERR(VMK_NO_SUCH_CARTEL,           "No cartel by that name",                     ESRCH       )\
   DEFINE_VMK_ERR(VMK_IS_A_SYMLINK,             "Is a symbolic link",                         ELOOP       )\
   DEFINE_VMK_ERR(VMK_CROSS_DEVICE_LINK,        "Cross-device link" ,                         EXDEV       )\
   DEFINE_VMK_ERR(VMK_NOT_A_SOCKET,		"Not a socket",				      ENOTSOCK    )\
   DEFINE_VMK_ERR(VMK_ILLEGAL_SEEK,		"Illegal seek",				      ESPIPE      )\
   DEFINE_VMK_ERR(VMK_ADDRFAM_UNSUPP,		"Unsupported address family",		      EAFNOSUPPORT)\
   DEFINE_VMK_ERR(VMK_ALREADY_CONNECTED,	"Already connected",			      EISCONN	  )\
   DEFINE_VMK_ERR(VMK_DEATH_PENDING,            "World is marked for death",		      ENOENT	  )\
   DEFINE_VMK_ERR(VMK_NO_CELL_ASSIGNMENT,       "No valid scheduler cell assignment",         EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MIN_INVALID,          "Invalid cpu min",                            EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MINLIMIT_INVALID,     "Invalid cpu minLimit",                       EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MAX_INVALID,          "Invalid cpu max",                            EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_SHARES_INVALID,       "Invalid cpu shares",                         EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MIN_OVERFLOW,         "Cpu min outside valid range",                EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MINLIMIT_OVERFLOW,    "Cpu minLimit outside valid range",           EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MAX_OVERFLOW,         "Cpu max outside valid range" ,               EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MIN_GT_MINLIMIT,      "Cpu min exceeds minLimit",                   EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MIN_GT_MAX,           "Cpu min exceeds max",                        EINVAL	  )\
   DEFINE_VMK_ERR(VMK_CPU_MINLIMIT_LT_RESERVED, "Cpu minLimit less than cpu already reserved by children", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_CPU_MAX_LT_RESERVED,      "Cpu max less than cpu already reserved by children", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_CPU_ADMIT_FAILED,         "Admission check failed for cpu resource",    ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_MEM_MIN_INVALID,          "Invalid memory min",                         EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MINLIMIT_INVALID,     "Invalid memory minLimit",                    EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MAX_INVALID,          "Invalid memory max",                         EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MIN_OVERFLOW,         "Memory min outside valid range",             EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MINLIMIT_OVERFLOW,    "Memory minLimit outside valid range",        EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MAX_OVERFLOW,         "Memory max outside valid range",             EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MIN_GT_MINLIMIT,      "Memory min exceeds minLimit",                EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MIN_GT_MAX,           "Memory min exceeds max",                     EINVAL	  )\
   DEFINE_VMK_ERR(VMK_MEM_MINLIMIT_LT_RESERVED, "Memory minLimit less than memory already reserved by children", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_MEM_MAX_LT_RESERVED,      "Memory max less than memory already reserved by children", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_MEM_ADMIT_FAILED,         "Admission check failed for memory resource", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_NO_SWAP_FILE,             "No swap file",                               ENOENT	  )\
   DEFINE_VMK_ERR(VMK_BAD_PARAM_COUNT,          "Bad parameter count",                        EINVAL      )\
   DEFINE_VMK_ERR(VMK_BAD_PARAM_TYPE,           "Bad parameter type",                         EINVAL      )\
   DEFINE_VMK_ERR(VMK_UNMAP_RETRY,              "Dueling unmaps (ok to retry)",               ENOMEM      )\
   DEFINE_VMK_ERR(VMK_INVALID_IOCTL,            "Inappropriate ioctl for device",             ENOTTY      )\
   DEFINE_VMK_ERR(VMK_MAPFAULT_RETRY,           "Mmap changed under page fault (ok to retry)",EBUSY       )\
   DEFINE_VMK_ERR(VMK_EINPROGRESS,              "Operation now in progress",                  EINPROGRESS )\
   DEFINE_VMK_ERR(VMK_ADDR_UNMAPPED,            "Address temporarily unmapped",               EFAULT      )\
   DEFINE_VMK_ERR(VMK_INVALID_BUDDY_TYPE,       "Invalid buddy type",                         ENOMEM      )\
   DEFINE_VMK_ERR(VMK_LPAGE_INFO_NOT_FOUND,     "Large page info not found",                   ENOMEM      )\
   DEFINE_VMK_ERR(VMK_LPAGE_INFO_INVALID,       "Invalid large page info",                     EINVAL      )\
   DEFINE_VMK_ERR(VMK_SNAPSHOT_DEV,             "SCSI LUN is in snapshot state",              EIO         )\
   DEFINE_VMK_ERR(VMK_IN_TRANSITION,            "SCSI LUN is in transition",                  EIO         )\
   DEFINE_VMK_ERR(VMK_TXN_FULL,                 "Transaction ran out of lock space or log space", ENOSPC  )\
   DEFINE_VMK_ERR(VMK_LOCK_NOT_FREE,            "Lock was not free",			      EBUSY       )\
   DEFINE_VMK_ERR(VMK_NUM_FILES_EXCEEDED,       "Exceed maximum number of files on the filesystem", ENOSPC)\
   DEFINE_VMK_ERR(VMK_MIGRATE_VMX_FAILURE,	"Migration determined a failure by the VMX",  EINVAL      )\
   DEFINE_VMK_ERR(VMK_VSI_LIST_OVERFLOW,	"VSI GetList handler overflow",               EFBIG       )\
   DEFINE_VMK_ERR(VMK_INVALID_WORLD,            "Invalid world",                              EINVAL      )\
   DEFINE_VMK_ERR(VMK_INVALID_VMM,              "Invalid vmm",                                EINVAL      )\
   DEFINE_VMK_ERR(VMK_INVALID_TXN,              "Invalid transaction",                        EINVAL      )\
   DEFINE_VMK_ERR(VMK_FS_RETRY_OPERATION,	"Transient file system condition, suggest retry", EAGAIN  )\
   DEFINE_VMK_ERR(VMK_VCPU_LIMIT_EXCEEDED,      "Number of running VCPUs limit exceeded",     EINVAL      )\
   DEFINE_VMK_ERR(VMK_INVALID_METADATA,         "Invalid metadata",                           EINVAL      )\
   DEFINE_VMK_ERR(VMK_INVALID_PAGE_NUMBER,	"Invalid page number",                        EINVAL      )\
   DEFINE_VMK_ERR(VMK_NOT_EXEC,                 "Not in executable format",                   ENOEXEC     )\
   DEFINE_VMK_ERR(VMK_NFS_CONNECT_FAILURE,      "Unable to connect to NFS server",            EHOSTDOWN) \
   DEFINE_VMK_ERR(VMK_NFS_MOUNT_NOT_SUPPORTED,  "The NFS server does not support MOUNT version 3 over TCP",     EINVAL) \
   DEFINE_VMK_ERR(VMK_NFS_NFS_NOT_SUPPORTED,    "The NFS server does not support NFS version 3 over TCP",       EINVAL) \
   DEFINE_VMK_ERR(VMK_NFS_MOUNT_DENIED,         "The mount request was denied by the NFS server. Check that the export exists and that the client is permitted to mount it",  EPERM)\
   DEFINE_VMK_ERR(VMK_NFS_MOUNT_NOT_DIR,        "The specified mount path was not a directory",                 ENOTDIR) \
   DEFINE_VMK_ERR(VMK_NFS_BAD_FSINFO,           "Unable to query remote mount point's attributes",              EACCES) \
   DEFINE_VMK_ERR(VMK_NFS_VOLUME_LIMIT_EXCEEDED,"NFS has reached the maximum number of supported volumes",      EINVAL) \
   DEFINE_VMK_ERR(VMK_NO_MEMORY_NICE,           "Out of nice memory",                         ENOMEM      )\
   DEFINE_VMK_ERR(VMK_MIGRATE_PREEMPTIVE_FAIL,	"VMotion failed to start due to lack of cpu or memory resources",     ENOMEM)\
   DEFINE_VMK_ERR(VMK_CACHE_MISS,               "Cache miss",                                 EFAULT      )\
   DEFINE_VMK_ERR(VMK_STRESS_INDUCED_ERROR,     "Error induced when stress options are enabled",    EIO)\
   DEFINE_VMK_ERR(VMK_TOO_MANY_LOCK_HOLDERS,    "Maximum number of concurrent hosts are already accessing this resource",    EUSERS)\
   DEFINE_VMK_ERR(VMK_NO_JOURNAL,               "Host doesn't have a journal",                EIO)\
   DEFINE_VMK_ERR(VMK_RANK_VIOLATION,           "Lock rank violation detected",               EDEADLK)\
   DEFINE_VMK_ERR(VMK_MODULE_FAILED,            "Module failed",                              ENODEV      )\
   DEFINE_VMK_ERR(VMK_NO_MASTER_PTY,            "Unable to open slave if no master pty",      ENXIO       )\
   DEFINE_VMK_ERR(VMK_NOT_IOABLE,               "Not IOAble",                                 EFAULT      )\
   DEFINE_VMK_ERR(VMK_NO_FREE_INODES,           "No free inodes",                             ENOSPC      )\
   DEFINE_VMK_ERR(VMK_NO_MEMORY_FOR_FILEDATA,   "No free memory for file data",               ENOSPC      )\
   DEFINE_VMK_ERR(VMK_NO_TAR_SPACE,             "No free space to expand file or meta data",  ENOSPC      )\
   DEFINE_VMK_ERR(VMK_NO_FIFO_READER,           "Unable to open writer if no fifo reader",    ENXIO       )\
   DEFINE_VMK_ERR(VMK_NO_SUCH_DEVICE,           "No underlying device for major,minor",       EINVAL      )\
   DEFINE_VMK_ERR(VMK_MEM_MIN_GT_MEMSIZE,       "Memory min exceeds memSize",                 EINVAL      )\
   DEFINE_VMK_ERR(VMK_NO_SUCH_VT,               "No virtual terminal for number",             ENXIO       )\
   DEFINE_VMK_ERR(VMK_TOO_MANY_ELEMENTS,        "Too many elements for list",                 E2BIG       )\
   DEFINE_VMK_ERR(VMK_SHAREDAREA_MISMATCH,      "VMM<->VMK shared are mismatch",              ENOSYS      )\
   DEFINE_VMK_ERR(VMK_EXEC_FAILURE,             "Failure during exec while original state already lost", ESRCH)\
   DEFINE_VMK_ERR(VMK_VMNIXMOD_NOT_LOADED,      "vmnixmod kernel module not loaded",          ENOSYS      )\
   DEFINE_VMK_ERR(VMK_INVALID_MODULE,		"Invalid module",			      EINVAL      )\
   DEFINE_VMK_ERR(VMK_UNALIGNED_ADDRESS,        "Address is not aligned on page boundary",    EINVAL      )\
   DEFINE_VMK_ERR(VMK_NOT_MAPPED,               "Address is not mapped in address space",     ENOMEM      )\
   DEFINE_VMK_ERR(VMK_NO_MESSAGE_SPACE,         "No space to record a message",               ENOMEM      )\
   DEFINE_VMK_ERR(VMK_PDI_STACK_OVERFLOW,       "No space left on PDI stack",                 EFBIG      )\
   DEFINE_VMK_ERR(VMK_EXCEPTION_HANDLER_INVALID,"Invalid exception handler",                  EINVAL      )\
   DEFINE_VMK_ERR(VMK_EXCEPTION_NOT_HANDLED,    "Exception not handled by exception handler", EINVAL      )\
   DEFINE_VMK_ERR(VMK_INVALID_MULTIWRITER_OBJECT, "Can't open sparse/TBZ files in multiwriter mode", EDEADLK)\
   DEFINE_VMK_ERR(VMK_STORAGE_RETRY_OPERATION,	"Transient storage condition, suggest retry",     EAGAIN)\
   DEFINE_VMK_ERR(VMK_HBA_ERROR,		"Storage initiator error",                    EIO)\
   DEFINE_VMK_ERR(VMK_TIMER_INIT_FAILED,	"Timer initialization failed",                EINVAL)\
   DEFINE_VMK_ERR(VMK_MODULE_NOT_FOUND,	        "Module not found",                           ENOENT)\
   DEFINE_VMK_ERR(VMK_NOT_SOCKET_OWNER,         "Socket not owned by cartel",                 EINVAL)\
   DEFINE_VMK_ERR(VMK_VSI_HANDLER_NOT_FOUND,    "No VSI handler found for the requested node",ENOENT)\
   DEFINE_VMK_ERR(VMK_INVALID_MMAPPROTFLAGS,    "Invalid mmap protection flags",              EINVAL)\
   DEFINE_VMK_ERR(VMK_INVALID_MAPCONTIG_SIZE,   "Invalid chunk size for contiguous mmap ",    EINVAL)\
   DEFINE_VMK_ERR(VMK_INVALID_MAPCONTIG_MAX,    "Invalid MPN max for contiguous mmap ",       EINVAL)\
   DEFINE_VMK_ERR(VMK_INVALID_MAPCONTIG_FLAG,   "Invalid mmap flag on contiguous mmap ",      EINVAL)\
   DEFINE_VMK_ERR(VMK_NOT_LAZY_MMINFO,          "Unexpected fault on pre-faulted memory region",EINVAL)\
   DEFINE_VMK_ERR(VMK_MMINFO_WONT_SPLIT,        "Memory region cannot be split (remap/unmap)",EINVAL)\
   DEFINE_VMK_ERR(VMK_NO_CACHE_INFO,            "Cache Information not available",            ENOENT)\
   DEFINE_VMK_ERR(VMK_CANNOT_REMAP_PINNED_MEMORY, "Cannot remap pinned memory",               EINVAL)\
   DEFINE_VMK_ERR(VMK_NO_SUCH_CARTELGROUP,      "No cartel group by that name",               ESRCH)\
   DEFINE_VMK_ERR(VMK_SPLOCKSTATS_DISABLED,     "SPLock stats collection disabled",           EINVAL)\
   DEFINE_VMK_ERR(VMK_BAD_TAR_IMAGE,            "Boot image is corrupted",                    EINVAL)\
   DEFINE_VMK_ERR(VMK_BRANCHED_ALREADY,         "Branched file cannot be modified",           EPERM)\
   DEFINE_VMK_ERR(VMK_NAME_RESERVED_FOR_BRANCH, "Name is reserved for branched file",         EPERM)\
   DEFINE_VMK_ERR(VMK_CANNOT_BRANCH_UNLINKED,   "Unlinked file cannot be branched",           EPERM)\
   DEFINE_VMK_ERR(VMK_MAX_RETRIES_EXCEEDED,     "Maximum kernel-level retries exceeded",      EAGAIN)\
   DEFINE_VMK_ERR(VMK_OPTLOCK_STOLEN,           "Optimistic lock acquired by another host",   EAGAIN)\
   DEFINE_VMK_ERR(VMK_NOT_MMAPABLE,             "Object cannot be mmapped",                   ENODEV)\
   DEFINE_VMK_ERR(VMK_INVALID_CPU_AFFINITY,     "Invalid cpu affinity",                       EINVAL)\
   DEFINE_VMK_ERR(VMK_DEVICE_NOT_PARTOF_LV,     "Device does not contain a logical volume",   ENXIO)\
   DEFINE_VMK_ERR(VMK_NO_SPACE,                 "No space left on device",                    ENOSPC)\
   DEFINE_VMK_ERR(VMK_VSI_INVALID_NODE_ID,      "Invalid vsi node ID",                        EINVAL)\
   DEFINE_VMK_ERR(VMK_TOO_MANY_USERS,           "Too many users accessing this resource",     EUSERS)\
   DEFINE_VMK_ERR(VMK_EALREADY,			"Operation already in progress",	      EALREADY)\
   DEFINE_VMK_ERR(VMK_BUF_TOO_SMALL,            "Buffer too small to complete the operation", EINVAL) \
   DEFINE_VMK_ERR(VMK_SNAPSHOT_DEV_DISALLOWED,  "Snapshot device disallowed",                 EACCES)\
   DEFINE_VMK_ERR(VMK_LVM_DEVICE_UNREACHABLE,   "LVM device unreachable",                     EIO)\
   DEFINE_VMK_ERR(VMK_CPU_INVALID_RESOURCE_UNITS, "Invalid cpu resource units",               EINVAL)\
   DEFINE_VMK_ERR(VMK_MEM_INVALID_RESOURCE_UNITS, "Invalid memory resource units",            EINVAL)\
   DEFINE_VMK_ERR(VMK_ABORTED,                  "IO was aborted",                             ECANCELED)\
   DEFINE_VMK_ERR(VMK_MEM_MIN_LT_RESERVED,      "Memory min less than memory already reserved by children", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_MEM_MIN_LT_CONSUMED,      "Memory min less than memory required to support current consumption", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_MEM_MAX_LT_CONSUMED,      "Memory max less than memory required to support current consumption", ENOSPC	  )\
   DEFINE_VMK_ERR(VMK_TIMEOUT_RETRY,            "Timeout (ok to retry)",                      ETIMEDOUT)\
   DEFINE_VMK_ERR(VMK_RESERVATION_LOST,         "Reservation Lost",                           EBUSY)\
   DEFINE_VMK_ERR(VMK_FS_STALE_METADATA,        "Cached metadata is stale",                   ENOENT)\
   DEFINE_VMK_ERR(VMK_NO_FCNTL_LOCK,            "No fcntl lock slot left",                    ENOLCK)\
   DEFINE_VMK_ERR(VMK_NO_FCNTL_LOCK_HOLDER,     "No fcntl lock holder slot left",             ENOLCK)\
   DEFINE_VMK_ERR(VMK_NO_LICENSE,               "Not licensed to access VMFS volumes",        EACCES)\
   DEFINE_VMK_ERR(VMK_VSI_MODULE_NOT_FOUND,     "Vmkernel module necessary for this vsi call not loaded",    ENOENT)\
   DEFINE_VMK_ERR(VMK_LVM_RETRY_OPERATION,      "Transient LVM device condition, suggest retry", EAGAIN)\
/* 
 * --- ADD NEW ERROR CODES ABOVE THIS COMMENT. --- VMK_GENERIC_LINUX_ERROR must be last.                   \
 */                                                                                                        \
   DEFINE_VMK_ERR_AT(VMK_GENERIC_LINUX_ERROR,   "Generic service console error", 0x2bad0000,  EIO         )
/* --- Don't add ERR_AT with negative value. --- */



/*
 * types
 */ 
#define DEFINE_VMK_ERR(_err, _str, _uerr) _err,
#define DEFINE_VMK_ERR_AT(_err, _str, _val, _uerr) _err = _val,
typedef enum {
   VMK_ERROR_CODES
} VMK_ReturnStatus;
#undef DEFINE_VMK_ERR
#undef DEFINE_VMK_ERR_AT

#endif //_VMKAPI_STATUS_H_
