/*
 * Autogenerated file by GPU Top : https://github.com/rib/gputop
 * DO NOT EDIT manually!
 *
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 */

#include <linux/sysfs.h>

#include "i915_drv.h"
#include "i915_oa_bxt.h"

enum metric_set_id {
	METRIC_SET_ID_RENDER_BASIC = 1,
	METRIC_SET_ID_COMPUTE_BASIC,
	METRIC_SET_ID_RENDER_PIPE_PROFILE,
	METRIC_SET_ID_MEMORY_READS,
	METRIC_SET_ID_MEMORY_WRITES,
	METRIC_SET_ID_COMPUTE_EXTENDED,
	METRIC_SET_ID_COMPUTE_L3_CACHE,
	METRIC_SET_ID_HDC_AND_SF,
	METRIC_SET_ID_L3_1,
	METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND,
	METRIC_SET_ID_SAMPLER,
	METRIC_SET_ID_TDL_1,
	METRIC_SET_ID_TDL_2,
	METRIC_SET_ID_COMPUTE_EXTRA,
	METRIC_SET_ID_TEST_OA,
};

int i915_oa_n_builtin_metric_sets_bxt = 15;

static const struct i915_oa_reg b_counter_config_render_basic[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2740), 0x00000000 },
};

static const struct i915_oa_reg flex_eu_config_render_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_render_basic_0_sku_gte_0x03[] = {
	{ _MMIO(0x9888), 0x166c00f0 },
	{ _MMIO(0x9888), 0x12120280 },
	{ _MMIO(0x9888), 0x12320280 },
	{ _MMIO(0x9888), 0x11930317 },
	{ _MMIO(0x9888), 0x159303df },
	{ _MMIO(0x9888), 0x3f900c00 },
	{ _MMIO(0x9888), 0x419000a0 },
	{ _MMIO(0x9888), 0x002d1000 },
	{ _MMIO(0x9888), 0x062d4000 },
	{ _MMIO(0x9888), 0x082d5000 },
	{ _MMIO(0x9888), 0x0a2d1000 },
	{ _MMIO(0x9888), 0x0c2e0800 },
	{ _MMIO(0x9888), 0x0e2e5900 },
	{ _MMIO(0x9888), 0x0a4c8000 },
	{ _MMIO(0x9888), 0x0c4c8000 },
	{ _MMIO(0x9888), 0x0e4c4000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084e8000 },
	{ _MMIO(0x9888), 0x0a4e2000 },
	{ _MMIO(0x9888), 0x1c4f0010 },
	{ _MMIO(0x9888), 0x0a6c0053 },
	{ _MMIO(0x9888), 0x106c0000 },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x1a0fcc00 },
	{ _MMIO(0x9888), 0x1c0f0002 },
	{ _MMIO(0x9888), 0x1c2c0040 },
	{ _MMIO(0x9888), 0x00101000 },
	{ _MMIO(0x9888), 0x04101000 },
	{ _MMIO(0x9888), 0x00114000 },
	{ _MMIO(0x9888), 0x08114000 },
	{ _MMIO(0x9888), 0x00120020 },
	{ _MMIO(0x9888), 0x08120021 },
	{ _MMIO(0x9888), 0x00141000 },
	{ _MMIO(0x9888), 0x08141000 },
	{ _MMIO(0x9888), 0x02308000 },
	{ _MMIO(0x9888), 0x04302000 },
	{ _MMIO(0x9888), 0x06318000 },
	{ _MMIO(0x9888), 0x08318000 },
	{ _MMIO(0x9888), 0x06320800 },
	{ _MMIO(0x9888), 0x08320840 },
	{ _MMIO(0x9888), 0x00320000 },
	{ _MMIO(0x9888), 0x06344000 },
	{ _MMIO(0x9888), 0x08344000 },
	{ _MMIO(0x9888), 0x0d931831 },
	{ _MMIO(0x9888), 0x0f939f3f },
	{ _MMIO(0x9888), 0x01939e80 },
	{ _MMIO(0x9888), 0x039303bc },
	{ _MMIO(0x9888), 0x0593000e },
	{ _MMIO(0x9888), 0x1993002a },
	{ _MMIO(0x9888), 0x07930000 },
	{ _MMIO(0x9888), 0x09930000 },
	{ _MMIO(0x9888), 0x1d900177 },
	{ _MMIO(0x9888), 0x1f900187 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x13904000 },
	{ _MMIO(0x9888), 0x21904000 },
	{ _MMIO(0x9888), 0x23904000 },
	{ _MMIO(0x9888), 0x25904000 },
	{ _MMIO(0x9888), 0x27904000 },
	{ _MMIO(0x9888), 0x2b904000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x53901110 },
	{ _MMIO(0x9888), 0x43900423 },
	{ _MMIO(0x9888), 0x55900111 },
	{ _MMIO(0x9888), 0x47900c02 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900020 },
	{ _MMIO(0x9888), 0x59901111 },
	{ _MMIO(0x9888), 0x4b900421 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900001 },
	{ _MMIO(0x9888), 0x45900821 },
};

static int
get_render_basic_mux_config(struct drm_i915_private *dev_priv,
			    const struct i915_oa_reg **regs,
			    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	if (dev_priv->drm.pdev->revision >= 0x03) {
		regs[n] = mux_config_render_basic_0_sku_gte_0x03;
		lens[n] = ARRAY_SIZE(mux_config_render_basic_0_sku_gte_0x03);
		n++;
	}

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_basic[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2740), 0x00000000 },
};

static const struct i915_oa_reg flex_eu_config_compute_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_compute_basic[] = {
	{ _MMIO(0x9888), 0x104f00e0 },
	{ _MMIO(0x9888), 0x124f1c00 },
	{ _MMIO(0x9888), 0x39900340 },
	{ _MMIO(0x9888), 0x3f900c00 },
	{ _MMIO(0x9888), 0x41900000 },
	{ _MMIO(0x9888), 0x002d5000 },
	{ _MMIO(0x9888), 0x062d4000 },
	{ _MMIO(0x9888), 0x082d4000 },
	{ _MMIO(0x9888), 0x0a2d1000 },
	{ _MMIO(0x9888), 0x0c2d5000 },
	{ _MMIO(0x9888), 0x0e2d4000 },
	{ _MMIO(0x9888), 0x0c2e1400 },
	{ _MMIO(0x9888), 0x0e2e5100 },
	{ _MMIO(0x9888), 0x102e0114 },
	{ _MMIO(0x9888), 0x044cc000 },
	{ _MMIO(0x9888), 0x0a4c8000 },
	{ _MMIO(0x9888), 0x0c4c8000 },
	{ _MMIO(0x9888), 0x0e4c4000 },
	{ _MMIO(0x9888), 0x104c8000 },
	{ _MMIO(0x9888), 0x124c8000 },
	{ _MMIO(0x9888), 0x164c2000 },
	{ _MMIO(0x9888), 0x004ea000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084e8000 },
	{ _MMIO(0x9888), 0x0a4e2000 },
	{ _MMIO(0x9888), 0x0c4ea000 },
	{ _MMIO(0x9888), 0x0e4e8000 },
	{ _MMIO(0x9888), 0x004f6b42 },
	{ _MMIO(0x9888), 0x064f6200 },
	{ _MMIO(0x9888), 0x084f4100 },
	{ _MMIO(0x9888), 0x0a4f0061 },
	{ _MMIO(0x9888), 0x0c4f6c4c },
	{ _MMIO(0x9888), 0x0e4f4b00 },
	{ _MMIO(0x9888), 0x1a4f0000 },
	{ _MMIO(0x9888), 0x1c4f0000 },
	{ _MMIO(0x9888), 0x180f5000 },
	{ _MMIO(0x9888), 0x1a0f8800 },
	{ _MMIO(0x9888), 0x1c0f08a2 },
	{ _MMIO(0x9888), 0x182c4000 },
	{ _MMIO(0x9888), 0x1c2c1451 },
	{ _MMIO(0x9888), 0x1e2c0001 },
	{ _MMIO(0x9888), 0x1a2c0010 },
	{ _MMIO(0x9888), 0x01938000 },
	{ _MMIO(0x9888), 0x0f938000 },
	{ _MMIO(0x9888), 0x19938a28 },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x19900177 },
	{ _MMIO(0x9888), 0x1b900178 },
	{ _MMIO(0x9888), 0x1d900125 },
	{ _MMIO(0x9888), 0x1f900123 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x13904000 },
	{ _MMIO(0x9888), 0x21904000 },
	{ _MMIO(0x9888), 0x25904000 },
	{ _MMIO(0x9888), 0x27904000 },
	{ _MMIO(0x9888), 0x2b904000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x53901000 },
	{ _MMIO(0x9888), 0x43900000 },
	{ _MMIO(0x9888), 0x55900111 },
	{ _MMIO(0x9888), 0x47900000 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b900000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900000 },
	{ _MMIO(0x9888), 0x45900000 },
};

static int
get_compute_basic_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_basic;
	lens[n] = ARRAY_SIZE(mux_config_compute_basic);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_render_pipe_profile[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007ffea },
	{ _MMIO(0x2774), 0x00007ffc },
	{ _MMIO(0x2778), 0x0007affa },
	{ _MMIO(0x277c), 0x0000f5fd },
	{ _MMIO(0x2780), 0x00079ffa },
	{ _MMIO(0x2784), 0x0000f3fb },
	{ _MMIO(0x2788), 0x0007bf7a },
	{ _MMIO(0x278c), 0x0000f7e7 },
	{ _MMIO(0x2790), 0x0007fefa },
	{ _MMIO(0x2794), 0x0000f7cf },
	{ _MMIO(0x2798), 0x00077ffa },
	{ _MMIO(0x279c), 0x0000efdf },
	{ _MMIO(0x27a0), 0x0006fffa },
	{ _MMIO(0x27a4), 0x0000cfbf },
	{ _MMIO(0x27a8), 0x0003fffa },
	{ _MMIO(0x27ac), 0x00005f7f },
};

static const struct i915_oa_reg flex_eu_config_render_pipe_profile[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_render_pipe_profile[] = {
	{ _MMIO(0x9888), 0x0c2e001f },
	{ _MMIO(0x9888), 0x0a2f0000 },
	{ _MMIO(0x9888), 0x10186800 },
	{ _MMIO(0x9888), 0x11810019 },
	{ _MMIO(0x9888), 0x15810013 },
	{ _MMIO(0x9888), 0x13820020 },
	{ _MMIO(0x9888), 0x11830020 },
	{ _MMIO(0x9888), 0x17840000 },
	{ _MMIO(0x9888), 0x11860007 },
	{ _MMIO(0x9888), 0x21860000 },
	{ _MMIO(0x9888), 0x178703e0 },
	{ _MMIO(0x9888), 0x0c2d8000 },
	{ _MMIO(0x9888), 0x042d4000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x022e5400 },
	{ _MMIO(0x9888), 0x002e0000 },
	{ _MMIO(0x9888), 0x0e2e0080 },
	{ _MMIO(0x9888), 0x082f0040 },
	{ _MMIO(0x9888), 0x002f0000 },
	{ _MMIO(0x9888), 0x06143000 },
	{ _MMIO(0x9888), 0x06174000 },
	{ _MMIO(0x9888), 0x06180012 },
	{ _MMIO(0x9888), 0x00180000 },
	{ _MMIO(0x9888), 0x0d804000 },
	{ _MMIO(0x9888), 0x0f804000 },
	{ _MMIO(0x9888), 0x05804000 },
	{ _MMIO(0x9888), 0x09810200 },
	{ _MMIO(0x9888), 0x0b810030 },
	{ _MMIO(0x9888), 0x03810003 },
	{ _MMIO(0x9888), 0x21819140 },
	{ _MMIO(0x9888), 0x23819050 },
	{ _MMIO(0x9888), 0x25810018 },
	{ _MMIO(0x9888), 0x0b820980 },
	{ _MMIO(0x9888), 0x03820d80 },
	{ _MMIO(0x9888), 0x11820000 },
	{ _MMIO(0x9888), 0x0182c000 },
	{ _MMIO(0x9888), 0x07828000 },
	{ _MMIO(0x9888), 0x09824000 },
	{ _MMIO(0x9888), 0x0f828000 },
	{ _MMIO(0x9888), 0x0d830004 },
	{ _MMIO(0x9888), 0x0583000c },
	{ _MMIO(0x9888), 0x0f831000 },
	{ _MMIO(0x9888), 0x01848072 },
	{ _MMIO(0x9888), 0x11840000 },
	{ _MMIO(0x9888), 0x07848000 },
	{ _MMIO(0x9888), 0x09844000 },
	{ _MMIO(0x9888), 0x0f848000 },
	{ _MMIO(0x9888), 0x07860000 },
	{ _MMIO(0x9888), 0x09860092 },
	{ _MMIO(0x9888), 0x0f860400 },
	{ _MMIO(0x9888), 0x01869100 },
	{ _MMIO(0x9888), 0x0f870065 },
	{ _MMIO(0x9888), 0x01870000 },
	{ _MMIO(0x9888), 0x19930800 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x1b952000 },
	{ _MMIO(0x9888), 0x1d955055 },
	{ _MMIO(0x9888), 0x1f951455 },
	{ _MMIO(0x9888), 0x0992a000 },
	{ _MMIO(0x9888), 0x0f928000 },
	{ _MMIO(0x9888), 0x1192a800 },
	{ _MMIO(0x9888), 0x1392028a },
	{ _MMIO(0x9888), 0x0b92a000 },
	{ _MMIO(0x9888), 0x0d922000 },
	{ _MMIO(0x9888), 0x13908000 },
	{ _MMIO(0x9888), 0x21908000 },
	{ _MMIO(0x9888), 0x23908000 },
	{ _MMIO(0x9888), 0x25908000 },
	{ _MMIO(0x9888), 0x27908000 },
	{ _MMIO(0x9888), 0x29908000 },
	{ _MMIO(0x9888), 0x2b908000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x2f908000 },
	{ _MMIO(0x9888), 0x31908000 },
	{ _MMIO(0x9888), 0x15908000 },
	{ _MMIO(0x9888), 0x17908000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b908000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43900c01 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900000 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900863 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b900061 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900000 },
	{ _MMIO(0x9888), 0x45900c22 },
};

static int
get_render_pipe_profile_mux_config(struct drm_i915_private *dev_priv,
				   const struct i915_oa_reg **regs,
				   int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_render_pipe_profile;
	lens[n] = ARRAY_SIZE(mux_config_render_pipe_profile);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_memory_reads[] = {
	{ _MMIO(0x272c), 0xffffffff },
	{ _MMIO(0x2728), 0xffffffff },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x271c), 0xffffffff },
	{ _MMIO(0x2718), 0xffffffff },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0x86543210 },
	{ _MMIO(0x2748), 0x86543210 },
	{ _MMIO(0x2744), 0x00006667 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x275c), 0x86543210 },
	{ _MMIO(0x2758), 0x86543210 },
	{ _MMIO(0x2754), 0x00006465 },
	{ _MMIO(0x2750), 0x00000000 },
	{ _MMIO(0x2770), 0x0007f81a },
	{ _MMIO(0x2774), 0x0000fe00 },
	{ _MMIO(0x2778), 0x0007f82a },
	{ _MMIO(0x277c), 0x0000fe00 },
	{ _MMIO(0x2780), 0x0007f872 },
	{ _MMIO(0x2784), 0x0000fe00 },
	{ _MMIO(0x2788), 0x0007f8ba },
	{ _MMIO(0x278c), 0x0000fe00 },
	{ _MMIO(0x2790), 0x0007f87a },
	{ _MMIO(0x2794), 0x0000fe00 },
	{ _MMIO(0x2798), 0x0007f8ea },
	{ _MMIO(0x279c), 0x0000fe00 },
	{ _MMIO(0x27a0), 0x0007f8e2 },
	{ _MMIO(0x27a4), 0x0000fe00 },
	{ _MMIO(0x27a8), 0x0007f8f2 },
	{ _MMIO(0x27ac), 0x0000fe00 },
};

static const struct i915_oa_reg flex_eu_config_memory_reads[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_memory_reads[] = {
	{ _MMIO(0x9888), 0x19800343 },
	{ _MMIO(0x9888), 0x39900340 },
	{ _MMIO(0x9888), 0x3f901000 },
	{ _MMIO(0x9888), 0x41900003 },
	{ _MMIO(0x9888), 0x03803180 },
	{ _MMIO(0x9888), 0x058035e2 },
	{ _MMIO(0x9888), 0x0780006a },
	{ _MMIO(0x9888), 0x11800000 },
	{ _MMIO(0x9888), 0x2181a000 },
	{ _MMIO(0x9888), 0x2381000a },
	{ _MMIO(0x9888), 0x1d950550 },
	{ _MMIO(0x9888), 0x0b928000 },
	{ _MMIO(0x9888), 0x0d92a000 },
	{ _MMIO(0x9888), 0x0f922000 },
	{ _MMIO(0x9888), 0x13900170 },
	{ _MMIO(0x9888), 0x21900171 },
	{ _MMIO(0x9888), 0x23900172 },
	{ _MMIO(0x9888), 0x25900173 },
	{ _MMIO(0x9888), 0x27900174 },
	{ _MMIO(0x9888), 0x29900175 },
	{ _MMIO(0x9888), 0x2b900176 },
	{ _MMIO(0x9888), 0x2d900177 },
	{ _MMIO(0x9888), 0x2f90017f },
	{ _MMIO(0x9888), 0x31900125 },
	{ _MMIO(0x9888), 0x15900123 },
	{ _MMIO(0x9888), 0x17900121 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b908000 },
	{ _MMIO(0x9888), 0x1d908000 },
	{ _MMIO(0x9888), 0x1f908000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43901084 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47901080 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49901084 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b901084 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900004 },
	{ _MMIO(0x9888), 0x45900000 },
};

static int
get_memory_reads_mux_config(struct drm_i915_private *dev_priv,
			    const struct i915_oa_reg **regs,
			    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_memory_reads;
	lens[n] = ARRAY_SIZE(mux_config_memory_reads);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_memory_writes[] = {
	{ _MMIO(0x272c), 0xffffffff },
	{ _MMIO(0x2728), 0xffffffff },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x271c), 0xffffffff },
	{ _MMIO(0x2718), 0xffffffff },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0x86543210 },
	{ _MMIO(0x2748), 0x86543210 },
	{ _MMIO(0x2744), 0x00006667 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x275c), 0x86543210 },
	{ _MMIO(0x2758), 0x86543210 },
	{ _MMIO(0x2754), 0x00006465 },
	{ _MMIO(0x2750), 0x00000000 },
	{ _MMIO(0x2770), 0x0007f81a },
	{ _MMIO(0x2774), 0x0000fe00 },
	{ _MMIO(0x2778), 0x0007f82a },
	{ _MMIO(0x277c), 0x0000fe00 },
	{ _MMIO(0x2780), 0x0007f822 },
	{ _MMIO(0x2784), 0x0000fe00 },
	{ _MMIO(0x2788), 0x0007f8ba },
	{ _MMIO(0x278c), 0x0000fe00 },
	{ _MMIO(0x2790), 0x0007f87a },
	{ _MMIO(0x2794), 0x0000fe00 },
	{ _MMIO(0x2798), 0x0007f8ea },
	{ _MMIO(0x279c), 0x0000fe00 },
	{ _MMIO(0x27a0), 0x0007f8e2 },
	{ _MMIO(0x27a4), 0x0000fe00 },
	{ _MMIO(0x27a8), 0x0007f8f2 },
	{ _MMIO(0x27ac), 0x0000fe00 },
};

static const struct i915_oa_reg flex_eu_config_memory_writes[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_memory_writes[] = {
	{ _MMIO(0x9888), 0x19800343 },
	{ _MMIO(0x9888), 0x39900340 },
	{ _MMIO(0x9888), 0x3f900000 },
	{ _MMIO(0x9888), 0x41900080 },
	{ _MMIO(0x9888), 0x03803180 },
	{ _MMIO(0x9888), 0x058035e2 },
	{ _MMIO(0x9888), 0x0780006a },
	{ _MMIO(0x9888), 0x11800000 },
	{ _MMIO(0x9888), 0x2181a000 },
	{ _MMIO(0x9888), 0x2381000a },
	{ _MMIO(0x9888), 0x1d950550 },
	{ _MMIO(0x9888), 0x0b928000 },
	{ _MMIO(0x9888), 0x0d92a000 },
	{ _MMIO(0x9888), 0x0f922000 },
	{ _MMIO(0x9888), 0x13900180 },
	{ _MMIO(0x9888), 0x21900181 },
	{ _MMIO(0x9888), 0x23900182 },
	{ _MMIO(0x9888), 0x25900183 },
	{ _MMIO(0x9888), 0x27900184 },
	{ _MMIO(0x9888), 0x29900185 },
	{ _MMIO(0x9888), 0x2b900186 },
	{ _MMIO(0x9888), 0x2d900187 },
	{ _MMIO(0x9888), 0x2f900170 },
	{ _MMIO(0x9888), 0x31900125 },
	{ _MMIO(0x9888), 0x15900123 },
	{ _MMIO(0x9888), 0x17900121 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b908000 },
	{ _MMIO(0x9888), 0x1d908000 },
	{ _MMIO(0x9888), 0x1f908000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43901084 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47901080 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49901084 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b901084 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900004 },
	{ _MMIO(0x9888), 0x45900000 },
};

static int
get_memory_writes_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_memory_writes;
	lens[n] = ARRAY_SIZE(mux_config_memory_writes);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_extended[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007fc2a },
	{ _MMIO(0x2774), 0x0000bf00 },
	{ _MMIO(0x2778), 0x0007fc6a },
	{ _MMIO(0x277c), 0x0000bf00 },
	{ _MMIO(0x2780), 0x0007fc92 },
	{ _MMIO(0x2784), 0x0000bf00 },
	{ _MMIO(0x2788), 0x0007fca2 },
	{ _MMIO(0x278c), 0x0000bf00 },
	{ _MMIO(0x2790), 0x0007fc32 },
	{ _MMIO(0x2794), 0x0000bf00 },
	{ _MMIO(0x2798), 0x0007fc9a },
	{ _MMIO(0x279c), 0x0000bf00 },
	{ _MMIO(0x27a0), 0x0007fe6a },
	{ _MMIO(0x27a4), 0x0000bf00 },
	{ _MMIO(0x27a8), 0x0007fe7a },
	{ _MMIO(0x27ac), 0x0000bf00 },
};

static const struct i915_oa_reg flex_eu_config_compute_extended[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_compute_extended[] = {
	{ _MMIO(0x9888), 0x104f00e0 },
	{ _MMIO(0x9888), 0x141c0160 },
	{ _MMIO(0x9888), 0x161c0015 },
	{ _MMIO(0x9888), 0x181c0120 },
	{ _MMIO(0x9888), 0x002d5000 },
	{ _MMIO(0x9888), 0x062d4000 },
	{ _MMIO(0x9888), 0x082d5000 },
	{ _MMIO(0x9888), 0x0a2d5000 },
	{ _MMIO(0x9888), 0x0c2d5000 },
	{ _MMIO(0x9888), 0x0e2d5000 },
	{ _MMIO(0x9888), 0x022d5000 },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x0c2e5400 },
	{ _MMIO(0x9888), 0x0e2e5515 },
	{ _MMIO(0x9888), 0x102e0155 },
	{ _MMIO(0x9888), 0x044cc000 },
	{ _MMIO(0x9888), 0x0a4c8000 },
	{ _MMIO(0x9888), 0x0c4cc000 },
	{ _MMIO(0x9888), 0x0e4cc000 },
	{ _MMIO(0x9888), 0x104c8000 },
	{ _MMIO(0x9888), 0x124c8000 },
	{ _MMIO(0x9888), 0x144c8000 },
	{ _MMIO(0x9888), 0x164c2000 },
	{ _MMIO(0x9888), 0x064cc000 },
	{ _MMIO(0x9888), 0x084cc000 },
	{ _MMIO(0x9888), 0x004ea000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084ea000 },
	{ _MMIO(0x9888), 0x0a4ea000 },
	{ _MMIO(0x9888), 0x0c4ea000 },
	{ _MMIO(0x9888), 0x0e4ea000 },
	{ _MMIO(0x9888), 0x024ea000 },
	{ _MMIO(0x9888), 0x044ea000 },
	{ _MMIO(0x9888), 0x0e4f4b41 },
	{ _MMIO(0x9888), 0x004f4200 },
	{ _MMIO(0x9888), 0x024f404c },
	{ _MMIO(0x9888), 0x1c4f0000 },
	{ _MMIO(0x9888), 0x1a4f0000 },
	{ _MMIO(0x9888), 0x001b4000 },
	{ _MMIO(0x9888), 0x061b8000 },
	{ _MMIO(0x9888), 0x081bc000 },
	{ _MMIO(0x9888), 0x0a1bc000 },
	{ _MMIO(0x9888), 0x0c1bc000 },
	{ _MMIO(0x9888), 0x041bc000 },
	{ _MMIO(0x9888), 0x001c0031 },
	{ _MMIO(0x9888), 0x061c1900 },
	{ _MMIO(0x9888), 0x081c1a33 },
	{ _MMIO(0x9888), 0x0a1c1b35 },
	{ _MMIO(0x9888), 0x0c1c3337 },
	{ _MMIO(0x9888), 0x041c31c7 },
	{ _MMIO(0x9888), 0x180f5000 },
	{ _MMIO(0x9888), 0x1a0fa8aa },
	{ _MMIO(0x9888), 0x1c0f0aaa },
	{ _MMIO(0x9888), 0x182c8000 },
	{ _MMIO(0x9888), 0x1c2c6aaa },
	{ _MMIO(0x9888), 0x1e2c0001 },
	{ _MMIO(0x9888), 0x1a2c2950 },
	{ _MMIO(0x9888), 0x01938000 },
	{ _MMIO(0x9888), 0x0f938000 },
	{ _MMIO(0x9888), 0x1993aaaa },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x05938000 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x13904000 },
	{ _MMIO(0x9888), 0x21904000 },
	{ _MMIO(0x9888), 0x23904000 },
	{ _MMIO(0x9888), 0x25904000 },
	{ _MMIO(0x9888), 0x27904000 },
	{ _MMIO(0x9888), 0x29904000 },
	{ _MMIO(0x9888), 0x2b904000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43900420 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900000 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b900400 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900001 },
	{ _MMIO(0x9888), 0x45900001 },
};

static int
get_compute_extended_mux_config(struct drm_i915_private *dev_priv,
				const struct i915_oa_reg **regs,
				int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_extended;
	lens[n] = ARRAY_SIZE(mux_config_compute_extended);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_l3_cache[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x30800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007fffa },
	{ _MMIO(0x2774), 0x0000fefe },
	{ _MMIO(0x2778), 0x0007fffa },
	{ _MMIO(0x277c), 0x0000fefd },
	{ _MMIO(0x2790), 0x0007fffa },
	{ _MMIO(0x2794), 0x0000fbef },
	{ _MMIO(0x2798), 0x0007fffa },
	{ _MMIO(0x279c), 0x0000fbdf },
};

static const struct i915_oa_reg flex_eu_config_compute_l3_cache[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00101100 },
	{ _MMIO(0xe45c), 0x00201200 },
	{ _MMIO(0xe55c), 0x00301300 },
	{ _MMIO(0xe65c), 0x00401400 },
};

static const struct i915_oa_reg mux_config_compute_l3_cache[] = {
	{ _MMIO(0x9888), 0x166c03b0 },
	{ _MMIO(0x9888), 0x1593001e },
	{ _MMIO(0x9888), 0x3f900c00 },
	{ _MMIO(0x9888), 0x41900000 },
	{ _MMIO(0x9888), 0x002d1000 },
	{ _MMIO(0x9888), 0x062d4000 },
	{ _MMIO(0x9888), 0x082d5000 },
	{ _MMIO(0x9888), 0x0e2d5000 },
	{ _MMIO(0x9888), 0x0c2e0400 },
	{ _MMIO(0x9888), 0x0e2e1500 },
	{ _MMIO(0x9888), 0x102e0140 },
	{ _MMIO(0x9888), 0x044c4000 },
	{ _MMIO(0x9888), 0x0a4c8000 },
	{ _MMIO(0x9888), 0x0c4cc000 },
	{ _MMIO(0x9888), 0x144c8000 },
	{ _MMIO(0x9888), 0x164c2000 },
	{ _MMIO(0x9888), 0x004e2000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084ea000 },
	{ _MMIO(0x9888), 0x0e4ea000 },
	{ _MMIO(0x9888), 0x1a4f4001 },
	{ _MMIO(0x9888), 0x1c4f5005 },
	{ _MMIO(0x9888), 0x006c0051 },
	{ _MMIO(0x9888), 0x066c5000 },
	{ _MMIO(0x9888), 0x086c5c5d },
	{ _MMIO(0x9888), 0x0e6c5e5f },
	{ _MMIO(0x9888), 0x106c0000 },
	{ _MMIO(0x9888), 0x146c0000 },
	{ _MMIO(0x9888), 0x1a6c0000 },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x180f1000 },
	{ _MMIO(0x9888), 0x1a0fa800 },
	{ _MMIO(0x9888), 0x1c0f0a00 },
	{ _MMIO(0x9888), 0x182c4000 },
	{ _MMIO(0x9888), 0x1c2c4015 },
	{ _MMIO(0x9888), 0x1e2c0001 },
	{ _MMIO(0x9888), 0x03931980 },
	{ _MMIO(0x9888), 0x05930032 },
	{ _MMIO(0x9888), 0x11930000 },
	{ _MMIO(0x9888), 0x01938000 },
	{ _MMIO(0x9888), 0x0f938000 },
	{ _MMIO(0x9888), 0x1993a00a },
	{ _MMIO(0x9888), 0x07930000 },
	{ _MMIO(0x9888), 0x09930000 },
	{ _MMIO(0x9888), 0x1d900177 },
	{ _MMIO(0x9888), 0x1f900178 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x13904000 },
	{ _MMIO(0x9888), 0x21904000 },
	{ _MMIO(0x9888), 0x23904000 },
	{ _MMIO(0x9888), 0x25904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x53901000 },
	{ _MMIO(0x9888), 0x43900000 },
	{ _MMIO(0x9888), 0x55900111 },
	{ _MMIO(0x9888), 0x47900001 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b900000 },
	{ _MMIO(0x9888), 0x4d900000 },
	{ _MMIO(0x9888), 0x45900400 },
};

static int
get_compute_l3_cache_mux_config(struct drm_i915_private *dev_priv,
				const struct i915_oa_reg **regs,
				int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_l3_cache;
	lens[n] = ARRAY_SIZE(mux_config_compute_l3_cache);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_hdc_and_sf[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x10800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fdff },
};

static const struct i915_oa_reg flex_eu_config_hdc_and_sf[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_hdc_and_sf[] = {
	{ _MMIO(0x9888), 0x104f0232 },
	{ _MMIO(0x9888), 0x124f4640 },
	{ _MMIO(0x9888), 0x11834400 },
	{ _MMIO(0x9888), 0x022d4000 },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x0e2e0055 },
	{ _MMIO(0x9888), 0x064c8000 },
	{ _MMIO(0x9888), 0x084cc000 },
	{ _MMIO(0x9888), 0x0a4c4000 },
	{ _MMIO(0x9888), 0x024e8000 },
	{ _MMIO(0x9888), 0x044ea000 },
	{ _MMIO(0x9888), 0x064e2000 },
	{ _MMIO(0x9888), 0x024f6100 },
	{ _MMIO(0x9888), 0x044f416b },
	{ _MMIO(0x9888), 0x064f004b },
	{ _MMIO(0x9888), 0x1a4f0000 },
	{ _MMIO(0x9888), 0x1a0f02a8 },
	{ _MMIO(0x9888), 0x1a2c5500 },
	{ _MMIO(0x9888), 0x0f808000 },
	{ _MMIO(0x9888), 0x25810020 },
	{ _MMIO(0x9888), 0x0f8305c0 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x1f951000 },
	{ _MMIO(0x9888), 0x13920200 },
	{ _MMIO(0x9888), 0x31908000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4d900003 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900000 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900000 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_hdc_and_sf_mux_config(struct drm_i915_private *dev_priv,
			  const struct i915_oa_reg **regs,
			  int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_hdc_and_sf;
	lens[n] = ARRAY_SIZE(mux_config_hdc_and_sf);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_1_0_sku_gte_0x03[] = {
	{ _MMIO(0x9888), 0x12643400 },
	{ _MMIO(0x9888), 0x12653400 },
	{ _MMIO(0x9888), 0x106c6800 },
	{ _MMIO(0x9888), 0x126c001e },
	{ _MMIO(0x9888), 0x166c0010 },
	{ _MMIO(0x9888), 0x0c2d5000 },
	{ _MMIO(0x9888), 0x0e2d5000 },
	{ _MMIO(0x9888), 0x002d4000 },
	{ _MMIO(0x9888), 0x022d5000 },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x102e0154 },
	{ _MMIO(0x9888), 0x0c2e5000 },
	{ _MMIO(0x9888), 0x0e2e0055 },
	{ _MMIO(0x9888), 0x104c8000 },
	{ _MMIO(0x9888), 0x124c8000 },
	{ _MMIO(0x9888), 0x144c8000 },
	{ _MMIO(0x9888), 0x164c2000 },
	{ _MMIO(0x9888), 0x044c8000 },
	{ _MMIO(0x9888), 0x064cc000 },
	{ _MMIO(0x9888), 0x084cc000 },
	{ _MMIO(0x9888), 0x0a4c4000 },
	{ _MMIO(0x9888), 0x0c4ea000 },
	{ _MMIO(0x9888), 0x0e4ea000 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x024ea000 },
	{ _MMIO(0x9888), 0x044ea000 },
	{ _MMIO(0x9888), 0x064e2000 },
	{ _MMIO(0x9888), 0x1c4f5500 },
	{ _MMIO(0x9888), 0x1a4f1554 },
	{ _MMIO(0x9888), 0x0a640024 },
	{ _MMIO(0x9888), 0x10640000 },
	{ _MMIO(0x9888), 0x04640000 },
	{ _MMIO(0x9888), 0x0c650024 },
	{ _MMIO(0x9888), 0x10650000 },
	{ _MMIO(0x9888), 0x06650000 },
	{ _MMIO(0x9888), 0x0c6c5327 },
	{ _MMIO(0x9888), 0x0e6c5425 },
	{ _MMIO(0x9888), 0x006c2a00 },
	{ _MMIO(0x9888), 0x026c285b },
	{ _MMIO(0x9888), 0x046c005c },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x1a6c0900 },
	{ _MMIO(0x9888), 0x1c0f0aa0 },
	{ _MMIO(0x9888), 0x180f4000 },
	{ _MMIO(0x9888), 0x1a0f02aa },
	{ _MMIO(0x9888), 0x1c2c5400 },
	{ _MMIO(0x9888), 0x1e2c0001 },
	{ _MMIO(0x9888), 0x1a2c5550 },
	{ _MMIO(0x9888), 0x1993aa00 },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x05938000 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x2b904000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b900421 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900001 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43900420 },
	{ _MMIO(0x9888), 0x45900021 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900000 },
};

static const struct i915_oa_reg mux_config_l3_1_0_sku_lt_0x03[] = {
	{ _MMIO(0x9888), 0x14640340 },
	{ _MMIO(0x9888), 0x14650340 },
	{ _MMIO(0x9888), 0x106c6800 },
	{ _MMIO(0x9888), 0x126c001e },
	{ _MMIO(0x9888), 0x166c0010 },
	{ _MMIO(0x9888), 0x0c2d5000 },
	{ _MMIO(0x9888), 0x0e2d5000 },
	{ _MMIO(0x9888), 0x002d4000 },
	{ _MMIO(0x9888), 0x022d5000 },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x102e0154 },
	{ _MMIO(0x9888), 0x0c2e5000 },
	{ _MMIO(0x9888), 0x0e2e0055 },
	{ _MMIO(0x9888), 0x104c8000 },
	{ _MMIO(0x9888), 0x124c8000 },
	{ _MMIO(0x9888), 0x144c8000 },
	{ _MMIO(0x9888), 0x164c2000 },
	{ _MMIO(0x9888), 0x044c8000 },
	{ _MMIO(0x9888), 0x064cc000 },
	{ _MMIO(0x9888), 0x084cc000 },
	{ _MMIO(0x9888), 0x0a4c4000 },
	{ _MMIO(0x9888), 0x0c4ea000 },
	{ _MMIO(0x9888), 0x0e4ea000 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x024ea000 },
	{ _MMIO(0x9888), 0x044ea000 },
	{ _MMIO(0x9888), 0x064e2000 },
	{ _MMIO(0x9888), 0x1c4f5500 },
	{ _MMIO(0x9888), 0x1a4f1554 },
	{ _MMIO(0x9888), 0x04642400 },
	{ _MMIO(0x9888), 0x22640000 },
	{ _MMIO(0x9888), 0x1a640000 },
	{ _MMIO(0x9888), 0x06650024 },
	{ _MMIO(0x9888), 0x22650000 },
	{ _MMIO(0x9888), 0x1c650000 },
	{ _MMIO(0x9888), 0x0c6c5327 },
	{ _MMIO(0x9888), 0x0e6c5425 },
	{ _MMIO(0x9888), 0x006c2a00 },
	{ _MMIO(0x9888), 0x026c285b },
	{ _MMIO(0x9888), 0x046c005c },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x1a6c0900 },
	{ _MMIO(0x9888), 0x1c0f0aa0 },
	{ _MMIO(0x9888), 0x180f4000 },
	{ _MMIO(0x9888), 0x1a0f02aa },
	{ _MMIO(0x9888), 0x1c2c5400 },
	{ _MMIO(0x9888), 0x1e2c0001 },
	{ _MMIO(0x9888), 0x1a2c5550 },
	{ _MMIO(0x9888), 0x1993aa00 },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x05938000 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x2b904000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b900421 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900001 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43900420 },
	{ _MMIO(0x9888), 0x45900021 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900000 },
};

static int
get_l3_1_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 2);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 2);

	if (dev_priv->drm.pdev->revision >= 0x03) {
		regs[n] = mux_config_l3_1_0_sku_gte_0x03;
		lens[n] = ARRAY_SIZE(mux_config_l3_1_0_sku_gte_0x03);
		n++;
	}
	if (dev_priv->drm.pdev->revision < 0x03) {
		regs[n] = mux_config_l3_1_0_sku_lt_0x03;
		lens[n] = ARRAY_SIZE(mux_config_l3_1_0_sku_lt_0x03);
		n++;
	}

	return n;
}

static const struct i915_oa_reg b_counter_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x30800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000efff },
	{ _MMIO(0x2778), 0x00006000 },
	{ _MMIO(0x277c), 0x0000f3ff },
};

static const struct i915_oa_reg flex_eu_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x9888), 0x102d7800 },
	{ _MMIO(0x9888), 0x122d79e0 },
	{ _MMIO(0x9888), 0x0c2f0004 },
	{ _MMIO(0x9888), 0x100e3800 },
	{ _MMIO(0x9888), 0x180f0005 },
	{ _MMIO(0x9888), 0x002d0940 },
	{ _MMIO(0x9888), 0x022d802f },
	{ _MMIO(0x9888), 0x042d4013 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x0e2e0050 },
	{ _MMIO(0x9888), 0x022f0010 },
	{ _MMIO(0x9888), 0x002f0000 },
	{ _MMIO(0x9888), 0x084c8000 },
	{ _MMIO(0x9888), 0x0a4c4000 },
	{ _MMIO(0x9888), 0x044e8000 },
	{ _MMIO(0x9888), 0x064e2000 },
	{ _MMIO(0x9888), 0x040e0480 },
	{ _MMIO(0x9888), 0x000e0000 },
	{ _MMIO(0x9888), 0x060f0027 },
	{ _MMIO(0x9888), 0x100f0000 },
	{ _MMIO(0x9888), 0x1a0f0040 },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x05938000 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x439014a0 },
	{ _MMIO(0x9888), 0x459000a4 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900001 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_rasterizer_and_pixel_backend_mux_config(struct drm_i915_private *dev_priv,
					    const struct i915_oa_reg **regs,
					    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_rasterizer_and_pixel_backend;
	lens[n] = ARRAY_SIZE(mux_config_rasterizer_and_pixel_backend);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_sampler[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x70800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x0000c000 },
	{ _MMIO(0x2774), 0x0000e7ff },
	{ _MMIO(0x2778), 0x00003000 },
	{ _MMIO(0x277c), 0x0000f9ff },
	{ _MMIO(0x2780), 0x00000c00 },
	{ _MMIO(0x2784), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_sampler[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_sampler[] = {
	{ _MMIO(0x9888), 0x121300a0 },
	{ _MMIO(0x9888), 0x141600ab },
	{ _MMIO(0x9888), 0x123300a0 },
	{ _MMIO(0x9888), 0x143600ab },
	{ _MMIO(0x9888), 0x125300a0 },
	{ _MMIO(0x9888), 0x145600ab },
	{ _MMIO(0x9888), 0x0c2d4000 },
	{ _MMIO(0x9888), 0x0e2d5000 },
	{ _MMIO(0x9888), 0x002d4000 },
	{ _MMIO(0x9888), 0x022d5000 },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x102e01a0 },
	{ _MMIO(0x9888), 0x0c2e5000 },
	{ _MMIO(0x9888), 0x0e2e0065 },
	{ _MMIO(0x9888), 0x164c2000 },
	{ _MMIO(0x9888), 0x044c8000 },
	{ _MMIO(0x9888), 0x064cc000 },
	{ _MMIO(0x9888), 0x084c4000 },
	{ _MMIO(0x9888), 0x0a4c4000 },
	{ _MMIO(0x9888), 0x0e4e8000 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x024ea000 },
	{ _MMIO(0x9888), 0x044e2000 },
	{ _MMIO(0x9888), 0x064e2000 },
	{ _MMIO(0x9888), 0x1c0f0800 },
	{ _MMIO(0x9888), 0x180f4000 },
	{ _MMIO(0x9888), 0x1a0f023f },
	{ _MMIO(0x9888), 0x1e2c0003 },
	{ _MMIO(0x9888), 0x1a2cc030 },
	{ _MMIO(0x9888), 0x04132180 },
	{ _MMIO(0x9888), 0x02130000 },
	{ _MMIO(0x9888), 0x0c148000 },
	{ _MMIO(0x9888), 0x0e142000 },
	{ _MMIO(0x9888), 0x04148000 },
	{ _MMIO(0x9888), 0x1e150140 },
	{ _MMIO(0x9888), 0x1c150040 },
	{ _MMIO(0x9888), 0x0c163000 },
	{ _MMIO(0x9888), 0x0e160068 },
	{ _MMIO(0x9888), 0x10160000 },
	{ _MMIO(0x9888), 0x18160000 },
	{ _MMIO(0x9888), 0x0a164000 },
	{ _MMIO(0x9888), 0x04330043 },
	{ _MMIO(0x9888), 0x02330000 },
	{ _MMIO(0x9888), 0x0234a000 },
	{ _MMIO(0x9888), 0x04342000 },
	{ _MMIO(0x9888), 0x1c350015 },
	{ _MMIO(0x9888), 0x02363460 },
	{ _MMIO(0x9888), 0x10360000 },
	{ _MMIO(0x9888), 0x04360000 },
	{ _MMIO(0x9888), 0x06360000 },
	{ _MMIO(0x9888), 0x08364000 },
	{ _MMIO(0x9888), 0x06530043 },
	{ _MMIO(0x9888), 0x02530000 },
	{ _MMIO(0x9888), 0x0e548000 },
	{ _MMIO(0x9888), 0x00548000 },
	{ _MMIO(0x9888), 0x06542000 },
	{ _MMIO(0x9888), 0x1e550400 },
	{ _MMIO(0x9888), 0x1a552000 },
	{ _MMIO(0x9888), 0x1c550100 },
	{ _MMIO(0x9888), 0x0e563000 },
	{ _MMIO(0x9888), 0x00563400 },
	{ _MMIO(0x9888), 0x10560000 },
	{ _MMIO(0x9888), 0x18560000 },
	{ _MMIO(0x9888), 0x02560000 },
	{ _MMIO(0x9888), 0x0c564000 },
	{ _MMIO(0x9888), 0x1993a800 },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x05938000 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b9014a0 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900001 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43900820 },
	{ _MMIO(0x9888), 0x45901022 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900000 },
};

static int
get_sampler_mux_config(struct drm_i915_private *dev_priv,
		       const struct i915_oa_reg **regs,
		       int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_sampler;
	lens[n] = ARRAY_SIZE(mux_config_sampler);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x00007fff },
	{ _MMIO(0x2778), 0x00000000 },
	{ _MMIO(0x277c), 0x00009fff },
	{ _MMIO(0x2780), 0x00000002 },
	{ _MMIO(0x2784), 0x0000efff },
	{ _MMIO(0x2788), 0x00000000 },
	{ _MMIO(0x278c), 0x0000f3ff },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000fdff },
	{ _MMIO(0x2798), 0x00000000 },
	{ _MMIO(0x279c), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_tdl_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_1[] = {
	{ _MMIO(0x9888), 0x141a0000 },
	{ _MMIO(0x9888), 0x143a0000 },
	{ _MMIO(0x9888), 0x145a0000 },
	{ _MMIO(0x9888), 0x0c2d4000 },
	{ _MMIO(0x9888), 0x0e2d5000 },
	{ _MMIO(0x9888), 0x002d4000 },
	{ _MMIO(0x9888), 0x022d5000 },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x102e0150 },
	{ _MMIO(0x9888), 0x0c2e5000 },
	{ _MMIO(0x9888), 0x0e2e006a },
	{ _MMIO(0x9888), 0x124c8000 },
	{ _MMIO(0x9888), 0x144c8000 },
	{ _MMIO(0x9888), 0x164c2000 },
	{ _MMIO(0x9888), 0x044c8000 },
	{ _MMIO(0x9888), 0x064c4000 },
	{ _MMIO(0x9888), 0x0a4c4000 },
	{ _MMIO(0x9888), 0x0c4e8000 },
	{ _MMIO(0x9888), 0x0e4ea000 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x024e2000 },
	{ _MMIO(0x9888), 0x064e2000 },
	{ _MMIO(0x9888), 0x1c0f0bc0 },
	{ _MMIO(0x9888), 0x180f4000 },
	{ _MMIO(0x9888), 0x1a0f0302 },
	{ _MMIO(0x9888), 0x1e2c0003 },
	{ _MMIO(0x9888), 0x1a2c00f0 },
	{ _MMIO(0x9888), 0x021a3080 },
	{ _MMIO(0x9888), 0x041a31e5 },
	{ _MMIO(0x9888), 0x02148000 },
	{ _MMIO(0x9888), 0x0414a000 },
	{ _MMIO(0x9888), 0x1c150054 },
	{ _MMIO(0x9888), 0x06168000 },
	{ _MMIO(0x9888), 0x08168000 },
	{ _MMIO(0x9888), 0x0a168000 },
	{ _MMIO(0x9888), 0x0c3a3280 },
	{ _MMIO(0x9888), 0x0e3a0063 },
	{ _MMIO(0x9888), 0x063a0061 },
	{ _MMIO(0x9888), 0x023a0000 },
	{ _MMIO(0x9888), 0x0c348000 },
	{ _MMIO(0x9888), 0x0e342000 },
	{ _MMIO(0x9888), 0x06342000 },
	{ _MMIO(0x9888), 0x1e350140 },
	{ _MMIO(0x9888), 0x1c350100 },
	{ _MMIO(0x9888), 0x18360028 },
	{ _MMIO(0x9888), 0x0c368000 },
	{ _MMIO(0x9888), 0x0e5a3080 },
	{ _MMIO(0x9888), 0x005a3280 },
	{ _MMIO(0x9888), 0x025a0063 },
	{ _MMIO(0x9888), 0x0e548000 },
	{ _MMIO(0x9888), 0x00548000 },
	{ _MMIO(0x9888), 0x02542000 },
	{ _MMIO(0x9888), 0x1e550400 },
	{ _MMIO(0x9888), 0x1a552000 },
	{ _MMIO(0x9888), 0x1c550001 },
	{ _MMIO(0x9888), 0x18560080 },
	{ _MMIO(0x9888), 0x02568000 },
	{ _MMIO(0x9888), 0x04568000 },
	{ _MMIO(0x9888), 0x1993a800 },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x05938000 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x2d904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x4b900420 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4d900000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43900000 },
	{ _MMIO(0x9888), 0x45901084 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900001 },
};

static int
get_tdl_1_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_1;
	lens[n] = ARRAY_SIZE(mux_config_tdl_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
};

static const struct i915_oa_reg flex_eu_config_tdl_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_2[] = {
	{ _MMIO(0x9888), 0x141a026b },
	{ _MMIO(0x9888), 0x143a0173 },
	{ _MMIO(0x9888), 0x145a026b },
	{ _MMIO(0x9888), 0x002d4000 },
	{ _MMIO(0x9888), 0x022d5000 },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x0c2e5000 },
	{ _MMIO(0x9888), 0x0e2e0069 },
	{ _MMIO(0x9888), 0x044c8000 },
	{ _MMIO(0x9888), 0x064cc000 },
	{ _MMIO(0x9888), 0x0a4c4000 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x024ea000 },
	{ _MMIO(0x9888), 0x064e2000 },
	{ _MMIO(0x9888), 0x180f6000 },
	{ _MMIO(0x9888), 0x1a0f030a },
	{ _MMIO(0x9888), 0x1a2c03c0 },
	{ _MMIO(0x9888), 0x041a37e7 },
	{ _MMIO(0x9888), 0x021a0000 },
	{ _MMIO(0x9888), 0x0414a000 },
	{ _MMIO(0x9888), 0x1c150050 },
	{ _MMIO(0x9888), 0x08168000 },
	{ _MMIO(0x9888), 0x0a168000 },
	{ _MMIO(0x9888), 0x003a3380 },
	{ _MMIO(0x9888), 0x063a006f },
	{ _MMIO(0x9888), 0x023a0000 },
	{ _MMIO(0x9888), 0x00348000 },
	{ _MMIO(0x9888), 0x06342000 },
	{ _MMIO(0x9888), 0x1a352000 },
	{ _MMIO(0x9888), 0x1c350100 },
	{ _MMIO(0x9888), 0x02368000 },
	{ _MMIO(0x9888), 0x0c368000 },
	{ _MMIO(0x9888), 0x025a37e7 },
	{ _MMIO(0x9888), 0x0254a000 },
	{ _MMIO(0x9888), 0x1c550005 },
	{ _MMIO(0x9888), 0x04568000 },
	{ _MMIO(0x9888), 0x06568000 },
	{ _MMIO(0x9888), 0x03938000 },
	{ _MMIO(0x9888), 0x05938000 },
	{ _MMIO(0x9888), 0x07938000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17904000 },
	{ _MMIO(0x9888), 0x19904000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x43900020 },
	{ _MMIO(0x9888), 0x45901080 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900001 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_tdl_2_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_2;
	lens[n] = ARRAY_SIZE(mux_config_tdl_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_extra[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
};

static const struct i915_oa_reg flex_eu_config_compute_extra[] = {
	{ _MMIO(0xe458), 0x00001000 },
	{ _MMIO(0xe558), 0x00003002 },
	{ _MMIO(0xe658), 0x00005004 },
	{ _MMIO(0xe758), 0x00011010 },
	{ _MMIO(0xe45c), 0x00050012 },
	{ _MMIO(0xe55c), 0x00052051 },
	{ _MMIO(0xe65c), 0x00000008 },
};

static const struct i915_oa_reg mux_config_compute_extra[] = {
	{ _MMIO(0x9888), 0x141a001f },
	{ _MMIO(0x9888), 0x143a001f },
	{ _MMIO(0x9888), 0x145a001f },
	{ _MMIO(0x9888), 0x042d5000 },
	{ _MMIO(0x9888), 0x062d1000 },
	{ _MMIO(0x9888), 0x0e2e0094 },
	{ _MMIO(0x9888), 0x084cc000 },
	{ _MMIO(0x9888), 0x044ea000 },
	{ _MMIO(0x9888), 0x1a0f00e0 },
	{ _MMIO(0x9888), 0x1a2c0c00 },
	{ _MMIO(0x9888), 0x061a0063 },
	{ _MMIO(0x9888), 0x021a0000 },
	{ _MMIO(0x9888), 0x06142000 },
	{ _MMIO(0x9888), 0x1c150100 },
	{ _MMIO(0x9888), 0x0c168000 },
	{ _MMIO(0x9888), 0x043a3180 },
	{ _MMIO(0x9888), 0x023a0000 },
	{ _MMIO(0x9888), 0x04348000 },
	{ _MMIO(0x9888), 0x1c350040 },
	{ _MMIO(0x9888), 0x0a368000 },
	{ _MMIO(0x9888), 0x045a0063 },
	{ _MMIO(0x9888), 0x025a0000 },
	{ _MMIO(0x9888), 0x04542000 },
	{ _MMIO(0x9888), 0x1c550010 },
	{ _MMIO(0x9888), 0x08568000 },
	{ _MMIO(0x9888), 0x09938000 },
	{ _MMIO(0x9888), 0x0b938000 },
	{ _MMIO(0x9888), 0x0d938000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1d904000 },
	{ _MMIO(0x9888), 0x1f904000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x45900400 },
	{ _MMIO(0x9888), 0x47900004 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_compute_extra_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_extra;
	lens[n] = ARRAY_SIZE(mux_config_compute_extra);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_test_oa[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2770), 0x00000004 },
	{ _MMIO(0x2774), 0x00000000 },
	{ _MMIO(0x2778), 0x00000003 },
	{ _MMIO(0x277c), 0x00000000 },
	{ _MMIO(0x2780), 0x00000007 },
	{ _MMIO(0x2784), 0x00000000 },
	{ _MMIO(0x2788), 0x00100002 },
	{ _MMIO(0x278c), 0x0000fff7 },
	{ _MMIO(0x2790), 0x00100002 },
	{ _MMIO(0x2794), 0x0000ffcf },
	{ _MMIO(0x2798), 0x00100082 },
	{ _MMIO(0x279c), 0x0000ffef },
	{ _MMIO(0x27a0), 0x001000c2 },
	{ _MMIO(0x27a4), 0x0000ffe7 },
	{ _MMIO(0x27a8), 0x00100001 },
	{ _MMIO(0x27ac), 0x0000ffe7 },
};

static const struct i915_oa_reg flex_eu_config_test_oa[] = {
};

static const struct i915_oa_reg mux_config_test_oa[] = {
	{ _MMIO(0x9888), 0x19800000 },
	{ _MMIO(0x9888), 0x07800063 },
	{ _MMIO(0x9888), 0x11800000 },
	{ _MMIO(0x9888), 0x23810008 },
	{ _MMIO(0x9888), 0x1d950400 },
	{ _MMIO(0x9888), 0x0f922000 },
	{ _MMIO(0x9888), 0x1f908000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x47900000 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_test_oa_mux_config(struct drm_i915_private *dev_priv,
		       const struct i915_oa_reg **regs,
		       int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_test_oa;
	lens[n] = ARRAY_SIZE(mux_config_test_oa);
	n++;

	return n;
}

int i915_oa_select_metric_set_bxt(struct drm_i915_private *dev_priv)
{
	dev_priv->perf.oa.n_mux_configs = 0;
	dev_priv->perf.oa.b_counter_regs = NULL;
	dev_priv->perf.oa.b_counter_regs_len = 0;
	dev_priv->perf.oa.flex_regs = NULL;
	dev_priv->perf.oa.flex_regs_len = 0;

	switch (dev_priv->perf.oa.metrics_set) {
	case METRIC_SET_ID_RENDER_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_render_basic_mux_config(dev_priv,
						    dev_priv->perf.oa.mux_regs,
						    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_basic);

		return 0;
	case METRIC_SET_ID_COMPUTE_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_basic_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_basic);

		return 0;
	case METRIC_SET_ID_RENDER_PIPE_PROFILE:
		dev_priv->perf.oa.n_mux_configs =
			get_render_pipe_profile_mux_config(dev_priv,
							   dev_priv->perf.oa.mux_regs,
							   dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_PIPE_PROFILE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_pipe_profile;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_pipe_profile);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_pipe_profile;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_pipe_profile);

		return 0;
	case METRIC_SET_ID_MEMORY_READS:
		dev_priv->perf.oa.n_mux_configs =
			get_memory_reads_mux_config(dev_priv,
						    dev_priv->perf.oa.mux_regs,
						    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"MEMORY_READS\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_memory_reads;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_memory_reads);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_memory_reads;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_memory_reads);

		return 0;
	case METRIC_SET_ID_MEMORY_WRITES:
		dev_priv->perf.oa.n_mux_configs =
			get_memory_writes_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"MEMORY_WRITES\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_memory_writes;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_memory_writes);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_memory_writes;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_memory_writes);

		return 0;
	case METRIC_SET_ID_COMPUTE_EXTENDED:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_extended_mux_config(dev_priv,
							dev_priv->perf.oa.mux_regs,
							dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_EXTENDED\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_extended;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_extended);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_extended;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_extended);

		return 0;
	case METRIC_SET_ID_COMPUTE_L3_CACHE:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_l3_cache_mux_config(dev_priv,
							dev_priv->perf.oa.mux_regs,
							dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_L3_CACHE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_l3_cache;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_l3_cache);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_l3_cache;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_l3_cache);

		return 0;
	case METRIC_SET_ID_HDC_AND_SF:
		dev_priv->perf.oa.n_mux_configs =
			get_hdc_and_sf_mux_config(dev_priv,
						  dev_priv->perf.oa.mux_regs,
						  dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"HDC_AND_SF\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_hdc_and_sf;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_hdc_and_sf);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_hdc_and_sf;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_hdc_and_sf);

		return 0;
	case METRIC_SET_ID_L3_1:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_1_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_1);

		return 0;
	case METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND:
		dev_priv->perf.oa.n_mux_configs =
			get_rasterizer_and_pixel_backend_mux_config(dev_priv,
								    dev_priv->perf.oa.mux_regs,
								    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RASTERIZER_AND_PIXEL_BACKEND\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_rasterizer_and_pixel_backend);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_rasterizer_and_pixel_backend);

		return 0;
	case METRIC_SET_ID_SAMPLER:
		dev_priv->perf.oa.n_mux_configs =
			get_sampler_mux_config(dev_priv,
					       dev_priv->perf.oa.mux_regs,
					       dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"SAMPLER\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_sampler;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_sampler);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_sampler;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_sampler);

		return 0;
	case METRIC_SET_ID_TDL_1:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_1_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_1);

		return 0;
	case METRIC_SET_ID_TDL_2:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_2_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_2);

		return 0;
	case METRIC_SET_ID_COMPUTE_EXTRA:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_extra_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_EXTRA\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_extra;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_extra);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_extra;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_extra);

		return 0;
	case METRIC_SET_ID_TEST_OA:
		dev_priv->perf.oa.n_mux_configs =
			get_test_oa_mux_config(dev_priv,
					       dev_priv->perf.oa.mux_regs,
					       dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TEST_OA\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_test_oa;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_test_oa);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_test_oa;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_test_oa);

		return 0;
	default:
		return -ENODEV;
	}
}

static ssize_t
show_render_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_BASIC);
}

static struct device_attribute dev_attr_render_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_basic_id,
	.store = NULL,
};

static struct attribute *attrs_render_basic[] = {
	&dev_attr_render_basic_id.attr,
	NULL,
};

static struct attribute_group group_render_basic = {
	.name = "22b9519a-e9ba-4c41-8b54-f4f8ca14fa0a",
	.attrs =  attrs_render_basic,
};

static ssize_t
show_compute_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_BASIC);
}

static struct device_attribute dev_attr_compute_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_basic_id,
	.store = NULL,
};

static struct attribute *attrs_compute_basic[] = {
	&dev_attr_compute_basic_id.attr,
	NULL,
};

static struct attribute_group group_compute_basic = {
	.name = "012d72cf-82a9-4d25-8ddf-74076fd30797",
	.attrs =  attrs_compute_basic,
};

static ssize_t
show_render_pipe_profile_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_PIPE_PROFILE);
}

static struct device_attribute dev_attr_render_pipe_profile_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_pipe_profile_id,
	.store = NULL,
};

static struct attribute *attrs_render_pipe_profile[] = {
	&dev_attr_render_pipe_profile_id.attr,
	NULL,
};

static struct attribute_group group_render_pipe_profile = {
	.name = "ce416533-e49e-4211-80af-ec513590a914",
	.attrs =  attrs_render_pipe_profile,
};

static ssize_t
show_memory_reads_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_MEMORY_READS);
}

static struct device_attribute dev_attr_memory_reads_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_memory_reads_id,
	.store = NULL,
};

static struct attribute *attrs_memory_reads[] = {
	&dev_attr_memory_reads_id.attr,
	NULL,
};

static struct attribute_group group_memory_reads = {
	.name = "398e2452-18d7-42d0-b241-e4d0a9148ada",
	.attrs =  attrs_memory_reads,
};

static ssize_t
show_memory_writes_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_MEMORY_WRITES);
}

static struct device_attribute dev_attr_memory_writes_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_memory_writes_id,
	.store = NULL,
};

static struct attribute *attrs_memory_writes[] = {
	&dev_attr_memory_writes_id.attr,
	NULL,
};

static struct attribute_group group_memory_writes = {
	.name = "d324a0d6-7269-4847-a5c2-6f71ddc7fed5",
	.attrs =  attrs_memory_writes,
};

static ssize_t
show_compute_extended_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_EXTENDED);
}

static struct device_attribute dev_attr_compute_extended_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_extended_id,
	.store = NULL,
};

static struct attribute *attrs_compute_extended[] = {
	&dev_attr_compute_extended_id.attr,
	NULL,
};

static struct attribute_group group_compute_extended = {
	.name = "caf3596a-7bb1-4dec-b3b3-2a080d283b49",
	.attrs =  attrs_compute_extended,
};

static ssize_t
show_compute_l3_cache_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_L3_CACHE);
}

static struct device_attribute dev_attr_compute_l3_cache_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_l3_cache_id,
	.store = NULL,
};

static struct attribute *attrs_compute_l3_cache[] = {
	&dev_attr_compute_l3_cache_id.attr,
	NULL,
};

static struct attribute_group group_compute_l3_cache = {
	.name = "49b956e2-d5b9-47e0-9d8a-cee5e8cec527",
	.attrs =  attrs_compute_l3_cache,
};

static ssize_t
show_hdc_and_sf_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_HDC_AND_SF);
}

static struct device_attribute dev_attr_hdc_and_sf_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_hdc_and_sf_id,
	.store = NULL,
};

static struct attribute *attrs_hdc_and_sf[] = {
	&dev_attr_hdc_and_sf_id.attr,
	NULL,
};

static struct attribute_group group_hdc_and_sf = {
	.name = "f64ef50a-bdba-4b35-8f09-203c13d8ee5a",
	.attrs =  attrs_hdc_and_sf,
};

static ssize_t
show_l3_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_1);
}

static struct device_attribute dev_attr_l3_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_1_id,
	.store = NULL,
};

static struct attribute *attrs_l3_1[] = {
	&dev_attr_l3_1_id.attr,
	NULL,
};

static struct attribute_group group_l3_1 = {
	.name = "00ad5a41-7eab-4f7a-9103-49d411c67219",
	.attrs =  attrs_l3_1,
};

static ssize_t
show_rasterizer_and_pixel_backend_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND);
}

static struct device_attribute dev_attr_rasterizer_and_pixel_backend_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_rasterizer_and_pixel_backend_id,
	.store = NULL,
};

static struct attribute *attrs_rasterizer_and_pixel_backend[] = {
	&dev_attr_rasterizer_and_pixel_backend_id.attr,
	NULL,
};

static struct attribute_group group_rasterizer_and_pixel_backend = {
	.name = "46dc44ca-491c-4cc1-a951-e7b3e62bf02b",
	.attrs =  attrs_rasterizer_and_pixel_backend,
};

static ssize_t
show_sampler_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_SAMPLER);
}

static struct device_attribute dev_attr_sampler_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_sampler_id,
	.store = NULL,
};

static struct attribute *attrs_sampler[] = {
	&dev_attr_sampler_id.attr,
	NULL,
};

static struct attribute_group group_sampler = {
	.name = "8364e2a8-af63-40af-b0d5-42969a255654",
	.attrs =  attrs_sampler,
};

static ssize_t
show_tdl_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_1);
}

static struct device_attribute dev_attr_tdl_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_1_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_1[] = {
	&dev_attr_tdl_1_id.attr,
	NULL,
};

static struct attribute_group group_tdl_1 = {
	.name = "175c8092-cb25-4d1e-8dc7-b4fdd39e2d92",
	.attrs =  attrs_tdl_1,
};

static ssize_t
show_tdl_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_2);
}

static struct device_attribute dev_attr_tdl_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_2_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_2[] = {
	&dev_attr_tdl_2_id.attr,
	NULL,
};

static struct attribute_group group_tdl_2 = {
	.name = "d260f03f-b34d-4b49-a44e-436819117332",
	.attrs =  attrs_tdl_2,
};

static ssize_t
show_compute_extra_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_EXTRA);
}

static struct device_attribute dev_attr_compute_extra_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_extra_id,
	.store = NULL,
};

static struct attribute *attrs_compute_extra[] = {
	&dev_attr_compute_extra_id.attr,
	NULL,
};

static struct attribute_group group_compute_extra = {
	.name = "fa6ecf21-2cb8-4d0b-9308-6e4a7b4ca87a",
	.attrs =  attrs_compute_extra,
};

static ssize_t
show_test_oa_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TEST_OA);
}

static struct device_attribute dev_attr_test_oa_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_test_oa_id,
	.store = NULL,
};

static struct attribute *attrs_test_oa[] = {
	&dev_attr_test_oa_id.attr,
	NULL,
};

static struct attribute_group group_test_oa = {
	.name = "5ee72f5c-092f-421e-8b70-225f7c3e9612",
	.attrs =  attrs_test_oa,
};

int
i915_perf_register_sysfs_bxt(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];
	int ret = 0;

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_basic);
		if (ret)
			goto error_render_basic;
	}
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
		if (ret)
			goto error_compute_basic;
	}
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
		if (ret)
			goto error_render_pipe_profile;
	}
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
		if (ret)
			goto error_memory_reads;
	}
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
		if (ret)
			goto error_memory_writes;
	}
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
		if (ret)
			goto error_compute_extended;
	}
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
		if (ret)
			goto error_compute_l3_cache;
	}
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
		if (ret)
			goto error_hdc_and_sf;
	}
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_1);
		if (ret)
			goto error_l3_1;
	}
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
		if (ret)
			goto error_rasterizer_and_pixel_backend;
	}
	if (get_sampler_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_sampler);
		if (ret)
			goto error_sampler;
	}
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
		if (ret)
			goto error_tdl_1;
	}
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
		if (ret)
			goto error_tdl_2;
	}
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
		if (ret)
			goto error_compute_extra;
	}
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_test_oa);
		if (ret)
			goto error_test_oa;
	}

	return 0;

error_test_oa:
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
error_compute_extra:
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
error_tdl_2:
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
error_tdl_1:
	if (get_sampler_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler);
error_sampler:
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
error_rasterizer_and_pixel_backend:
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
error_l3_1:
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
error_hdc_and_sf:
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
error_compute_l3_cache:
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
error_compute_extended:
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
error_memory_writes:
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
error_memory_reads:
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
error_render_pipe_profile:
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
error_compute_basic:
	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
error_render_basic:
	return ret;
}

void
i915_perf_unregister_sysfs_bxt(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
	if (get_sampler_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler);
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_test_oa);
}
