/*
 * Copyright (C) Fuzhou Rockchip Electronics Co.Ltd
 * Author:Mark Yao <mark.yao@rock-chips.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _ROCKCHIP_VOP_REG_H
#define _ROCKCHIP_VOP_REG_H

/* rk3288 register definition */
#define RK3288_REG_CFG_DONE			0x0000
#define RK3288_VERSION_INFO			0x0004
#define RK3288_SYS_CTRL				0x0008
#define RK3288_SYS_CTRL1			0x000c
#define RK3288_DSP_CTRL0			0x0010
#define RK3288_DSP_CTRL1			0x0014
#define RK3288_DSP_BG				0x0018
#define RK3288_MCU_CTRL				0x001c
#define RK3288_INTR_CTRL0			0x0020
#define RK3288_INTR_CTRL1			0x0024
#define RK3288_WIN0_CTRL0			0x0030
#define RK3288_WIN0_CTRL1			0x0034
#define RK3288_WIN0_COLOR_KEY			0x0038
#define RK3288_WIN0_VIR				0x003c
#define RK3288_WIN0_YRGB_MST			0x0040
#define RK3288_WIN0_CBR_MST			0x0044
#define RK3288_WIN0_ACT_INFO			0x0048
#define RK3288_WIN0_DSP_INFO			0x004c
#define RK3288_WIN0_DSP_ST			0x0050
#define RK3288_WIN0_SCL_FACTOR_YRGB		0x0054
#define RK3288_WIN0_SCL_FACTOR_CBR		0x0058
#define RK3288_WIN0_SCL_OFFSET			0x005c
#define RK3288_WIN0_SRC_ALPHA_CTRL		0x0060
#define RK3288_WIN0_DST_ALPHA_CTRL		0x0064
#define RK3288_WIN0_FADING_CTRL			0x0068

/* win1 register */
#define RK3288_WIN1_CTRL0			0x0070
#define RK3288_WIN1_CTRL1			0x0074
#define RK3288_WIN1_COLOR_KEY			0x0078
#define RK3288_WIN1_VIR				0x007c
#define RK3288_WIN1_YRGB_MST			0x0080
#define RK3288_WIN1_CBR_MST			0x0084
#define RK3288_WIN1_ACT_INFO			0x0088
#define RK3288_WIN1_DSP_INFO			0x008c
#define RK3288_WIN1_DSP_ST			0x0090
#define RK3288_WIN1_SCL_FACTOR_YRGB		0x0094
#define RK3288_WIN1_SCL_FACTOR_CBR		0x0098
#define RK3288_WIN1_SCL_OFFSET			0x009c
#define RK3288_WIN1_SRC_ALPHA_CTRL		0x00a0
#define RK3288_WIN1_DST_ALPHA_CTRL		0x00a4
#define RK3288_WIN1_FADING_CTRL			0x00a8
/* win2 register */
#define RK3288_WIN2_CTRL0			0x00b0
#define RK3288_WIN2_CTRL1			0x00b4
#define RK3288_WIN2_VIR0_1			0x00b8
#define RK3288_WIN2_VIR2_3			0x00bc
#define RK3288_WIN2_MST0			0x00c0
#define RK3288_WIN2_DSP_INFO0			0x00c4
#define RK3288_WIN2_DSP_ST0			0x00c8
#define RK3288_WIN2_COLOR_KEY			0x00cc
#define RK3288_WIN2_MST1			0x00d0
#define RK3288_WIN2_DSP_INFO1			0x00d4
#define RK3288_WIN2_DSP_ST1			0x00d8
#define RK3288_WIN2_SRC_ALPHA_CTRL		0x00dc
#define RK3288_WIN2_MST2			0x00e0
#define RK3288_WIN2_DSP_INFO2			0x00e4
#define RK3288_WIN2_DSP_ST2			0x00e8
#define RK3288_WIN2_DST_ALPHA_CTRL		0x00ec
#define RK3288_WIN2_MST3			0x00f0
#define RK3288_WIN2_DSP_INFO3			0x00f4
#define RK3288_WIN2_DSP_ST3			0x00f8
#define RK3288_WIN2_FADING_CTRL			0x00fc
/* win3 register */
#define RK3288_WIN3_CTRL0			0x0100
#define RK3288_WIN3_CTRL1			0x0104
#define RK3288_WIN3_VIR0_1			0x0108
#define RK3288_WIN3_VIR2_3			0x010c
#define RK3288_WIN3_MST0			0x0110
#define RK3288_WIN3_DSP_INFO0			0x0114
#define RK3288_WIN3_DSP_ST0			0x0118
#define RK3288_WIN3_COLOR_KEY			0x011c
#define RK3288_WIN3_MST1			0x0120
#define RK3288_WIN3_DSP_INFO1			0x0124
#define RK3288_WIN3_DSP_ST1			0x0128
#define RK3288_WIN3_SRC_ALPHA_CTRL		0x012c
#define RK3288_WIN3_MST2			0x0130
#define RK3288_WIN3_DSP_INFO2			0x0134
#define RK3288_WIN3_DSP_ST2			0x0138
#define RK3288_WIN3_DST_ALPHA_CTRL		0x013c
#define RK3288_WIN3_MST3			0x0140
#define RK3288_WIN3_DSP_INFO3			0x0144
#define RK3288_WIN3_DSP_ST3			0x0148
#define RK3288_WIN3_FADING_CTRL			0x014c
/* hwc register */
#define RK3288_HWC_CTRL0			0x0150
#define RK3288_HWC_CTRL1			0x0154
#define RK3288_HWC_MST				0x0158
#define RK3288_HWC_DSP_ST			0x015c
#define RK3288_HWC_SRC_ALPHA_CTRL		0x0160
#define RK3288_HWC_DST_ALPHA_CTRL		0x0164
#define RK3288_HWC_FADING_CTRL			0x0168
/* post process register */
#define RK3288_POST_DSP_HACT_INFO		0x0170
#define RK3288_POST_DSP_VACT_INFO		0x0174
#define RK3288_POST_SCL_FACTOR_YRGB		0x0178
#define RK3288_POST_SCL_CTRL			0x0180
#define RK3288_POST_DSP_VACT_INFO_F1		0x0184
#define RK3288_DSP_HTOTAL_HS_END		0x0188
#define RK3288_DSP_HACT_ST_END			0x018c
#define RK3288_DSP_VTOTAL_VS_END		0x0190
#define RK3288_DSP_VACT_ST_END			0x0194
#define RK3288_DSP_VS_ST_END_F1			0x0198
#define RK3288_DSP_VACT_ST_END_F1		0x019c
/* register definition end */

/* rk3036 register definition */
#define RK3036_SYS_CTRL			0x00
#define RK3036_DSP_CTRL0		0x04
#define RK3036_DSP_CTRL1		0x08
#define RK3036_INT_STATUS		0x10
#define RK3036_ALPHA_CTRL		0x14
#define RK3036_WIN0_COLOR_KEY		0x18
#define RK3036_WIN1_COLOR_KEY		0x1c
#define RK3036_WIN0_YRGB_MST		0x20
#define RK3036_WIN0_CBR_MST		0x24
#define RK3036_WIN1_VIR			0x28
#define RK3036_AXI_BUS_CTRL		0x2c
#define RK3036_WIN0_VIR			0x30
#define RK3036_WIN0_ACT_INFO		0x34
#define RK3036_WIN0_DSP_INFO		0x38
#define RK3036_WIN0_DSP_ST		0x3c
#define RK3036_WIN0_SCL_FACTOR_YRGB	0x40
#define RK3036_WIN0_SCL_FACTOR_CBR	0x44
#define RK3036_WIN0_SCL_OFFSET		0x48
#define RK3036_HWC_MST			0x58
#define RK3036_HWC_DSP_ST		0x5c
#define RK3036_DSP_HTOTAL_HS_END	0x6c
#define RK3036_DSP_HACT_ST_END		0x70
#define RK3036_DSP_VTOTAL_VS_END	0x74
#define RK3036_DSP_VACT_ST_END		0x78
#define RK3036_DSP_VS_ST_END_F1		0x7c
#define RK3036_DSP_VACT_ST_END_F1	0x80
#define RK3036_GATHER_TRANSFER		0x84
#define RK3036_VERSION_INFO		0x94
#define RK3036_REG_CFG_DONE		0x90
#define RK3036_WIN1_MST			0xa0
#define RK3036_WIN1_ACT_INFO		0xb4
#define RK3036_WIN1_DSP_INFO		0xb8
#define RK3036_WIN1_DSP_ST		0xbc
#define RK3036_WIN1_SCL_FACTOR_YRGB	0xc0
#define RK3036_WIN1_SCL_OFFSET		0xc8
#define RK3036_BCSH_CTRL		0xd0
#define RK3036_BCSH_COLOR_BAR		0xd4
#define RK3036_BCSH_BCS			0xd8
#define RK3036_BCSH_H			0xdc
#define RK3036_WIN1_LUT_ADDR		0x400
#define RK3036_HWC_LUT_ADDR		0x800
/* rk3036 register definition end */

/* rk3399 register definition */
#define RK3399_REG_CFG_DONE		0x00000
#define RK3399_VERSION_INFO		0x00004
#define RK3399_SYS_CTRL			0x00008
#define RK3399_SYS_CTRL1		0x0000c
#define RK3399_DSP_CTRL0		0x00010
#define RK3399_DSP_CTRL1		0x00014
#define RK3399_DSP_BG			0x00018
#define RK3399_MCU_CTRL			0x0001c
#define RK3399_WB_CTRL0			0x00020
#define RK3399_WB_CTRL1			0x00024
#define RK3399_WB_YRGB_MST		0x00028
#define RK3399_WB_CBR_MST		0x0002c
#define RK3399_WIN0_CTRL0		0x00030
#define RK3399_WIN0_CTRL1		0x00034
#define RK3399_WIN0_COLOR_KEY		0x00038
#define RK3399_WIN0_VIR			0x0003c
#define RK3399_WIN0_YRGB_MST		0x00040
#define RK3399_WIN0_CBR_MST		0x00044
#define RK3399_WIN0_ACT_INFO		0x00048
#define RK3399_WIN0_DSP_INFO		0x0004c
#define RK3399_WIN0_DSP_ST		0x00050
#define RK3399_WIN0_SCL_FACTOR_YRGB	0x00054
#define RK3399_WIN0_SCL_FACTOR_CBR	0x00058
#define RK3399_WIN0_SCL_OFFSET		0x0005c
#define RK3399_WIN0_SRC_ALPHA_CTRL	0x00060
#define RK3399_WIN0_DST_ALPHA_CTRL	0x00064
#define RK3399_WIN0_FADING_CTRL		0x00068
#define RK3399_WIN0_CTRL2		0x0006c
#define RK3399_WIN1_CTRL0		0x00070
#define RK3399_WIN1_CTRL1		0x00074
#define RK3399_WIN1_COLOR_KEY		0x00078
#define RK3399_WIN1_VIR			0x0007c
#define RK3399_WIN1_YRGB_MST		0x00080
#define RK3399_WIN1_CBR_MST		0x00084
#define RK3399_WIN1_ACT_INFO		0x00088
#define RK3399_WIN1_DSP_INFO		0x0008c
#define RK3399_WIN1_DSP_ST		0x00090
#define RK3399_WIN1_SCL_FACTOR_YRGB	0x00094
#define RK3399_WIN1_SCL_FACTOR_CBR	0x00098
#define RK3399_WIN1_SCL_OFFSET		0x0009c
#define RK3399_WIN1_SRC_ALPHA_CTRL	0x000a0
#define RK3399_WIN1_DST_ALPHA_CTRL	0x000a4
#define RK3399_WIN1_FADING_CTRL		0x000a8
#define RK3399_WIN1_CTRL2		0x000ac
#define RK3399_WIN2_CTRL0		0x000b0
#define RK3399_WIN2_CTRL1		0x000b4
#define RK3399_WIN2_VIR0_1		0x000b8
#define RK3399_WIN2_VIR2_3		0x000bc
#define RK3399_WIN2_MST0		0x000c0
#define RK3399_WIN2_DSP_INFO0		0x000c4
#define RK3399_WIN2_DSP_ST0		0x000c8
#define RK3399_WIN2_COLOR_KEY		0x000cc
#define RK3399_WIN2_MST1		0x000d0
#define RK3399_WIN2_DSP_INFO1		0x000d4
#define RK3399_WIN2_DSP_ST1		0x000d8
#define RK3399_WIN2_SRC_ALPHA_CTRL	0x000dc
#define RK3399_WIN2_MST2		0x000e0
#define RK3399_WIN2_DSP_INFO2		0x000e4
#define RK3399_WIN2_DSP_ST2		0x000e8
#define RK3399_WIN2_DST_ALPHA_CTRL	0x000ec
#define RK3399_WIN2_MST3		0x000f0
#define RK3399_WIN2_DSP_INFO3		0x000f4
#define RK3399_WIN2_DSP_ST3		0x000f8
#define RK3399_WIN2_FADING_CTRL		0x000fc
#define RK3399_WIN3_CTRL0		0x00100
#define RK3399_WIN3_CTRL1		0x00104
#define RK3399_WIN3_VIR0_1		0x00108
#define RK3399_WIN3_VIR2_3		0x0010c
#define RK3399_WIN3_MST0		0x00110
#define RK3399_WIN3_DSP_INFO0		0x00114
#define RK3399_WIN3_DSP_ST0		0x00118
#define RK3399_WIN3_COLOR_KEY		0x0011c
#define RK3399_WIN3_MST1		0x00120
#define RK3399_WIN3_DSP_INFO1		0x00124
#define RK3399_WIN3_DSP_ST1		0x00128
#define RK3399_WIN3_SRC_ALPHA_CTRL	0x0012c
#define RK3399_WIN3_MST2		0x00130
#define RK3399_WIN3_DSP_INFO2		0x00134
#define RK3399_WIN3_DSP_ST2		0x00138
#define RK3399_WIN3_DST_ALPHA_CTRL	0x0013c
#define RK3399_WIN3_MST3		0x00140
#define RK3399_WIN3_DSP_INFO3		0x00144
#define RK3399_WIN3_DSP_ST3		0x00148
#define RK3399_WIN3_FADING_CTRL		0x0014c
#define RK3399_HWC_CTRL0		0x00150
#define RK3399_HWC_CTRL1		0x00154
#define RK3399_HWC_MST			0x00158
#define RK3399_HWC_DSP_ST		0x0015c
#define RK3399_HWC_SRC_ALPHA_CTRL	0x00160
#define RK3399_HWC_DST_ALPHA_CTRL	0x00164
#define RK3399_HWC_FADING_CTRL		0x00168
#define RK3399_HWC_RESERVED1		0x0016c
#define RK3399_POST_DSP_HACT_INFO	0x00170
#define RK3399_POST_DSP_VACT_INFO	0x00174
#define RK3399_POST_SCL_FACTOR_YRGB	0x00178
#define RK3399_POST_RESERVED		0x0017c
#define RK3399_POST_SCL_CTRL		0x00180
#define RK3399_POST_DSP_VACT_INFO_F1	0x00184
#define RK3399_DSP_HTOTAL_HS_END	0x00188
#define RK3399_DSP_HACT_ST_END		0x0018c
#define RK3399_DSP_VTOTAL_VS_END	0x00190
#define RK3399_DSP_VACT_ST_END		0x00194
#define RK3399_DSP_VS_ST_END_F1		0x00198
#define RK3399_DSP_VACT_ST_END_F1	0x0019c
#define RK3399_PWM_CTRL			0x001a0
#define RK3399_PWM_PERIOD_HPR		0x001a4
#define RK3399_PWM_DUTY_LPR		0x001a8
#define RK3399_PWM_CNT			0x001ac
#define RK3399_BCSH_COLOR_BAR		0x001b0
#define RK3399_BCSH_BCS			0x001b4
#define RK3399_BCSH_H			0x001b8
#define RK3399_BCSH_CTRL		0x001bc
#define RK3399_CABC_CTRL0		0x001c0
#define RK3399_CABC_CTRL1		0x001c4
#define RK3399_CABC_CTRL2		0x001c8
#define RK3399_CABC_CTRL3		0x001cc
#define RK3399_CABC_GAUSS_LINE0_0	0x001d0
#define RK3399_CABC_GAUSS_LINE0_1	0x001d4
#define RK3399_CABC_GAUSS_LINE1_0	0x001d8
#define RK3399_CABC_GAUSS_LINE1_1	0x001dc
#define RK3399_CABC_GAUSS_LINE2_0	0x001e0
#define RK3399_CABC_GAUSS_LINE2_1	0x001e4
#define RK3399_FRC_LOWER01_0		0x001e8
#define RK3399_FRC_LOWER01_1		0x001ec
#define RK3399_FRC_LOWER10_0		0x001f0
#define RK3399_FRC_LOWER10_1		0x001f4
#define RK3399_FRC_LOWER11_0		0x001f8
#define RK3399_FRC_LOWER11_1		0x001fc
#define RK3399_AFBCD0_CTRL		0x00200
#define RK3399_AFBCD0_HDR_PTR		0x00204
#define RK3399_AFBCD0_PIC_SIZE		0x00208
#define RK3399_AFBCD0_STATUS		0x0020c
#define RK3399_AFBCD1_CTRL		0x00220
#define RK3399_AFBCD1_HDR_PTR		0x00224
#define RK3399_AFBCD1_PIC_SIZE		0x00228
#define RK3399_AFBCD1_STATUS		0x0022c
#define RK3399_AFBCD2_CTRL		0x00240
#define RK3399_AFBCD2_HDR_PTR		0x00244
#define RK3399_AFBCD2_PIC_SIZE		0x00248
#define RK3399_AFBCD2_STATUS		0x0024c
#define RK3399_AFBCD3_CTRL		0x00260
#define RK3399_AFBCD3_HDR_PTR		0x00264
#define RK3399_AFBCD3_PIC_SIZE		0x00268
#define RK3399_AFBCD3_STATUS		0x0026c
#define RK3399_INTR_EN0			0x00280
#define RK3399_INTR_CLEAR0		0x00284
#define RK3399_INTR_STATUS0		0x00288
#define RK3399_INTR_RAW_STATUS0		0x0028c
#define RK3399_INTR_EN1			0x00290
#define RK3399_INTR_CLEAR1		0x00294
#define RK3399_INTR_STATUS1		0x00298
#define RK3399_INTR_RAW_STATUS1		0x0029c
#define RK3399_LINE_FLAG		0x002a0
#define RK3399_VOP_STATUS		0x002a4
#define RK3399_BLANKING_VALUE		0x002a8
#define RK3399_MCU_BYPASS_PORT		0x002ac
#define RK3399_WIN0_DSP_BG		0x002b0
#define RK3399_WIN1_DSP_BG		0x002b4
#define RK3399_WIN2_DSP_BG		0x002b8
#define RK3399_WIN3_DSP_BG		0x002bc
#define RK3399_YUV2YUV_WIN		0x002c0
#define RK3399_YUV2YUV_POST		0x002c4
#define RK3399_AUTO_GATING_EN		0x002cc
#define RK3399_WIN0_CSC_COE		0x003a0
#define RK3399_WIN1_CSC_COE		0x003c0
#define RK3399_WIN2_CSC_COE		0x003e0
#define RK3399_WIN3_CSC_COE		0x00400
#define RK3399_HWC_CSC_COE		0x00420
#define RK3399_BCSH_R2Y_CSC_COE		0x00440
#define RK3399_BCSH_Y2R_CSC_COE		0x00460
#define RK3399_POST_YUV2YUV_Y2R_COE	0x00480
#define RK3399_POST_YUV2YUV_3X3_COE	0x004a0
#define RK3399_POST_YUV2YUV_R2Y_COE	0x004c0
#define RK3399_WIN0_YUV2YUV_Y2R		0x004e0
#define RK3399_WIN0_YUV2YUV_3X3		0x00500
#define RK3399_WIN0_YUV2YUV_R2Y		0x00520
#define RK3399_WIN1_YUV2YUV_Y2R		0x00540
#define RK3399_WIN1_YUV2YUV_3X3		0x00560
#define RK3399_WIN1_YUV2YUV_R2Y		0x00580
#define RK3399_WIN2_YUV2YUV_Y2R		0x005a0
#define RK3399_WIN2_YUV2YUV_3X3		0x005c0
#define RK3399_WIN2_YUV2YUV_R2Y		0x005e0
#define RK3399_WIN3_YUV2YUV_Y2R		0x00600
#define RK3399_WIN3_YUV2YUV_3X3		0x00620
#define RK3399_WIN3_YUV2YUV_R2Y		0x00640
#define RK3399_WIN2_LUT_ADDR		0x01000
#define RK3399_WIN3_LUT_ADDR		0x01400
#define RK3399_HWC_LUT_ADDR		0x01800
#define RK3399_CABC_GAMMA_LUT_ADDR	0x01c00
#define RK3399_GAMMA_LUT_ADDR		0x02000
/* rk3399 register definition end */

#endif /* _ROCKCHIP_VOP_REG_H */
