/*
 * Common syscall restarting data
 */
#ifndef __LINUX_RESTART_BLOCK_H
#define __LINUX_RESTART_BLOCK_H

#include <linux/compiler.h>
#include <linux/types.h>

struct timespec;
struct compat_timespec;
struct pollfd;

enum timespec_type {
	TT_NONE		= 0,
	TT_NATIVE	= 1,
#ifdef CONFIG_COMPAT
	TT_COMPAT	= 2,
#endif
};

/*
 * System call restart block.
 */
struct restart_block {
	long (*fn)(struct restart_block *);
	union {
		/* For futex_wait and futex_wait_requeue_pi */
		struct {
			u32 __user *uaddr;
			u32 val;
			u32 flags;
			u32 bitset;
			u64 time;
			u32 __user *uaddr2;
		} futex;
		/* For nanosleep */
		struct {
			clockid_t clockid;
			enum timespec_type type;
			union {
				struct timespec __user *rmtp;
#ifdef CONFIG_COMPAT
				struct compat_timespec __user *compat_rmtp;
#endif
			};
			u64 expires;
		} nanosleep;
		/* For poll */
		struct {
			struct pollfd __user *ufds;
			int nfds;
			int has_timeout;
			unsigned long tv_sec;
			unsigned long tv_nsec;
		} poll;
	};
};

extern long do_no_restart_syscall(struct restart_block *parm);

#endif /* __LINUX_RESTART_BLOCK_H */
