/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2016 Freescale Semiconductor, Inc.
 * Copyright 2017~2018 NXP
 *
 * Header file containing types used across multiple service APIs.
 */

#ifndef _SC_TYPES_H
#define _SC_TYPES_H

/*
 * This type is used to indicate a control.
 */
enum imx_sc_ctrl {
	IMX_SC_C_TEMP = 0,
	IMX_SC_C_TEMP_HI = 1,
	IMX_SC_C_TEMP_LOW = 2,
	IMX_SC_C_PXL_LINK_MST1_ADDR = 3,
	IMX_SC_C_PXL_LINK_MST2_ADDR = 4,
	IMX_SC_C_PXL_LINK_MST_ENB = 5,
	IMX_SC_C_PXL_LINK_MST1_ENB = 6,
	IMX_SC_C_PXL_LINK_MST2_ENB = 7,
	IMX_SC_C_PXL_LINK_SLV1_ADDR = 8,
	IMX_SC_C_PXL_LINK_SLV2_ADDR = 9,
	IMX_SC_C_PXL_LINK_MST_VLD = 10,
	IMX_SC_C_PXL_LINK_MST1_VLD = 11,
	IMX_SC_C_PXL_LINK_MST2_VLD = 12,
	IMX_SC_C_SINGLE_MODE = 13,
	IMX_SC_C_ID = 14,
	IMX_SC_C_PXL_CLK_POLARITY = 15,
	IMX_SC_C_LINESTATE = 16,
	IMX_SC_C_PCIE_G_RST = 17,
	IMX_SC_C_PCIE_BUTTON_RST = 18,
	IMX_SC_C_PCIE_PERST = 19,
	IMX_SC_C_PHY_RESET = 20,
	IMX_SC_C_PXL_LINK_RATE_CORRECTION = 21,
	IMX_SC_C_PANIC = 22,
	IMX_SC_C_PRIORITY_GROUP = 23,
	IMX_SC_C_TXCLK = 24,
	IMX_SC_C_CLKDIV = 25,
	IMX_SC_C_DISABLE_50 = 26,
	IMX_SC_C_DISABLE_125 = 27,
	IMX_SC_C_SEL_125 = 28,
	IMX_SC_C_MODE = 29,
	IMX_SC_C_SYNC_CTRL0 = 30,
	IMX_SC_C_KACHUNK_CNT = 31,
	IMX_SC_C_KACHUNK_SEL = 32,
	IMX_SC_C_SYNC_CTRL1 = 33,
	IMX_SC_C_DPI_RESET = 34,
	IMX_SC_C_MIPI_RESET = 35,
	IMX_SC_C_DUAL_MODE = 36,
	IMX_SC_C_VOLTAGE = 37,
	IMX_SC_C_PXL_LINK_SEL = 38,
	IMX_SC_C_OFS_SEL = 39,
	IMX_SC_C_OFS_AUDIO = 40,
	IMX_SC_C_OFS_PERIPH = 41,
	IMX_SC_C_OFS_IRQ = 42,
	IMX_SC_C_RST0 = 43,
	IMX_SC_C_RST1 = 44,
	IMX_SC_C_SEL0 = 45,
	IMX_SC_C_LAST
};

#endif /* _SC_TYPES_H */
