; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;
; Test that a vector select with a logic combination of two compares do not
; produce any unnecessary pack, unpack or shift instructions.
; And, Or and Xor are tested.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13   | FileCheck %s


define <2 x i8> @fun0(<2 x i8> %val1, <2 x i8> %val2, <2 x i8> %val3, <2 x i8> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun0:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i8> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i16> @fun1(<2 x i8> %val1, <2 x i8> %val2, <2 x i8> %val3, <2 x i8> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun1:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i8> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i8> @fun2(<2 x i8> %val1, <2 x i8> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun2:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v1, %v28, %v30
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vpkh %v1, %v1, %v1
; CHECK-NEXT:    vn %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i32> @fun3(<2 x i8> %val1, <2 x i8> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun3:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i32> @fun4(<2 x i8> %val1, <2 x i8> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun4:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i16> @fun5(<2 x i8> %val1, <2 x i8> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun5:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i64> @fun6(<2 x i8> %val1, <2 x i8> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun6:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i8> @fun7(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun7:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i16> @fun8(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun8:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i32> @fun9(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun9:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i8> @fun10(<2 x i16> %val1, <2 x i16> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun10:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v28, %v30
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vpkf %v1, %v1, %v1
; CHECK-NEXT:    vn %v0, %v0, %v1
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i8> @fun11(<2 x i16> %val1, <2 x i16> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun11:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI11_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x double> @fun12(<2 x i16> %val1, <2 x i16> %val2, <2 x float> %val3, <2 x float> %val4, <2 x double> %val5, <2 x double> %val6) {
; CHECK-LABEL: fun12:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x double> %val5, <2 x double> %val6
  ret <2 x double> %sel
}

define <2 x i16> @fun13(<2 x i16> %val1, <2 x i16> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun13:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI13_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i16> @fun14(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun14:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i32> @fun15(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun15:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i64> @fun16(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun16:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i64> @fun17(<2 x i32> %val1, <2 x i32> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun17:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i16> @fun18(<2 x i32> %val1, <2 x i32> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun18:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x float> @fun19(<2 x i32> %val1, <2 x i32> %val2, <2 x double> %val3, <2 x double> %val4, <2 x float> %val5, <2 x float> %val6) {
; CHECK-LABEL: fun19:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v1, %v28, %v30
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vpkg %v1, %v1, %v1
; CHECK-NEXT:    vn %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x float> %val5, <2 x float> %val6
  ret <2 x float> %sel
}

define <2 x i16> @fun20(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun20:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI20_0
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i64> @fun21(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun21:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i64> @fun22(<2 x i64> %val1, <2 x i64> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun22:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i16> @fun23(<2 x i64> %val1, <2 x i64> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun23:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI23_0
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x float> @fun24(<2 x float> %val1, <2 x float> %val2, <2 x float> %val3, <2 x float> %val4, <2 x float> %val5, <2 x float> %val6) {
; CHECK-LABEL: fun24:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <2 x float> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x float> %val5, <2 x float> %val6
  ret <2 x float> %sel
}

define <2 x i32> @fun25(<2 x float> %val1, <2 x float> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun25:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v28, %v30
; CHECK-NEXT:    vpkg %v1, %v1, %v1
; CHECK-NEXT:    vn %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <2 x float> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = and <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <4 x i16> @fun26(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun26:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x i32> @fun27(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun27:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i64> @fun28(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun28:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x i32> @fun29(<4 x i32> %val1, <4 x i32> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun29:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v30, %v27
; CHECK-NEXT:    vceqg %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i16> @fun30(<4 x i32> %val1, <4 x i32> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun30:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x i8> @fun31(<4 x i32> %val1, <4 x i32> %val2, <4 x double> %val3, <4 x double> %val4, <4 x i8> %val5, <4 x i8> %val6) {
; CHECK-LABEL: fun31:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v27
; CHECK-NEXT:    vfchdb %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI31_0
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i8> %val5, <4 x i8> %val6
  ret <4 x i8> %sel
}

define <4 x i32> @fun32(<4 x i64> %val1, <4 x i64> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun32:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v29
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i64> @fun33(<4 x i64> %val1, <4 x i64> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun33:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v25, %v29
; CHECK-NEXT:    vceqg %v1, %v24, %v28
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqg %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x i64> @fun34(<4 x i64> %val1, <4 x i64> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun34:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v2, %v1
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x float> @fun35(<4 x i64> %val1, <4 x i64> %val2, <4 x double> %val3, <4 x double> %val4, <4 x float> %val5, <4 x float> %val6) {
; CHECK-LABEL: fun35:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v29
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x float> %val5, <4 x float> %val6
  ret <4 x float> %sel
}

define <4 x i16> @fun36(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun36:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x float> @fun37(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x float> %val5, <4 x float> %val6) {
; CHECK-LABEL: fun37:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x float> %val5, <4 x float> %val6
  ret <4 x float> %sel
}

define <4 x double> @fun38(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x double> %val5, <4 x double> %val6) {
; CHECK-LABEL: fun38:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x double> %val5, <4 x double> %val6
  ret <4 x double> %sel
}

define <4 x i8> @fun39(<4 x float> %val1, <4 x float> %val2, <4 x double> %val3, <4 x double> %val4, <4 x i8> %val5, <4 x i8> %val6) {
; CHECK-LABEL: fun39:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v27
; CHECK-NEXT:    vfchdb %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    larl %r1, .LCPI39_0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = and <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i8> %val5, <4 x i8> %val6
  ret <4 x i8> %sel
}

define <8 x i8> @fun40(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i8> %val5, <8 x i8> %val6) {
; CHECK-LABEL: fun40:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i8> %val5, <8 x i8> %val6
  ret <8 x i8> %sel
}

define <8 x i16> @fun41(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i16> %val5, <8 x i16> %val6) {
; CHECK-LABEL: fun41:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i16> %val5, <8 x i16> %val6
  ret <8 x i16> %sel
}

define <8 x i32> @fun42(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun42:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x i64> @fun43(<8 x i16> %val1, <8 x i16> %val2, <8 x i32> %val3, <8 x i32> %val4, <8 x i64> %val5, <8 x i64> %val6) {
; CHECK-LABEL: fun43:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vceqf %v0, %v28, %v25
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v26, %v31, %v2, %v0
; CHECK-NEXT:    vceqf %v0, %v30, %v27
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i32> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i64> %val5, <8 x i64> %val6
  ret <8 x i64> %sel
}

define <8 x i8> @fun44(<8 x i16> %val1, <8 x i16> %val2, <8 x i64> %val3, <8 x i64> %val4, <8 x i8> %val5, <8 x i8> %val6) {
; CHECK-LABEL: fun44:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v30, %v31
; CHECK-NEXT:    vceqg %v2, %v28, %v29
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vlrepg %v1, 200(%r15)
; CHECK-NEXT:    vlrepg %v2, 192(%r15)
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i64> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i8> %val5, <8 x i8> %val6
  ret <8 x i8> %sel
}

define <8 x i16> @fun45(<8 x i16> %val1, <8 x i16> %val2, <8 x float> %val3, <8 x float> %val4, <8 x i16> %val5, <8 x i16> %val6) {
; CHECK-LABEL: fun45:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = fcmp ogt <8 x float> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i16> %val5, <8 x i16> %val6
  ret <8 x i16> %sel
}

define <8 x i32> @fun46(<8 x i16> %val1, <8 x i16> %val2, <8 x double> %val3, <8 x double> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun46:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vfchdb %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x i32> @fun47(<8 x i32> %val1, <8 x i32> %val2, <8 x i64> %val3, <8 x i64> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun47:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = icmp eq <8 x i64> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x double> @fun48(<8 x i32> %val1, <8 x i32> %val2, <8 x float> %val3, <8 x float> %val4, <8 x double> %val5, <8 x double> %val6) {
; CHECK-LABEL: fun48:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v29, %v29
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v29, %v29
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v31, %v31
; CHECK-NEXT:    vmrlf %v2, %v27, %v27
; CHECK-NEXT:    vmrhf %v3, %v27, %v27
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v31, %v31
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vceqf %v2, %v26, %v30
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = fcmp ogt <8 x float> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x double> %val5, <8 x double> %val6
  ret <8 x double> %sel
}

define <8 x double> @fun49(<8 x i32> %val1, <8 x i32> %val2, <8 x double> %val3, <8 x double> %val4, <8 x double> %val5, <8 x double> %val6) {
; CHECK-LABEL: fun49:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vfchdb %v0, %v25, %v0
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vceqf %v2, %v26, %v30
; CHECK-NEXT:    vfchdb %v0, %v29, %v0
; CHECK-NEXT:    vuphf %v3, %v2
; CHECK-NEXT:    vn %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x double> %val5, <8 x double> %val6
  ret <8 x double> %sel
}

define <8 x i64> @fun50(<8 x float> %val1, <8 x float> %val2, <8 x double> %val3, <8 x double> %val4, <8 x i64> %val5, <8 x i64> %val6) {
; CHECK-LABEL: fun50:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v28, %v28
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 224(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vn %v1, %v1, %v2
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vfchdb %v3, %v29, %v3
; CHECK-NEXT:    vn %v2, %v2, %v3
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vfchdb %v2, %v27, %v2
; CHECK-NEXT:    vn %v0, %v0, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vfchdb %v1, %v31, %v1
; CHECK-NEXT:    vn %v0, %v0, %v1
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <8 x float> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = and <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i64> %val5, <8 x i64> %val6
  ret <8 x i64> %sel
}

define <16 x i8> @fun51(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3, <16 x i8> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun51:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i8> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i16> @fun52(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3, <16 x i8> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun52:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i8> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i64> @fun53(<16 x i8> %val1, <16 x i8> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun53:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vceqh %v0, %v28, %v25
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vuphh %v2, %v0
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v24, %v29, %v3, %v2
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v26, %v31, %v3, %v2
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v3, 288(%r15)
; CHECK-NEXT:    vl %v4, 160(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v0, %v3, %v2, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vceqh %v2, %v30, %v27
; CHECK-NEXT:    vlr %v30, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vn %v1, %v1, %v2
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v25, %v4, %v3, %v2
; CHECK-NEXT:    vl %v3, 336(%r15)
; CHECK-NEXT:    vl %v4, 208(%r15)
; CHECK-NEXT:    vpkg %v2, %v1, %v1
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v27, %v4, %v3, %v2
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vmrlg %v2, %v1, %v1
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v1, %v1, %v1, 12
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsel %v29, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v31, %v3, %v2, %v1
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i64> @fun54(<16 x i8> %val1, <16 x i8> %val2, <16 x i32> %val3, <16 x i32> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun54:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vceqf %v0, %v28, %v29
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vl %v3, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vpkg %v2, %v1, %v1
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vceqf %v0, %v30, %v31
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vl %v5, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vmrlg %v3, %v1, %v1
; CHECK-NEXT:    vuphb %v3, %v3
; CHECK-NEXT:    vceqf %v2, %v25, %v2
; CHECK-NEXT:    vuphh %v3, %v3
; CHECK-NEXT:    vn %v2, %v3, %v2
; CHECK-NEXT:    vuphf %v3, %v2
; CHECK-NEXT:    vsldb %v1, %v1, %v1, 12
; CHECK-NEXT:    vsel %v25, %v5, %v4, %v3
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vl %v4, 416(%r15)
; CHECK-NEXT:    vl %v5, 288(%r15)
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vceqf %v3, %v27, %v3
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v1, %v1, %v3
; CHECK-NEXT:    vuphf %v3, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v29, %v5, %v4, %v3
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vl %v4, 240(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v4, %v3, %v0
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i32> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i64> @fun55(<16 x i8> %val1, <16 x i8> %val2, <16 x i64> %val3, <16 x i64> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun55:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vceqg %v1, %v28, %v0
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 448(%r15)
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vpkf %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v30, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 464(%r15)
; CHECK-NEXT:    vl %v3, 336(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v1
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 480(%r15)
; CHECK-NEXT:    vsel %v28, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 6
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v27, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 496(%r15)
; CHECK-NEXT:    vsel %v30, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v3, 384(%r15)
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 512(%r15)
; CHECK-NEXT:    vsel %v25, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v3, 400(%r15)
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 10
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v31, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 528(%r15)
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 288(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vl %v3, 416(%r15)
; CHECK-NEXT:    vceqg %v1, %v2, %v1
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 12
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 14
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 544(%r15)
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v29, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 432(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vn %v0, %v0, %v1
; CHECK-NEXT:    vl %v1, 560(%r15)
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i64> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i16> @fun56(<16 x i8> %val1, <16 x i8> %val2, <16 x float> %val3, <16 x float> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun56:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v31, %v31
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v31, %v31
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vmrlf %v4, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v29, %v29
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vmrlf %v2, %v0, %v0
; CHECK-NEXT:    vmrlf %v3, %v27, %v27
; CHECK-NEXT:    vmrhf %v0, %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vmrhf %v3, %v27, %v27
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v0, %v3, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v2
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vpkf %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = fcmp ogt <16 x float> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i8> @fun57(<16 x i8> %val1, <16 x i8> %val2, <16 x double> %val3, <16 x double> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun57:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 288(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v31, %v1
; CHECK-NEXT:    vfchdb %v2, %v29, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vfchdb %v1, %v27, %v1
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vfchdb %v2, %v30, %v2
; CHECK-NEXT:    vfchdb %v3, %v28, %v3
; CHECK-NEXT:    vpkg %v2, %v3, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = fcmp ogt <16 x double> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i8> @fun58(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun58:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v27, %v31
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v25, %v29
; CHECK-NEXT:    vceqh %v2, %v24, %v28
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i16> @fun59(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun59:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v25, %v29
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqh %v0, %v27, %v31
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i32> @fun60(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun60:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v25, %v29
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vceqh %v1, %v27, %v31
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <16 x i8> @fun61(<16 x i16> %val1, <16 x i16> %val2, <16 x i32> %val3, <16 x i32> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun61:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqf %v0, %v31, %v0
; CHECK-NEXT:    vceqf %v1, %v29, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqf %v1, %v27, %v1
; CHECK-NEXT:    vceqf %v2, %v25, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vceqh %v2, %v24, %v28
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i32> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i32> @fun62(<16 x i16> %val1, <16 x i16> %val2, <16 x i64> %val3, <16 x i64> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun62:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 416(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vceqg %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vceqg %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vuphh %v3, %v2
; CHECK-NEXT:    vn %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 448(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v3, %v29, %v3
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v3, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 336(%r15)
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vceqg %v1, %v3, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i64> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <16 x double> @fun63(<16 x i16> %val1, <16 x i16> %val2, <16 x float> %val3, <16 x float> %val4, <16 x double> %val5, <16 x double> %val6) {
; CHECK-LABEL: fun63:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vmrlf %v1, %v0, %v0
; CHECK-NEXT:    vmrlf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v0, %v0, %v0
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vl %v5, 416(%r15)
; CHECK-NEXT:    vl %v6, 288(%r15)
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vsel %v24, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrlf %v4, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v27, %v27
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vl %v3, 384(%r15)
; CHECK-NEXT:    vn %v1, %v1, %v2
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrlf %v4, %v29, %v29
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vceqh %v3, %v26, %v30
; CHECK-NEXT:    vuphh %v4, %v3
; CHECK-NEXT:    vn %v2, %v4, %v2
; CHECK-NEXT:    vuphf %v4, %v2
; CHECK-NEXT:    vsel %v25, %v6, %v5, %v4
; CHECK-NEXT:    vl %v4, 208(%r15)
; CHECK-NEXT:    vmrlf %v5, %v4, %v4
; CHECK-NEXT:    vmrlf %v6, %v31, %v31
; CHECK-NEXT:    vmrhf %v4, %v4, %v4
; CHECK-NEXT:    vmrlg %v3, %v3, %v3
; CHECK-NEXT:    vuphh %v3, %v3
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v5, %v6, %v5
; CHECK-NEXT:    vmrhf %v6, %v31, %v31
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v4, %v6, %v4
; CHECK-NEXT:    vl %v6, 320(%r15)
; CHECK-NEXT:    vpkg %v4, %v4, %v5
; CHECK-NEXT:    vl %v5, 448(%r15)
; CHECK-NEXT:    vn %v3, %v3, %v4
; CHECK-NEXT:    vuphf %v4, %v3
; CHECK-NEXT:    vsel %v29, %v6, %v5, %v4
; CHECK-NEXT:    vl %v4, 368(%r15)
; CHECK-NEXT:    vl %v5, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v5, %v4, %v0
; CHECK-NEXT:    vl %v4, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 400(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v4, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vmrlg %v0, %v2, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vmrlg %v0, %v3, %v3
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = fcmp ogt <16 x float> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x double> %val5, <16 x double> %val6
  ret <16 x double> %sel
}

define <16 x i32> @fun64(<16 x i16> %val1, <16 x i16> %val2, <16 x double> %val3, <16 x double> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun64:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vn %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 416(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vuphh %v3, %v2
; CHECK-NEXT:    vn %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 448(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vfchdb %v3, %v29, %v3
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v3, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 336(%r15)
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vfchdb %v1, %v3, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vn %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = fcmp ogt <16 x double> %val3, %val4
  %and = and <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <2 x i8> @fun65(<2 x i8> %val1, <2 x i8> %val2, <2 x i8> %val3, <2 x i8> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun65:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i8> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i16> @fun66(<2 x i8> %val1, <2 x i8> %val2, <2 x i8> %val3, <2 x i8> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun66:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i8> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i8> @fun67(<2 x i8> %val1, <2 x i8> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun67:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v1, %v28, %v30
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vpkh %v1, %v1, %v1
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i32> @fun68(<2 x i8> %val1, <2 x i8> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun68:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i32> @fun69(<2 x i8> %val1, <2 x i8> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun69:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i16> @fun70(<2 x i8> %val1, <2 x i8> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun70:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i64> @fun71(<2 x i8> %val1, <2 x i8> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun71:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i8> @fun72(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun72:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i16> @fun73(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun73:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i32> @fun74(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun74:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i8> @fun75(<2 x i16> %val1, <2 x i16> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun75:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v28, %v30
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vpkf %v1, %v1, %v1
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i8> @fun76(<2 x i16> %val1, <2 x i16> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun76:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI76_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x double> @fun77(<2 x i16> %val1, <2 x i16> %val2, <2 x float> %val3, <2 x float> %val4, <2 x double> %val5, <2 x double> %val6) {
; CHECK-LABEL: fun77:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x double> %val5, <2 x double> %val6
  ret <2 x double> %sel
}

define <2 x i16> @fun78(<2 x i16> %val1, <2 x i16> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun78:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI78_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i16> @fun79(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun79:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i32> @fun80(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun80:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i64> @fun81(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun81:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i64> @fun82(<2 x i32> %val1, <2 x i32> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun82:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i16> @fun83(<2 x i32> %val1, <2 x i32> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun83:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x float> @fun84(<2 x i32> %val1, <2 x i32> %val2, <2 x double> %val3, <2 x double> %val4, <2 x float> %val5, <2 x float> %val6) {
; CHECK-LABEL: fun84:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v1, %v28, %v30
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vpkg %v1, %v1, %v1
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x float> %val5, <2 x float> %val6
  ret <2 x float> %sel
}

define <2 x i16> @fun85(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun85:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI85_0
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i64> @fun86(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun86:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i64> @fun87(<2 x i64> %val1, <2 x i64> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun87:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i16> @fun88(<2 x i64> %val1, <2 x i64> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun88:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI88_0
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x float> @fun89(<2 x float> %val1, <2 x float> %val2, <2 x float> %val3, <2 x float> %val4, <2 x float> %val5, <2 x float> %val6) {
; CHECK-LABEL: fun89:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <2 x float> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x float> %val5, <2 x float> %val6
  ret <2 x float> %sel
}

define <2 x i32> @fun90(<2 x float> %val1, <2 x float> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun90:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v28, %v30
; CHECK-NEXT:    vpkg %v1, %v1, %v1
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <2 x float> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = or <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <4 x i16> @fun91(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun91:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x i32> @fun92(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun92:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i64> @fun93(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun93:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x i32> @fun94(<4 x i32> %val1, <4 x i32> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun94:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v30, %v27
; CHECK-NEXT:    vceqg %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i16> @fun95(<4 x i32> %val1, <4 x i32> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun95:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x i8> @fun96(<4 x i32> %val1, <4 x i32> %val2, <4 x double> %val3, <4 x double> %val4, <4 x i8> %val5, <4 x i8> %val6) {
; CHECK-LABEL: fun96:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v27
; CHECK-NEXT:    vfchdb %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI96_0
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i8> %val5, <4 x i8> %val6
  ret <4 x i8> %sel
}

define <4 x i32> @fun97(<4 x i64> %val1, <4 x i64> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun97:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v29
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i64> @fun98(<4 x i64> %val1, <4 x i64> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun98:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v25, %v29
; CHECK-NEXT:    vceqg %v1, %v24, %v28
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqg %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x i64> @fun99(<4 x i64> %val1, <4 x i64> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun99:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v2, %v1
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x float> @fun100(<4 x i64> %val1, <4 x i64> %val2, <4 x double> %val3, <4 x double> %val4, <4 x float> %val5, <4 x float> %val6) {
; CHECK-LABEL: fun100:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v29
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x float> %val5, <4 x float> %val6
  ret <4 x float> %sel
}

define <4 x i16> @fun101(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun101:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x float> @fun102(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x float> %val5, <4 x float> %val6) {
; CHECK-LABEL: fun102:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x float> %val5, <4 x float> %val6
  ret <4 x float> %sel
}

define <4 x double> @fun103(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x double> %val5, <4 x double> %val6) {
; CHECK-LABEL: fun103:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x double> %val5, <4 x double> %val6
  ret <4 x double> %sel
}

define <4 x i8> @fun104(<4 x float> %val1, <4 x float> %val2, <4 x double> %val3, <4 x double> %val4, <4 x i8> %val5, <4 x i8> %val6) {
; CHECK-LABEL: fun104:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v27
; CHECK-NEXT:    vfchdb %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    larl %r1, .LCPI104_0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = or <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i8> %val5, <4 x i8> %val6
  ret <4 x i8> %sel
}

define <8 x i8> @fun105(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i8> %val5, <8 x i8> %val6) {
; CHECK-LABEL: fun105:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i8> %val5, <8 x i8> %val6
  ret <8 x i8> %sel
}

define <8 x i16> @fun106(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i16> %val5, <8 x i16> %val6) {
; CHECK-LABEL: fun106:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i16> %val5, <8 x i16> %val6
  ret <8 x i16> %sel
}

define <8 x i32> @fun107(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun107:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x i64> @fun108(<8 x i16> %val1, <8 x i16> %val2, <8 x i32> %val3, <8 x i32> %val4, <8 x i64> %val5, <8 x i64> %val6) {
; CHECK-LABEL: fun108:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vceqf %v0, %v28, %v25
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v26, %v31, %v2, %v0
; CHECK-NEXT:    vceqf %v0, %v30, %v27
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i32> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i64> %val5, <8 x i64> %val6
  ret <8 x i64> %sel
}

define <8 x i8> @fun109(<8 x i16> %val1, <8 x i16> %val2, <8 x i64> %val3, <8 x i64> %val4, <8 x i8> %val5, <8 x i8> %val6) {
; CHECK-LABEL: fun109:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v30, %v31
; CHECK-NEXT:    vceqg %v2, %v28, %v29
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vlrepg %v1, 200(%r15)
; CHECK-NEXT:    vlrepg %v2, 192(%r15)
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i64> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i8> %val5, <8 x i8> %val6
  ret <8 x i8> %sel
}

define <8 x i16> @fun110(<8 x i16> %val1, <8 x i16> %val2, <8 x float> %val3, <8 x float> %val4, <8 x i16> %val5, <8 x i16> %val6) {
; CHECK-LABEL: fun110:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = fcmp ogt <8 x float> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i16> %val5, <8 x i16> %val6
  ret <8 x i16> %sel
}

define <8 x i32> @fun111(<8 x i16> %val1, <8 x i16> %val2, <8 x double> %val3, <8 x double> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun111:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vfchdb %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x i32> @fun112(<8 x i32> %val1, <8 x i32> %val2, <8 x i64> %val3, <8 x i64> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun112:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = icmp eq <8 x i64> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x double> @fun113(<8 x i32> %val1, <8 x i32> %val2, <8 x float> %val3, <8 x float> %val4, <8 x double> %val5, <8 x double> %val6) {
; CHECK-LABEL: fun113:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v29, %v29
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v29, %v29
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v31, %v31
; CHECK-NEXT:    vmrlf %v2, %v27, %v27
; CHECK-NEXT:    vmrhf %v3, %v27, %v27
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v31, %v31
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vceqf %v2, %v26, %v30
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = fcmp ogt <8 x float> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x double> %val5, <8 x double> %val6
  ret <8 x double> %sel
}

define <8 x double> @fun114(<8 x i32> %val1, <8 x i32> %val2, <8 x double> %val3, <8 x double> %val4, <8 x double> %val5, <8 x double> %val6) {
; CHECK-LABEL: fun114:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vfchdb %v0, %v25, %v0
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vceqf %v2, %v26, %v30
; CHECK-NEXT:    vfchdb %v0, %v29, %v0
; CHECK-NEXT:    vuphf %v3, %v2
; CHECK-NEXT:    vo %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x double> %val5, <8 x double> %val6
  ret <8 x double> %sel
}

define <8 x i64> @fun115(<8 x float> %val1, <8 x float> %val2, <8 x double> %val3, <8 x double> %val4, <8 x i64> %val5, <8 x i64> %val6) {
; CHECK-LABEL: fun115:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v28, %v28
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 224(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vo %v1, %v1, %v2
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vfchdb %v3, %v29, %v3
; CHECK-NEXT:    vo %v2, %v2, %v3
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vfchdb %v2, %v27, %v2
; CHECK-NEXT:    vo %v0, %v0, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vfchdb %v1, %v31, %v1
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <8 x float> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = or <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i64> %val5, <8 x i64> %val6
  ret <8 x i64> %sel
}

define <16 x i8> @fun116(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3, <16 x i8> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun116:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i8> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i16> @fun117(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3, <16 x i8> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun117:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i8> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i64> @fun118(<16 x i8> %val1, <16 x i8> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun118:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vceqh %v0, %v28, %v25
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vuphh %v2, %v0
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v24, %v29, %v3, %v2
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v26, %v31, %v3, %v2
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v3, 288(%r15)
; CHECK-NEXT:    vl %v4, 160(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v0, %v3, %v2, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vceqh %v2, %v30, %v27
; CHECK-NEXT:    vlr %v30, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vo %v1, %v1, %v2
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v25, %v4, %v3, %v2
; CHECK-NEXT:    vl %v3, 336(%r15)
; CHECK-NEXT:    vl %v4, 208(%r15)
; CHECK-NEXT:    vpkg %v2, %v1, %v1
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v27, %v4, %v3, %v2
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vmrlg %v2, %v1, %v1
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v1, %v1, %v1, 12
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsel %v29, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v31, %v3, %v2, %v1
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i64> @fun119(<16 x i8> %val1, <16 x i8> %val2, <16 x i32> %val3, <16 x i32> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun119:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vceqf %v0, %v28, %v29
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vl %v3, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vpkg %v2, %v1, %v1
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vceqf %v0, %v30, %v31
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vl %v5, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vmrlg %v3, %v1, %v1
; CHECK-NEXT:    vuphb %v3, %v3
; CHECK-NEXT:    vceqf %v2, %v25, %v2
; CHECK-NEXT:    vuphh %v3, %v3
; CHECK-NEXT:    vo %v2, %v3, %v2
; CHECK-NEXT:    vuphf %v3, %v2
; CHECK-NEXT:    vsldb %v1, %v1, %v1, 12
; CHECK-NEXT:    vsel %v25, %v5, %v4, %v3
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vl %v4, 416(%r15)
; CHECK-NEXT:    vl %v5, 288(%r15)
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vceqf %v3, %v27, %v3
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v1, %v1, %v3
; CHECK-NEXT:    vuphf %v3, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v29, %v5, %v4, %v3
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vl %v4, 240(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v4, %v3, %v0
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i32> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i64> @fun120(<16 x i8> %val1, <16 x i8> %val2, <16 x i64> %val3, <16 x i64> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun120:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vceqg %v1, %v28, %v0
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 448(%r15)
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vpkf %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v30, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 464(%r15)
; CHECK-NEXT:    vl %v3, 336(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v1
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 480(%r15)
; CHECK-NEXT:    vsel %v28, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 6
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v27, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 496(%r15)
; CHECK-NEXT:    vsel %v30, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v3, 384(%r15)
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 512(%r15)
; CHECK-NEXT:    vsel %v25, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v3, 400(%r15)
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 10
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v31, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 528(%r15)
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 288(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vl %v3, 416(%r15)
; CHECK-NEXT:    vceqg %v1, %v2, %v1
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 12
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 14
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 544(%r15)
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v29, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 432(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vo %v0, %v0, %v1
; CHECK-NEXT:    vl %v1, 560(%r15)
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i64> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i16> @fun121(<16 x i8> %val1, <16 x i8> %val2, <16 x float> %val3, <16 x float> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun121:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v31, %v31
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v31, %v31
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vmrlf %v4, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v29, %v29
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vmrlf %v2, %v0, %v0
; CHECK-NEXT:    vmrlf %v3, %v27, %v27
; CHECK-NEXT:    vmrhf %v0, %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vmrhf %v3, %v27, %v27
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v0, %v3, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v2
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vpkf %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = fcmp ogt <16 x float> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i8> @fun122(<16 x i8> %val1, <16 x i8> %val2, <16 x double> %val3, <16 x double> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun122:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 288(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v31, %v1
; CHECK-NEXT:    vfchdb %v2, %v29, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vfchdb %v1, %v27, %v1
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vfchdb %v2, %v30, %v2
; CHECK-NEXT:    vfchdb %v3, %v28, %v3
; CHECK-NEXT:    vpkg %v2, %v3, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = fcmp ogt <16 x double> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i8> @fun123(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun123:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v27, %v31
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v25, %v29
; CHECK-NEXT:    vceqh %v2, %v24, %v28
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i16> @fun124(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun124:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v25, %v29
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqh %v0, %v27, %v31
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i32> @fun125(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun125:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v25, %v29
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vceqh %v1, %v27, %v31
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <16 x i8> @fun126(<16 x i16> %val1, <16 x i16> %val2, <16 x i32> %val3, <16 x i32> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun126:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqf %v0, %v31, %v0
; CHECK-NEXT:    vceqf %v1, %v29, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqf %v1, %v27, %v1
; CHECK-NEXT:    vceqf %v2, %v25, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vceqh %v2, %v24, %v28
; CHECK-NEXT:    vo %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i32> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i32> @fun127(<16 x i16> %val1, <16 x i16> %val2, <16 x i64> %val3, <16 x i64> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun127:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 416(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vceqg %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vceqg %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vuphh %v3, %v2
; CHECK-NEXT:    vo %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 448(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v3, %v29, %v3
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v3, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 336(%r15)
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vceqg %v1, %v3, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i64> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <16 x double> @fun128(<16 x i16> %val1, <16 x i16> %val2, <16 x float> %val3, <16 x float> %val4, <16 x double> %val5, <16 x double> %val6) {
; CHECK-LABEL: fun128:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vmrlf %v1, %v0, %v0
; CHECK-NEXT:    vmrlf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v0, %v0, %v0
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vl %v5, 416(%r15)
; CHECK-NEXT:    vl %v6, 288(%r15)
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vsel %v24, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrlf %v4, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v27, %v27
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vl %v3, 384(%r15)
; CHECK-NEXT:    vo %v1, %v1, %v2
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrlf %v4, %v29, %v29
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vceqh %v3, %v26, %v30
; CHECK-NEXT:    vuphh %v4, %v3
; CHECK-NEXT:    vo %v2, %v4, %v2
; CHECK-NEXT:    vuphf %v4, %v2
; CHECK-NEXT:    vsel %v25, %v6, %v5, %v4
; CHECK-NEXT:    vl %v4, 208(%r15)
; CHECK-NEXT:    vmrlf %v5, %v4, %v4
; CHECK-NEXT:    vmrlf %v6, %v31, %v31
; CHECK-NEXT:    vmrhf %v4, %v4, %v4
; CHECK-NEXT:    vmrlg %v3, %v3, %v3
; CHECK-NEXT:    vuphh %v3, %v3
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v5, %v6, %v5
; CHECK-NEXT:    vmrhf %v6, %v31, %v31
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v4, %v6, %v4
; CHECK-NEXT:    vl %v6, 320(%r15)
; CHECK-NEXT:    vpkg %v4, %v4, %v5
; CHECK-NEXT:    vl %v5, 448(%r15)
; CHECK-NEXT:    vo %v3, %v3, %v4
; CHECK-NEXT:    vuphf %v4, %v3
; CHECK-NEXT:    vsel %v29, %v6, %v5, %v4
; CHECK-NEXT:    vl %v4, 368(%r15)
; CHECK-NEXT:    vl %v5, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v5, %v4, %v0
; CHECK-NEXT:    vl %v4, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 400(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v4, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vmrlg %v0, %v2, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vmrlg %v0, %v3, %v3
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = fcmp ogt <16 x float> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x double> %val5, <16 x double> %val6
  ret <16 x double> %sel
}

define <16 x i32> @fun129(<16 x i16> %val1, <16 x i16> %val2, <16 x double> %val3, <16 x double> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun129:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vo %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 416(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vuphh %v3, %v2
; CHECK-NEXT:    vo %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 448(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vfchdb %v3, %v29, %v3
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v3, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 336(%r15)
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vfchdb %v1, %v3, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vo %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = fcmp ogt <16 x double> %val3, %val4
  %and = or <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <2 x i8> @fun130(<2 x i8> %val1, <2 x i8> %val2, <2 x i8> %val3, <2 x i8> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun130:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i8> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i16> @fun131(<2 x i8> %val1, <2 x i8> %val2, <2 x i8> %val3, <2 x i8> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun131:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i8> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i8> @fun132(<2 x i8> %val1, <2 x i8> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun132:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v1, %v28, %v30
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vpkh %v1, %v1, %v1
; CHECK-NEXT:    vx %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i32> @fun133(<2 x i8> %val1, <2 x i8> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun133:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i32> @fun134(<2 x i8> %val1, <2 x i8> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun134:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i16> @fun135(<2 x i8> %val1, <2 x i8> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun135:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i64> @fun136(<2 x i8> %val1, <2 x i8> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun136:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i8> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i8> @fun137(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun137:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i16> @fun138(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun138:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i32> @fun139(<2 x i16> %val1, <2 x i16> %val2, <2 x i16> %val3, <2 x i16> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun139:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i16> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i8> @fun140(<2 x i16> %val1, <2 x i16> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun140:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v28, %v30
; CHECK-NEXT:    vceqh %v0, %v24, %v26
; CHECK-NEXT:    vpkf %v1, %v1, %v1
; CHECK-NEXT:    vx %v0, %v0, %v1
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x i8> @fun141(<2 x i16> %val1, <2 x i16> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i8> %val5, <2 x i8> %val6) {
; CHECK-LABEL: fun141:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI141_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i8> %val5, <2 x i8> %val6
  ret <2 x i8> %sel
}

define <2 x double> @fun142(<2 x i16> %val1, <2 x i16> %val2, <2 x float> %val3, <2 x float> %val4, <2 x double> %val5, <2 x double> %val6) {
; CHECK-LABEL: fun142:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x double> %val5, <2 x double> %val6
  ret <2 x double> %sel
}

define <2 x i16> @fun143(<2 x i16> %val1, <2 x i16> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun143:
; CHECK:       # BB#0:
; CHECK-NEXT:    larl %r1, .LCPI143_0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i16> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i16> @fun144(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun144:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i32> @fun145(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun145:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <2 x i64> @fun146(<2 x i32> %val1, <2 x i32> %val2, <2 x i32> %val3, <2 x i32> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun146:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i32> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i64> @fun147(<2 x i32> %val1, <2 x i32> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun147:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i16> @fun148(<2 x i32> %val1, <2 x i32> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun148:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x float> @fun149(<2 x i32> %val1, <2 x i32> %val2, <2 x double> %val3, <2 x double> %val4, <2 x float> %val5, <2 x float> %val6) {
; CHECK-LABEL: fun149:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v1, %v28, %v30
; CHECK-NEXT:    vceqf %v0, %v24, %v26
; CHECK-NEXT:    vpkg %v1, %v1, %v1
; CHECK-NEXT:    vx %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i32> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x float> %val5, <2 x float> %val6
  ret <2 x float> %sel
}

define <2 x i16> @fun150(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun150:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI150_0
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x i64> @fun151(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3, <2 x i64> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun151:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = icmp eq <2 x i64> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i64> @fun152(<2 x i64> %val1, <2 x i64> %val2, <2 x float> %val3, <2 x float> %val4, <2 x i64> %val5, <2 x i64> %val6) {
; CHECK-LABEL: fun152:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i64> %val5, <2 x i64> %val6
  ret <2 x i64> %sel
}

define <2 x i16> @fun153(<2 x i64> %val1, <2 x i64> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i16> %val5, <2 x i16> %val6) {
; CHECK-LABEL: fun153:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v28, %v30
; CHECK-NEXT:    vceqg %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI153_0
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <2 x i64> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i16> %val5, <2 x i16> %val6
  ret <2 x i16> %sel
}

define <2 x float> @fun154(<2 x float> %val1, <2 x float> %val2, <2 x float> %val3, <2 x float> %val4, <2 x float> %val5, <2 x float> %val6) {
; CHECK-LABEL: fun154:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <2 x float> %val1, %val2
  %cmp1 = fcmp ogt <2 x float> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x float> %val5, <2 x float> %val6
  ret <2 x float> %sel
}

define <2 x i32> @fun155(<2 x float> %val1, <2 x float> %val2, <2 x double> %val3, <2 x double> %val4, <2 x i32> %val5, <2 x i32> %val6) {
; CHECK-LABEL: fun155:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v26, %v26
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v26, %v26
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v28, %v30
; CHECK-NEXT:    vpkg %v1, %v1, %v1
; CHECK-NEXT:    vx %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <2 x float> %val1, %val2
  %cmp1 = fcmp ogt <2 x double> %val3, %val4
  %and = xor <2 x i1> %cmp0, %cmp1
  %sel = select <2 x i1> %and, <2 x i32> %val5, <2 x i32> %val6
  ret <2 x i32> %sel
}

define <4 x i16> @fun156(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun156:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x i32> @fun157(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun157:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i64> @fun158(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3, <4 x i32> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun158:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqf %v0, %v28, %v30
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i32> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x i32> @fun159(<4 x i32> %val1, <4 x i32> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun159:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v30, %v27
; CHECK-NEXT:    vceqg %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i16> @fun160(<4 x i32> %val1, <4 x i32> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun160:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x i8> @fun161(<4 x i32> %val1, <4 x i32> %val2, <4 x double> %val3, <4 x double> %val4, <4 x i8> %val5, <4 x i8> %val6) {
; CHECK-LABEL: fun161:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v27
; CHECK-NEXT:    vfchdb %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v26
; CHECK-NEXT:    larl %r1, .LCPI161_0
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i32> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i8> %val5, <4 x i8> %val6
  ret <4 x i8> %sel
}

define <4 x i32> @fun162(<4 x i64> %val1, <4 x i64> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i32> %val5, <4 x i32> %val6) {
; CHECK-LABEL: fun162:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v29
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i32> %val5, <4 x i32> %val6
  ret <4 x i32> %sel
}

define <4 x i64> @fun163(<4 x i64> %val1, <4 x i64> %val2, <4 x i64> %val3, <4 x i64> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun163:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqg %v0, %v25, %v29
; CHECK-NEXT:    vceqg %v1, %v24, %v28
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqg %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = icmp eq <4 x i64> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x i64> @fun164(<4 x i64> %val1, <4 x i64> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i64> %val5, <4 x i64> %val6) {
; CHECK-LABEL: fun164:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v2, %v1
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v31, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i64> %val5, <4 x i64> %val6
  ret <4 x i64> %sel
}

define <4 x float> @fun165(<4 x i64> %val1, <4 x i64> %val2, <4 x double> %val3, <4 x double> %val4, <4 x float> %val5, <4 x float> %val6) {
; CHECK-LABEL: fun165:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v27, %v31
; CHECK-NEXT:    vceqg %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v29
; CHECK-NEXT:    vceqg %v2, %v24, %v28
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <4 x i64> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x float> %val5, <4 x float> %val6
  ret <4 x float> %sel
}

define <4 x i16> @fun166(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x i16> %val5, <4 x i16> %val6) {
; CHECK-LABEL: fun166:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkf %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i16> %val5, <4 x i16> %val6
  ret <4 x i16> %sel
}

define <4 x float> @fun167(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x float> %val5, <4 x float> %val6) {
; CHECK-LABEL: fun167:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x float> %val5, <4 x float> %val6
  ret <4 x float> %sel
}

define <4 x double> @fun168(<4 x float> %val1, <4 x float> %val2, <4 x float> %val3, <4 x float> %val4, <4 x double> %val5, <4 x double> %val6) {
; CHECK-LABEL: fun168:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v30, %v30
; CHECK-NEXT:    vmrlf %v1, %v28, %v28
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v30, %v30
; CHECK-NEXT:    vmrhf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x float> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x double> %val5, <4 x double> %val6
  ret <4 x double> %sel
}

define <4 x i8> @fun169(<4 x float> %val1, <4 x float> %val2, <4 x double> %val3, <4 x double> %val4, <4 x i8> %val5, <4 x i8> %val6) {
; CHECK-LABEL: fun169:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v27
; CHECK-NEXT:    vfchdb %v1, %v28, %v25
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v26, %v26
; CHECK-NEXT:    vmrlf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v24, %v24
; CHECK-NEXT:    larl %r1, .LCPI169_0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1)
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <4 x float> %val1, %val2
  %cmp1 = fcmp ogt <4 x double> %val3, %val4
  %and = xor <4 x i1> %cmp0, %cmp1
  %sel = select <4 x i1> %and, <4 x i8> %val5, <4 x i8> %val6
  ret <4 x i8> %sel
}

define <8 x i8> @fun170(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i8> %val5, <8 x i8> %val6) {
; CHECK-LABEL: fun170:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i8> %val5, <8 x i8> %val6
  ret <8 x i8> %sel
}

define <8 x i16> @fun171(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i16> %val5, <8 x i16> %val6) {
; CHECK-LABEL: fun171:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i16> %val5, <8 x i16> %val6
  ret <8 x i16> %sel
}

define <8 x i32> @fun172(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3, <8 x i16> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun172:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v28, %v30
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i16> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x i64> @fun173(<8 x i16> %val1, <8 x i16> %val2, <8 x i32> %val3, <8 x i32> %val4, <8 x i64> %val5, <8 x i64> %val6) {
; CHECK-LABEL: fun173:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vceqf %v0, %v28, %v25
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v3, %v2
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v26, %v31, %v2, %v0
; CHECK-NEXT:    vceqf %v0, %v30, %v27
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i32> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i64> %val5, <8 x i64> %val6
  ret <8 x i64> %sel
}

define <8 x i8> @fun174(<8 x i16> %val1, <8 x i16> %val2, <8 x i64> %val3, <8 x i64> %val4, <8 x i8> %val5, <8 x i8> %val6) {
; CHECK-LABEL: fun174:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqg %v1, %v30, %v31
; CHECK-NEXT:    vceqg %v2, %v28, %v29
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vlrepg %v1, 200(%r15)
; CHECK-NEXT:    vlrepg %v2, 192(%r15)
; CHECK-NEXT:    vpkh %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = icmp eq <8 x i64> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i8> %val5, <8 x i8> %val6
  ret <8 x i8> %sel
}

define <8 x i16> @fun175(<8 x i16> %val1, <8 x i16> %val2, <8 x float> %val3, <8 x float> %val4, <8 x i16> %val5, <8 x i16> %val6) {
; CHECK-LABEL: fun175:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v27, %v27
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v29, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = fcmp ogt <8 x float> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i16> %val5, <8 x i16> %val6
  ret <8 x i16> %sel
}

define <8 x i32> @fun176(<8 x i16> %val1, <8 x i16> %val2, <8 x double> %val3, <8 x double> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun176:
; CHECK:       # BB#0:
; CHECK-NEXT:    vfchdb %v0, %v30, %v31
; CHECK-NEXT:    vfchdb %v1, %v28, %v29
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v26
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i16> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x i32> @fun177(<8 x i32> %val1, <8 x i32> %val2, <8 x i64> %val3, <8 x i64> %val4, <8 x i32> %val5, <8 x i32> %val6) {
; CHECK-LABEL: fun177:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vl %v1, 160(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = icmp eq <8 x i64> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i32> %val5, <8 x i32> %val6
  ret <8 x i32> %sel
}

define <8 x double> @fun178(<8 x i32> %val1, <8 x i32> %val2, <8 x float> %val3, <8 x float> %val4, <8 x double> %val5, <8 x double> %val6) {
; CHECK-LABEL: fun178:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v29, %v29
; CHECK-NEXT:    vmrlf %v1, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v29, %v29
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v31, %v31
; CHECK-NEXT:    vmrlf %v2, %v27, %v27
; CHECK-NEXT:    vmrhf %v3, %v27, %v27
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v31, %v31
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vceqf %v2, %v26, %v30
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = fcmp ogt <8 x float> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x double> %val5, <8 x double> %val6
  ret <8 x double> %sel
}

define <8 x double> @fun179(<8 x i32> %val1, <8 x i32> %val2, <8 x double> %val3, <8 x double> %val4, <8 x double> %val5, <8 x double> %val6) {
; CHECK-LABEL: fun179:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vceqf %v1, %v24, %v28
; CHECK-NEXT:    vfchdb %v0, %v25, %v0
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vceqf %v2, %v26, %v30
; CHECK-NEXT:    vfchdb %v0, %v29, %v0
; CHECK-NEXT:    vuphf %v3, %v2
; CHECK-NEXT:    vx %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <8 x i32> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x double> %val5, <8 x double> %val6
  ret <8 x double> %sel
}

define <8 x i64> @fun180(<8 x float> %val1, <8 x float> %val2, <8 x double> %val3, <8 x double> %val4, <8 x i64> %val5, <8 x i64> %val6) {
; CHECK-LABEL: fun180:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v28, %v28
; CHECK-NEXT:    vmrlf %v1, %v24, %v24
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v28, %v28
; CHECK-NEXT:    vmrhf %v2, %v24, %v24
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vl %v3, 224(%r15)
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vuphf %v1, %v0
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vx %v1, %v1, %v2
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vmrlf %v2, %v26, %v26
; CHECK-NEXT:    vmrhf %v3, %v26, %v26
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vfchdb %v3, %v29, %v3
; CHECK-NEXT:    vx %v2, %v2, %v3
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vfchdb %v2, %v27, %v2
; CHECK-NEXT:    vx %v0, %v0, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vfchdb %v1, %v31, %v1
; CHECK-NEXT:    vx %v0, %v0, %v1
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = fcmp ogt <8 x float> %val1, %val2
  %cmp1 = fcmp ogt <8 x double> %val3, %val4
  %and = xor <8 x i1> %cmp0, %cmp1
  %sel = select <8 x i1> %and, <8 x i64> %val5, <8 x i64> %val6
  ret <8 x i64> %sel
}

define <16 x i8> @fun181(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3, <16 x i8> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun181:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v27, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i8> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i16> @fun182(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3, <16 x i8> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun182:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v0, %v28, %v30
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vuphb %v1, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v24, %v25, %v29, %v1
; CHECK-NEXT:    vsel %v26, %v27, %v31, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i8> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i64> @fun183(<16 x i8> %val1, <16 x i8> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun183:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vceqh %v0, %v28, %v25
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vuphh %v2, %v0
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v24, %v29, %v3, %v2
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v26, %v31, %v3, %v2
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 12
; CHECK-NEXT:    vl %v3, 288(%r15)
; CHECK-NEXT:    vl %v4, 160(%r15)
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vsel %v0, %v3, %v2, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vceqh %v2, %v30, %v27
; CHECK-NEXT:    vlr %v30, %v0
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vx %v1, %v1, %v2
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v25, %v4, %v3, %v2
; CHECK-NEXT:    vl %v3, 336(%r15)
; CHECK-NEXT:    vl %v4, 208(%r15)
; CHECK-NEXT:    vpkg %v2, %v1, %v1
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsel %v27, %v4, %v3, %v2
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vmrlg %v2, %v1, %v1
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vsldb %v1, %v1, %v1, 12
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vsel %v29, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 368(%r15)
; CHECK-NEXT:    vl %v3, 240(%r15)
; CHECK-NEXT:    vuphf %v1, %v1
; CHECK-NEXT:    vsel %v31, %v3, %v2, %v1
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i64> @fun184(<16 x i8> %val1, <16 x i8> %val2, <16 x i32> %val3, <16 x i32> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun184:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vceqf %v0, %v28, %v29
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v24, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vl %v3, 208(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vpkg %v2, %v1, %v1
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vceqf %v0, %v30, %v31
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vl %v5, 256(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vmrlg %v3, %v1, %v1
; CHECK-NEXT:    vuphb %v3, %v3
; CHECK-NEXT:    vceqf %v2, %v25, %v2
; CHECK-NEXT:    vuphh %v3, %v3
; CHECK-NEXT:    vx %v2, %v3, %v2
; CHECK-NEXT:    vuphf %v3, %v2
; CHECK-NEXT:    vsldb %v1, %v1, %v1, 12
; CHECK-NEXT:    vsel %v25, %v5, %v4, %v3
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vl %v4, 416(%r15)
; CHECK-NEXT:    vl %v5, 288(%r15)
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vceqf %v3, %v27, %v3
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v1, %v1, %v3
; CHECK-NEXT:    vuphf %v3, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v29, %v5, %v4, %v3
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vl %v4, 240(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v4, %v3, %v0
; CHECK-NEXT:    vl %v3, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v0
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i32> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i64> @fun185(<16 x i8> %val1, <16 x i8> %val2, <16 x i64> %val3, <16 x i64> %val4, <16 x i64> %val5, <16 x i64> %val6) {
; CHECK-LABEL: fun185:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 192(%r15)
; CHECK-NEXT:    vceqg %v1, %v28, %v0
; CHECK-NEXT:    vceqb %v0, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v0
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 448(%r15)
; CHECK-NEXT:    vl %v3, 320(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vpkf %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v30, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 464(%r15)
; CHECK-NEXT:    vl %v3, 336(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v1
; CHECK-NEXT:    vpkg %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 480(%r15)
; CHECK-NEXT:    vsel %v28, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 6
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v27, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 496(%r15)
; CHECK-NEXT:    vsel %v30, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 256(%r15)
; CHECK-NEXT:    vl %v3, 384(%r15)
; CHECK-NEXT:    vmrlg %v2, %v0, %v0
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v29, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 512(%r15)
; CHECK-NEXT:    vsel %v25, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v3, 400(%r15)
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 10
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vceqg %v1, %v31, %v1
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 528(%r15)
; CHECK-NEXT:    vsel %v27, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 288(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vl %v3, 416(%r15)
; CHECK-NEXT:    vceqg %v1, %v2, %v1
; CHECK-NEXT:    vsldb %v2, %v0, %v0, 12
; CHECK-NEXT:    vuphb %v2, %v2
; CHECK-NEXT:    vuphh %v2, %v2
; CHECK-NEXT:    vuphf %v2, %v2
; CHECK-NEXT:    vsldb %v0, %v0, %v0, 14
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 544(%r15)
; CHECK-NEXT:    vuphb %v0, %v0
; CHECK-NEXT:    vsel %v29, %v3, %v2, %v1
; CHECK-NEXT:    vl %v1, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vceqg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 432(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vx %v0, %v0, %v1
; CHECK-NEXT:    vl %v1, 560(%r15)
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = icmp eq <16 x i64> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i64> %val5, <16 x i64> %val6
  ret <16 x i64> %sel
}

define <16 x i16> @fun186(<16 x i8> %val1, <16 x i8> %val2, <16 x float> %val3, <16 x float> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun186:
; CHECK:       # BB#0:
; CHECK-NEXT:    vmrlf %v0, %v31, %v31
; CHECK-NEXT:    vmrlf %v1, %v30, %v30
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vmrhf %v1, %v31, %v31
; CHECK-NEXT:    vmrhf %v2, %v30, %v30
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vmrhf %v3, %v28, %v28
; CHECK-NEXT:    vmrlf %v4, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlf %v1, %v29, %v29
; CHECK-NEXT:    vmrlf %v2, %v28, %v28
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v2, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vuphb %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 176(%r15)
; CHECK-NEXT:    vmrlf %v2, %v0, %v0
; CHECK-NEXT:    vmrlf %v3, %v27, %v27
; CHECK-NEXT:    vmrhf %v0, %v0, %v0
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vmrhf %v3, %v27, %v27
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vfchdb %v0, %v3, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v2
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v25, %v25
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vpkf %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = fcmp ogt <16 x float> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i8> @fun187(<16 x i8> %val1, <16 x i8> %val2, <16 x double> %val3, <16 x double> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun187:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 288(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 256(%r15)
; CHECK-NEXT:    vfchdb %v1, %v31, %v1
; CHECK-NEXT:    vfchdb %v2, %v29, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vfchdb %v1, %v27, %v1
; CHECK-NEXT:    vfchdb %v2, %v25, %v2
; CHECK-NEXT:    vpkg %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vfchdb %v2, %v30, %v2
; CHECK-NEXT:    vfchdb %v3, %v28, %v3
; CHECK-NEXT:    vpkg %v2, %v3, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vceqb %v1, %v24, %v26
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 336(%r15)
; CHECK-NEXT:    vl %v2, 320(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i8> %val1, %val2
  %cmp1 = fcmp ogt <16 x double> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i8> @fun188(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun188:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v27, %v31
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v25, %v29
; CHECK-NEXT:    vceqh %v2, %v24, %v28
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i16> @fun189(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i16> %val5, <16 x i16> %val6) {
; CHECK-LABEL: fun189:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v25, %v29
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    vceqh %v0, %v27, %v31
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vsel %v26, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i16> %val5, <16 x i16> %val6
  ret <16 x i16> %sel
}

define <16 x i32> @fun190(<16 x i16> %val1, <16 x i16> %val2, <16 x i16> %val3, <16 x i16> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun190:
; CHECK:       # BB#0:
; CHECK-NEXT:    vceqh %v0, %v25, %v29
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vuphh %v1, %v0
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v1
; CHECK-NEXT:    vceqh %v1, %v27, %v31
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vl %v4, 192(%r15)
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 240(%r15)
; CHECK-NEXT:    vl %v3, 176(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v26, %v3, %v2, %v0
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 272(%r15)
; CHECK-NEXT:    vl %v2, 208(%r15)
; CHECK-NEXT:    vuphh %v0, %v0
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i16> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <16 x i8> @fun191(<16 x i16> %val1, <16 x i16> %val2, <16 x i32> %val3, <16 x i32> %val4, <16 x i8> %val5, <16 x i8> %val6) {
; CHECK-LABEL: fun191:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 208(%r15)
; CHECK-NEXT:    vl %v1, 192(%r15)
; CHECK-NEXT:    vceqf %v0, %v31, %v0
; CHECK-NEXT:    vceqf %v1, %v29, %v1
; CHECK-NEXT:    vpkf %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v26, %v30
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 176(%r15)
; CHECK-NEXT:    vl %v2, 160(%r15)
; CHECK-NEXT:    vceqf %v1, %v27, %v1
; CHECK-NEXT:    vceqf %v2, %v25, %v2
; CHECK-NEXT:    vpkf %v1, %v2, %v1
; CHECK-NEXT:    vceqh %v2, %v24, %v28
; CHECK-NEXT:    vx %v1, %v2, %v1
; CHECK-NEXT:    vpkh %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 240(%r15)
; CHECK-NEXT:    vl %v2, 224(%r15)
; CHECK-NEXT:    vsel %v24, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i32> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i8> %val5, <16 x i8> %val6
  ret <16 x i8> %sel
}

define <16 x i32> @fun192(<16 x i16> %val1, <16 x i16> %val2, <16 x i64> %val3, <16 x i64> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun192:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vceqg %v0, %v27, %v0
; CHECK-NEXT:    vceqg %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 416(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vceqg %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vceqg %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vuphh %v3, %v2
; CHECK-NEXT:    vx %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 448(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vceqg %v0, %v31, %v0
; CHECK-NEXT:    vceqg %v3, %v29, %v3
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v3, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 336(%r15)
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vceqg %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vceqg %v1, %v3, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = icmp eq <16 x i64> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

define <16 x double> @fun193(<16 x i16> %val1, <16 x i16> %val2, <16 x float> %val3, <16 x float> %val4, <16 x double> %val5, <16 x double> %val6) {
; CHECK-LABEL: fun193:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 160(%r15)
; CHECK-NEXT:    vmrlf %v1, %v0, %v0
; CHECK-NEXT:    vmrlf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v1, %v1
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vfchdb %v1, %v2, %v1
; CHECK-NEXT:    vmrhf %v0, %v0, %v0
; CHECK-NEXT:    vmrhf %v2, %v25, %v25
; CHECK-NEXT:    vldeb %v0, %v0
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vl %v4, 224(%r15)
; CHECK-NEXT:    vl %v5, 416(%r15)
; CHECK-NEXT:    vl %v6, 288(%r15)
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vpkg %v0, %v0, %v1
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vuphf %v2, %v0
; CHECK-NEXT:    vsel %v24, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrlf %v4, %v27, %v27
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vmrlg %v0, %v0, %v0
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v27, %v27
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vl %v4, 256(%r15)
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vl %v3, 384(%r15)
; CHECK-NEXT:    vx %v1, %v1, %v2
; CHECK-NEXT:    vuphf %v2, %v1
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v2
; CHECK-NEXT:    vl %v2, 192(%r15)
; CHECK-NEXT:    vmrlf %v3, %v2, %v2
; CHECK-NEXT:    vmrlf %v4, %v29, %v29
; CHECK-NEXT:    vmrhf %v2, %v2, %v2
; CHECK-NEXT:    vldeb %v3, %v3
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v3, %v4, %v3
; CHECK-NEXT:    vmrhf %v4, %v29, %v29
; CHECK-NEXT:    vldeb %v2, %v2
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vfchdb %v2, %v4, %v2
; CHECK-NEXT:    vpkg %v2, %v2, %v3
; CHECK-NEXT:    vceqh %v3, %v26, %v30
; CHECK-NEXT:    vuphh %v4, %v3
; CHECK-NEXT:    vx %v2, %v4, %v2
; CHECK-NEXT:    vuphf %v4, %v2
; CHECK-NEXT:    vsel %v25, %v6, %v5, %v4
; CHECK-NEXT:    vl %v4, 208(%r15)
; CHECK-NEXT:    vmrlf %v5, %v4, %v4
; CHECK-NEXT:    vmrlf %v6, %v31, %v31
; CHECK-NEXT:    vmrhf %v4, %v4, %v4
; CHECK-NEXT:    vmrlg %v3, %v3, %v3
; CHECK-NEXT:    vuphh %v3, %v3
; CHECK-NEXT:    vldeb %v5, %v5
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v5, %v6, %v5
; CHECK-NEXT:    vmrhf %v6, %v31, %v31
; CHECK-NEXT:    vldeb %v4, %v4
; CHECK-NEXT:    vldeb %v6, %v6
; CHECK-NEXT:    vfchdb %v4, %v6, %v4
; CHECK-NEXT:    vl %v6, 320(%r15)
; CHECK-NEXT:    vpkg %v4, %v4, %v5
; CHECK-NEXT:    vl %v5, 448(%r15)
; CHECK-NEXT:    vx %v3, %v3, %v4
; CHECK-NEXT:    vuphf %v4, %v3
; CHECK-NEXT:    vsel %v29, %v6, %v5, %v4
; CHECK-NEXT:    vl %v4, 368(%r15)
; CHECK-NEXT:    vl %v5, 240(%r15)
; CHECK-NEXT:    vsel %v26, %v5, %v4, %v0
; CHECK-NEXT:    vl %v4, 272(%r15)
; CHECK-NEXT:    vmrlg %v0, %v1, %v1
; CHECK-NEXT:    vl %v1, 400(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v30, %v4, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vmrlg %v0, %v2, %v2
; CHECK-NEXT:    vl %v2, 304(%r15)
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v27, %v2, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vl %v2, 336(%r15)
; CHECK-NEXT:    vmrlg %v0, %v3, %v3
; CHECK-NEXT:    vuphf %v0, %v0
; CHECK-NEXT:    vsel %v31, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = fcmp ogt <16 x float> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x double> %val5, <16 x double> %val6
  ret <16 x double> %sel
}

define <16 x i32> @fun194(<16 x i16> %val1, <16 x i16> %val2, <16 x double> %val3, <16 x double> %val4, <16 x i32> %val5, <16 x i32> %val6) {
; CHECK-LABEL: fun194:
; CHECK:       # BB#0:
; CHECK-NEXT:    vl %v0, 240(%r15)
; CHECK-NEXT:    vl %v1, 224(%r15)
; CHECK-NEXT:    vfchdb %v0, %v27, %v0
; CHECK-NEXT:    vfchdb %v1, %v25, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vceqh %v1, %v24, %v28
; CHECK-NEXT:    vuphh %v2, %v1
; CHECK-NEXT:    vx %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 416(%r15)
; CHECK-NEXT:    vl %v3, 352(%r15)
; CHECK-NEXT:    vsel %v24, %v3, %v2, %v0
; CHECK-NEXT:    vl %v0, 304(%r15)
; CHECK-NEXT:    vl %v2, 176(%r15)
; CHECK-NEXT:    vfchdb %v0, %v2, %v0
; CHECK-NEXT:    vl %v2, 288(%r15)
; CHECK-NEXT:    vl %v3, 160(%r15)
; CHECK-NEXT:    vfchdb %v2, %v3, %v2
; CHECK-NEXT:    vpkg %v0, %v2, %v0
; CHECK-NEXT:    vceqh %v2, %v26, %v30
; CHECK-NEXT:    vuphh %v3, %v2
; CHECK-NEXT:    vx %v0, %v3, %v0
; CHECK-NEXT:    vl %v3, 448(%r15)
; CHECK-NEXT:    vl %v4, 384(%r15)
; CHECK-NEXT:    vsel %v28, %v4, %v3, %v0
; CHECK-NEXT:    vl %v0, 272(%r15)
; CHECK-NEXT:    vl %v3, 256(%r15)
; CHECK-NEXT:    vfchdb %v0, %v31, %v0
; CHECK-NEXT:    vfchdb %v3, %v29, %v3
; CHECK-NEXT:    vmrlg %v1, %v1, %v1
; CHECK-NEXT:    vpkg %v0, %v3, %v0
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vl %v3, 368(%r15)
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 432(%r15)
; CHECK-NEXT:    vsel %v26, %v3, %v1, %v0
; CHECK-NEXT:    vl %v0, 336(%r15)
; CHECK-NEXT:    vl %v1, 208(%r15)
; CHECK-NEXT:    vl %v3, 192(%r15)
; CHECK-NEXT:    vfchdb %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 320(%r15)
; CHECK-NEXT:    vfchdb %v1, %v3, %v1
; CHECK-NEXT:    vpkg %v0, %v1, %v0
; CHECK-NEXT:    vmrlg %v1, %v2, %v2
; CHECK-NEXT:    vl %v2, 400(%r15)
; CHECK-NEXT:    vuphh %v1, %v1
; CHECK-NEXT:    vx %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 464(%r15)
; CHECK-NEXT:    vsel %v30, %v2, %v1, %v0
; CHECK-NEXT:    br %r14
  %cmp0 = icmp eq <16 x i16> %val1, %val2
  %cmp1 = fcmp ogt <16 x double> %val3, %val4
  %and = xor <16 x i1> %cmp0, %cmp1
  %sel = select <16 x i1> %and, <16 x i32> %val5, <16 x i32> %val6
  ret <16 x i32> %sel
}

