/**
 * @file cache/entity/version.cpp
 * @author Peter Rockai <me@mornfall.net>
 */
#include <apt-front/cache/entity/version.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/packages.h>
#include <apt-front/utils/cast.h>
#include <iostream>

#include <apt-pkg/tagfile.h>  /* used only by completeRecord() */


using namespace std;
using namespace aptFront::cache;
using namespace entity;


std::string Version::completeRecord() {
	return string("Name: ") + package().name() +
		   "\nPriority: not available" +
		   "\nSection: " + section("not available") +
		   "\nInstalled-Size: not available" +
		   "\nMaintainer: " + maintainer("not available") +
		   "\nArchitecture: not available" +
		   "\nVersion: " + versionString("not available") +
		   "\nDepends: not available" +
		   "\nFilename: not available" +
		   "\nSize: not available" +
		   "\nMD5Sum: not available" +
		   "\nDescription: " + longDescription("not available");
}

bool Version::valid() const
{
    return (m_version)
        && (m_version != packageCache().verPtr());
}

pkgCache::VerFileIterator Version::fileList() const
{
    return pkgCache::VerFileIterator
        ( packageCache(),
          packageCache().verFilePtr( m_version->FileList ) );
} // {return VerFileIterator(*Owner,Owner->VerFileP + Ver->FileList);};

Version Version::nextInCache() const
{
    Version v = *this;
    v.m_version = packageCache().verPtr(
        m_version->NextVer );
    return v;
} // {if (Ver != Owner->VerP) Ver = Owner->VerP + Ver->NextVer;};


Version::operator pkgCache::VerIterator() {
    return pkgCache::VerIterator( packageCache(),m_version );
}

void StableVersion::notifyPreRebuild (component::Base *)
{
    m_pkgName = package().name();
    m_pkgVersion = versionString();
}

Version::Version(pkgCache::VerIterator V)
{
    component::Packages &pc = downcast<component::Packages>( V.Cache() );
    setCache( pc.ownerCache() );
    m_version = (pkgCache::Version *) V;
}
void StableVersion::notifyPostRebuild (component::Base *c)
{
    component::Packages &pc = downcast<component::Packages>(c);
    *this = StableVersion( pc.packageByName(m_pkgName).versionByString( m_pkgVersion ) );
}

#ifdef COMPILE_TESTSUITE
#include "test-utils.h"
namespace tut {

    struct versioniterator_shar {
        versioniterator_shar () {
            aptInit ();
            c.open( Cache::OpenDefault | Cache::OpenReadOnly );
        }
        Cache c;
        Version a;
    };
    TESTGRP( versioniterator );

    template<> template<>
    void to::test<1> ()
    {
        Version v;
        Entity i (v);
        ensure( Version::instance (i) );
    }

    template<> template<>
    void to::test<2> ()
    {
        Package p = c.packages().packageByName( "exim4" );
        vector<Version> _v;
        p.versions( back_inserter( _v ));
        Version v = *_v.begin();
        ensure_equals( v.shortDescription(), "An MTA (Mail Transport Agent)" );
    }

    template<> template<>
    void to::test<3> ()
    {
        Package p = c.packages().packageByName( "alsa-utils-0.5" );
        vector<Version> l;
        p.versions( back_inserter( l ));
        ensure( l.empty() );
    }

    template<> template<>
    void to::test<4> ()
    {
        Package p = c.packages().packageByName( "exim4" );
        Package q = c.packages().packageByName( "exim4" );
        Package r = c.packages().packageByName( "exim" );
        vector<Version> l;
        l.clear(); p.versions( back_inserter( l ));
        Version v = *l.begin();
        l.clear(); q.versions( back_inserter( l ));
        Version w = *l.begin();
        l.clear(); r.versions( back_inserter( l ));
        Version x = *l.begin();
        ensure( v == w );
        ensure( v != x );
    }

    template<> template<>
    void to::test<5> ()
    {
        Package p = c.packages().packageByName( "exim4" );
        vector<Version> l;
        l.clear(); p.versions( back_inserter( l ));
        vector<Version>::iterator v = l.begin(),
                                  w = l.end(), x, y = v;
        ++ y;
        if (v != l.end() && w != l.end())
            ensure( *v != *w );
        if (w != l.end() && x != l.end())
            ensure( *w == *x );
        if (w != l.end() && y != l.end())
            ensure( *w == *y );
    }

    template<> template<>
    void to::test<6> ()
    {
        Package p = c.packages().packageByName( "exim4" );
        vector<Version> l;
        l.clear(); p.versions( back_inserter( l ));
        vector<Version>::iterator v = l.begin(), w = v;
        ++ w;
        ensure( v != w );
        if (v != l.end() && w != l.end())
            ensure( *v != *w );
        ++ v;
        ensure( v == w );
        if (v != l.end() && w != l.end())
            ensure( *v == *w );
    }
    template<> template<>
    void to::test<7> ()
    {
        Package p = c.packages().packageByName( "exim4" );
        vector<Version> l;
        l.clear(); p.versions( back_inserter( l ));
        Version v = *l.begin();
        ensure( v.package() == p );
    }
}
#endif

// vim:set ts=4 sw=4:
