package Date::Manip::TZ::eusama00;
# Copyright (c) 2008-2010 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Tue Apr 27 10:29:44 EDT 2010
#    Data version: tzdata2010i
#    Code version: tzcode2010f

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::eusama00 - Support for the Europe/Samara time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION='6.11';

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,3,20,36],'+03:20:36',[3,20,36],
          'LMT',0,[1919,6,30,22,39,23],[1919,7,1,1,59,59],
          '0001010200:00:00','0001010203:20:36','1919063022:39:23','1919070101:59:59' ],
     ],
   1919 =>
     [
        [ [1919,6,30,22,39,24],[1919,7,1,1,39,24],'+03:00:00',[3,0,0],
          'SAMT',0,[1930,6,20,20,59,59],[1930,6,20,23,59,59],
          '1919063022:39:24','1919070101:39:24','1930062020:59:59','1930062023:59:59' ],
     ],
   1930 =>
     [
        [ [1930,6,20,21,0,0],[1930,6,21,1,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1935,1,26,19,59,59],[1935,1,26,23,59,59],
          '1930062021:00:00','1930062101:00:00','1935012619:59:59','1935012623:59:59' ],
     ],
   1935 =>
     [
        [ [1935,1,26,20,0,0],[1935,1,27,0,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1981,3,31,19,59,59],[1981,3,31,23,59,59],
          '1935012620:00:00','1935012700:00:00','1981033119:59:59','1981033123:59:59' ],
     ],
   1981 =>
     [
        [ [1981,3,31,20,0,0],[1981,4,1,1,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1981,9,30,18,59,59],[1981,9,30,23,59,59],
          '1981033120:00:00','1981040101:00:00','1981093018:59:59','1981093023:59:59' ],
        [ [1981,9,30,19,0,0],[1981,9,30,23,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1982,3,31,19,59,59],[1982,3,31,23,59,59],
          '1981093019:00:00','1981093023:00:00','1982033119:59:59','1982033123:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,31,20,0,0],[1982,4,1,1,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1982,9,30,18,59,59],[1982,9,30,23,59,59],
          '1982033120:00:00','1982040101:00:00','1982093018:59:59','1982093023:59:59' ],
        [ [1982,9,30,19,0,0],[1982,9,30,23,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1983,3,31,19,59,59],[1983,3,31,23,59,59],
          '1982093019:00:00','1982093023:00:00','1983033119:59:59','1983033123:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,31,20,0,0],[1983,4,1,1,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1983,9,30,18,59,59],[1983,9,30,23,59,59],
          '1983033120:00:00','1983040101:00:00','1983093018:59:59','1983093023:59:59' ],
        [ [1983,9,30,19,0,0],[1983,9,30,23,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1984,3,31,19,59,59],[1984,3,31,23,59,59],
          '1983093019:00:00','1983093023:00:00','1984033119:59:59','1984033123:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,31,20,0,0],[1984,4,1,1,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1984,9,29,21,59,59],[1984,9,30,2,59,59],
          '1984033120:00:00','1984040101:00:00','1984092921:59:59','1984093002:59:59' ],
        [ [1984,9,29,22,0,0],[1984,9,30,2,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1985,3,30,21,59,59],[1985,3,31,1,59,59],
          '1984092922:00:00','1984093002:00:00','1985033021:59:59','1985033101:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,30,22,0,0],[1985,3,31,3,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1985,9,28,21,59,59],[1985,9,29,2,59,59],
          '1985033022:00:00','1985033103:00:00','1985092821:59:59','1985092902:59:59' ],
        [ [1985,9,28,22,0,0],[1985,9,29,2,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1986,3,29,21,59,59],[1986,3,30,1,59,59],
          '1985092822:00:00','1985092902:00:00','1986032921:59:59','1986033001:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,29,22,0,0],[1986,3,30,3,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1986,9,27,21,59,59],[1986,9,28,2,59,59],
          '1986032922:00:00','1986033003:00:00','1986092721:59:59','1986092802:59:59' ],
        [ [1986,9,27,22,0,0],[1986,9,28,2,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1987,3,28,21,59,59],[1987,3,29,1,59,59],
          '1986092722:00:00','1986092802:00:00','1987032821:59:59','1987032901:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,28,22,0,0],[1987,3,29,3,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1987,9,26,21,59,59],[1987,9,27,2,59,59],
          '1987032822:00:00','1987032903:00:00','1987092621:59:59','1987092702:59:59' ],
        [ [1987,9,26,22,0,0],[1987,9,27,2,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1988,3,26,21,59,59],[1988,3,27,1,59,59],
          '1987092622:00:00','1987092702:00:00','1988032621:59:59','1988032701:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,26,22,0,0],[1988,3,27,3,0,0],'+05:00:00',[5,0,0],
          'KUYST',1,[1988,9,24,21,59,59],[1988,9,25,2,59,59],
          '1988032622:00:00','1988032703:00:00','1988092421:59:59','1988092502:59:59' ],
        [ [1988,9,24,22,0,0],[1988,9,25,2,0,0],'+04:00:00',[4,0,0],
          'KUYT',0,[1989,3,25,21,59,59],[1989,3,26,1,59,59],
          '1988092422:00:00','1988092502:00:00','1989032521:59:59','1989032601:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,25,22,0,0],[1989,3,26,2,0,0],'+04:00:00',[4,0,0],
          'KUYST',1,[1989,9,23,22,59,59],[1989,9,24,2,59,59],
          '1989032522:00:00','1989032602:00:00','1989092322:59:59','1989092402:59:59' ],
        [ [1989,9,23,23,0,0],[1989,9,24,2,0,0],'+03:00:00',[3,0,0],
          'KUYT',0,[1990,3,24,22,59,59],[1990,3,25,1,59,59],
          '1989092323:00:00','1989092402:00:00','1990032422:59:59','1990032501:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,24,23,0,0],[1990,3,25,3,0,0],'+04:00:00',[4,0,0],
          'KUYST',1,[1990,9,29,22,59,59],[1990,9,30,2,59,59],
          '1990032423:00:00','1990032503:00:00','1990092922:59:59','1990093002:59:59' ],
        [ [1990,9,29,23,0,0],[1990,9,30,2,0,0],'+03:00:00',[3,0,0],
          'KUYT',0,[1991,3,30,22,59,59],[1991,3,31,1,59,59],
          '1990092923:00:00','1990093002:00:00','1991033022:59:59','1991033101:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,30,23,0,0],[1991,3,31,2,0,0],'+03:00:00',[3,0,0],
          'KUYST',1,[1991,9,28,23,59,59],[1991,9,29,2,59,59],
          '1991033023:00:00','1991033102:00:00','1991092823:59:59','1991092902:59:59' ],
        [ [1991,9,29,0,0,0],[1991,9,29,3,0,0],'+03:00:00',[3,0,0],
          'KUYT',0,[1991,10,19,23,59,59],[1991,10,20,2,59,59],
          '1991092900:00:00','1991092903:00:00','1991101923:59:59','1991102002:59:59' ],
        [ [1991,10,20,0,0,0],[1991,10,20,4,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1992,3,28,18,59,59],[1992,3,28,22,59,59],
          '1991102000:00:00','1991102004:00:00','1992032818:59:59','1992032822:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,28,19,0,0],[1992,3,29,0,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1992,9,26,17,59,59],[1992,9,26,22,59,59],
          '1992032819:00:00','1992032900:00:00','1992092617:59:59','1992092622:59:59' ],
        [ [1992,9,26,18,0,0],[1992,9,26,22,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1993,3,27,21,59,59],[1993,3,28,1,59,59],
          '1992092618:00:00','1992092622:00:00','1993032721:59:59','1993032801:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,27,22,0,0],[1993,3,28,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1993,9,25,21,59,59],[1993,9,26,2,59,59],
          '1993032722:00:00','1993032803:00:00','1993092521:59:59','1993092602:59:59' ],
        [ [1993,9,25,22,0,0],[1993,9,26,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1994,3,26,21,59,59],[1994,3,27,1,59,59],
          '1993092522:00:00','1993092602:00:00','1994032621:59:59','1994032701:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,26,22,0,0],[1994,3,27,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1994,9,24,21,59,59],[1994,9,25,2,59,59],
          '1994032622:00:00','1994032703:00:00','1994092421:59:59','1994092502:59:59' ],
        [ [1994,9,24,22,0,0],[1994,9,25,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1995,3,25,21,59,59],[1995,3,26,1,59,59],
          '1994092422:00:00','1994092502:00:00','1995032521:59:59','1995032601:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,25,22,0,0],[1995,3,26,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1995,9,23,21,59,59],[1995,9,24,2,59,59],
          '1995032522:00:00','1995032603:00:00','1995092321:59:59','1995092402:59:59' ],
        [ [1995,9,23,22,0,0],[1995,9,24,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1996,3,30,21,59,59],[1996,3,31,1,59,59],
          '1995092322:00:00','1995092402:00:00','1996033021:59:59','1996033101:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,30,22,0,0],[1996,3,31,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1996,10,26,21,59,59],[1996,10,27,2,59,59],
          '1996033022:00:00','1996033103:00:00','1996102621:59:59','1996102702:59:59' ],
        [ [1996,10,26,22,0,0],[1996,10,27,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1997,3,29,21,59,59],[1997,3,30,1,59,59],
          '1996102622:00:00','1996102702:00:00','1997032921:59:59','1997033001:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,29,22,0,0],[1997,3,30,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1997,10,25,21,59,59],[1997,10,26,2,59,59],
          '1997032922:00:00','1997033003:00:00','1997102521:59:59','1997102602:59:59' ],
        [ [1997,10,25,22,0,0],[1997,10,26,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1998,3,28,21,59,59],[1998,3,29,1,59,59],
          '1997102522:00:00','1997102602:00:00','1998032821:59:59','1998032901:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,28,22,0,0],[1998,3,29,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1998,10,24,21,59,59],[1998,10,25,2,59,59],
          '1998032822:00:00','1998032903:00:00','1998102421:59:59','1998102502:59:59' ],
        [ [1998,10,24,22,0,0],[1998,10,25,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[1999,3,27,21,59,59],[1999,3,28,1,59,59],
          '1998102422:00:00','1998102502:00:00','1999032721:59:59','1999032801:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,27,22,0,0],[1999,3,28,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[1999,10,30,21,59,59],[1999,10,31,2,59,59],
          '1999032722:00:00','1999032803:00:00','1999103021:59:59','1999103102:59:59' ],
        [ [1999,10,30,22,0,0],[1999,10,31,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2000,3,25,21,59,59],[2000,3,26,1,59,59],
          '1999103022:00:00','1999103102:00:00','2000032521:59:59','2000032601:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,25,22,0,0],[2000,3,26,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2000,10,28,21,59,59],[2000,10,29,2,59,59],
          '2000032522:00:00','2000032603:00:00','2000102821:59:59','2000102902:59:59' ],
        [ [2000,10,28,22,0,0],[2000,10,29,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2001,3,24,21,59,59],[2001,3,25,1,59,59],
          '2000102822:00:00','2000102902:00:00','2001032421:59:59','2001032501:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,24,22,0,0],[2001,3,25,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2001,10,27,21,59,59],[2001,10,28,2,59,59],
          '2001032422:00:00','2001032503:00:00','2001102721:59:59','2001102802:59:59' ],
        [ [2001,10,27,22,0,0],[2001,10,28,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2002,3,30,21,59,59],[2002,3,31,1,59,59],
          '2001102722:00:00','2001102802:00:00','2002033021:59:59','2002033101:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,30,22,0,0],[2002,3,31,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2002,10,26,21,59,59],[2002,10,27,2,59,59],
          '2002033022:00:00','2002033103:00:00','2002102621:59:59','2002102702:59:59' ],
        [ [2002,10,26,22,0,0],[2002,10,27,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2003,3,29,21,59,59],[2003,3,30,1,59,59],
          '2002102622:00:00','2002102702:00:00','2003032921:59:59','2003033001:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,29,22,0,0],[2003,3,30,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2003,10,25,21,59,59],[2003,10,26,2,59,59],
          '2003032922:00:00','2003033003:00:00','2003102521:59:59','2003102602:59:59' ],
        [ [2003,10,25,22,0,0],[2003,10,26,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2004,3,27,21,59,59],[2004,3,28,1,59,59],
          '2003102522:00:00','2003102602:00:00','2004032721:59:59','2004032801:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,27,22,0,0],[2004,3,28,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2004,10,30,21,59,59],[2004,10,31,2,59,59],
          '2004032722:00:00','2004032803:00:00','2004103021:59:59','2004103102:59:59' ],
        [ [2004,10,30,22,0,0],[2004,10,31,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2005,3,26,21,59,59],[2005,3,27,1,59,59],
          '2004103022:00:00','2004103102:00:00','2005032621:59:59','2005032701:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,26,22,0,0],[2005,3,27,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2005,10,29,21,59,59],[2005,10,30,2,59,59],
          '2005032622:00:00','2005032703:00:00','2005102921:59:59','2005103002:59:59' ],
        [ [2005,10,29,22,0,0],[2005,10,30,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2006,3,25,21,59,59],[2006,3,26,1,59,59],
          '2005102922:00:00','2005103002:00:00','2006032521:59:59','2006032601:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,25,22,0,0],[2006,3,26,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2006,10,28,21,59,59],[2006,10,29,2,59,59],
          '2006032522:00:00','2006032603:00:00','2006102821:59:59','2006102902:59:59' ],
        [ [2006,10,28,22,0,0],[2006,10,29,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2007,3,24,21,59,59],[2007,3,25,1,59,59],
          '2006102822:00:00','2006102902:00:00','2007032421:59:59','2007032501:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,24,22,0,0],[2007,3,25,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2007,10,27,21,59,59],[2007,10,28,2,59,59],
          '2007032422:00:00','2007032503:00:00','2007102721:59:59','2007102802:59:59' ],
        [ [2007,10,27,22,0,0],[2007,10,28,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2008,3,29,21,59,59],[2008,3,30,1,59,59],
          '2007102722:00:00','2007102802:00:00','2008032921:59:59','2008033001:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,29,22,0,0],[2008,3,30,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2008,10,25,21,59,59],[2008,10,26,2,59,59],
          '2008032922:00:00','2008033003:00:00','2008102521:59:59','2008102602:59:59' ],
        [ [2008,10,25,22,0,0],[2008,10,26,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2009,3,28,21,59,59],[2009,3,29,1,59,59],
          '2008102522:00:00','2008102602:00:00','2009032821:59:59','2009032901:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,28,22,0,0],[2009,3,29,3,0,0],'+05:00:00',[5,0,0],
          'SAMST',1,[2009,10,24,21,59,59],[2009,10,25,2,59,59],
          '2009032822:00:00','2009032903:00:00','2009102421:59:59','2009102502:59:59' ],
        [ [2009,10,24,22,0,0],[2009,10,25,2,0,0],'+04:00:00',[4,0,0],
          'SAMT',0,[2010,3,27,21,59,59],[2010,3,28,1,59,59],
          '2009102422:00:00','2009102502:00:00','2010032721:59:59','2010032801:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,27,22,0,0],[2010,3,28,2,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2010,10,30,22,59,59],[2010,10,31,2,59,59],
          '2010032722:00:00','2010032802:00:00','2010103022:59:59','2010103102:59:59' ],
        [ [2010,10,30,23,0,0],[2010,10,31,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2011,3,26,22,59,59],[2011,3,27,1,59,59],
          '2010103023:00:00','2010103102:00:00','2011032622:59:59','2011032701:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,26,23,0,0],[2011,3,27,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2011,10,29,22,59,59],[2011,10,30,2,59,59],
          '2011032623:00:00','2011032703:00:00','2011102922:59:59','2011103002:59:59' ],
        [ [2011,10,29,23,0,0],[2011,10,30,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2012,3,24,22,59,59],[2012,3,25,1,59,59],
          '2011102923:00:00','2011103002:00:00','2012032422:59:59','2012032501:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,24,23,0,0],[2012,3,25,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2012,10,27,22,59,59],[2012,10,28,2,59,59],
          '2012032423:00:00','2012032503:00:00','2012102722:59:59','2012102802:59:59' ],
        [ [2012,10,27,23,0,0],[2012,10,28,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2013,3,30,22,59,59],[2013,3,31,1,59,59],
          '2012102723:00:00','2012102802:00:00','2013033022:59:59','2013033101:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,30,23,0,0],[2013,3,31,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2013,10,26,22,59,59],[2013,10,27,2,59,59],
          '2013033023:00:00','2013033103:00:00','2013102622:59:59','2013102702:59:59' ],
        [ [2013,10,26,23,0,0],[2013,10,27,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2014,3,29,22,59,59],[2014,3,30,1,59,59],
          '2013102623:00:00','2013102702:00:00','2014032922:59:59','2014033001:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,29,23,0,0],[2014,3,30,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2014,10,25,22,59,59],[2014,10,26,2,59,59],
          '2014032923:00:00','2014033003:00:00','2014102522:59:59','2014102602:59:59' ],
        [ [2014,10,25,23,0,0],[2014,10,26,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2015,3,28,22,59,59],[2015,3,29,1,59,59],
          '2014102523:00:00','2014102602:00:00','2015032822:59:59','2015032901:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,28,23,0,0],[2015,3,29,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2015,10,24,22,59,59],[2015,10,25,2,59,59],
          '2015032823:00:00','2015032903:00:00','2015102422:59:59','2015102502:59:59' ],
        [ [2015,10,24,23,0,0],[2015,10,25,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2016,3,26,22,59,59],[2016,3,27,1,59,59],
          '2015102423:00:00','2015102502:00:00','2016032622:59:59','2016032701:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,26,23,0,0],[2016,3,27,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2016,10,29,22,59,59],[2016,10,30,2,59,59],
          '2016032623:00:00','2016032703:00:00','2016102922:59:59','2016103002:59:59' ],
        [ [2016,10,29,23,0,0],[2016,10,30,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2017,3,25,22,59,59],[2017,3,26,1,59,59],
          '2016102923:00:00','2016103002:00:00','2017032522:59:59','2017032601:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,25,23,0,0],[2017,3,26,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2017,10,28,22,59,59],[2017,10,29,2,59,59],
          '2017032523:00:00','2017032603:00:00','2017102822:59:59','2017102902:59:59' ],
        [ [2017,10,28,23,0,0],[2017,10,29,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2018,3,24,22,59,59],[2018,3,25,1,59,59],
          '2017102823:00:00','2017102902:00:00','2018032422:59:59','2018032501:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,24,23,0,0],[2018,3,25,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2018,10,27,22,59,59],[2018,10,28,2,59,59],
          '2018032423:00:00','2018032503:00:00','2018102722:59:59','2018102802:59:59' ],
        [ [2018,10,27,23,0,0],[2018,10,28,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2019,3,30,22,59,59],[2019,3,31,1,59,59],
          '2018102723:00:00','2018102802:00:00','2019033022:59:59','2019033101:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,30,23,0,0],[2019,3,31,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2019,10,26,22,59,59],[2019,10,27,2,59,59],
          '2019033023:00:00','2019033103:00:00','2019102622:59:59','2019102702:59:59' ],
        [ [2019,10,26,23,0,0],[2019,10,27,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2020,3,28,22,59,59],[2020,3,29,1,59,59],
          '2019102623:00:00','2019102702:00:00','2020032822:59:59','2020032901:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,28,23,0,0],[2020,3,29,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2020,10,24,22,59,59],[2020,10,25,2,59,59],
          '2020032823:00:00','2020032903:00:00','2020102422:59:59','2020102502:59:59' ],
        [ [2020,10,24,23,0,0],[2020,10,25,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2021,3,27,22,59,59],[2021,3,28,1,59,59],
          '2020102423:00:00','2020102502:00:00','2021032722:59:59','2021032801:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,27,23,0,0],[2021,3,28,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2021,10,30,22,59,59],[2021,10,31,2,59,59],
          '2021032723:00:00','2021032803:00:00','2021103022:59:59','2021103102:59:59' ],
        [ [2021,10,30,23,0,0],[2021,10,31,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2022,3,26,22,59,59],[2022,3,27,1,59,59],
          '2021103023:00:00','2021103102:00:00','2022032622:59:59','2022032701:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,26,23,0,0],[2022,3,27,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2022,10,29,22,59,59],[2022,10,30,2,59,59],
          '2022032623:00:00','2022032703:00:00','2022102922:59:59','2022103002:59:59' ],
        [ [2022,10,29,23,0,0],[2022,10,30,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2023,3,25,22,59,59],[2023,3,26,1,59,59],
          '2022102923:00:00','2022103002:00:00','2023032522:59:59','2023032601:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,25,23,0,0],[2023,3,26,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2023,10,28,22,59,59],[2023,10,29,2,59,59],
          '2023032523:00:00','2023032603:00:00','2023102822:59:59','2023102902:59:59' ],
        [ [2023,10,28,23,0,0],[2023,10,29,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2024,3,30,22,59,59],[2024,3,31,1,59,59],
          '2023102823:00:00','2023102902:00:00','2024033022:59:59','2024033101:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,30,23,0,0],[2024,3,31,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2024,10,26,22,59,59],[2024,10,27,2,59,59],
          '2024033023:00:00','2024033103:00:00','2024102622:59:59','2024102702:59:59' ],
        [ [2024,10,26,23,0,0],[2024,10,27,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2025,3,29,22,59,59],[2025,3,30,1,59,59],
          '2024102623:00:00','2024102702:00:00','2025032922:59:59','2025033001:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,29,23,0,0],[2025,3,30,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2025,10,25,22,59,59],[2025,10,26,2,59,59],
          '2025032923:00:00','2025033003:00:00','2025102522:59:59','2025102602:59:59' ],
        [ [2025,10,25,23,0,0],[2025,10,26,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2026,3,28,22,59,59],[2026,3,29,1,59,59],
          '2025102523:00:00','2025102602:00:00','2026032822:59:59','2026032901:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,28,23,0,0],[2026,3,29,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2026,10,24,22,59,59],[2026,10,25,2,59,59],
          '2026032823:00:00','2026032903:00:00','2026102422:59:59','2026102502:59:59' ],
        [ [2026,10,24,23,0,0],[2026,10,25,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2027,3,27,22,59,59],[2027,3,28,1,59,59],
          '2026102423:00:00','2026102502:00:00','2027032722:59:59','2027032801:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,27,23,0,0],[2027,3,28,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2027,10,30,22,59,59],[2027,10,31,2,59,59],
          '2027032723:00:00','2027032803:00:00','2027103022:59:59','2027103102:59:59' ],
        [ [2027,10,30,23,0,0],[2027,10,31,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2028,3,25,22,59,59],[2028,3,26,1,59,59],
          '2027103023:00:00','2027103102:00:00','2028032522:59:59','2028032601:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,25,23,0,0],[2028,3,26,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2028,10,28,22,59,59],[2028,10,29,2,59,59],
          '2028032523:00:00','2028032603:00:00','2028102822:59:59','2028102902:59:59' ],
        [ [2028,10,28,23,0,0],[2028,10,29,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2029,3,24,22,59,59],[2029,3,25,1,59,59],
          '2028102823:00:00','2028102902:00:00','2029032422:59:59','2029032501:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,24,23,0,0],[2029,3,25,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2029,10,27,22,59,59],[2029,10,28,2,59,59],
          '2029032423:00:00','2029032503:00:00','2029102722:59:59','2029102802:59:59' ],
        [ [2029,10,27,23,0,0],[2029,10,28,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2030,3,30,22,59,59],[2030,3,31,1,59,59],
          '2029102723:00:00','2029102802:00:00','2030033022:59:59','2030033101:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,30,23,0,0],[2030,3,31,3,0,0],'+04:00:00',[4,0,0],
          'SAMST',1,[2030,10,26,22,59,59],[2030,10,27,2,59,59],
          '2030033023:00:00','2030033103:00:00','2030102622:59:59','2030102702:59:59' ],
        [ [2030,10,26,23,0,0],[2030,10,27,2,0,0],'+03:00:00',[3,0,0],
          'SAMT',0,[2031,3,29,22,59,59],[2031,3,30,1,59,59],
          '2030102623:00:00','2030102702:00:00','2031032922:59:59','2031033001:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+04:00:00',
                'stdoff' => '+03:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 's',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'SAMST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 's',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'SAMT',
                        },
               },
);

1;
