/*
 * Ready-made utility classes for Debtags
 *
 * Copyright (C) 2003--2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#if 0
#include <apt-front/cache/component/debtags/utils.h>
#include <apt-front/cache/component/tagmap.h>

#include <tagcoll/SmartHierarchy.h>
#if 0
#include <debtags/Filters.h>
#endif

using namespace Tagcoll;
using namespace std;
using namespace aptFront;
using namespace cache;
using namespace component;
using namespace debtags;

template<class ITEM>
static OpSet<ITEM> getItems(HierarchyNode<ITEM, entity::Facet>* node)
{
	OpSet<ITEM> items = node->getItems();

	for (typename HierarchyNode<ITEM, entity::Facet>::iterator i = node->begin();
			i != node->end(); i++)
		items += getItems(*i);

	return items;
}

template<class ITEM>
void SearchHelper<ITEM>::storeTag(const entity::Tag& tag, int card, int idx)
{
	if (idx >= dist)
		return;

	if (card == -1)
		card = debtags.tagdb().getCardinality(tag);

	if (cards[idx] < card)
	{
		// Move forward the past ones
		for (int i = dist - 1; i > idx; i--)
		{
			cards[i] = cards[i - 1];
			tags[i] = tags[i - 1];
		}
		cards[idx] = card;
		tags[idx] = tag;
	} else {
		storeTag(tag, card, idx + 1);
	}
}

template<class ITEM>
void SearchHelper<ITEM>::compute()
{
	fprintf(stderr, "Start computing 1\n");
	// Compute list of unwanted items from their tags
	OpSet<ITEM> punwanted;
	for (OpSet<entity::Tag>::const_iterator i = unwanted.begin();
			i != unwanted.end(); i++)
		punwanted += debtags.tagdb().getItems(*i);

	// Perform the search
	found = startPackages - punwanted;
	if (!wanted.empty())
		found ^= debtags.tagdb().getItems(wanted);

	cardComputer.clear();
	for (typename OpSet<ITEM>::const_iterator i = found.begin(); i != found.end(); i++)
		cardComputer.consume(*i, debtags.tagdb().getTags(*i));

	// Compute the found tags and their cardinality
	/*
	map<Tag, int> cardMap;
	for (typename OpSet<ITEM>::const_iterator i = found.begin();
			i != found.end(); i++)
	{
		fprintf(stderr, "QUI0 %p %p\n", &debtags, &(debtags.tagDB()));
		fprintf(stderr, "QUI0 %.*s\n", PFSTR((*i)));
		//fprintf(stderr, "QUI0 %d\n", debtags.tagDB().getCardinality(*i));
		OpSet<Tag> tags = debtags.tagDB().getTags(*i);
		fprintf(stderr, "QUI1\n");
		for (OpSet<Tag>::const_iterator j = tags.begin();
				j != tags.end(); j++)
		{
		fprintf(stderr, "QUI2\n");
			cardMap[*j]++;
		}
	}
	*/

	// Create the TagCollection with the results
	/*
	coll = TagCollection<ITEM, Tag>();
	debtags.outputPackages(found, coll);
	*/
	/*
	// Create the TagCollection with the results
	coll = TagCollection<ITEM, Tag>();
	for (typename OpSet<ITEM>::const_iterator i = found.begin();
			i != found.end(); i++)
		coll.consume(*i, debtags.tagDB().getTags(*i));
	*/

	// Compute top-<dist> cardinality tags among the ones in getTags(found)
	for (int i = 0; i < dist; i++)
		cards[i] = 0;
	/*
	OpSet<Tag> allTags = coll.getAllTags();
	for (OpSet<Tag>::const_iterator i = allTags.begin();
			i != allTags.end(); i++)
		storeTag(*i, coll.getCardinality(*i));
	*/
	for (map<entity::Tag, int>::const_iterator i = cardComputer.begin();
			i != cardComputer.end(); i++)
		storeTag(i->first, i->second);

	// Store the resulting pivot tags in a tagset
	pivotTags.clear();
	for (int i = 0; i < dist; i++)
		if (cards[i] != 0)
			pivotTags += tags[i];

	// Add the related items from the pivot tags
	OpSet<ITEM> related;
	for (unsigned int i = 0; i < pivotTags.size() && related.empty(); i++)
	{
		fprintf(stderr, "Trying related distance %d\n", i);
		related = debtags.tagdb().getRelatedItems(pivotTags, i);
	}
//			pivotTags.size() > 3 ? pivotTags.size() - 3 : 1);
	found += related;

	fprintf(stderr, "%d related found\n", related.size());

	for (typename OpSet<ITEM>::const_iterator i = related.begin();
			i != related.end(); i++)
		cardComputer.consume(*i, debtags.tagdb().getTags(*i));

	// Recompute top-<dist> cardinality tags
	for (int i = 0; i < dist; i++)
		cards[i] = 0;
	for (map<entity::Tag, int>::const_iterator i = cardComputer.begin();
			i != cardComputer.end(); i++)
		storeTag(i->first, i->second);

	fprintf(stderr, "Recomputed cardinalities\n");
	/*
	allTags = coll.getAllTags();
	for (OpSet<Tag>::const_iterator i = allTags.begin();
			i != allTags.end(); i++)
		storeTag(*i, coll.getCardinality(*i));
	*/

	// Finally store the resulting pivot tags in a tagset
	pivotTags.clear();
	for (int i = 0; i < dist; i++)
		if (cards[i] != 0)
			pivotTags += tags[i];
}


template<class ITEM>
void Specials<ITEM>::compute(/*Status* tracker*/)
{
	if (computed)
		return;

	entity::Facet f;
	SmartHierarchyNode<ITEM, entity::Facet> node(f, coll, 0);

	/*
	if (tracker)
		tracker->setTotal(node.size());
	*/

	OpSet<entity::Facet> seen;
	for (typename HierarchyNode<ITEM, entity::Facet>::iterator i = node.begin();
			i != node.end(); i++)
	{
		OpSet<ITEM> items = getItems(*i);

		// Find the items in this branch that are not present in
		// any of the previous ones
		if (!seen.empty())
		{
			OpSet<ITEM> newItems;
			for (typename OpSet<ITEM>::const_iterator j = items.begin();
					j != items.end() && newItems.size() <= 101; j++)
			{
				OpSet<entity::Facet> facets = coll.getTags(*j);
				bool isSeen = false;
				for (OpSet<entity::Facet>::const_iterator i = facets.begin(); i != facets.end(); i++)
					if (seen.contains(*i))
					{
						isSeen = true;
						break;
					}
				/*
				TagSet tags = j->tags();
				bool isSeen = false;
				for (TagSet::const_iterator i = tags.begin(); i != tags.end(); i++)
					if (seen.contains(i->facet()))
					{
						isSeen = true;
						break;
					}
				*/
				if (!isSeen)
					newItems += *j;
			}

			if (!newItems.empty() && (maxPerGroup == 0 || newItems.size() <= maxPerGroup))
				specials.insert(make_pair<entity::Facet, OpSet<ITEM> >((*i)->tag(), newItems));
		}

		seen += (*i)->tag();

		/*
		if (tracker && !tracker->advance())
		{
			specials.clear();
			return;
		}
		*/
	}

	computed = true;
}

#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace aptFront {
namespace cache {
namespace component {
namespace debtags {
	template class TagToFacet<entity::Package>;
	template class SearchHelper<entity::Package>;
	template class Specials<entity::Package>;
}
}
}
}
#endif


/*
#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>

namespace tut {

struct cache_component_debtags_utils_shar {
};
TESTGRP(cache_component_debtags_utils);

template<> template<>
void to::test<1>()
{
	ensure(false);
}

}

#endif
*/

#endif // 0
// vim:set ts=4 sw=4:
