require 'rexml/document'
include REXML

class Generator

  Blacklist = /Amorph/
  Prefix  = "Apt"
  Blacklist2 = /AptPackages|AptEntity|AptNamedEntity/

  def output( id, typedef = "", level = 0 )
    ids = []
    
    el = @namespace[ id ];
    
    if el == nil
      el = @typedef[ id ];
      unless el == nil
        ids = el.attributes[ "type" ].split( / / );
        typedef = el.attributes[ "name" ] if ( typedef == "" );
      end
    else
      ids = el.attributes[ "members" ].split( / / ) unless el == nil
    end
    
    ids.each { |i|
      output( i.to_i, typedef, level ) }
    ids = []
    
    el = @struct[ id ];
    unless el == nil
      
      mangled = el.attributes[ "mangled" ];
      ids = el.attributes[ "bases" ].split( / / ) if el.attributes[ "bases" ];
      
      ids.each { |i|
        output( i.to_i, typedef, level + 1 ) }
      
      demangled = `echo "#{mangled}" | c++filt -t`
      
      unless Blacklist.match( demangled ) || Blacklist2.match( Prefix + typedef )
        if ( level == 0 )
          puts "%template( " + Prefix + typedef + " ) " + demangled.chomp() + "; // " + typedef
        else
          puts "%template( MANGLED_" + mangled + " ) " + demangled.chomp() + "; // " + typedef
        end
      end
      
    end
  end

  def gccxml()
    $stderr.puts "calling gccxml on ept.cpp..."
    system( "gccxml -DWIBBLE_AMORPH_PADDING=1 -fxml=ept.xml -I/usr/include/sigc++-2.0 -I/usr/lib/sigc++-2.0/include -I.. -I../_build/default/ ./ept.cpp" )
  end
  
  def load()
    $stderr.puts "loading up ept.xml..."
    @doc = Document.new( File.new( "ept.xml" ) )

    $stderr.puts "hashing up interesting elements..."
    @namespace = Hash.new
    @typedef = Hash.new
    @struct = Hash.new

    @doc.root.elements.each { |el|
      @namespace[ el.attributes[ "id" ].to_i ] = el if el.name == "Namespace"
      @typedef[ el.attributes[ "id" ].to_i ] = el if el.name == "Typedef"
      @struct[ el.attributes[ "id" ].to_i ] = el if el.name == "Struct"
    }
  end

  def generate( conf )
    gccxml()
    load()
    $stderr.puts "generating output..."
    output( @doc.root.elements["Namespace[@mangled='" + conf + "']" ].attributes[ "id" ].to_i )
  end

end

gen = Generator.new
gen.generate( "_ZN3ept13configuration3aptE" )

