/*
 * Match tag expressions against sets of Debtags Tags
 *
 * Copyright (C) 2005,2006,2007  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ept/tests/test-utils.h>
#include <ept/debtags/maint/path.h>
#include <ept/debtags/expression.h>
#include <ept/debtags/vocabulary.h>

namespace tut {

using namespace tagcoll;
using namespace std;
using namespace ept::debtags;

struct ept_debtags_expression_shar {
	Path::OverrideDebtagsSourceDir odsd;
	Path::OverrideDebtagsIndexDir odid;
	Path::OverrideDebtagsUserSourceDir odusd;
	Path::OverrideDebtagsUserIndexDir oduid;

	Vocabulary voc;

	ept_debtags_expression_shar()
		: odsd("./"), odid("./"), odusd("./"), oduid("./") {}
};
TESTGRP(ept_debtags_expression);


template<> template<>
void to::test< 1 >()
{
	set<Tag> test;
	test.insert(voc.tagByName("use::editing"));
	test.insert(voc.tagByName("use::viewing"));
	test.insert(voc.tagByName("works-with::text"));

	ensure_equals(test.size(), 3u);

	Expression e1("use::editing");
	ensure(e1(test));

	Expression e2("use::editing && use::viewing");
	ensure(e2(test));

	e1 = Expression("!use::editing");
	ensure(!e1(test));

	e1 = Expression("use::editing || sugo");
	ensure(e1(test));

	e1 = Expression("use::editing && !sugo");
	ensure(e1(test));

	e1 = Expression("use::editing && !use::viewing");
	ensure(!e1(test));

	e1 = Expression("(use::editing || sugo) && (use::viewing && works-with::text)");
	ensure(e1(test));

	e1 = Expression("!(use::editinuse::editingra && works-with::text)");
	ensure(e1(test));

	e1 = Expression("works-with::*");
	ensure(e1(test));

	e1 = Expression("*::text");
	ensure(e1(test));

	e1 = Expression("!*::antani");
	ensure(e1(test));

	e1 = Expression("*::antani");
	ensure(!e1(test));
}

}

// vim:set ts=4 sw=4:
