// -*- mode: c++; tab-width: 4; indent-tabs-mode: t -*-
/*
 * popcon/local test
 *
 * Copyright (C) 2007  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ept/tests/test-utils.h>
#include <ept/popcon/local.h>
#include <ept/popcon/popcon.h>
#include <ept/popcon/maint/path.h>

using namespace std;
using namespace ept;
using namespace ept::popcon;

namespace tut {

struct ept_popcon_local_shar
{
	Path::OverridePopconSourceDir odsd;
	Path::OverridePopconIndexDir odid;
	Path::OverridePopconUserSourceDir odusd;
	Path::OverridePopconUserIndexDir oduid;
	Popcon popcon;
	Local local;

	ept_popcon_local_shar()
		: odsd("./"), odid("./"), odusd("./"), oduid("./"), local("./popularity-contest") {}
};
TESTGRP(ept_popcon_local);

// Very basic access
template<> template<>
void to::test< 1 >()
{
	ensure(local.score("apt") > 0);
	ensure(local.tfidf(popcon, "apt") > 0);
}

#if 0
// Check that every valid index is accessible
template<> template<>
void to::test< 2 >()
{
	for (size_t i = 0; i < popcon.size(); ++i)
	{
		//cerr << popcon.name(i) << " " << popcon.score(i) << endl;
		ensure(popcon.score(i) > 0);
	}
}

// Check that we can get a score for every package
template<> template<>
void to::test< 3 >()
{
	int has = 0;
	for (Apt::iterator i = apt.begin(); i != apt.end(); ++i)
	{
		float score = popcon.score(*i);
		if (score > 0)
			++has;
	}
	// At least 1000 packages should have a score
	ensure(has > 1000);
}

// Check that scores are meaningful
template<> template<>
void to::test< 4 >()
{
	ensure(popcon["apt"] > popcon["libapt-pkg-dev"]);
}

// If there is no data, Popcon should work as if all scores were 0
template<> template<>
void to::test<5>()
{
	Path::OverridePopconSourceDir odsd("./empty");
	Path::OverridePopconIndexDir odid("./empty");
	Path::OverridePopconUserSourceDir odusd("./empty");
	Path::OverridePopconUserIndexDir oduid("./empty");
	Popcon empty;

	ensure_equals(empty.timestamp(), 0);
	ensure(!empty.hasData());

	ensure(empty.size() == 0);
	ensure(empty.score("apt") == 0.0);
}
#endif

}

// vim:set ts=4 sw=4:
