/* testcollection.c generated by valac 0.9.8.14-51a7, the Vala compiler
 * generated from testcollection.vala, do not modify */

/* testcollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
enum  {
	COLLECTION_TESTS_DUMMY_PROPERTY
};
CollectionTests* collection_tests_construct (GType object_type, const char* name);
GeeTestCase* gee_test_case_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void collection_tests_test_type_correctness (CollectionTests* self);
static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self);
static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self);
void collection_tests_test_mutable_iterator (CollectionTests* self);
static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_size_and_is_empty (CollectionTests* self);
static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_remove (CollectionTests* self);
static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self);
void collection_tests_test_clear (CollectionTests* self);
static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_all (CollectionTests* self);
static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_all (CollectionTests* self);
static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_remove_all (CollectionTests* self);
static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_retain_all (CollectionTests* self);
static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_to_array (CollectionTests* self);
static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self);
void collection_tests_test_gobject_properties (CollectionTests* self);
static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
static void collection_tests_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self) {
	collection_tests_test_type_correctness (self);
}


static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self) {
	collection_tests_test_iterator_returns_all_elements_once (self);
}


static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self) {
	collection_tests_test_mutable_iterator (self);
}


static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_size_and_is_empty (self);
}


static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_remove (self);
}


static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self) {
	collection_tests_test_clear (self);
}


static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_all (self);
}


static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_all (self);
}


static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_remove_all (self);
}


static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_retain_all (self);
}


static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self) {
	collection_tests_test_to_array (self);
}


static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	collection_tests_test_gobject_properties (self);
}


CollectionTests* collection_tests_construct (GType object_type, const char* name) {
	CollectionTests * self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (CollectionTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] type correctness", _collection_tests_test_type_correctness_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator returns all elements once", _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] mutable iterator", _collection_tests_test_mutable_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains, size and is_empty", _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add and remove", _collection_tests_test_add_remove_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _collection_tests_test_clear_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add_all", _collection_tests_test_add_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains_all", _collection_tests_test_contains_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove_all", _collection_tests_test_remove_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] retain_all", _collection_tests_test_retain_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] to_array", _collection_tests_test_to_array_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] GObject properties", _collection_tests_test_gobject_properties_gee_test_case_test_method, self);
	return self;
}


void collection_tests_test_type_correctness (CollectionTests* self) {
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	g_assert (gee_iterable_get_element_type ((GeeIterable*) self->test_collection) == G_TYPE_STRING);
}


void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self) {
	gboolean has_next = FALSE;
	GeeIterator* iterator;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	iterator = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	g_assert (!gee_iterator_has_next (iterator));
	g_assert (!gee_iterator_next (iterator));
	g_assert (!gee_iterator_first (iterator));
	g_assert (gee_collection_add (self->test_collection, "one"));
	g_assert (gee_collection_add (self->test_collection, "two"));
	g_assert (gee_collection_add (self->test_collection, "three"));
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	iterator = (_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->test_collection), _g_object_unref0 (iterator), _tmp0_);
	while (TRUE) {
		char* element;
		has_next = gee_iterator_has_next (iterator);
		g_assert (has_next == gee_iterator_next (iterator));
		if (!has_next) {
			break;
		}
		element = (char*) gee_iterator_get (iterator);
		if (_vala_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (_vala_strcmp0 (element, "two") == 0) {
				if (two_found) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				if (_vala_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	has_next = gee_iterator_has_next (iterator);
	g_assert (!has_next);
	g_assert (has_next == gee_iterator_next (iterator));
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (two_found);
	g_assert (two_found_once);
	g_assert (three_found);
	g_assert (three_found_once);
	g_assert (gee_iterator_first (iterator));
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		char* element;
		element = (char*) gee_iterator_get (iterator);
		if (_vala_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (_vala_strcmp0 (element, "two") == 0) {
				if (two_found) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				if (_vala_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		has_next = gee_iterator_has_next (iterator);
		g_assert (has_next == gee_iterator_next (iterator));
		if (!has_next) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	has_next = gee_iterator_has_next (iterator);
	g_assert (!has_next);
	g_assert (has_next == gee_iterator_next (iterator));
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (two_found);
	g_assert (two_found_once);
	g_assert (three_found);
	g_assert (three_found_once);
	_g_object_unref0 (iterator);
}


void collection_tests_test_mutable_iterator (CollectionTests* self) {
	gboolean has_next = FALSE;
	GeeIterator* iterator;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	iterator = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	g_assert (gee_collection_add (self->test_collection, "one"));
	g_assert (gee_collection_add (self->test_collection, "two"));
	g_assert (gee_collection_add (self->test_collection, "three"));
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	iterator = (_tmp0_ = gee_iterable_iterator ((GeeIterable*) self->test_collection), _g_object_unref0 (iterator), _tmp0_);
	while (TRUE) {
		char* element;
		has_next = gee_iterator_has_next (iterator);
		g_assert (has_next == gee_iterator_next (iterator));
		if (!has_next) {
			break;
		}
		element = (char*) gee_iterator_get (iterator);
		if (_vala_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (_vala_strcmp0 (element, "two") == 0) {
				if (two_found) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
				gee_iterator_remove (iterator);
			} else {
				if (_vala_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	has_next = gee_iterator_has_next (iterator);
	g_assert (!has_next);
	g_assert (has_next == gee_iterator_next (iterator));
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (two_found);
	g_assert (two_found_once);
	g_assert (three_found);
	g_assert (three_found_once);
	g_assert (gee_iterator_first (iterator));
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		char* element;
		element = (char*) gee_iterator_get (iterator);
		if (_vala_strcmp0 (element, "one") == 0) {
			if (one_found) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			if (_vala_strcmp0 (element, "two") == 0) {
				two_found = TRUE;
			} else {
				if (_vala_strcmp0 (element, "three") == 0) {
					if (three_found) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		has_next = gee_iterator_has_next (iterator);
		g_assert (has_next == gee_iterator_next (iterator));
		if (!has_next) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	has_next = gee_iterator_has_next (iterator);
	g_assert (!has_next);
	g_assert (has_next == gee_iterator_next (iterator));
	g_assert (one_found);
	g_assert (one_found_once);
	g_assert (!two_found);
	g_assert (three_found);
	g_assert (three_found_once);
	_g_object_unref0 (iterator);
}


void collection_tests_test_contains_size_and_is_empty (CollectionTests* self) {
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	g_assert (!gee_collection_contains (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "two"));
	g_assert (!gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 0);
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_add (self->test_collection, "one"));
	g_assert (gee_collection_contains (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "two"));
	g_assert (!gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 1);
	g_assert (!gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_remove (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "two"));
	g_assert (!gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 0);
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_add (self->test_collection, "one"));
	g_assert (gee_collection_contains (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "two"));
	g_assert (!gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 1);
	g_assert (!gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_add (self->test_collection, "two"));
	g_assert (gee_collection_contains (self->test_collection, "one"));
	g_assert (gee_collection_contains (self->test_collection, "two"));
	g_assert (!gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 2);
	g_assert (!gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_add (self->test_collection, "three"));
	g_assert (gee_collection_contains (self->test_collection, "one"));
	g_assert (gee_collection_contains (self->test_collection, "two"));
	g_assert (gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 3);
	g_assert (!gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_remove (self->test_collection, "two"));
	g_assert (gee_collection_contains (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "two"));
	g_assert (gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 2);
	g_assert (!gee_collection_get_is_empty (self->test_collection));
	g_assert (!gee_collection_remove (self->test_collection, "two"));
	g_assert (gee_collection_contains (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "two"));
	g_assert (gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 2);
	g_assert (!gee_collection_get_is_empty (self->test_collection));
	gee_collection_clear (self->test_collection);
	g_assert (!gee_collection_contains (self->test_collection, "one"));
	g_assert (!gee_collection_contains (self->test_collection, "two"));
	g_assert (!gee_collection_contains (self->test_collection, "three"));
	g_assert (gee_collection_get_size (self->test_collection) == 0);
	g_assert (gee_collection_get_is_empty (self->test_collection));
}


void collection_tests_test_add_remove (CollectionTests* self) {
	gint to_add_length1;
	gint _to_add_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** to_add;
	gint expected_size;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	to_add = (_tmp1_ = (_tmp0_ = g_new0 (char*, 39 + 1), _tmp0_[0] = g_strdup ("one"), _tmp0_[1] = g_strdup ("two"), _tmp0_[2] = g_strdup ("three"), _tmp0_[3] = g_strdup ("four"), _tmp0_[4] = g_strdup ("five"), _tmp0_[5] = g_strdup ("six"), _tmp0_[6] = g_strdup ("seven"), _tmp0_[7] = g_strdup ("eight"), _tmp0_[8] = g_strdup ("nine"), _tmp0_[9] = g_strdup ("ten"), _tmp0_[10] = g_strdup ("eleven"), _tmp0_[11] = g_strdup ("twelve"), _tmp0_[12] = g_strdup ("thirteen"), _tmp0_[13] = g_strdup ("fourteen"), _tmp0_[14] = g_strdup ("fifteen"), _tmp0_[15] = g_strdup ("sixteen"), _tmp0_[16] = g_strdup ("seventeen"), _tmp0_[17] = g_strdup ("eighteen"), _tmp0_[18] = g_strdup ("nineteen"), _tmp0_[19] = g_strdup ("twenty"), _tmp0_[20] = g_strdup ("twenty one"), _tmp0_[21] = g_strdup ("twenty two"), _tmp0_[22] = g_strdup ("twenty three"), _tmp0_[23] = g_strdup ("twenty four"), _tmp0_[24] = g_strdup ("twenty five"), _tmp0_[25] = g_strdup ("twenty six"), _tmp0_[26] = g_strdup ("twenty seven"), _tmp0_[27] = g_strdup ("twenty eight"), _tmp0_[28] = g_strdup ("twenty nine"), _tmp0_[29] = g_strdup ("thirty"), _tmp0_[30] = g_strdup ("thirty one"), _tmp0_[31] = g_strdup ("thirty two"), _tmp0_[32] = g_strdup ("thirty four"), _tmp0_[33] = g_strdup ("thirty five"), _tmp0_[34] = g_strdup ("thirty six"), _tmp0_[35] = g_strdup ("thirty seven"), _tmp0_[36] = g_strdup ("thirty eight"), _tmp0_[37] = g_strdup ("thirty nine"), _tmp0_[38] = g_strdup ("fourty"), _tmp0_), to_add_length1 = 39, _to_add_size_ = to_add_length1, _tmp1_);
	expected_size = 0;
	{
		char** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			char* a;
			a = g_strdup (a_collection[a_it]);
			{
				g_assert (!gee_collection_contains (self->test_collection, a));
				g_assert (gee_collection_get_size (self->test_collection) == (expected_size++));
				g_assert (gee_collection_add (self->test_collection, a));
				g_assert (gee_collection_contains (self->test_collection, a));
				_g_free0 (a);
			}
		}
	}
	g_assert (gee_collection_get_size (self->test_collection) == to_add_length1);
	{
		char** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			char* a;
			a = g_strdup (a_collection[a_it]);
			{
				g_assert (gee_collection_contains (self->test_collection, a));
				_g_free0 (a);
			}
		}
	}
	{
		char** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			char* a;
			a = g_strdup (a_collection[a_it]);
			{
				g_assert (gee_collection_contains (self->test_collection, a));
				g_assert (gee_collection_get_size (self->test_collection) == (expected_size--));
				g_assert (gee_collection_remove (self->test_collection, a));
				g_assert (!gee_collection_contains (self->test_collection, a));
				_g_free0 (a);
			}
		}
	}
	g_assert (gee_collection_get_size (self->test_collection) == 0);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_clear (CollectionTests* self) {
	gint to_add_length1;
	gint _to_add_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** to_add;
	gint expected_size;
	GeeIterator* iter;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	to_add = (_tmp1_ = (_tmp0_ = g_new0 (char*, 39 + 1), _tmp0_[0] = g_strdup ("one"), _tmp0_[1] = g_strdup ("two"), _tmp0_[2] = g_strdup ("three"), _tmp0_[3] = g_strdup ("four"), _tmp0_[4] = g_strdup ("five"), _tmp0_[5] = g_strdup ("six"), _tmp0_[6] = g_strdup ("seven"), _tmp0_[7] = g_strdup ("eight"), _tmp0_[8] = g_strdup ("nine"), _tmp0_[9] = g_strdup ("ten"), _tmp0_[10] = g_strdup ("eleven"), _tmp0_[11] = g_strdup ("twelve"), _tmp0_[12] = g_strdup ("thirteen"), _tmp0_[13] = g_strdup ("fourteen"), _tmp0_[14] = g_strdup ("fifteen"), _tmp0_[15] = g_strdup ("sixteen"), _tmp0_[16] = g_strdup ("seventeen"), _tmp0_[17] = g_strdup ("eighteen"), _tmp0_[18] = g_strdup ("nineteen"), _tmp0_[19] = g_strdup ("twenty"), _tmp0_[20] = g_strdup ("twenty one"), _tmp0_[21] = g_strdup ("twenty two"), _tmp0_[22] = g_strdup ("twenty three"), _tmp0_[23] = g_strdup ("twenty four"), _tmp0_[24] = g_strdup ("twenty five"), _tmp0_[25] = g_strdup ("twenty six"), _tmp0_[26] = g_strdup ("twenty seven"), _tmp0_[27] = g_strdup ("twenty eight"), _tmp0_[28] = g_strdup ("twenty nine"), _tmp0_[29] = g_strdup ("thirty"), _tmp0_[30] = g_strdup ("thirty one"), _tmp0_[31] = g_strdup ("thirty two"), _tmp0_[32] = g_strdup ("thirty four"), _tmp0_[33] = g_strdup ("thirty five"), _tmp0_[34] = g_strdup ("thirty six"), _tmp0_[35] = g_strdup ("thirty seven"), _tmp0_[36] = g_strdup ("thirty eight"), _tmp0_[37] = g_strdup ("thirty nine"), _tmp0_[38] = g_strdup ("fourty"), _tmp0_), to_add_length1 = 39, _to_add_size_ = to_add_length1, _tmp1_);
	expected_size = 0;
	{
		char** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = to_add;
		a_collection_length1 = to_add_length1;
		for (a_it = 0; a_it < to_add_length1; a_it = a_it + 1) {
			char* a;
			a = g_strdup (a_collection[a_it]);
			{
				g_assert (!gee_collection_contains (self->test_collection, a));
				g_assert (gee_collection_get_size (self->test_collection) == (expected_size++));
				g_assert (gee_collection_add (self->test_collection, a));
				g_assert (gee_collection_contains (self->test_collection, a));
				_g_free0 (a);
			}
		}
	}
	g_assert (gee_collection_get_size (self->test_collection) == to_add_length1);
	gee_collection_clear (self->test_collection);
	g_assert (gee_collection_get_size (self->test_collection) == 0);
	iter = gee_iterable_iterator ((GeeIterable*) self->test_collection);
	g_assert (iter != NULL);
	g_assert (!gee_iterator_has_next (iter));
	_g_object_unref0 (iter);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_add_all (CollectionTests* self) {
	GeeArrayList* dummy;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	dummy = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (!gee_collection_add_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy));
	g_assert (gee_collection_add (self->test_collection, "hello"));
	g_assert (!gee_collection_add_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_size (self->test_collection) == 1);
	g_assert (gee_collection_contains (self->test_collection, "hello"));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_size (self->test_collection) == 3);
	g_assert (gee_collection_contains (self->test_collection, "hello1"));
	g_assert (gee_collection_contains (self->test_collection, "hello2"));
	g_assert (gee_collection_contains (self->test_collection, "hello3"));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello"));
	g_assert (gee_collection_add_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_size (self->test_collection) == 4);
	g_assert (gee_collection_contains (self->test_collection, "hello"));
	g_assert (gee_collection_contains (self->test_collection, "hello1"));
	g_assert (gee_collection_contains (self->test_collection, "hello2"));
	g_assert (gee_collection_contains (self->test_collection, "hello3"));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello1"));
	g_assert (gee_collection_add_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_size (self->test_collection) >= 3);
	g_assert (gee_collection_contains (self->test_collection, "hello1"));
	g_assert (gee_collection_contains (self->test_collection, "hello2"));
	g_assert (gee_collection_contains (self->test_collection, "hello3"));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"));
	_g_object_unref0 (dummy);
}


void collection_tests_test_contains_all (CollectionTests* self) {
	GeeArrayList* dummy;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	dummy = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (!gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_add (self->test_collection, "hello4"));
	g_assert (gee_collection_add (self->test_collection, "hello5"));
	g_assert (!gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_add (self->test_collection, "hello1"));
	g_assert (gee_collection_add (self->test_collection, "hello2"));
	g_assert (!gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_add (self->test_collection, "hello3"));
	g_assert (gee_collection_contains_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (!gee_abstract_collection_contains_all ((GeeAbstractCollection*) dummy, self->test_collection));
	_g_object_unref0 (dummy);
}


void collection_tests_test_remove_all (CollectionTests* self) {
	GeeArrayList* dummy;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	dummy = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (!gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (!gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello4"));
	g_assert (gee_collection_add (self->test_collection, "hello5"));
	g_assert (!gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_size (self->test_collection) == 2);
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello1"));
	g_assert (gee_collection_add (self->test_collection, "hello2"));
	g_assert (gee_collection_add (self->test_collection, "hello3"));
	g_assert (gee_collection_remove_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_retain_all (CollectionTests* self) {
	GeeArrayList* dummy;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	dummy = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	g_assert (!gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy));
	g_assert (gee_collection_add (self->test_collection, "hello1"));
	g_assert (gee_collection_add (self->test_collection, "hello2"));
	g_assert (gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (!gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello4"));
	g_assert (gee_collection_add (self->test_collection, "hello5"));
	g_assert (gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello1"));
	g_assert (gee_collection_add (self->test_collection, "hello2"));
	g_assert (gee_collection_add (self->test_collection, "hello3"));
	g_assert (!gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_size (self->test_collection) == 3);
	g_assert (gee_collection_contains (self->test_collection, "hello1"));
	g_assert (gee_collection_contains (self->test_collection, "hello2"));
	g_assert (gee_collection_contains (self->test_collection, "hello3"));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello2"));
	g_assert (gee_collection_add (self->test_collection, "hello3"));
	g_assert (gee_collection_add (self->test_collection, "hello4"));
	g_assert (gee_collection_retain_all (self->test_collection, (GeeCollection*) dummy));
	g_assert (gee_collection_get_size (self->test_collection) == 2);
	g_assert (gee_collection_contains (self->test_collection, "hello2"));
	g_assert (gee_collection_contains (self->test_collection, "hello3"));
	g_assert (gee_collection_get_size ((GeeCollection*) dummy) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3"));
	gee_collection_clear (self->test_collection);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_to_array (CollectionTests* self) {
	gint array_length1;
	gint _array_size_;
	char** _tmp1_;
	gint _tmp0_;
	char** array;
	gint index;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	g_assert (gee_collection_get_is_empty (self->test_collection));
	g_assert (gee_collection_add (self->test_collection, "hello1"));
	g_assert (gee_collection_add (self->test_collection, "hello2"));
	g_assert (gee_collection_add (self->test_collection, "hello3"));
	array = (_tmp1_ = (char**) gee_collection_to_array (self->test_collection, &_tmp0_), array_length1 = _tmp0_, _array_size_ = array_length1, _tmp1_);
	index = 0;
	{
		GeeIterator* _element_it;
		_element_it = gee_iterable_iterator ((GeeIterable*) self->test_collection);
		while (TRUE) {
			char* element;
			if (!gee_iterator_next (_element_it)) {
				break;
			}
			element = (char*) gee_iterator_get (_element_it);
			g_assert (_vala_strcmp0 (element, array[index++]) == 0);
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_gobject_properties (CollectionTests* self) {
	GValue value = {0};
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GValue _tmp2_ = {0};
	GValue _tmp3_;
	GValue _tmp4_ = {0};
	GValue _tmp5_;
	g_return_if_fail (self != NULL);
	g_assert (self->test_collection != NULL);
	value = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_GTYPE), _tmp0_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp1_);
	g_object_get_property ((GObject*) self->test_collection, "element-type", &value);
	g_assert (g_value_get_gtype (&value) == gee_iterable_get_element_type ((GeeIterable*) self->test_collection));
	g_value_unset (&value);
	value = (_tmp3_ = (g_value_init (&_tmp2_, G_TYPE_BOOLEAN), _tmp2_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp3_);
	g_object_get_property ((GObject*) self->test_collection, "is-empty", &value);
	g_assert (g_value_get_boolean (&value) == gee_collection_get_is_empty (self->test_collection));
	g_value_unset (&value);
	value = (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_INT), _tmp4_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp5_);
	g_object_get_property ((GObject*) self->test_collection, "size", &value);
	g_assert (g_value_get_int (&value) == gee_collection_get_size (self->test_collection));
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


static void collection_tests_class_init (CollectionTestsClass * klass) {
	collection_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = collection_tests_finalize;
}


static void collection_tests_instance_init (CollectionTests * self) {
}


static void collection_tests_finalize (GObject* obj) {
	CollectionTests * self;
	self = COLLECTION_TESTS (obj);
	_g_object_unref0 (self->test_collection);
	G_OBJECT_CLASS (collection_tests_parent_class)->finalize (obj);
}


GType collection_tests_get_type (void) {
	static volatile gsize collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CollectionTests), 0, (GInstanceInitFunc) collection_tests_instance_init, NULL };
		GType collection_tests_type_id;
		collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "CollectionTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&collection_tests_type_id__volatile, collection_tests_type_id);
	}
	return collection_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




