/* example-vala.c generated by valac 0.9.7, the Vala compiler
 * generated from example-vala.vala, do not modify */

/*
 * Copyright (C) 2010 Ken VanDine
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gwibber.h>
#include <stdio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))



gint _vala_main (char** args, int args_length1);
static void _g_list_free_g_free (GList* self);
void PrintUsage (void);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	GwibberService* service;
	GwibberAccounts* accounts;
	GwibberStreams* streams;
	const char* _tmp5_;
	GQuark _tmp6_;
	static GQuark _tmp6__label0 = 0;
	static GQuark _tmp6__label1 = 0;
	static GQuark _tmp6__label2 = 0;
	static GQuark _tmp6__label3 = 0;
	static GQuark _tmp6__label4 = 0;
	static GQuark _tmp6__label5 = 0;
	static GQuark _tmp6__label6 = 0;
	static GQuark _tmp6__label7 = 0;
	static GQuark _tmp6__label8 = 0;
	service = gwibber_service_new ();
	accounts = gwibber_accounts_new ();
	streams = gwibber_streams_new ();
	_tmp5_ = args[1];
	_tmp6_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp6_ == ((0 != _tmp6__label0) ? _tmp6__label0 : (_tmp6__label0 = g_quark_from_static_string ("--refresh"))))
	switch (0) {
		default:
		{
			fprintf (stdout, "Refreshing gwibber\n");
			gwibber_service_refresh (service);
			result = 0;
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label1) ? _tmp6__label1 : (_tmp6__label1 = g_quark_from_static_string ("--start"))))
	switch (0) {
		default:
		{
			fprintf (stdout, "Starting the gwibber service\n");
			gwibber_service_start (service);
			result = 0;
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label2) ? _tmp6__label2 : (_tmp6__label2 = g_quark_from_static_string ("--shutdown"))))
	switch (0) {
		default:
		{
			fprintf (stdout, "Shutting down the gwibber service\n");
			gwibber_service_quit (service);
			result = 0;
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label3) ? _tmp6__label3 : (_tmp6__label3 = g_quark_from_static_string ("--version"))))
	switch (0) {
		default:
		{
			char* version;
			version = gwibber_service_version (service);
			fprintf (stdout, "Gwibber version is: %s\n", version);
			result = 0;
			_g_free0 (version);
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label4) ? _tmp6__label4 : (_tmp6__label4 = g_quark_from_static_string ("--accounts"))))
	switch (0) {
		default:
		{
			GHashTable* accounts_table;
			GList* k;
			accounts_table = gwibber_accounts_list (accounts);
			k = g_hash_table_get_keys (accounts_table);
			{
				GList* s_collection;
				GList* s_it;
				s_collection = k;
				for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
					char* s;
					s = g_strdup ((const char*) s_it->data);
					{
						GHashTable* account_table;
						GList* kk;
						fprintf (stdout, "ID: %s\n", s);
						account_table = _g_hash_table_ref0 ((GHashTable*) g_hash_table_lookup (accounts_table, s));
						kk = g_hash_table_get_keys (account_table);
						{
							GList* ss_collection;
							GList* ss_it;
							ss_collection = kk;
							for (ss_it = ss_collection; ss_it != NULL; ss_it = ss_it->next) {
								char* ss;
								ss = g_strdup ((const char*) ss_it->data);
								{
									if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (account_table, ss)), "gboolean") == 0) {
										const char* _tmp0_;
										_tmp0_ = NULL;
										if (g_value_get_boolean ((GValue*) g_hash_table_lookup (account_table, ss))) {
											_tmp0_ = "true";
										} else {
											_tmp0_ = "false";
										}
										fprintf (stdout, "\t%s: %s\n", ss, _tmp0_);
									} else {
										if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (account_table, ss)), "gchararray") == 0) {
											fprintf (stdout, "\t%s: %s\n", ss, g_value_get_string ((GValue*) g_hash_table_lookup (account_table, ss)));
										}
									}
									_g_free0 (ss);
								}
							}
						}
						__g_list_free_g_free0 (kk);
						_g_hash_table_unref0 (account_table);
						_g_free0 (s);
					}
				}
			}
			result = 0;
			__g_list_free_g_free0 (k);
			_g_hash_table_unref0 (accounts_table);
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label5) ? _tmp6__label5 : (_tmp6__label5 = g_quark_from_static_string ("--features"))))
	switch (0) {
		default:
		{
			GHashTable* features_table;
			GList* k;
			features_table = gwibber_service_features (service);
			k = g_hash_table_get_keys (features_table);
			{
				GList* s_collection;
				GList* s_it;
				s_collection = k;
				for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
					char* s;
					s = g_strdup ((const char*) s_it->data);
					{
						GHashTable* feature_table;
						GList* kk;
						fprintf (stdout, "Feature: %s\n", s);
						feature_table = _g_hash_table_ref0 ((GHashTable*) g_hash_table_lookup (features_table, s));
						kk = g_hash_table_get_keys (feature_table);
						{
							GList* ss_collection;
							GList* ss_it;
							ss_collection = kk;
							for (ss_it = ss_collection; ss_it != NULL; ss_it = ss_it->next) {
								char* ss;
								ss = g_strdup ((const char*) ss_it->data);
								{
									if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (feature_table, ss)), "gboolean") == 0) {
										const char* _tmp1_;
										_tmp1_ = NULL;
										if (g_value_get_boolean ((GValue*) g_hash_table_lookup (feature_table, ss))) {
											_tmp1_ = "true";
										} else {
											_tmp1_ = "false";
										}
										fprintf (stdout, "\t%s: %s\n", ss, _tmp1_);
									} else {
										if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (feature_table, ss)), "gchararray") == 0) {
											fprintf (stdout, "\t%s: %s\n", ss, g_value_get_string ((GValue*) g_hash_table_lookup (feature_table, ss)));
										}
									}
									_g_free0 (ss);
								}
							}
						}
						__g_list_free_g_free0 (kk);
						_g_hash_table_unref0 (feature_table);
						_g_free0 (s);
					}
				}
			}
			result = 0;
			__g_list_free_g_free0 (k);
			_g_hash_table_unref0 (features_table);
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label6) ? _tmp6__label6 : (_tmp6__label6 = g_quark_from_static_string ("--services"))))
	switch (0) {
		default:
		{
			GHashTable* services_table;
			GList* k;
			services_table = gwibber_service_services (service);
			k = g_hash_table_get_keys (services_table);
			{
				GList* s_collection;
				GList* s_it;
				s_collection = k;
				for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
					char* s;
					s = g_strdup ((const char*) s_it->data);
					{
						GHashTable* service_table;
						GList* kk;
						fprintf (stdout, "Service: %s\n", s);
						service_table = _g_hash_table_ref0 ((GHashTable*) g_hash_table_lookup (services_table, s));
						kk = g_hash_table_get_keys (service_table);
						{
							GList* ss_collection;
							GList* ss_it;
							ss_collection = kk;
							for (ss_it = ss_collection; ss_it != NULL; ss_it = ss_it->next) {
								char* ss;
								ss = g_strdup ((const char*) ss_it->data);
								{
									if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (service_table, ss)), "GHashTable") == 0) {
										GHashTable* service_attr_table;
										service_attr_table = _g_hash_table_ref0 (g_value_get_boxed ((GValue*) g_hash_table_lookup (service_table, ss)));
										if (service_attr_table != NULL) {
											GList* kkk;
											kkk = g_hash_table_get_keys (service_attr_table);
											{
												GList* sss_collection;
												GList* sss_it;
												sss_collection = kkk;
												for (sss_it = sss_collection; sss_it != NULL; sss_it = sss_it->next) {
													char* sss;
													sss = g_strdup ((const char*) sss_it->data);
													{
														if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (service_attr_table, ss)), "gboolean") == 0) {
															const char* _tmp2_;
															_tmp2_ = NULL;
															if (g_value_get_boolean ((GValue*) g_hash_table_lookup (service_attr_table, ss))) {
																_tmp2_ = "true";
															} else {
																_tmp2_ = "false";
															}
															fprintf (stdout, "\t%s: %s\n", sss, _tmp2_);
														} else {
															if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (service_attr_table, ss)), "gchararray") == 0) {
																fprintf (stdout, "\t%s: %s\n", sss, g_value_get_string ((GValue*) g_hash_table_lookup (service_attr_table, ss)));
															}
														}
														_g_free0 (sss);
													}
												}
											}
											__g_list_free_g_free0 (kkk);
											_g_hash_table_unref0 (service_attr_table);
											_g_free0 (ss);
											continue;
										}
										_g_hash_table_unref0 (service_attr_table);
									} else {
										if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (service_table, ss)), "gboolean") == 0) {
											const char* _tmp3_;
											_tmp3_ = NULL;
											if (g_value_get_boolean ((GValue*) g_hash_table_lookup (service_table, ss))) {
												_tmp3_ = "true";
											} else {
												_tmp3_ = "false";
											}
											fprintf (stdout, "\t%s: %s\n", ss, _tmp3_);
										} else {
											if (_vala_strcmp0 (G_VALUE_TYPE_NAME ((GValue*) g_hash_table_lookup (service_table, ss)), "gchararray") == 0) {
												fprintf (stdout, "\t%s: %s\n", ss, g_value_get_string ((GValue*) g_hash_table_lookup (service_table, ss)));
											}
										}
									}
									_g_free0 (ss);
								}
							}
						}
						__g_list_free_g_free0 (kk);
						_g_hash_table_unref0 (service_table);
						_g_free0 (s);
					}
				}
			}
			result = 0;
			__g_list_free_g_free0 (k);
			_g_hash_table_unref0 (services_table);
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label7) ? _tmp6__label7 : (_tmp6__label7 = g_quark_from_static_string ("--send-message"))))
	switch (0) {
		default:
		{
			if (args_length1 < 3) {
				PrintUsage ();
				result = 1;
				_g_object_unref0 (streams);
				_g_object_unref0 (accounts);
				_g_object_unref0 (service);
				return result;
			}
			{
				gint i;
				i = 1;
				{
					gboolean _tmp4_;
					_tmp4_ = TRUE;
					while (TRUE) {
						if (!_tmp4_) {
							i++;
						}
						_tmp4_ = FALSE;
						if (!(i < args_length1)) {
							break;
						}
						if (_vala_strcmp0 (args[i], "--send-message") == 0) {
							if (args[1 + 1] != NULL) {
								char* message;
								message = g_strdup (args[i + 1]);
								fprintf (stdout, "Posting...\n");
								gwibber_service_send_message (service, message);
								_g_free0 (message);
							} else {
								PrintUsage ();
								result = 1;
								_g_object_unref0 (streams);
								_g_object_unref0 (accounts);
								_g_object_unref0 (service);
								return result;
							}
						}
					}
				}
			}
			result = 0;
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else if (_tmp6_ == ((0 != _tmp6__label8) ? _tmp6__label8 : (_tmp6__label8 = g_quark_from_static_string ("--help"))))
	switch (0) {
		default:
		{
			PrintUsage ();
			result = 0;
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	} else
	switch (0) {
		default:
		{
			result = 1;
			_g_object_unref0 (streams);
			_g_object_unref0 (accounts);
			_g_object_unref0 (service);
			return result;
		}
	}
	_g_object_unref0 (streams);
	_g_object_unref0 (accounts);
	_g_object_unref0 (service);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


void PrintUsage (void) {
	char* usage;
	char* _tmp0_;
	usage = g_strdup ("Usage:\n" "  --help\t\t\tPrint this usage message.\n" "  --start\t\t\tStart the gwibber-service\n" "  --shutdown\t\t\tShutdown the gwibber-service\n" "  --refresh\t\t\tRefresh the gwibber-service\n" "  --send-message [message]\t\tMessage to post\n" "  --accounts\t\t\tReturns list of accounts\n" "  --services\t\t\tReturns list of services\n" "  --features\t\t\tReturns list of features\n" "  --version\t\t\tReturns the version of the gwibber-service\n");
	fprintf (stdout, "%s", _tmp0_ = g_strdup_printf ("%s\n", usage));
	_g_free0 (_tmp0_);
	_g_free0 (usage);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




