/* entry.c generated by valac 0.9.7, the Vala compiler
 * generated from entry.vala, do not modify */

/*
 * Copyright (C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gwibber.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>


#define GWIBBER_TYPE_ENTRY (gwibber_entry_get_type ())
#define GWIBBER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_ENTRY, GwibberEntry))
#define GWIBBER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_ENTRY, GwibberEntryClass))
#define GWIBBER_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_ENTRY))
#define GWIBBER_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_ENTRY))
#define GWIBBER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_ENTRY, GwibberEntryClass))

typedef struct _GwibberEntry GwibberEntry;
typedef struct _GwibberEntryClass GwibberEntryClass;
typedef struct _GwibberEntryPrivate GwibberEntryPrivate;

#define GWIBBER_TYPE_INPUT_TEXT_VIEW (gwibber_input_text_view_get_type ())
#define GWIBBER_INPUT_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_INPUT_TEXT_VIEW, GwibberInputTextView))
#define GWIBBER_INPUT_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_INPUT_TEXT_VIEW, GwibberInputTextViewClass))
#define GWIBBER_IS_INPUT_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_INPUT_TEXT_VIEW))
#define GWIBBER_IS_INPUT_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_INPUT_TEXT_VIEW))
#define GWIBBER_INPUT_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_INPUT_TEXT_VIEW, GwibberInputTextViewClass))

typedef struct _GwibberInputTextView GwibberInputTextView;
typedef struct _GwibberInputTextViewClass GwibberInputTextViewClass;

#define GWIBBER_TYPE_ACCOUNT_TARGET_BAR (gwibber_account_target_bar_get_type ())
#define GWIBBER_ACCOUNT_TARGET_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_ACCOUNT_TARGET_BAR, GwibberAccountTargetBar))
#define GWIBBER_ACCOUNT_TARGET_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_ACCOUNT_TARGET_BAR, GwibberAccountTargetBarClass))
#define GWIBBER_IS_ACCOUNT_TARGET_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_ACCOUNT_TARGET_BAR))
#define GWIBBER_IS_ACCOUNT_TARGET_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_ACCOUNT_TARGET_BAR))
#define GWIBBER_ACCOUNT_TARGET_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_ACCOUNT_TARGET_BAR, GwibberAccountTargetBarClass))

typedef struct _GwibberAccountTargetBar GwibberAccountTargetBar;
typedef struct _GwibberAccountTargetBarClass GwibberAccountTargetBarClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GwibberAccountTargetBarPrivate GwibberAccountTargetBarPrivate;

#define GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON (gwibber_account_toggle_button_get_type ())
#define GWIBBER_ACCOUNT_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON, GwibberAccountToggleButton))
#define GWIBBER_ACCOUNT_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON, GwibberAccountToggleButtonClass))
#define GWIBBER_IS_ACCOUNT_TOGGLE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON))
#define GWIBBER_IS_ACCOUNT_TOGGLE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON))
#define GWIBBER_ACCOUNT_TOGGLE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON, GwibberAccountToggleButtonClass))

typedef struct _GwibberAccountToggleButton GwibberAccountToggleButton;
typedef struct _GwibberAccountToggleButtonClass GwibberAccountToggleButtonClass;

#define GWIBBER_TYPE_SIMPLE_ENTRY (gwibber_simple_entry_get_type ())
#define GWIBBER_SIMPLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_SIMPLE_ENTRY, GwibberSimpleEntry))
#define GWIBBER_SIMPLE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_SIMPLE_ENTRY, GwibberSimpleEntryClass))
#define GWIBBER_IS_SIMPLE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_SIMPLE_ENTRY))
#define GWIBBER_IS_SIMPLE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_SIMPLE_ENTRY))
#define GWIBBER_SIMPLE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_SIMPLE_ENTRY, GwibberSimpleEntryClass))

typedef struct _GwibberSimpleEntry GwibberSimpleEntry;
typedef struct _GwibberSimpleEntryClass GwibberSimpleEntryClass;
typedef struct _GwibberSimpleEntryPrivate GwibberSimpleEntryPrivate;

#define GWIBBER_TYPE_SEND_BAR (gwibber_send_bar_get_type ())
#define GWIBBER_SEND_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_SEND_BAR, GwibberSendBar))
#define GWIBBER_SEND_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TYPE_SEND_BAR, GwibberSendBarClass))
#define GWIBBER_IS_SEND_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_SEND_BAR))
#define GWIBBER_IS_SEND_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TYPE_SEND_BAR))
#define GWIBBER_SEND_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TYPE_SEND_BAR, GwibberSendBarClass))

typedef struct _GwibberSendBar GwibberSendBar;
typedef struct _GwibberSendBarClass GwibberSendBarClass;
typedef struct _GwibberSendBarPrivate GwibberSendBarPrivate;
typedef struct _GwibberInputTextViewPrivate GwibberInputTextViewPrivate;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _GwibberAccountToggleButtonPrivate GwibberAccountToggleButtonPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _GwibberEntry {
	GtkVBox parent_instance;
	GwibberEntryPrivate * priv;
	GwibberService* service;
	GwibberAccounts* accounts_service;
};

struct _GwibberEntryClass {
	GtkVBoxClass parent_class;
};

struct _GwibberEntryPrivate {
	GwibberInputTextView* text_view;
	GwibberAccountTargetBar* target_bar;
};

struct _GwibberAccountTargetBar {
	GtkHBox parent_instance;
	GwibberAccountTargetBarPrivate * priv;
	GtkButton* send;
	GHashTable* accounts_buttons_table;
};

struct _GwibberAccountTargetBarClass {
	GtkHBoxClass parent_class;
};

struct _GwibberSimpleEntry {
	GtkVBox parent_instance;
	GwibberSimpleEntryPrivate * priv;
	GwibberService* service;
};

struct _GwibberSimpleEntryClass {
	GtkVBoxClass parent_class;
};

struct _GwibberSimpleEntryPrivate {
	GwibberInputTextView* text_view;
	GwibberSendBar* send_bar;
};

struct _GwibberSendBar {
	GtkHBox parent_instance;
	GwibberSendBarPrivate * priv;
	GtkButton* send;
};

struct _GwibberSendBarClass {
	GtkHBoxClass parent_class;
};

struct _GwibberInputTextView {
	GtkTextView parent_instance;
	GwibberInputTextViewPrivate * priv;
	char* overlay_text;
	char* overlay_color;
	GdkDrawable* drawable;
	PangoLayout* pango_overlay;
};

struct _GwibberInputTextViewClass {
	GtkTextViewClass parent_class;
	void (*submit) (GwibberInputTextView* self);
};

struct _GwibberInputTextViewPrivate {
	GwibberService* _service;
	GwibberConnection* _conn_service;
	GwibberURLShorten* _urlshorten;
	GdkColor base_color;
	GdkColor error_color;
	gboolean last_was_shortened;
};

struct _GwibberAccountToggleButton {
	GtkToggleButton parent_instance;
	GwibberAccountToggleButtonPrivate * priv;
};

struct _GwibberAccountToggleButtonClass {
	GtkToggleButtonClass parent_class;
};

struct _GwibberAccountToggleButtonPrivate {
	char* _color;
};

struct _GwibberAccountTargetBarPrivate {
	GwibberAccounts* _accounts_service;
	GwibberConnection* _conn_service;
};

struct _Block1Data {
	int _ref_count_;
	GwibberAccountTargetBar * self;
	char* id;
	GwibberAccountToggleButton* account_button;
};

struct _GwibberSendBarPrivate {
	GwibberService* _service;
};


static gpointer gwibber_entry_parent_class = NULL;
static gpointer gwibber_simple_entry_parent_class = NULL;
static gpointer gwibber_input_text_view_parent_class = NULL;
static gpointer gwibber_account_toggle_button_parent_class = NULL;
static gpointer gwibber_account_target_bar_parent_class = NULL;
static gpointer gwibber_send_bar_parent_class = NULL;

GType gwibber_entry_get_type (void) G_GNUC_CONST;
GType gwibber_input_text_view_get_type (void) G_GNUC_CONST;
GType gwibber_account_target_bar_get_type (void) G_GNUC_CONST;
#define GWIBBER_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_ENTRY, GwibberEntryPrivate))
enum  {
	GWIBBER_ENTRY_DUMMY_PROPERTY
};
GwibberEntry* gwibber_entry_new (void);
GwibberEntry* gwibber_entry_construct (GType object_type);
static void gwibber_entry_on_send (GwibberEntry* self, const char* msg);
void gwibber_input_text_view_clear (GwibberInputTextView* self);
GwibberInputTextView* gwibber_input_text_view_new (GwibberService* service);
GwibberInputTextView* gwibber_input_text_view_construct (GType object_type, GwibberService* service);
GwibberAccountTargetBar* gwibber_account_target_bar_new (GwibberAccounts* accounts_service);
GwibberAccountTargetBar* gwibber_account_target_bar_construct (GType object_type, GwibberAccounts* accounts_service);
static void _lambda5_ (GwibberInputTextView* source, GwibberEntry* self);
static void __lambda5__gwibber_input_text_view_submit (GwibberInputTextView* _sender, gpointer self);
GType gwibber_account_toggle_button_get_type (void) G_GNUC_CONST;
static void _lambda6_ (GtkButton* source, GwibberEntry* self);
static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * gwibber_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_entry_finalize (GObject* obj);
GType gwibber_simple_entry_get_type (void) G_GNUC_CONST;
GType gwibber_send_bar_get_type (void) G_GNUC_CONST;
#define GWIBBER_SIMPLE_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_SIMPLE_ENTRY, GwibberSimpleEntryPrivate))
enum  {
	GWIBBER_SIMPLE_ENTRY_DUMMY_PROPERTY
};
GwibberSimpleEntry* gwibber_simple_entry_new (void);
GwibberSimpleEntry* gwibber_simple_entry_construct (GType object_type);
static void gwibber_simple_entry_on_send (GwibberSimpleEntry* self, const char* msg);
GwibberSendBar* gwibber_send_bar_new (GwibberService* service);
GwibberSendBar* gwibber_send_bar_construct (GType object_type, GwibberService* service);
static void _lambda7_ (GwibberInputTextView* source, GwibberSimpleEntry* self);
static void __lambda7__gwibber_input_text_view_submit (GwibberInputTextView* _sender, gpointer self);
static void _lambda8_ (GtkButton* source, GwibberSimpleEntry* self);
static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * gwibber_simple_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_simple_entry_finalize (GObject* obj);
#define GWIBBER_INPUT_TEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_INPUT_TEXT_VIEW, GwibberInputTextViewPrivate))
enum  {
	GWIBBER_INPUT_TEXT_VIEW_DUMMY_PROPERTY,
	GWIBBER_INPUT_TEXT_VIEW_SERVICE,
	GWIBBER_INPUT_TEXT_VIEW_CONN_SERVICE,
	GWIBBER_INPUT_TEXT_VIEW_URLSHORTEN
};
#define GWIBBER_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH 140
static void gwibber_input_text_view_on_connection_changed (GwibberInputTextView* self, gboolean is_connected);
static void gwibber_input_text_view_on_text_changed (GwibberInputTextView* self);
static void gwibber_input_text_view_set_overlay_text (GwibberInputTextView* self, const char* text);
static void gwibber_input_text_view_on_text_inserted (GwibberInputTextView* self, GtkTextIter* iter, const char* text, gint len);
GwibberURLShorten* gwibber_input_text_view_get_urlshorten (GwibberInputTextView* self);
static void gwibber_input_text_view_expose_view (GwibberInputTextView* self, GdkEventExpose* event);
GwibberService* gwibber_input_text_view_get_service (GwibberInputTextView* self);
static void gwibber_input_text_view_set_service (GwibberInputTextView* self, GwibberService* value);
GwibberConnection* gwibber_input_text_view_get_conn_service (GwibberInputTextView* self);
static void gwibber_input_text_view_set_conn_service (GwibberInputTextView* self, GwibberConnection* value);
static void gwibber_input_text_view_set_urlshorten (GwibberInputTextView* self, GwibberURLShorten* value);
void gwibber_input_text_view_submit (GwibberInputTextView* self);
static void gwibber_input_text_view_real_submit (GwibberInputTextView* self);
static void _gwibber_input_text_view_on_text_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void _gwibber_input_text_view_on_text_inserted_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self);
static gboolean _lambda0_ (GdkEventExpose* source, GwibberInputTextView* self);
static gboolean __lambda0__gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static void _lambda1_ (gboolean source, GwibberInputTextView* self);
static void __lambda1__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self);
static GObject * gwibber_input_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_input_text_view_finalize (GObject* obj);
static void gwibber_input_text_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gwibber_input_text_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_ACCOUNT_TOGGLE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON, GwibberAccountToggleButtonPrivate))
enum  {
	GWIBBER_ACCOUNT_TOGGLE_BUTTON_DUMMY_PROPERTY,
	GWIBBER_ACCOUNT_TOGGLE_BUTTON_COLOR
};
GwibberAccountToggleButton* gwibber_account_toggle_button_new (const char* color);
GwibberAccountToggleButton* gwibber_account_toggle_button_construct (GType object_type, const char* color);
static gboolean gwibber_account_toggle_button_real_expose_event (GtkWidget* base, GdkEventExpose* event);
const char* gwibber_account_toggle_button_get_color (GwibberAccountToggleButton* self);
static void gwibber_account_toggle_button_set_color (GwibberAccountToggleButton* self, const char* value);
static GObject * gwibber_account_toggle_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_account_toggle_button_finalize (GObject* obj);
static void gwibber_account_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gwibber_account_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_ACCOUNT_TARGET_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_ACCOUNT_TARGET_BAR, GwibberAccountTargetBarPrivate))
enum  {
	GWIBBER_ACCOUNT_TARGET_BAR_DUMMY_PROPERTY,
	GWIBBER_ACCOUNT_TARGET_BAR_ACCOUNTS_SERVICE,
	GWIBBER_ACCOUNT_TARGET_BAR_CONN_SERVICE
};
static void gwibber_account_target_bar_on_account_toggled (GwibberAccountTargetBar* self, GwibberAccountToggleButton* account_button, const char* id);
GwibberAccounts* gwibber_account_target_bar_get_accounts_service (GwibberAccountTargetBar* self);
static void gwibber_account_target_bar_account_updated (GHashTable* accounts_buttons_table, GHashTable* account);
static void gwibber_account_target_bar_on_connection_changed (GwibberAccountTargetBar* self, gboolean is_connected);
static void gwibber_account_target_bar_set_accounts_service (GwibberAccountTargetBar* self, GwibberAccounts* value);
GwibberConnection* gwibber_account_target_bar_get_conn_service (GwibberAccountTargetBar* self);
static void gwibber_account_target_bar_set_conn_service (GwibberAccountTargetBar* self, GwibberConnection* value);
static void _lambda2_ (GtkButton* source, Block1Data* _data1_);
static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda3_ (gboolean source, GwibberAccountTargetBar* self);
static void __lambda3__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self);
static void _lambda4_ (GHashTable* source, GwibberAccountTargetBar* self);
static void __lambda4__gwibber_accounts_account_updated (GwibberAccounts* _sender, GHashTable* account_table, gpointer self);
static GObject * gwibber_account_target_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_account_target_bar_finalize (GObject* obj);
static void gwibber_account_target_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gwibber_account_target_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_SEND_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_SEND_BAR, GwibberSendBarPrivate))
enum  {
	GWIBBER_SEND_BAR_DUMMY_PROPERTY,
	GWIBBER_SEND_BAR_SERVICE
};
GwibberService* gwibber_send_bar_get_service (GwibberSendBar* self);
static void gwibber_send_bar_set_service (GwibberSendBar* self, GwibberService* value);
static GObject * gwibber_send_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_send_bar_finalize (GObject* obj);
static void gwibber_send_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gwibber_send_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GwibberEntry* gwibber_entry_construct (GType object_type) {
	GwibberEntry * self;
	self = (GwibberEntry*) g_object_new (object_type, NULL);
	return self;
}


GwibberEntry* gwibber_entry_new (void) {
	return gwibber_entry_construct (GWIBBER_TYPE_ENTRY);
}


static void gwibber_entry_on_send (GwibberEntry* self, const char* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	gwibber_service_send_message (self->service, msg);
	g_debug ("entry.vala:59: Message: %s posted", msg);
	gwibber_input_text_view_clear (self->priv->text_view);
}


static void _lambda5_ (GwibberInputTextView* source, GwibberEntry* self) {
	char* _tmp0_ = NULL;
	char* _tmp1_;
	g_return_if_fail (source != NULL);
	gwibber_entry_on_send (self, _tmp1_ = (g_object_get (gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view), "text", &_tmp0_, NULL), _tmp0_));
	_g_free0 (_tmp1_);
}


static void __lambda5__gwibber_input_text_view_submit (GwibberInputTextView* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (GtkButton* source, GwibberEntry* self) {
	char* _tmp0_ = NULL;
	char* _tmp1_;
	g_return_if_fail (source != NULL);
	gwibber_entry_on_send (self, _tmp1_ = (g_object_get (gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view), "text", &_tmp0_, NULL), _tmp0_));
	_g_free0 (_tmp1_);
}


static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static GObject * gwibber_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberEntry * self;
	parent_class = G_OBJECT_CLASS (gwibber_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_ENTRY (obj);
	{
		GwibberService* _tmp0_;
		GwibberAccounts* _tmp1_;
		GwibberInputTextView* _tmp2_;
		GwibberAccountTargetBar* _tmp3_;
		self->service = (_tmp0_ = gwibber_service_new (), _g_object_unref0 (self->service), _tmp0_);
		self->accounts_service = (_tmp1_ = gwibber_accounts_new (), _g_object_unref0 (self->accounts_service), _tmp1_);
		self->priv->text_view = (_tmp2_ = g_object_ref_sink (gwibber_input_text_view_new (self->service)), _g_object_unref0 (self->priv->text_view), _tmp2_);
		self->priv->target_bar = (_tmp3_ = g_object_ref_sink (gwibber_account_target_bar_new (self->accounts_service)), _g_object_unref0 (self->priv->target_bar), _tmp3_);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->text_view);
		gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) self->priv->target_bar, "expand", FALSE, NULL);
		gtk_widget_show ((GtkWidget*) self->priv->text_view);
		g_signal_connect_object (self->priv->text_view, "submit", (GCallback) __lambda5__gwibber_input_text_view_submit, self, 0);
		gtk_widget_show ((GtkWidget*) self->priv->target_bar);
		g_signal_connect_object (self->priv->target_bar->send, "clicked", (GCallback) __lambda6__gtk_button_clicked, self, 0);
	}
	return obj;
}


static void gwibber_entry_class_init (GwibberEntryClass * klass) {
	gwibber_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_entry_finalize;
}


static void gwibber_entry_instance_init (GwibberEntry * self) {
	self->priv = GWIBBER_ENTRY_GET_PRIVATE (self);
}


static void gwibber_entry_finalize (GObject* obj) {
	GwibberEntry * self;
	self = GWIBBER_ENTRY (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->accounts_service);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->target_bar);
	G_OBJECT_CLASS (gwibber_entry_parent_class)->finalize (obj);
}


GType gwibber_entry_get_type (void) {
	static volatile gsize gwibber_entry_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberEntry), 0, (GInstanceInitFunc) gwibber_entry_instance_init, NULL };
		GType gwibber_entry_type_id;
		gwibber_entry_type_id = g_type_register_static (GTK_TYPE_VBOX, "GwibberEntry", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_entry_type_id__volatile, gwibber_entry_type_id);
	}
	return gwibber_entry_type_id__volatile;
}


GwibberSimpleEntry* gwibber_simple_entry_construct (GType object_type) {
	GwibberSimpleEntry * self;
	self = (GwibberSimpleEntry*) g_object_new (object_type, NULL);
	return self;
}


GwibberSimpleEntry* gwibber_simple_entry_new (void) {
	return gwibber_simple_entry_construct (GWIBBER_TYPE_SIMPLE_ENTRY);
}


static void gwibber_simple_entry_on_send (GwibberSimpleEntry* self, const char* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	gwibber_service_send_message (self->service, msg);
	g_debug ("entry.vala:97: Message: %s posted", msg);
	gwibber_input_text_view_clear (self->priv->text_view);
}


static void _lambda7_ (GwibberInputTextView* source, GwibberSimpleEntry* self) {
	char* _tmp0_ = NULL;
	char* _tmp1_;
	g_return_if_fail (source != NULL);
	gwibber_simple_entry_on_send (self, _tmp1_ = (g_object_get (gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view), "text", &_tmp0_, NULL), _tmp0_));
	_g_free0 (_tmp1_);
}


static void __lambda7__gwibber_input_text_view_submit (GwibberInputTextView* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static void _lambda8_ (GtkButton* source, GwibberSimpleEntry* self) {
	char* _tmp0_ = NULL;
	char* _tmp1_;
	g_return_if_fail (source != NULL);
	gwibber_simple_entry_on_send (self, _tmp1_ = (g_object_get (gtk_text_view_get_buffer ((GtkTextView*) self->priv->text_view), "text", &_tmp0_, NULL), _tmp0_));
	_g_free0 (_tmp1_);
}


static void __lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda8_ (_sender, self);
}


static GObject * gwibber_simple_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberSimpleEntry * self;
	parent_class = G_OBJECT_CLASS (gwibber_simple_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_SIMPLE_ENTRY (obj);
	{
		GwibberService* _tmp0_;
		GwibberInputTextView* _tmp1_;
		GwibberSendBar* _tmp2_;
		self->service = (_tmp0_ = gwibber_service_new (), _g_object_unref0 (self->service), _tmp0_);
		self->priv->text_view = (_tmp1_ = g_object_ref_sink (gwibber_input_text_view_new (self->service)), _g_object_unref0 (self->priv->text_view), _tmp1_);
		self->priv->send_bar = (_tmp2_ = g_object_ref_sink (gwibber_send_bar_new (self->service)), _g_object_unref0 (self->priv->send_bar), _tmp2_);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->text_view);
		gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) self->priv->send_bar, "expand", FALSE, NULL);
		gtk_widget_show ((GtkWidget*) self->priv->text_view);
		gtk_widget_show ((GtkWidget*) self->priv->send_bar);
		g_signal_connect_object (self->priv->text_view, "submit", (GCallback) __lambda7__gwibber_input_text_view_submit, self, 0);
		g_signal_connect_object (self->priv->send_bar->send, "clicked", (GCallback) __lambda8__gtk_button_clicked, self, 0);
	}
	return obj;
}


static void gwibber_simple_entry_class_init (GwibberSimpleEntryClass * klass) {
	gwibber_simple_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberSimpleEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_simple_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_simple_entry_finalize;
}


static void gwibber_simple_entry_instance_init (GwibberSimpleEntry * self) {
	self->priv = GWIBBER_SIMPLE_ENTRY_GET_PRIVATE (self);
}


static void gwibber_simple_entry_finalize (GObject* obj) {
	GwibberSimpleEntry * self;
	self = GWIBBER_SIMPLE_ENTRY (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->send_bar);
	G_OBJECT_CLASS (gwibber_simple_entry_parent_class)->finalize (obj);
}


GType gwibber_simple_entry_get_type (void) {
	static volatile gsize gwibber_simple_entry_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_simple_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberSimpleEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_simple_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberSimpleEntry), 0, (GInstanceInitFunc) gwibber_simple_entry_instance_init, NULL };
		GType gwibber_simple_entry_type_id;
		gwibber_simple_entry_type_id = g_type_register_static (GTK_TYPE_VBOX, "GwibberSimpleEntry", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_simple_entry_type_id__volatile, gwibber_simple_entry_type_id);
	}
	return gwibber_simple_entry_type_id__volatile;
}


GwibberInputTextView* gwibber_input_text_view_construct (GType object_type, GwibberService* service) {
	GwibberInputTextView * self;
	g_return_val_if_fail (service != NULL, NULL);
	self = (GwibberInputTextView*) g_object_new (object_type, "service", service, "border-width", 5, "accepts-tab", TRUE, "editable", TRUE, "cursor-visible", TRUE, "wrap-mode", GTK_WRAP_WORD_CHAR, "left-margin", 2, "right-margin", 2, "pixels-above-lines", 2, "pixels-below-lines", 2, NULL);
	return self;
}


GwibberInputTextView* gwibber_input_text_view_new (GwibberService* service) {
	return gwibber_input_text_view_construct (GWIBBER_TYPE_INPUT_TEXT_VIEW, service);
}


void gwibber_input_text_view_clear (GwibberInputTextView* self) {
	g_return_if_fail (self != NULL);
	gtk_text_buffer_set_text (gtk_text_view_get_buffer ((GtkTextView*) self), "", -1);
}


static void gwibber_input_text_view_on_connection_changed (GwibberInputTextView* self, gboolean is_connected) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self, is_connected);
}


static void gwibber_input_text_view_on_text_changed (GwibberInputTextView* self) {
	gint chars;
	char* _tmp0_;
	GdkColor _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	chars = gtk_text_buffer_get_char_count (gtk_text_view_get_buffer ((GtkTextView*) self));
	gwibber_input_text_view_set_overlay_text (self, _tmp0_ = g_strdup_printf ("%i", GWIBBER_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH - chars));
	_g_free0 (_tmp0_);
	if (chars > GWIBBER_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH) {
		_tmp1_ = self->priv->error_color;
	} else {
		_tmp1_ = self->priv->base_color;
	}
	gtk_widget_modify_base ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp1_);
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gwibber_input_text_view_on_text_inserted (GwibberInputTextView* self, GtkTextIter* iter, const char* text, gint len) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->last_was_shortened == FALSE) {
		_tmp2_ = len > 30;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = text != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp3_;
		_tmp0_ = _vala_strcmp0 (_tmp3_ = string_slice (text, (glong) 0, (glong) 4), "http") == 0;
		_g_free0 (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTextBuffer* buf;
		char* shrt;
		buf = _g_object_ref0 (gtk_text_view_get_buffer ((GtkTextView*) self));
		g_signal_stop_emission_by_name (buf, "insert-text");
		shrt = gwibber_url_shorten_shorten (self->priv->_urlshorten, text);
		self->priv->last_was_shortened = TRUE;
		gtk_text_buffer_insert (buf, iter, shrt, -1);
		_g_free0 (shrt);
		_g_object_unref0 (buf);
	} else {
		self->priv->last_was_shortened = FALSE;
	}
}


static void gwibber_input_text_view_expose_view (GwibberInputTextView* self, GdkEventExpose* event) {
	GdkGC* gc;
	gint ww = 0;
	gint wh = 0;
	gint tw = 0;
	gint th = 0;
	g_return_if_fail (self != NULL);
	if (self->drawable == NULL) {
		GdkDrawable* _tmp0_;
		PangoLayout* _tmp1_;
		char* _tmp2_;
		self->drawable = (_tmp0_ = _g_object_ref0 ((GdkDrawable*) gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT)), _g_object_unref0 (self->drawable), _tmp0_);
		self->pango_overlay = (_tmp1_ = gtk_widget_create_pango_layout ((GtkWidget*) self, ""), _g_object_unref0 (self->pango_overlay), _tmp1_);
		gwibber_input_text_view_set_overlay_text (self, _tmp2_ = g_strdup_printf ("%i", GWIBBER_INPUT_TEXT_VIEW_MAX_MESSAGE_LENGTH));
		_g_free0 (_tmp2_);
	}
	gc = gdk_gc_new (self->drawable);
	gdk_drawable_get_size (self->drawable, &ww, &wh);
	pango_layout_get_pixel_size (self->pango_overlay, &tw, &th);
	gdk_draw_layout (self->drawable, gc, (ww - tw) - 2, wh - th, self->pango_overlay);
	_g_object_unref0 (gc);
}


static void gwibber_input_text_view_set_overlay_text (GwibberInputTextView* self, const char* text) {
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->pango_overlay == NULL) {
		PangoLayout* _tmp0_;
		self->pango_overlay = (_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, ""), _g_object_unref0 (self->pango_overlay), _tmp0_);
	}
	pango_layout_set_markup (self->pango_overlay, _tmp1_ = g_strdup_printf (self->overlay_text, self->overlay_color, text), -1);
	_g_free0 (_tmp1_);
}


GwibberService* gwibber_input_text_view_get_service (GwibberInputTextView* self) {
	GwibberService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


static void gwibber_input_text_view_set_service (GwibberInputTextView* self, GwibberService* value) {
	GwibberService* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_service = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_service), _tmp0_);
	g_object_notify ((GObject *) self, "service");
}


GwibberConnection* gwibber_input_text_view_get_conn_service (GwibberInputTextView* self) {
	GwibberConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_conn_service;
	return result;
}


static void gwibber_input_text_view_set_conn_service (GwibberInputTextView* self, GwibberConnection* value) {
	GwibberConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_conn_service = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_conn_service), _tmp0_);
	g_object_notify ((GObject *) self, "conn-service");
}


GwibberURLShorten* gwibber_input_text_view_get_urlshorten (GwibberInputTextView* self) {
	GwibberURLShorten* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_urlshorten;
	return result;
}


static void gwibber_input_text_view_set_urlshorten (GwibberInputTextView* self, GwibberURLShorten* value) {
	GwibberURLShorten* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_urlshorten = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_urlshorten), _tmp0_);
	g_object_notify ((GObject *) self, "urlshorten");
}


static void gwibber_input_text_view_real_submit (GwibberInputTextView* self) {
	g_return_if_fail (self != NULL);
}


static void _gwibber_input_text_view_on_text_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	gwibber_input_text_view_on_text_changed (self);
}


static void _gwibber_input_text_view_on_text_inserted_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const char* text, gint length, gpointer self) {
	gwibber_input_text_view_on_text_inserted (self, pos, text, length);
}


static gboolean _lambda0_ (GdkEventExpose* source, GwibberInputTextView* self) {
	gboolean result = FALSE;
	gwibber_input_text_view_expose_view (self, source);
	result = FALSE;
	return result;
}


static gboolean __lambda0__gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = _lambda0_ (event, self);
	return result;
}


static void _lambda1_ (gboolean source, GwibberInputTextView* self) {
	gwibber_input_text_view_on_connection_changed (self, source);
}


static void __lambda1__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self) {
	_lambda1_ (is_online, self);
}


static GObject * gwibber_input_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberInputTextView * self;
	parent_class = G_OBJECT_CLASS (gwibber_input_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_INPUT_TEXT_VIEW (obj);
	{
		GwibberConnection* _tmp0_;
		GwibberURLShorten* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		GtkBindingSet* binding_set;
		GTypeClass* _tmp4_;
		gwibber_input_text_view_set_conn_service (self, _tmp0_ = gwibber_connection_new ());
		_g_object_unref0 (_tmp0_);
		gwibber_input_text_view_set_urlshorten (self, _tmp1_ = gwibber_url_shorten_new ());
		_g_object_unref0 (_tmp1_);
		self->overlay_color = (_tmp2_ = g_strdup ("#aeab9f"), _g_free0 (self->overlay_color), _tmp2_);
		self->overlay_text = (_tmp3_ = g_strdup ("<span weight=\"bold\" size=\"xx-large\" foreground=\"%s\">%s</span>"), _g_free0 (self->overlay_text), _tmp3_);
		binding_set = NULL;
		binding_set = gtk_binding_set_by_class (_tmp4_ = g_type_class_ref (GWIBBER_TYPE_INPUT_TEXT_VIEW));
		_g_type_class_unref0 (_tmp4_);
		gtk_binding_entry_add_signal (binding_set, gdk_keyval_from_name ("Return"), 0, "submit", (guint) 0);
		gtk_binding_entry_add_signal (binding_set, gdk_keyval_from_name ("KP_Enter"), 0, "submit", (guint) 0);
		self->priv->base_color = gtk_widget_get_style ((GtkWidget*) self)->base[GTK_STATE_NORMAL];
		gdk_color_parse ("indianred", &self->priv->error_color);
		g_signal_connect_object (gtk_text_view_get_buffer ((GtkTextView*) self), "changed", (GCallback) _gwibber_input_text_view_on_text_changed_gtk_text_buffer_changed, self, 0);
		g_signal_connect_object (gtk_text_view_get_buffer ((GtkTextView*) self), "insert-text", (GCallback) _gwibber_input_text_view_on_text_inserted_gtk_text_buffer_insert_text, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "expose-event", (GCallback) __lambda0__gtk_widget_expose_event, self, 0);
		gtk_widget_set_sensitive ((GtkWidget*) self, gwibber_connection_is_connected (self->priv->_conn_service));
		g_signal_connect_object (self->priv->_conn_service, "connection-changed", (GCallback) __lambda1__gwibber_connection_connection_changed, self, 0);
	}
	return obj;
}


static void gwibber_input_text_view_class_init (GwibberInputTextViewClass * klass) {
	gwibber_input_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberInputTextViewPrivate));
	GWIBBER_INPUT_TEXT_VIEW_CLASS (klass)->submit = gwibber_input_text_view_real_submit;
	G_OBJECT_CLASS (klass)->get_property = gwibber_input_text_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = gwibber_input_text_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_input_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_input_text_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_INPUT_TEXT_VIEW_SERVICE, g_param_spec_object ("service", "service", "service", GWIBBER_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_INPUT_TEXT_VIEW_CONN_SERVICE, g_param_spec_object ("conn-service", "conn-service", "conn-service", GWIBBER_TYPE_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_INPUT_TEXT_VIEW_URLSHORTEN, g_param_spec_object ("urlshorten", "urlshorten", "urlshorten", GWIBBER_TYPE_URL_SHORTEN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("submit", GWIBBER_TYPE_INPUT_TEXT_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberInputTextViewClass, submit), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gwibber_input_text_view_instance_init (GwibberInputTextView * self) {
	self->priv = GWIBBER_INPUT_TEXT_VIEW_GET_PRIVATE (self);
	self->priv->last_was_shortened = FALSE;
}


static void gwibber_input_text_view_finalize (GObject* obj) {
	GwibberInputTextView * self;
	self = GWIBBER_INPUT_TEXT_VIEW (obj);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->priv->_conn_service);
	_g_object_unref0 (self->priv->_urlshorten);
	_g_free0 (self->overlay_text);
	_g_free0 (self->overlay_color);
	_g_object_unref0 (self->drawable);
	_g_object_unref0 (self->pango_overlay);
	G_OBJECT_CLASS (gwibber_input_text_view_parent_class)->finalize (obj);
}


GType gwibber_input_text_view_get_type (void) {
	static volatile gsize gwibber_input_text_view_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_input_text_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberInputTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_input_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberInputTextView), 0, (GInstanceInitFunc) gwibber_input_text_view_instance_init, NULL };
		GType gwibber_input_text_view_type_id;
		gwibber_input_text_view_type_id = g_type_register_static (GTK_TYPE_TEXT_VIEW, "GwibberInputTextView", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_input_text_view_type_id__volatile, gwibber_input_text_view_type_id);
	}
	return gwibber_input_text_view_type_id__volatile;
}


static void gwibber_input_text_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberInputTextView * self;
	self = GWIBBER_INPUT_TEXT_VIEW (object);
	switch (property_id) {
		case GWIBBER_INPUT_TEXT_VIEW_SERVICE:
		g_value_set_object (value, gwibber_input_text_view_get_service (self));
		break;
		case GWIBBER_INPUT_TEXT_VIEW_CONN_SERVICE:
		g_value_set_object (value, gwibber_input_text_view_get_conn_service (self));
		break;
		case GWIBBER_INPUT_TEXT_VIEW_URLSHORTEN:
		g_value_set_object (value, gwibber_input_text_view_get_urlshorten (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gwibber_input_text_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberInputTextView * self;
	self = GWIBBER_INPUT_TEXT_VIEW (object);
	switch (property_id) {
		case GWIBBER_INPUT_TEXT_VIEW_SERVICE:
		gwibber_input_text_view_set_service (self, g_value_get_object (value));
		break;
		case GWIBBER_INPUT_TEXT_VIEW_CONN_SERVICE:
		gwibber_input_text_view_set_conn_service (self, g_value_get_object (value));
		break;
		case GWIBBER_INPUT_TEXT_VIEW_URLSHORTEN:
		gwibber_input_text_view_set_urlshorten (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberAccountToggleButton* gwibber_account_toggle_button_construct (GType object_type, const char* color) {
	GwibberAccountToggleButton * self;
	g_return_val_if_fail (color != NULL, NULL);
	self = (GwibberAccountToggleButton*) g_object_new (object_type, "color", color, NULL);
	return self;
}


GwibberAccountToggleButton* gwibber_account_toggle_button_new (const char* color) {
	return gwibber_account_toggle_button_construct (GWIBBER_TYPE_ACCOUNT_TOGGLE_BUTTON, color);
}


static gboolean gwibber_account_toggle_button_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	GwibberAccountToggleButton * self;
	gboolean result = FALSE;
	double factor;
	GdkColor gdk_color = {0};
	cairo_t* context;
	double left;
	double top;
	double right;
	double bottom;
	double radius;
	self = (GwibberAccountToggleButton*) base;
	factor = 0.3;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) self)) {
		factor = 1.0;
	} else {
		if (((GtkWidget*) self)->state == 2) {
			factor = 0.3;
		} else {
			if (((GtkWidget*) self)->state == 1) {
				factor = 0.5;
			}
		}
	}
	context = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
	gdk_color_parse (self->priv->_color, &gdk_color);
	left = (double) (*event).area.x;
	top = (double) (*event).area.y;
	right = (double) ((*event).area.x + (*event).area.width);
	bottom = (double) ((*event).area.y + (*event).area.height);
	radius = (double) 10;
	cairo_move_to (context, left, top + radius);
	cairo_curve_to (context, left, top, left, top, left + radius, top);
	cairo_line_to (context, right - radius, top);
	cairo_curve_to (context, right, top, right, top, right, top + radius);
	cairo_line_to (context, right, bottom - radius);
	cairo_curve_to (context, right, bottom, right, bottom, right - radius, bottom);
	cairo_line_to (context, left + radius, bottom);
	cairo_curve_to (context, left, bottom, left, bottom, left, bottom - radius);
	cairo_clip (context);
	gdk_color_parse (self->priv->_color, &gdk_color);
	cairo_set_source_rgba (context, gdk_color.red / 65535.0, gdk_color.green / 65535.0, gdk_color.blue / 65535.0, factor);
	cairo_paint (context);
	gtk_container_propagate_expose ((GtkContainer*) self, ((GtkBin*) self)->child, event);
	result = TRUE;
	_cairo_destroy0 (context);
	return result;
}


const char* gwibber_account_toggle_button_get_color (GwibberAccountToggleButton* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_color;
	return result;
}


static void gwibber_account_toggle_button_set_color (GwibberAccountToggleButton* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_color = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_color), _tmp0_);
	g_object_notify ((GObject *) self, "color");
}


static GObject * gwibber_account_toggle_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberAccountToggleButton * self;
	parent_class = G_OBJECT_CLASS (gwibber_account_toggle_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_ACCOUNT_TOGGLE_BUTTON (obj);
	{
	}
	return obj;
}


static void gwibber_account_toggle_button_class_init (GwibberAccountToggleButtonClass * klass) {
	gwibber_account_toggle_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberAccountToggleButtonPrivate));
	GTK_WIDGET_CLASS (klass)->expose_event = gwibber_account_toggle_button_real_expose_event;
	G_OBJECT_CLASS (klass)->get_property = gwibber_account_toggle_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = gwibber_account_toggle_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_account_toggle_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_account_toggle_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_ACCOUNT_TOGGLE_BUTTON_COLOR, g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gwibber_account_toggle_button_instance_init (GwibberAccountToggleButton * self) {
	self->priv = GWIBBER_ACCOUNT_TOGGLE_BUTTON_GET_PRIVATE (self);
}


static void gwibber_account_toggle_button_finalize (GObject* obj) {
	GwibberAccountToggleButton * self;
	self = GWIBBER_ACCOUNT_TOGGLE_BUTTON (obj);
	_g_free0 (self->priv->_color);
	G_OBJECT_CLASS (gwibber_account_toggle_button_parent_class)->finalize (obj);
}


GType gwibber_account_toggle_button_get_type (void) {
	static volatile gsize gwibber_account_toggle_button_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_account_toggle_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberAccountToggleButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_account_toggle_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberAccountToggleButton), 0, (GInstanceInitFunc) gwibber_account_toggle_button_instance_init, NULL };
		GType gwibber_account_toggle_button_type_id;
		gwibber_account_toggle_button_type_id = g_type_register_static (GTK_TYPE_TOGGLE_BUTTON, "GwibberAccountToggleButton", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_account_toggle_button_type_id__volatile, gwibber_account_toggle_button_type_id);
	}
	return gwibber_account_toggle_button_type_id__volatile;
}


static void gwibber_account_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberAccountToggleButton * self;
	self = GWIBBER_ACCOUNT_TOGGLE_BUTTON (object);
	switch (property_id) {
		case GWIBBER_ACCOUNT_TOGGLE_BUTTON_COLOR:
		g_value_set_string (value, gwibber_account_toggle_button_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gwibber_account_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberAccountToggleButton * self;
	self = GWIBBER_ACCOUNT_TOGGLE_BUTTON (object);
	switch (property_id) {
		case GWIBBER_ACCOUNT_TOGGLE_BUTTON_COLOR:
		gwibber_account_toggle_button_set_color (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberAccountTargetBar* gwibber_account_target_bar_construct (GType object_type, GwibberAccounts* accounts_service) {
	GwibberAccountTargetBar * self;
	g_return_val_if_fail (accounts_service != NULL, NULL);
	self = (GwibberAccountTargetBar*) g_object_new (object_type, "accounts-service", accounts_service, "spacing", 0, NULL);
	return self;
}


GwibberAccountTargetBar* gwibber_account_target_bar_new (GwibberAccounts* accounts_service) {
	return gwibber_account_target_bar_construct (GWIBBER_TYPE_ACCOUNT_TARGET_BAR, accounts_service);
}


static void gwibber_account_target_bar_on_account_toggled (GwibberAccountTargetBar* self, GwibberAccountToggleButton* account_button, const char* id) {
	GHashTable* account;
	gboolean enabled;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account_button != NULL);
	g_return_if_fail (id != NULL);
	account = gwibber_accounts_lookup_by_id (self->priv->_accounts_service, id);
	enabled = g_value_get_boolean ((GValue*) g_hash_table_lookup (account, "send_enabled"));
	if (enabled != gtk_toggle_button_get_active ((GtkToggleButton*) account_button)) {
		gwibber_accounts_send_enabled (self->priv->_accounts_service, id);
	}
	_g_hash_table_unref0 (account);
}


static void gwibber_account_target_bar_account_updated (GHashTable* accounts_buttons_table, GHashTable* account) {
	char* username;
	char* service;
	char* id;
	gboolean enabled;
	GwibberAccountToggleButton* account_button;
	g_return_if_fail (accounts_buttons_table != NULL);
	g_return_if_fail (account != NULL);
	username = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (account, "username")));
	service = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (account, "service")));
	id = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (account, "id")));
	enabled = g_value_get_boolean ((GValue*) g_hash_table_lookup (account, "send_enabled"));
	g_debug ("entry.vala:383: ACCOUNT: %s %s %s", username, service, id);
	account_button = _g_object_ref0 ((GwibberAccountToggleButton*) g_hash_table_lookup (accounts_buttons_table, id));
	if (!enabled) {
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		char* _tmp3_;
		gtk_widget_set_tooltip_text ((GtkWidget*) account_button, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (service, " (", NULL), username, NULL), ") - ", NULL), _ ("Disabled"), NULL));
		_g_free0 (_tmp3_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
	} else {
		char* _tmp4_;
		char* _tmp5_;
		char* _tmp6_;
		gtk_widget_set_tooltip_text ((GtkWidget*) account_button, _tmp6_ = g_strconcat (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat (service, " (", NULL), username, NULL), ")", NULL));
		_g_free0 (_tmp6_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp4_);
	}
	if (enabled != gtk_toggle_button_get_active ((GtkToggleButton*) account_button)) {
		gtk_toggle_button_set_active ((GtkToggleButton*) account_button, enabled);
	}
	_g_object_unref0 (account_button);
	_g_free0 (id);
	_g_free0 (service);
	_g_free0 (username);
}


static void gwibber_account_target_bar_on_connection_changed (GwibberAccountTargetBar* self, gboolean is_connected) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self->send, is_connected);
}


GwibberAccounts* gwibber_account_target_bar_get_accounts_service (GwibberAccountTargetBar* self) {
	GwibberAccounts* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_accounts_service;
	return result;
}


static void gwibber_account_target_bar_set_accounts_service (GwibberAccountTargetBar* self, GwibberAccounts* value) {
	GwibberAccounts* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_accounts_service = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_accounts_service), _tmp0_);
	g_object_notify ((GObject *) self, "accounts-service");
}


GwibberConnection* gwibber_account_target_bar_get_conn_service (GwibberAccountTargetBar* self) {
	GwibberConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_conn_service;
	return result;
}


static void gwibber_account_target_bar_set_conn_service (GwibberAccountTargetBar* self, GwibberConnection* value) {
	GwibberConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_conn_service = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_conn_service), _tmp0_);
	g_object_notify ((GObject *) self, "conn-service");
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _lambda2_ (GtkButton* source, Block1Data* _data1_) {
	GwibberAccountTargetBar * self;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	gwibber_account_target_bar_on_account_toggled (self, _data1_->account_button, _data1_->id);
}


static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->account_button);
		_g_free0 (_data1_->id);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda3_ (gboolean source, GwibberAccountTargetBar* self) {
	gwibber_account_target_bar_on_connection_changed (self, source);
}


static void __lambda3__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self) {
	_lambda3_ (is_online, self);
}


static void _lambda4_ (GHashTable* source, GwibberAccountTargetBar* self) {
	g_return_if_fail (source != NULL);
	gwibber_account_target_bar_account_updated (self->accounts_buttons_table, source);
}


static void __lambda4__gwibber_accounts_account_updated (GwibberAccounts* _sender, GHashTable* account_table, gpointer self) {
	_lambda4_ (account_table, self);
}


static GObject * gwibber_account_target_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberAccountTargetBar * self;
	parent_class = G_OBJECT_CLASS (gwibber_account_target_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_ACCOUNT_TARGET_BAR (obj);
	{
		GwibberConnection* _tmp0_;
		GtkHBox* box;
		GtkLabel* send_with_label;
		char* service_icon_path;
		char* _tmp1_;
		gboolean _tmp2_;
		GHashTable* accounts_table;
		GHashTable* _tmp4_;
		GtkButton* _tmp14_;
		gwibber_account_target_bar_set_conn_service (self, _tmp0_ = gwibber_connection_new ());
		_g_object_unref0 (_tmp0_);
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
		send_with_label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Send with:")));
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) send_with_label, FALSE, FALSE, (guint) 5);
		service_icon_path = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "share", "gwibber", "ui", "icons", "breakdance", "22x22", G_DIR_SEPARATOR_S, NULL);
		if ((_tmp2_ = g_file_test (_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "local", "share", "gwibber", "ui", "icons", "breakdance", "22x22", NULL), G_FILE_TEST_EXISTS), _g_free0 (_tmp1_), _tmp2_)) {
			char* _tmp3_;
			service_icon_path = (_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "local", "share", "gwibber", "ui", "icons", "breakdance", "22x22", G_DIR_SEPARATOR_S, NULL), _g_free0 (service_icon_path), _tmp3_);
		}
		accounts_table = gwibber_accounts_list (self->priv->_accounts_service);
		self->accounts_buttons_table = (_tmp4_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->accounts_buttons_table), _tmp4_);
		{
			GList* k_collection;
			GList* k_it;
			k_collection = g_hash_table_get_keys (accounts_table);
			for (k_it = k_collection; k_it != NULL; k_it = k_it->next) {
				const char* k;
				k = (const char*) k_it->data;
				{
					Block1Data* _data1_;
					GHashTable* account_table;
					char* username;
					char* service;
					char* color;
					gboolean enabled;
					GtkImage* icon_service;
					char* _tmp5_;
					char* _tmp6_;
					_data1_ = g_slice_new0 (Block1Data);
					_data1_->_ref_count_ = 1;
					_data1_->self = g_object_ref (self);
					account_table = _g_hash_table_ref0 ((GHashTable*) g_hash_table_lookup (accounts_table, k));
					username = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (account_table, "username")));
					service = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (account_table, "service")));
					_data1_->id = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (account_table, "id")));
					color = g_strdup (g_value_get_string ((GValue*) g_hash_table_lookup (account_table, "color")));
					enabled = g_value_get_boolean ((GValue*) g_hash_table_lookup (account_table, "send_enabled"));
					icon_service = g_object_ref_sink ((GtkImage*) gtk_image_new ());
					gtk_image_set_from_file (icon_service, _tmp6_ = g_strconcat (_tmp5_ = g_strconcat (service_icon_path, service, NULL), ".png", NULL));
					_g_free0 (_tmp6_);
					_g_free0 (_tmp5_);
					gtk_widget_show ((GtkWidget*) icon_service);
					_data1_->account_button = g_object_ref_sink (gwibber_account_toggle_button_new (color));
					gtk_toggle_button_set_active ((GtkToggleButton*) _data1_->account_button, enabled);
					if (!enabled) {
						char* _tmp7_;
						char* _tmp8_;
						char* _tmp9_;
						char* _tmp10_;
						gtk_widget_set_tooltip_text ((GtkWidget*) _data1_->account_button, _tmp10_ = g_strconcat (_tmp9_ = g_strconcat (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (service, " (", NULL), username, NULL), ") - ", NULL), _ ("Disabled"), NULL));
						_g_free0 (_tmp10_);
						_g_free0 (_tmp9_);
						_g_free0 (_tmp8_);
						_g_free0 (_tmp7_);
					} else {
						char* _tmp11_;
						char* _tmp12_;
						char* _tmp13_;
						gtk_widget_set_tooltip_text ((GtkWidget*) _data1_->account_button, _tmp13_ = g_strconcat (_tmp12_ = g_strconcat (_tmp11_ = g_strconcat (service, " (", NULL), username, NULL), ")", NULL));
						_g_free0 (_tmp13_);
						_g_free0 (_tmp12_);
						_g_free0 (_tmp11_);
					}
					gtk_button_set_image ((GtkButton*) _data1_->account_button, (GtkWidget*) icon_service);
					g_signal_connect_data ((GtkButton*) _data1_->account_button, "clicked", (GCallback) __lambda2__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
					gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) _data1_->account_button, FALSE, FALSE, (guint) 2);
					g_hash_table_insert (self->accounts_buttons_table, g_strdup (_data1_->id), _g_object_ref0 (_data1_->account_button));
					_g_object_unref0 (icon_service);
					_g_free0 (color);
					_g_free0 (service);
					_g_free0 (username);
					_g_hash_table_unref0 (account_table);
					block1_data_unref (_data1_);
				}
			}
			_g_list_free0 (k_collection);
		}
		self->send = (_tmp14_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Send"))), _g_object_unref0 (self->send), _tmp14_);
		gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) self->send, FALSE, FALSE, (guint) 5);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
		gtk_widget_set_sensitive ((GtkWidget*) self->send, gwibber_connection_is_connected (self->priv->_conn_service));
		g_signal_connect_object (self->priv->_conn_service, "connection-changed", (GCallback) __lambda3__gwibber_connection_connection_changed, self, 0);
		g_signal_connect_object (self->priv->_accounts_service, "account-updated", (GCallback) __lambda4__gwibber_accounts_account_updated, self, 0);
		_g_hash_table_unref0 (accounts_table);
		_g_free0 (service_icon_path);
		_g_object_unref0 (send_with_label);
		_g_object_unref0 (box);
	}
	return obj;
}


static void gwibber_account_target_bar_class_init (GwibberAccountTargetBarClass * klass) {
	gwibber_account_target_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberAccountTargetBarPrivate));
	G_OBJECT_CLASS (klass)->get_property = gwibber_account_target_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = gwibber_account_target_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_account_target_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_account_target_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_ACCOUNT_TARGET_BAR_ACCOUNTS_SERVICE, g_param_spec_object ("accounts-service", "accounts-service", "accounts-service", GWIBBER_TYPE_ACCOUNTS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_ACCOUNT_TARGET_BAR_CONN_SERVICE, g_param_spec_object ("conn-service", "conn-service", "conn-service", GWIBBER_TYPE_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gwibber_account_target_bar_instance_init (GwibberAccountTargetBar * self) {
	self->priv = GWIBBER_ACCOUNT_TARGET_BAR_GET_PRIVATE (self);
}


static void gwibber_account_target_bar_finalize (GObject* obj) {
	GwibberAccountTargetBar * self;
	self = GWIBBER_ACCOUNT_TARGET_BAR (obj);
	_g_object_unref0 (self->priv->_accounts_service);
	_g_object_unref0 (self->priv->_conn_service);
	_g_object_unref0 (self->send);
	_g_hash_table_unref0 (self->accounts_buttons_table);
	G_OBJECT_CLASS (gwibber_account_target_bar_parent_class)->finalize (obj);
}


GType gwibber_account_target_bar_get_type (void) {
	static volatile gsize gwibber_account_target_bar_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_account_target_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberAccountTargetBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_account_target_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberAccountTargetBar), 0, (GInstanceInitFunc) gwibber_account_target_bar_instance_init, NULL };
		GType gwibber_account_target_bar_type_id;
		gwibber_account_target_bar_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberAccountTargetBar", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_account_target_bar_type_id__volatile, gwibber_account_target_bar_type_id);
	}
	return gwibber_account_target_bar_type_id__volatile;
}


static void gwibber_account_target_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberAccountTargetBar * self;
	self = GWIBBER_ACCOUNT_TARGET_BAR (object);
	switch (property_id) {
		case GWIBBER_ACCOUNT_TARGET_BAR_ACCOUNTS_SERVICE:
		g_value_set_object (value, gwibber_account_target_bar_get_accounts_service (self));
		break;
		case GWIBBER_ACCOUNT_TARGET_BAR_CONN_SERVICE:
		g_value_set_object (value, gwibber_account_target_bar_get_conn_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gwibber_account_target_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberAccountTargetBar * self;
	self = GWIBBER_ACCOUNT_TARGET_BAR (object);
	switch (property_id) {
		case GWIBBER_ACCOUNT_TARGET_BAR_ACCOUNTS_SERVICE:
		gwibber_account_target_bar_set_accounts_service (self, g_value_get_object (value));
		break;
		case GWIBBER_ACCOUNT_TARGET_BAR_CONN_SERVICE:
		gwibber_account_target_bar_set_conn_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberSendBar* gwibber_send_bar_construct (GType object_type, GwibberService* service) {
	GwibberSendBar * self;
	g_return_val_if_fail (service != NULL, NULL);
	self = (GwibberSendBar*) g_object_new (object_type, "service", service, "spacing", 5, NULL);
	return self;
}


GwibberSendBar* gwibber_send_bar_new (GwibberService* service) {
	return gwibber_send_bar_construct (GWIBBER_TYPE_SEND_BAR, service);
}


GwibberService* gwibber_send_bar_get_service (GwibberSendBar* self) {
	GwibberService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


static void gwibber_send_bar_set_service (GwibberSendBar* self, GwibberService* value) {
	GwibberService* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_service = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_service), _tmp0_);
	g_object_notify ((GObject *) self, "service");
}


static GObject * gwibber_send_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberSendBar * self;
	parent_class = G_OBJECT_CLASS (gwibber_send_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_SEND_BAR (obj);
	{
		GtkHBox* box;
		GtkButton* _tmp0_;
		box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
		self->send = (_tmp0_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Send"))), _g_object_unref0 (self->send), _tmp0_);
		gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) self->send, FALSE, FALSE, (guint) 0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
		_g_object_unref0 (box);
	}
	return obj;
}


static void gwibber_send_bar_class_init (GwibberSendBarClass * klass) {
	gwibber_send_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberSendBarPrivate));
	G_OBJECT_CLASS (klass)->get_property = gwibber_send_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = gwibber_send_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_send_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_send_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_SEND_BAR_SERVICE, g_param_spec_object ("service", "service", "service", GWIBBER_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gwibber_send_bar_instance_init (GwibberSendBar * self) {
	self->priv = GWIBBER_SEND_BAR_GET_PRIVATE (self);
}


static void gwibber_send_bar_finalize (GObject* obj) {
	GwibberSendBar * self;
	self = GWIBBER_SEND_BAR (obj);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->send);
	G_OBJECT_CLASS (gwibber_send_bar_parent_class)->finalize (obj);
}


GType gwibber_send_bar_get_type (void) {
	static volatile gsize gwibber_send_bar_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_send_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberSendBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_send_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberSendBar), 0, (GInstanceInitFunc) gwibber_send_bar_instance_init, NULL };
		GType gwibber_send_bar_type_id;
		gwibber_send_bar_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberSendBar", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_send_bar_type_id__volatile, gwibber_send_bar_type_id);
	}
	return gwibber_send_bar_type_id__volatile;
}


static void gwibber_send_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberSendBar * self;
	self = GWIBBER_SEND_BAR (object);
	switch (property_id) {
		case GWIBBER_SEND_BAR_SERVICE:
		g_value_set_object (value, gwibber_send_bar_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gwibber_send_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberSendBar * self;
	self = GWIBBER_SEND_BAR (object);
	switch (property_id) {
		case GWIBBER_SEND_BAR_SERVICE:
		gwibber_send_bar_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




